@ECHO OFF
REM C99C.BAT
REM
REM Batch file for x-compiling, optimizing and assembling
REM TI99/4A C99 programs
REM
REM Compiled code will be stored in the \OBJ directory
REM 
REM This batchfile is intended to be used with TotalCommander
REM  Command=		?:\Ti994w\Utl\C99c.bat
REM  Parameters=	%O %E
REM  Iconfile=		?:\Ti994w\Utl\C99c.exe
REM  Tooltip=		C99C - Cross-compiler for the TI99/4A
REM
REM TIP: To prevent the "out of environment space" error
REM      add the environment variable space=***op to 200chars***
REM      in your autoexec.bat file.
REM
REM Author:	Frederik G. Kaal
REM Version:	1.0
REM Data	09-11-2002
REM 
REM Call: C99C.BAT inputfile extentsion


@echo [%1] [%2] [%3] [%4] [%5]

SET SPACE=
SET PATH=D:\TI994W\UTL;%PATH%
SET VIEWER=notepad.exe

if .%2.==.c99. goto compile
if .%2.==.C99. goto compile

if .%2.==.A99. goto assemble
if .%2.==.a99. goto assemble

start /WAIT wmessage -M%1.%2 does not have the right extension\nfor compiling like .C99\nor assembling like .A99 -TL99 -K1 -I4
goto end


:assemble
if exist .\obj\%1.s del .\obj\%1.s
copy %1.%2 .\obj\%1.s >nul
CD .\obj
goto A99


:compile
@echo Start Compiling
if exist .\obj\%1.err del .\obj\%1.err
@echo C99C.EXE %1.%2 .\obj\%1.a99
@echo on
C99C.EXE %1.%2 .\obj\%1.a99 .\obj\%1.err /t
@echo off
CD .\OBJ
findstring "No errors found" <%1.err
if errorlevel 1 goto comperr

@echo Start Optimizing
@echo C99O.EXE %1.a99 %1.o99
C99O.EXE %1.a99 %1.o99

@echo Start X-Optimizing
@echo C99X.EXE %1.o99 %1.x99
C99X.EXE %1.o99 %1.x99

@echo Start F-Optimizing
@echo C99F.EXE %1.x99 %1.s
C99F.EXE %1.x99 %1.s

:A99
@echo Start Assembling
if exist %1.aer del %1.aer
rem @echo TASM.EXE +ROL -C %1.S
rem TASM.EXE +ROL -C %1.S >%1.aer
rem findstring "Assembler done.  Errors: 0" <%1.aer
@echo ASM990.EXE -c -r -l %1.p -o %1.x %1.S
ASM990.EXE -c -r -l %1.p -o %1.x %1.s
if errorlevel 1 goto asmerr
goto end

:comperr
@echo Compiler errors
start /WAIT wmessage -MCompiler errors -TC99 -K1 -I4
%VIEWER% %1.ERR
set ERROR=1
goto end

:asmerr
@echo Assembler errors
start /WAIT wmessage -MAssembler errors -TTasm -K1 -I4
REM %VIEWER% %1.AER
%VIEWER% %1.P
set ERROR=1
goto end

:end
cd ..
