//////////////////////////////////////////////////////////////////////////////
// DCTO8DKEYB.H - TO8D keyboard definition
// Author   : Daniel Coulom - danielcoulom@gmail.com
// Web site : http://dcto8.free.fr
// Created  : December 2007
//
// This file is part of DCTO8D.
//
// DCTO8D is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DCTO8D is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with DCTO8D.  If not, see <http://www.gnu.org/licenses/>.
//
//////////////////////////////////////////////////////////////////////////////

#ifdef WIN32
//scancode hardware du PC Windows pour chaque touche TO9+
//(+ 0x40 pour les touches du pave numerique pour les distinguer des autres)
int pckeycode[KEYBOARDKEY_MAX]=
{
0x3c, //0x00 F2
0x07, //0x01 6
0x15, //0x02 Y
0x23, //0x03 H
0x48, //0x04 haut
0x4d, //0x05 droite
0x47, //0x06 RAZ
0x31, //0x07 N
0x3d, //0x08 F3
0x06, //0x09 5
0x14, //0x0a T
0x22, //0x0b G
0x0d, //0x0c +
0x4b, //0x0d gauche
0x52, //0x0e INS
0x30, //0x0f B
0x3e, //0x10 F4
0x05, //0x11 4
0x13, //0x12 R
0x21, //0x13 F
0x38, //0x14 ACC
0x8f, //0x15 1
0x53, //0x16 EFF
0x2f, //0x17 V
0x3f, //0x18 F5
0x04, //0x19 3
0x12, //0x1a E
0x20, //0x1b D
0x87, //0x1c 7 pad
0x8b, //0x1d 4 pad
0x92, //0x1e 0 pad
0x2e, //0x1f C
0x3b, //0x20 F1
0x03, //0x21 2
0x11, //0x22 Z
0x1f, //0x23 S
0x88, //0x24 8
0x90, //0x25 2
0x93, //0x26 .
0x2d, //0x27 X
0x29, //0x28 @
0x02, //0x29 1
0x10, //0x2a A
0x1e, //0x2b Q
0x56, //0x2c [
0x8c, //0x2d 5 pad
0x8d, //0x2e 6 pad
0x2c, //0x2f W
0x0f, //0x30 STOP
0x08, //0x31 7
0x16, //0x32 U
0x24, //0x33 J
0x39, //0x34 espace
0x89, //0x35 9 pad
0x5c, //0x36 Ent pad
0x32, //0x37 ,
0xff, //0x38 ?????????
0x09, //0x39 8
0x17, //0x3a I
0x25, //0x3b K
0x1b, //0x3c $
0x50, //0x3d bas
0x2b, //0x3e ]
0x33, //0x3f ;
0xff, //0x40 ?????????
0x0a, //0x41 9
0x18, //0x42 O
0x26, //0x43 L
0x0e, //0x44 -
0x28, //0x45 
0x1c, //0x46 Entree
0x34, //0x47 :
0xff, //0x48 ?????????
0x0b, //0x49 0
0x19, //0x4a P
0x27, //0x4b M
0x0c, //0x4c )
0x1a, //0x4d ^
0x91, //0x4e 3 pad
0x35, //0x4f > <
0x3a, //0x50 lock
0x2a, //0x51 left shift
0x36, //0x52 right shift
0x1d  //0x53 cnt
};

//scancode hardware du PC Windows pour chaque fonction des manettes TO9+
//(+ 0x40 pour les touches du pave numerique pour les distinguer des autres)
int pcjoycode[JOYSTICKKEY_MAX]=
{
 0x8c, //0 manette 0 HAUT
 0x90, //1 manette 0 BAS
 0x8f, //2 manette 0 GAUCHE
 0x91, //3 manette 0 DROITE
 0x75, //4 manette 1 HAUT
 0x88, //5 manette 1 BAS
 0x87, //6 manette 1 GAUCHE
 0x89, //7 manette 1 DROITE
 0x5c, //8 manette 0 ACTION
 0x8e  //9 manette 1 ACTION
};

#else

//scancode hardware du PC Linux pour chaque touche TO9+
//(+ 0x40 pour les touches du pave numerique pour les distinguer des autres)
int pckeycode[KEYBOARDKEY_MAX]=
{
0x44, //0x00 F2
0x0f, //0x01 6
0x1d, //0x02 Y
0x2b, //0x03 H
0x62, //0x04 haut
0x66, //0x05 droite
0x61, //0x06 RAZ
0x39, //0x07 N
0x45, //0x08 F3
0x0e, //0x09 5
0x1c, //0x0a T
0x2a, //0x0b G
0x15, //0x0c +
0x64, //0x0d gauche
0x6a, //0x0e INS
0x38, //0x0f B
0x46, //0x10 F4
0x0d, //0x11 4
0x1b, //0x12 R
0x29, //0x13 F
0x71, //0x14 ACC
0x97, //0x15 1
0x6b, //0x16 EFF
0x37, //0x17 V
0x47, //0x18 F5
0x0c, //0x19 3
0x1a, //0x1a E
0x28, //0x1b D
0x8f, //0x1c 7 pad
0x93, //0x1d 4 pad
0x9a, //0x1e 0 pad
0x36, //0x1f C
0x43, //0x20 F1
0x0b, //0x21 2
0x19, //0x22 Z
0x27, //0x23 S
0x90, //0x24 8
0x98, //0x25 2
0x9b, //0x26 .
0x35, //0x27 X
0x31, //0x28 @
0x0a, //0x29 1
0x18, //0x2a A
0x26, //0x2b Q
0x5e, //0x2c [
0x94, //0x2d 5 pad
0x95, //0x2e 6 pad
0x34, //0x2f W
0x17, //0x30 STOP
0x10, //0x31 7
0x1e, //0x32 U
0x2c, //0x33 J
0x41, //0x34 espace
0x91, //0x35 9 pad
0xac, //0x36 Ent pad
0x3a, //0x37 ,
0xff, //0x38 ?????????
0x11, //0x39 8
0x1f, //0x3a I
0x2d, //0x3b K
0x23, //0x3c $
0x68, //0x3d bas
0x33, //0x3e ]
0x3b, //0x3f ;
0xff, //0x40 ?????????
0x12, //0x41 9
0x20, //0x42 O
0x2e, //0x43 L
0x16, //0x44 -
0x30, //0x45 
0x24, //0x46 Entree
0x3c, //0x47 :
0xff, //0x48 ?????????
0x13, //0x49 0
0x21, //0x4a P
0x2f, //0x4b M
0x14, //0x4c )
0x22, //0x4d ^
0x99, //0x4e 3 pad
0x3d, //0x4f > <
0x42, //0x50 lock
0x32, //0x51 left shift
0x3e, //0x52 right shift
0x25  //0x53 cnt
};

//scancode hardware du PC Linux pour chaque fonction des manettes T09+
//(+ 0x40 pour les touches du pave numerique pour les distinguer des autres)
int pcjoycode[JOYSTICKKEY_MAX]=
{
 0x94, //0 manette 0 HAUT
 0x98, //1 manette 0 BAS
 0x97, //2 manette 0 GAUCHE
 0x99, //3 manette 0 DROITE
 0xb0, //4 manette 1 HAUT
 0x90, //5 manette 1 BAS
 0x8f, //6 manette 1 GAUCHE
 0x91, //7 manette 1 DROITE
 0xac, //8 manette 0 ACTION
 0x96  //9 manette 1 ACTION
};

#endif
