;#####################################################
;#     RomManager.mrc build 73 for mIRC > 6.1        #
;#####################################################
;Original code by q^-o|o-^p
;Some changes by Bananolu & Douglas
;Code rewrite, modifications & additions by b1u3j


;#################################
;# SCRIPT INITIALIZATION SECTION #
;#################################

on *:load {
  unset %rm*
  hfree -w rm*

  ;this is to track script versions only. do not change unless script code has been changed.
  %rm.build = 73

  if ($version < 6.1) {
    echo -a RomManager requires mIRC version04 6.1 or higher and will not work with mIRC v04 $+ $version
    .unload -rs " $+ $script $+ "
    halt
  }

  %rm.rlm = " $+ $scriptdir $+ rlm.ini"
  %rm.rmp = " $+ $scriptdir $+ rmp.ini"
  %rm.icon = " $+ $scriptdir $+ rmicons.dll"
  %rm.version = $readini(%rm.rlm,V,v)
  %rm.mode = 22
  %rm.current_section = 9

  ; make sure the RM database is at least v4.42, and unload RM if it isn't
  if (%rm.version < 4.42) {
    echo -a RomManager04 Code Revision (build %rm.build requires a RomManager Database version04 4.42 or higher
    echo -a Please upgrade your RomManager installation using an Official04 4.x version before using this build.
    .unload -rs " $+ $script $+ "
    halt
  }

  echo -s 11RomManager Database 04v $+ %rm.version (build %rm.build $+ )11 has been loaded

  ; if the rmp.ini file does not exist, make an empty one.
  if ($isfile(%rm.rmp) == $false) {
    writeini %rm.rmp PREF RMversion %rm.version
    writeini %rm.rmp PREF RMbuild %rm.build
    %rm.mode = 21
    rmhelp documentation
  }

  ; check to see if rmp.ini was created for the rommanager version listed in rlm.ini.
  if (($readini(%rm.rmp,PREF,RMversion) != %rm.version) || ($readini(%rm.rmp,PREF,RMbuild) == $null) || ($readini(%rm.rmp,PREF,RMbuild) < 58)) {
    ; copy old colors, custom systems, and existing log paths from the old rmp.ini to a new rmp.ini
    parse_old_rmp
    writeini %rm.rmp PREF RMversion %rm.version
    writeini %rm.rmp PREF RMbuild %rm.build
    %rm.mode = 21
    rmhelp documentation
  }

  ; just in case these options aren't already set...
  if ($readini(%rm.rmp,PREF,public) == $null) { writeini %rm.rmp PREF public 71 | writeini %rm.rmp PREF private 74 }
  if ($readini(%rm.rmp,PREF,AllowRequests) == $null) { writeini %rm.rmp PREF AllowRequests 1 }
  elseif ($readini(%rm.rmp,PREF,AllowRequests) == 0) { %rm.AllowRequests = No Thanks! }

  ; copy the custom information to the rlm.ini file
  var %section = 18
  while (%section < 21) {
    if ($readini(%rm.rlm,TIPS,%section) == $null) { writeini %rm.rlm TIPS %section Category - CUSTOM Dats }
    if ($rmSectionLabel(%section) == $null) { writeini %rm.rlm %section m &Custom $calc(%section - 17) }
    if ($rmSectionName(%section) == $null) { writeini %rm.rlm %section s Custom $+ $calc(%section - 17) }
    if ($readini(%rm.rlm,%section,p) == $null) { writeini %rm.rlm %section p Use the Custom Editor to add additional systems to your collection }
    var %n = $readini(%rm.rmp,%section,n)
    if (%n == $null) { var %n = 0 | writeini %rm.rmp %section n 0 }
    writeini %rm.rlm %section n %n
    var %i = 1
    while (%i <= %n) { writeini %rm.rlm %section n $+ %i $readini(%rm.rmp,%section,n $+ %i) | inc %i }
    inc %section
  }

  ;reload the rmUpdate script if it is already loaded
  if ($script(rmUpdate.mrc) != $null) {
    .load -rs " $+ $scriptdir $+ rmUpdate.mrc"
    if ($dialog(rmu) != $null) { rmupdate }
  }
}

on *:unload {
  if ($dialog(rmm) != $null) { dialog -x rmm }
  if ($dialog(rmu) != $null) { dialog -x rmu }
  if ($dialog(rmCustomEdit) != $null) { dialog -x rmCustomEdit }
  if $script(rmUpdate.mrc) { .unload -rs " $+ $scriptdir $+ rmUpdate.mrc" }
  hfree -w rm*
  unset %rm*
}

;##################
;#    Aliases     #
;##################

;*** Copy log paths, colors, & custom systems, from the old rmp.ini to a new rmp.ini file
alias -l parse_old_rmp {

  ; make a backup
  var %old_rmp = " $+ $scriptdir $+ rmp_old.ini"
  if ($exists(%old_rmp)) {
    var %i = 1
    while $exists(" $+ $scriptdir $+ rmp_old $+ %i $+ .ini") { inc %i }
    .rename %old_rmp " $+ $scriptdir $+ rmp_old $+ %i $+ .ini"
  }
  rename %rm.rmp %old_rmp

  ; notify the user
  echo -a 12
  echo -a You are upgrading to 12RomManager v $+ %rm.version
  echo -a Your old settings are being moved to %old_rmp
  echo -a Settings compatible with v $+ %rm.version will be copied into a new rmp.ini file.
  echo -a This process can take up to 0430 seconds to complete and mIRC will be unresponsive during this time...

  ;initialize the rmpINI hash table
  if ($hget(rmpINI) != $null) { hfree rmpINI } | hmake rmpINI 100

  ;read the old_rmp file into the rmpINI hash table
  .fopen old_rmp %old_rmp
  if $ferr { fclose old_rmp | return }
  var %section = Unknown
  var %line = $fread(old_rmp)
  while (!$ferr) {
    ;[C]
    if ($left(%line,1) == $chr(91)) { %section = $remove(%line,$chr(91),$chr(93)) }
    ;c1=12
    elseif ($numtok(%line,61) > 1) {
      var %data = $gettok(%line,2-,61)
      ;send all [C] & [PREF] items directly to %rm.rmp
      if ((%section == C) || (%section == PREF)) { writeini %rm.rmp %section $gettok(%line,1,61) %data }
      ;else load the line into the hash table
      else { var %item = %section $+ $chr(61) $+ $gettok(%line,1,61) | hadd rmpINI %item %data }
    }
    if $feof { break }
    var %line = $fread(old_rmp)
  }
  .fclose old_rmp

  ; fix the Custom root paths if needed
  if ($hget(rmpINI,CUSTOM=n) != $null) {
    var %s = $readini(%rm.rmp,PREF,root16)
    ;custom was in section 16
    if (%s != $null) { writeini %rm.rmp PREF root20 %s }
    var %s = $readini(%rm.rmp,PREF,root15)
    if (%s != $null) { writeini %rm.rmp PREF root16 %s }
    var %s = $readini(%rm.rmp,PREF,root14)
    if (%s != $null) { writeini %rm.rmp PREF root15 %s }
  }

  ; if New sections 9 & 10 arnt set, shift 11-15 to 9-13 and 16-17 to 15-16
  if (($readini(%rm.rmp,PREF,root9) == $null) && ($readini(%rm.rmp,PREF,root10) == $null)) {
    var %s = $readini(%rm.rmp,PREF,root11)
    if (%s != $null) { writeini %rm.rmp PREF root9 %s }
    var %s = $readini(%rm.rmp,PREF,root12)
    if (%s != $null) { writeini %rm.rmp PREF root10 %s }
    var %s = $readini(%rm.rmp,PREF,root13)
    if (%s != $null) { writeini %rm.rmp PREF root11 %s }
    var %s = $readini(%rm.rmp,PREF,root14)
    if (%s != $null) { writeini %rm.rmp PREF root12 %s }
    var %s = $readini(%rm.rmp,PREF,root15)
    if (%s != $null) { writeini %rm.rmp PREF root13 %s }
    var %s = $readini(%rm.rmp,PREF,root16)
    if (%s != $null) { writeini %rm.rmp PREF root15 %s }
    var %s = $readini(%rm.rmp,PREF,root17)
    if (%s != $null) { writeini %rm.rmp PREF root16 %s }
  }

  ; if tosec1 is defined, copy it to other tosec if needed
  var %s = $readini(%rm.rmp,PREF,root12)
  if (%s != $null) {
    if ($readini(%rm.rmp,PREF,root13) == $null) { writeini %rm.rmp PREF root13  %s }
    if ($readini(%rm.rmp,PREF,root14) == $null) { writeini %rm.rmp PREF root14  %s }
  }


  ; loop thru the %rlm.ini systems and compare them to rmpINI, move matches to %rmp.ini
  var %section = 9
  while (%section < 18) {
    var %i = 1 | var %count = $rmSystemCount(%section)
    while (%i <= %count) {
      var %system = $rmSystem(%section,%i)
      ;look for current format
      var %search = logs*= $+ %system | var %result = $hfind(rmpINI,%search,1,w)
      if (%result != $null) { writeini %rm.rmp logs $+ %section %system $hget(rmpINI,%result) | hdel rmpINI %result }
      else {
        ;look for old format
        var %search = *p= $+ %system | var %result = $hfind(rmpINI,%search,1,w)
        if (%result != $null) {
          var %type = $hget(rmpINI,$replace(%result,p=,t=)) | if (%type == $null) { var %type = 0 }
          writeini %rm.rmp logs $+ %section %system %type $+ $chr(124) $+ $hget(rmpINI,%result)
          hdel rmpINI %result | hdel rmpINI $replace(%result,p=,t=)
        }
      }
      inc %i
    }
    inc %section
  }

  ; move any remaining custom systems
  if ($hget(rmpINI,CUSTOM=n) != $null) { var %section = 16 | var %new_sect = 18 }
  else { var %section = 18 | var %new_sect = 18 }
  while (%section < 21) {
    var %n = 0
    ;look for current format  result: logs18=ArtGbaBox
    var %search = logs $+ %section $+ =* | var %result = $hfind(rmpINI,%search,1,w)
    ;if not found, look for old format  ;result:  18p=ArtGbaBox
    if (%result == $null) { var %search = %section $+ p=* | var %result = $hfind(rmpINI,%search,1,w) }
    while (%result != $null) {
      var %system = $gettok(%result,2,61)
      ;write the log info
      if (%search = logs $+ %section $+ =*) { writeini %rm.rmp logs $+ %new_sect %system $hget(rmpINI,%result) }
      else {
        var %type = $hget(rmpINI,$replace(%result,p=,t=)) | if (%type == $null) { var %type = 0 }
        writeini %rm.rmp logs $+ %new_sect %system %type $+ $chr(124) $+ $hget(rmpINI,%result)
        hdel rmpINI $replace(%result,p=,t=)
      }
      hdel rmpINI %result
      ;look for the custom definition of %system
      var %result = $hfind(rmpINI,%system $+ |*,1,w).data
      if (%result == $null) { var %result = $hfind(rmpINI,%system,1).data }
      var %item
      if ($left($gettok(%result,2,61),1) == n) { var %item = $hget(rmpINI,%result) }
      elseif ($left($gettok(%result,2,61),1) == d) {
        hdel rmpINI %result
        var %result = $replace(%result,=d,=n)
        var %item = %system $+ $chr(124) $+ $hget(rmpINI,%result)
      }
      if ($numtok(%item,124) >= 2) {
        inc %n
        ;write the custom system info
        writeini %rm.rmp %new_sect n %n
        writeini %rm.rmp %new_sect n $+ %n %item
        hdel rmpINI %result
      }
      ;look for current format  result: logs18=ArtGbaBox
      var %search = logs $+ %section $+ =* | var %result = $hfind(rmpINI,%search,1,w)
      ;if not found, look for old format  ;result:  18p=ArtGbaBox
      if (%result == $null) { var %search = %section $+ p=* | var %result = $hfind(rmpINI,%search,1,w) }
    }
    if (%section = 16) { var %section = 18 } | else { inc %section | inc %new_sect }
  }

  ; we are finished with the rmpINI hash table
  if ($hget(rmpINI) != $null) { hfree rmpINI }

  ; notify the user
  echo -a 12
  echo -a The upgrade process is now complete!
  echo -a Please open the RomManager dialog and check your log paths.
  echo -a Remember, the 'Find All Logs' button will erase existing paths before it sets new ones.
  echo -a If you have a lot of Custom systems, or manually set a lot of log paths,
  echo -a 04it is a good idea to make your own backups of the rmp.ini file!
  echo -a Good Luck 12:)
  echo -a 12
}

; *** Sets the RM window title to: RomManager [Current Version] - [Current section] - [Current mode]
alias -l rm.updateDialogTitle { dialog -t rmm RomManager v $+ %rm.version - $remove($rmSectionLabel(%rm.current_section),&) - $rmSectionLabel(%rm.mode) }

; *** Shows the RM specific error message in the "Messages" text box
alias -l rm.err { did -ra rmm 200 $readini(%rm.rlm,E,$1) }

; *** Shows the selected section tip in the "Messages" text box
alias -l rm.tip { did -ra rmm 200 TIP: $readini(%rm.rlm,$1,p) }

; *** Writes into "Modes" area read only edit box the selected section root path
alias -l rm.displaySectionRootPath { did -ra rmm 63 $rmLogRoot(%rm.current_section) | if ($did(63) == $null) { did -a rmm 63 <<none>> } }

; *** return the section name: $rmSectionName(section)
alias -l rmSectionName { return $readini(%rm.rlm,$1,s) }

; *** return the section label: $rmSectionLabel(section)
alias rmSectionLabel {
  if ($readini(%rm.rmp,PREF,CustomLabel_ $+ $1) == $null) { return $readini(%rm.rlm,$1,m) }
  else { return $readini(%rm.rmp,PREF,CustomLabel_ $+ $1) }
}

; *** return the system count for a section: $rmSystemCount(section)
alias rmSystemCount { return $readini(%rm.rlm,$1,n) }

; *** search all of the sections in the rlm file for a system named $1 then returns section N
alias -l rmFindSystem {
  var %section = 9
  while (%section < 21) {
    var %i = 1 | var %n = $rmSystemCount(%section)
    while (%i <= %n) {
      if ($rmSystem(%section,%i) == $1) { return %section %i }
      inc %i
    }
    inc %section
  }
}

; *** remove spaces at the beginning of a string
alias -l removeLeadingSpaces { return $1- }

; *** return the system: $rmSystem(section,N)
alias rmSystem { return $gettok($readini(%rm.rlm,$1,n $+ $2),1,124) }

; *** return the systemName: $rmSystemName(section,N)
alias rmSystemName { return $gettok($readini(%rm.rlm,$1,n $+ $2),2,124) }

; *** return an alternate system name if it exists (DAT names that don't match the LOG names)
; *** $rmSystemAlt(section,N)
alias rmSystemAlt { return $readini(%rm.rlm,$1,a $+ $2) }

; *** beautify the systemName: $cleanSystemName(section,N)
alias -l rmCleanSystemName {
  var %section = $1
  var %systemName = $rmSystemName($1,$2)
  var %lasttok = $gettok(%systemName,-1,32)
  ;Art
  if (%section == 10) {
    if (%lasttok == Pack) {
      var %systemName = $deltok(%systemName,-1,32)
      if ($right(%systemName,1) != s) { var %systemName = %systemName $+ s }
    }
  }
  ;Fruit
  elseif (%section == 15) { if (%lasttok == Rollback) { var %systemName = %systemName ROMs } }
  ;everything else except Tosec
  elseif ((%section < 12) || (%section > 14)) { if ($right(%systemName,1) != s) { var %systemName = %systemName ROMs } }
  return %systemName
}

; *** return the log root path: $rmLogRoot(section)
alias rmLogRoot { return $readini(%rm.rmp,PREF,root $+ $1) }

; *** return the complete log file path: $rmLogFile(section,N)
alias rmLogFile {
  var %system = $rmSystem($1,$2)
  var %logFile = $gettok($readini(%rm.rmp,logs $+ $1,%system),2-,124)
  if ($numtok(%logFile,58) > 1) { return %logFile }
  return $rmLogRoot($1) $+ %logFile
}

; *** return the log file type: $rmLogType(section,N)
alias rmLogType {
  var %system = $rmSystem($1,$2)
  var %logType = $gettok($readini(%rm.rmp,logs $+ $1,%system),1,124)
  if (%logType == $null) { return 0 }
  return %logType
}

; *** save the system count for a section: saveSystemCount section N
alias -l saveSystemCount { writeini %rm.rmp $1 n $2 | writeini %rm.rlm $1 n $2 }

; *** save the system & its description: saveSystemInfo section N system description
alias -l saveSystemInfo {
  writeini %rm.rmp $1 n $+ $2 $3 $+ $chr(124) $+ $4-
  writeini %rm.rlm $1 n $+ $2 $3 $+ $chr(124) $+ $4-
}

; *** delete the system & its description: deleteSystemInfo section N
alias -l deleteSystemInfo {
  remini %rm.rlm $1 n $+ $2
  remini %rm.rmp $1 n $+ $2
}

; *** save the complete log file path: saveLogInfo section system logType logFile
alias -l saveLogInfo { writeini %rm.rmp logs $+ $1 $2 $3 $+ $chr(124) $+ $4- }

; *** save the complete log file path: remLogInfo section system
alias -l remLogInfo { remini %rm.rmp logs $+ $1- }

; *** Writes into main dialog "Messages" text box the selected system log path
; if $2=DAT, tries to find the dat, otherwise displays the log file
; rm.displaySystemPath N [DAT]
alias -l rm.displaySystemPath {
  var %selected_system = $rmSystem(%rm.current_section,$1)
  if ($2 == dat) { var %file = $rmFindDat(%rm.current_section,$1) }
  else {
    var %rm.type = $rmLogType(%rm.current_section,$1)
    if (%rm.type > 0) { var %file = $rmLogFile(%rm.current_section,$1) }
    else { did -ra rmm 200 Log path not set for this system | return }
  }
  if ($len(%file) > 80) {
    var %file = $puttok(%file,...,1,92)
    while (($len(%file) > 80) && ($numtok(%file,92) > 2)) { var %file = $deltok(%file,2,92) }
  }
  did -ra rmm 200 %file
}

; rm.displaySystemPath N
alias -l rm.displaySystemStats {
  rm.zget %rm.current_section $1
  if ((%rm.ztotal == 0) && (%rm.ztotal.disks == 0) && (%rm.ztotal.samples == 0)) {
    var %result = (not found)
  }
  else {
    var %disks
    var %samples
    if (%rm.ztotal.disks > 0) { var %disks = , CHDs %rm.zmissing.disks $+ / $+ %rm.ztotal.disks }
    if (%rm.ztotal.samples > 0) { var %samples = , Samples %rm.zmissing.samples $+ / $+ %rm.ztotal.samples }
    var %result = $chr(91) $+ missing %rm.zmissing $+ / $+ %rm.ztotal $+ %disks $+ %samples $+ $chr(93)
  }
  did -i rmm 5 1 $rmSystem(%rm.current_section,$1)
  did -vi rmm 6 1 %result
}

; *** Clears the main dialog multi-line box and then refills it with the current section system list
; if a log path has been set it will show with the tool used to scan it
alias -l rm.reloadSystemsList {
  did -r rmm 1
  if ($hget(rmSELECTION) != $null) { hfree rmSELECTION } | hmake rmSELECTION 10

  if ($did(rmm,103).state) {
    if ($1 == $null) { rmrf %rm.current_section zeros write noscan }
    ;did -i rmm 5 [Missing 387/100522, CHDs 9/95]
    did -i rmm 5 1 $deltok($deltok($strip($hget(rmrf.pages,1)),1,93),2,32) $+ $chr(93)
    ;did -vi rmm 6 [Complete Systems 0/5]
    did -vi rmm 6 1 $gettok($strip($hget(rmrf.pages,$hget(rmrf.pages,0).item)),1,93) $+ $chr(93)
    var %i = 2
    var %n = 1
    var %hash = 1
    while (%i < $hget(rmrf.pages,0).item) {
      var %x = $rmLogType(%rm.current_section,%n)
      if (%x == $null) { var %x = 0 }

      ;record= 94mb or 43/678 or 0/0
      var %record = $left($gettok($strip($hget(rmrf.pages,%i)),2,32),-1)
      ;echo -a r1: $rmSystem(%rm.current_section,%n) %record

      ;if %record is a size field, get the next field
      var %size
      if ($right(%record,1) == b) {
        if ($did(rmm,109).state) { var %size = $strip($bracket(%record missing)) }
        ;record= 43/678 or 0/0
        var %record = $left($gettok($strip($hget(rmrf.pages,%i)),3,32),-1)
      }

      ;record= 43/678 or 0/0
      var %missing = $gettok(%record,1,47)
      var %total = $gettok($gettok(%record,2,47),1,32)

      ;check for Disk Only systems
      if (($numtok($hget(rmrf.pages,%i),47) > 2) && (%total == 0)) {
        var %record = $left($gettok($strip($hget(rmrf.pages,%i)),-1,32),-1)
        var %missing = $gettok(%record,1,47)
        var %total = $gettok(%record,2,47)
      }

      ; hide complete
      if (!$did(rmm,106).state) { if ((%total > 0) && (%missing == 0)) { var %record } }
      ; hide incomplete
      if (!$did(rmm,107).state) { if ((%total > 0) && (%missing > 0)) { var %record } }
      ; hide missing
      if (!$did(rmm,108).state) { if ((%total == 0) && (%missing == 0)) { var %record } }

      ;show the dat version if wanted and if found
      var %version
      if ($did(rmm,102).state) {
        var %version = v $+ $rmGetDatVersion(%rm.current_section,%n)
        if (%version == v(not found)) { var %version }
      }

      if %record {
        if ($did(rmm,104).state) {
          did -az rmm 1 $chr(91) $+ %record $+ $chr(93) $rmSystemName(%rm.current_section,%n) %version %size
        }
        else { did -az rmm 1 $readini(%rm.rlm,TOOL,%x) : $rmSystemName(%rm.current_section,%n) %version $chr(91) $+ %record $+ $chr(93) %size }
        hadd rmSELECTION %hash %n
        inc %hash
      }
      inc %i
      inc %n
    }
  }
  else {
    var %i = $rmSystemCount(%rm.current_section)
    did -i rmm 5 1 System count: %i
    did -h rmm 6
    while (%i > 0) {

      ;show the dat version if wanted and if found
      var %version
      if ($did(rmm,102).state) {
        var %version = v $+ $rmGetDatVersion(%rm.current_section,%i)
        if (%version == v(not found)) { var %version }
      }

      var %x = $rmLogType(%rm.current_section,%i)
      if (%x == $null) { var %x = 0 }
      did -iz rmm 1 1 $readini(%rm.rlm,TOOL,%x) : $rmSystemName(%rm.current_section,%i) %version
      hadd rmSELECTION %i %i
      dec %i
    }
  }
}

; *** Set the specified system missing list/log and analyze it to establish the origin scan tool
alias -l rm.setSystemLogPath {
  var %logRoot = $rmLogRoot(%rm.current_section)
  var %fileWithPath = $remove($$sfile(%logRoot $+ *.*,Please select a valid log file.),%logRoot)
  var %logFile = $nopath(%fileWithPath)
  var %system = $rmSystem(%rm.current_section,$1)
  var %systemName = $rmSystemName(%rm.current_section,$1)
  var %logType = 0
  if (%logFile == %system $+ miss.txt) { var %logType = 1 }
  elseif ($gettok(%logFile,-1,46) == log) { var %logType = 2 }
  elseif ($pos(%logFile,missrom.txt,1) != $null) { var %logType = 3 }
  elseif ($pos(%logFile,_miss.txt,1) != $null) {
    if ($istok($read(%fileWithPath,1),TUGID,32)) { var %logType = 5 }
    else { var %logType = 6 }
  }
  elseif ($pos(%logFile,miss.txt,1) != $null) { var %logType = 4 }
  if (%logType == 0) {
    remLogInfo %rm.current_section %system
    return $false
  }
  ;if RM managed to determine the log type, save the info and update the list box
  saveLogInfo %rm.current_section %system %logType %fileWithPath
  did -o rmm 1 $2 $readini(%rm.rlm,TOOL,%logType) : %systemName
  set -u2 %rm.~wait~ 1
  return $true
}

;*** echo to $1 mynick blah bhah... (used by button 53 in Display / Request mode)
alias -l rm.echome { echo $1 $me $2- }

;*** send a file to $1 : rm.sendfile nick filewithpath
alias -l rm.sendfile {
  if $isfile($2-) {
    var %file = " $+ $nofile($2-) $+ $nopath($2-) $+ "
    var %folder = $readini(%rm.rmp,PREF,zipfolder)
    if (%folder == $null) { var %folder = $getdir }
    var %folder = %folder $+ _Files Sent by RomManager\
    mkdir " $+ %folder $+ "
    var %nickfile = " $+ %folder $+ $replace($me,$chr(124),$chr(95)) $+ 's $nopath($2-) $+ "
    .remove %nickfile

    ;if the file is a fix.dat or a complete stats.txt file in the mirc folder, it will be moved
    if ($nofile($2-) == $null) {
      if (($right(%file,8) == fix.dat") || ($right(%file,10) == stats.txt")) { .rename %file %nickfile }
      else { .copy %file %nickfile }
    }
    else { .copy %file %nickfile }
    write " $+ %folder $+ _this folder is safe to delete_" $date(yyyymmdd) $time $1 requested:  $nopath($2-)

    if ($1 == $me) { echo -a $me $+ , you can't send a file to yourself so look for it here instead: %nickfile }
    elseif ($1 == notepad) { run notepad.exe %nickfile }
    elseif ($1 == rmhelp) { rmhelp %nickfile }
    else { dcc send $1 %nickfile }
  }
  else { .notice $1 I don't have that file. }
}

; *** Display the stats for each section
alias -l rm.all {
  var %section = 9
  while (%section < 21) {
    .timer 1 $calc(%section + 7) rm.dispage %section $1 $2
    inc %section
  }
  .timer 1 7 rm.ttl $1 $2
}

; *** Display the total ROM counts (add all the section totals)
alias -l rm.ttl {
  if (($3 == $null) && ($readini(%rm.rmp,PREF,g) == 1)) { var %rm.gms = game } | else { var %rm.gms = ROM }
  var %completeSystems = 0 | var %totalSystems = 0
  var %totalGMS = 0 | var %missingGMS = 0 | var %excludedGMS = 0
  var %section = 9
  while (%section < 21) {
    if ($rmSectionName(%section) != $null) {
      if (%rm.gms == game) { rmrf %section 1 } | else { rmrf %section }
      %completeSystems = %completeSystems + $hget(rmrf.totals,completeSystems)
      %totalSystems = %totalSystems + $hget(rmrf.totals,totalSystems)
      %totalGMS = %totalGMS + $hget(rmrf.totals,totalGMS)
      %missingGMS = %missingGMS + $hget(rmrf.totals,missingGMS)
      %excludedGMS = %excludedGMS + $hget(rmrf.totals,excludedGMS)
    }
    inc %section
  }
  $1 $2 has $bracket( $+ $calc(%totalGMS - %missingGMS - %excludedGMS) $+ / $+ %totalGMS  $+ %rm.gms $+ s) and $bracket( $+ %completeSystems $+ / $+ %totalSystems Complete Systems)
}

; *** Display short summary stats for each section
alias -l rm.shortstats {
  rm.color_check
  if (($3 == $null) && ($readini(%rm.rmp,PREF,g) == 1)) { var %rm.gms = Games | var %GMS = 1 }
  else { var %rm.gms = ROMs | var %GMS = $null }
  var %s = $bracket(%rm.c3 $+ Statistics)

  ; get stats
  var %completeSystems = 0 | var %totalSystems = 0
  var %totalGMS = 0 | var %missingGMS = 0
  var %section = 9
  while (%section < 18) {
    ; if section is 12 send the TOSEC flag to rmrf for combined tosec ROM stats, then skip tosec section 13
    if (%section == 12) { rmrf TOSEC %GMS | var %section = 13 | var %rmSectionLabel = TOSEC }
    else { rmrf %section %GMS | var %rmSectionLabel = $remove($rmSectionLabel(%section),$chr(38)) }
    var %completeSystems = %completeSystems + $hget(rmrf.totals,completeSystems)
    var %totalSystems = %totalSystems + $hget(rmrf.totals,totalSystems)
    var %totalGMS = %totalGMS + $hget(rmrf.totals,totalGMS)
    var %missingGMS = %missingGMS + $hget(rmrf.totals,missingGMS)
    var %s = %s $+ $bracket(%rm.c1 $+ %rmSectionLabel $+ %rm.c2 $hget(rmrf.totals,missingGMS) $+ / $+ %rm.c2 $+ $hget(rmrf.totals,totalGMS))
    inc %section
  }
  var %s = %s $+ $bracket(%rm.c3 $+ Missing %rm.gms %rm.c2 $+ %missingGMS $+ / $+ %rm.c2 $+ %totalGMS)
  var %s = %s $+ $bracket(%rm.c3 $+ Complete Systems %rm.c2 $+ %completeSystems $+ / $+ %rm.c2 $+ %totalSystems)

  ; get Custom stats
  var %completeSystems = 0 | var %totalSystems = 0
  var %totalGMS = 0 | var %missingGMS = 0
  var %section = 18
  while (%section < 21) {
    rmrf %section %GMS
    var %completeSystems = %completeSystems + $hget(rmrf.totals,completeSystems)
    var %totalSystems = %totalSystems + $hget(rmrf.totals,totalSystems)
    var %totalGMS = %totalGMS + $hget(rmrf.totals,totalGMS)
    var %missingGMS = %missingGMS + $hget(rmrf.totals,missingGMS)
    inc %section
  }
  if (%totalSystems > 0) {
    var %s = %s + $bracket(%rm.c1 $+ Custom $+ %rm.c2 %missingGMS $+ / $+ %rm.c2 $+ %totalGMS)
    var %s = %s $+ $bracket(%rm.c3 $+ Complete Custom Systems %rm.c2 $+ %completeSystems $+ / $+ %rm.c2 $+ %totalSystems)
  }

  $1 $2 %s
}

; *** display stats for a single system, like this:  is missing 0 of 58718 known MAME ROMs [and 0 of 9 CHDs]
alias -l rm.disp {
  if (($5 == $null) && ($readini(%rm.rmp,PREF,g) == 1)) { rm.zget $1 $2 g | var %gms = gamesets }
  else { rm.zget $1 $2 | var %gms = ROMs }
  if (%rm.zmissing == n/a) { %rm.zmissing = 0 | %rm.ztotal = 0 }

  if (%gms = ROMs) { var %s = is missing %rm.zmissing of %rm.ztotal  $+ $rmCleanSystemName($1,$2) }
  else {
    var %s = is missing %rm.zmissing of %rm.ztotal  $+ $rmSystemName($1,$2) %gms
    if ($matchtok(%s,ROMs,0,32) > 0) { var %s = $remtok(%s,ROMs,1,32) }
  }

  if (%rm.ztotal.disks > 0) {
    if (%rm.ztotal > 0) { var %s = %s $bracket(and %rm.zmissing.disks of %rm.ztotal.disks CHDs) }
    else { var %s = is missing %rm.zmissing.disks of %rm.ztotal.disks  $+ $rmSystemName($1,$2) }
  }
  if (%rm.ztotal.samples > 0) { var %s = %s $bracket(and %rm.zmissing.samples of %rm.ztotal.samples Samples) }
  if (%rm.zexcluded > 0) { var %s = %s $bracket( $+ %rm.zexcluded excluded) }
  if ($1 >= 18) { var %s = %s $bracket(Custom: $+ $rmSystem($1,$2)) }

  ;show the dat version if found
  var %version = $rmGetDatVersion($1,$2)
  if (%version != (not found)) { var %s = %s v $+ %version }

  ;show the system size if known
  if (%rm.ztotal.mb > 0) { var %s = %s $bracket(missing $convert(%rm.zmissing.mb) of $convert(%rm.ztotal.mb)) }

  ;only display results if there is something to show
  if ((%rm.ztotal > 0) || (%rm.ztotal.disks > 0) || (%rm.ztotal.samples > 0)) { $3 $4 %s }
}

; *** display stats for an entire section: [Arcade][Missing ROMs 75/62167, CHDs 14/27] ...
alias -l rm.dispage {
  ; rm.dispage <section, Custom, TOSEC> <write,echo,[describe,.notice,etc.]> <$me, $nick, $snicks, $active> [1] [zeros] [hideUnscannedSections]
  ;  some usage examples:
  ;..rm.dispage 14 write $snicks zeros
  ;..rm.dispage 15 echo $me
  ;..rm.dispage 14 describe $active 1
  ;..rm.dispage Custom .notice $nick 1 zeros

  if ($1 == Custom) { var %sectionName = Custom }
  elseif ($1 == TOSEC) { var %sectionName = TOSEC }
  else { var %sectionName = $rmSectionName($1) }
  if (%sectionName == $null) { return }
  if ($istok($4-,zeros,32) == $true) { var %showZeros = zeros } | else { var %showZeros }
  if (($istok($4-,1,32) == $false) && ($readini(%rm.rmp,PREF,g) == 1)) { rmrf $1 $2 1 %showZeros } | else { rmrf $1 $2 %showZeros }
  var %i = 1
  if ($2 == write) {
    var %filename = Complete %sectionName Stats.txt
    var %file = " $+ %filename $+ "
    write -c %file $me $+ 's Complete %sectionName Stats
    write %file 
    while (%i <= $hget(rmrf.pages,0).item) {
      write %file $strip($hget(rmrf.pages,%i))
      inc %i
    }
    rm.sendfile $3 %filename
  }
  else {
    if (($istok($4-,hideUnscannedSections,32) == $true) && ($hget(rmrf.totals,unscannedSystems) == $hget(rmrf.totals,totalSystems))) { return }
    if (1 <= $hget(rmrf.pages,0).item) { $2 $3 $hget(rmrf.pages,1) }
    if ($2 == echo) { var %interval = .2 } | else { var %interval = .5 }
    inc %i
    while (%i <= $hget(rmrf.pages,0).item) {
      .timer 1 $calc(%i * %interval) $2 $3 $hget(rmrf.pages,%i)
      if (%i == 3) { var %interval = .8 }
      inc %i
    }
  }
}

; *** generate the stats for an entire section and format it for display
alias -l rmrf {
  ; rmrf <section> [1] [zeros] [write]
  ;  some usage examples:
  ;..rmrf 14
  ;..rmrf 14 1
  ;..rmrf 14 1 zeros

  rm.color_check
  if $istok($2-,1,32) { var %rmrf.gms = Games } | else { var %rmrf.gms = ROMs }
  if $istok($2-,zeros,32) { var %rmrf.showZeros = $true } | else { var %rmrf.showZeros }
  if $istok($2-,write,32) { var %rmrf.write = $true } | else { var %rmrf.write }
  if $istok($2-,noscan,32) { var %rmrf.noscan = $true } | else { var %rmrf.noscan }

  if $hget(rmrf.pages) { .hfree rmrf.pages }
  if $hget(rmrf.totals) { .hfree rmrf.totals }
  if ($1 == Custom) { var %section = 18 }
  elseif ($1 == TOSEC) { var %section = 12 }
  else { var %section = $1 }
  var %systems = $rmSystemCount(%section)
  .hmake rmrf.pages 10
  .hmake rmrf.totals 11
  hadd rmrf.totals totalSystems %systems | hadd rmrf.totals completeSystems 0 | hadd rmrf.totals emptySystems 0 | hadd rmrf.totals unscannedSystems 0
  hadd rmrf.totals totalGMS 0 | hadd rmrf.totals missingGMS 0 | hadd rmrf.totals excludedGMS 0
  hadd rmrf.totals totalCHDs 0 | hadd rmrf.totals missingCHDs 0
  hadd rmrf.totals totalSamples 0 | hadd rmrf.totals missingSamples 0
  hadd rmrf.totals totalMBytes 0 | hadd rmrf.totals missingMBytes 0
  var %disks | var %samples | var %bytes
  var %i = 1 | var %x = 1
  var %linelength = 300
  if (%rmrf.showZeros == $true) { inc %x | inc %linelength 50 }
  ; [MAME 100/57512][MisfitNM 0/1378]...
  while (%i <= %systems) {
    ; these are set by rm.zget: %rm.zmissing,%rm.ztotal,%rm.zexcluded
    if (%rmrf.gms == Games) { rm.zget %section %i g }
    else { rm.zget %section %i }
    if ((%rm.ztotal == 0) && (%rm.ztotal.disks == 0) && (%rm.ztotal.samples == 0)) {
      hinc rmrf.totals unscannedSystems
      if %rmrf.noscan { hadd rmrf.pages %x $hget(rmrf.pages,%x) $+ $bracket($rmSystem(%section,%i) 0/0) | inc %x }
    }
    else {
      if ((%rm.zmissing == %rm.ztotal) && (%rm.zmissing.disks == %rm.ztotal.disks) && (%rm.zmissing.samples == %rm.ztotal.samples)) { hinc rmrf.totals emptySystems }
      if (%rm.ztotal.disks > 0) {
        hinc rmrf.totals totalDisks %rm.ztotal.disks
        hinc rmrf.totals missingDisks %rm.zmissing.disks
        var %disks = , $+ %rm.c2 CHDs %rm.zmissing.disks $+ / $+ %rm.c2 $+ %rm.ztotal.disks
      }
      if (%rm.ztotal.samples > 0) {
        hinc rmrf.totals totalSamples %rm.ztotal.samples
        hinc rmrf.totals missingSamples %rm.zmissing.samples
        var %samples = , $+ %rm.c2 Samples %rm.zmissing.samples $+ / $+ %rm.c2 $+ %rm.ztotal.samples
      }
      if (%rm.zmissing.mb > 0) {
        hinc rmrf.totals totalMBytes %rm.ztotal.mb
        hinc rmrf.totals missingMBytes %rm.zmissing.mb
        ;var %bytes = , $+ %rm.c2 $convert(%rm.zmissing.mb) $+ / $+ %rm.c2 $+ $convert(%rm.ztotal.mb)
        var %bytes = %rm.c2 $convert(%rm.zmissing.mb) $+  $+ $chr(44)
      }
      if (%rm.zmissing == 0) {
        if ((%rm.zmissing.disks == 0) && (%rm.zmissing.samples == 0)) { hinc rmrf.totals completeSystems }
        if ((%rmrf.showZeros == $true) || (%rm.zmissing.disks > 0) || (%rm.zmissing.samples > 0)) {
          hadd rmrf.pages %x $hget(rmrf.pages,%x) $+ $bracket(%rm.c1 $+ $rmSystem(%section,%i) $+ %bytes $+ %rm.c2 %rm.zmissing $+ / $+ %rm.c2 $+ %rm.ztotal $+ %disks $+ %samples)
        }
      }
      else {
        hinc rmrf.totals missingGMS %rm.zmissing
        if (%rm.ztotal.disks == 0) { var %disks }
        if (%rm.ztotal.samples == 0) { var %samples }
        hadd rmrf.pages %x $hget(rmrf.pages,%x) $+ $bracket(%rm.c1 $+ $rmSystem(%section,%i) $+ %bytes $+ %rm.c2 %rm.zmissing $+ / $+ %rm.c2 $+ %rm.ztotal $+ %disks $+ %samples)
      }
      hinc rmrf.totals totalGMS %rm.ztotal
      hinc rmrf.totals excludedGMS %rm.zexcluded
      if (%rmrf.write == $true) { inc %x }
      elseif ($len($hget(rmrf.pages,%x)) > %linelength) { inc %x }
    }
    var %disks | var %samples | var %bytes

    inc %i
    ; if $1=Custom, reset the counters to allow all the custom info to be loaded
    if (($1 == Custom) && (%i > %systems) && (%section < 20)) {
      inc %section
      var %systems = $rmSystemCount(%section)
      hinc rmrf.totals totalSystems %systems
      var %i = 1
    }
    ; if $1=TOSEC, reset the counters to allow the TOSEC 2 info to be loaded
    if (($1 == TOSEC) && (%i > %systems) && (%section < 13)) {
      inc %section
      var %systems = $rmSystemCount(%section)
      hinc rmrf.totals totalSystems %systems
      var %i = 1
    }
  }
  if ($1 == Custom) { var %sectionName = Custom }
  elseif ($1 == TOSEC) { var %sectionName = TOSEC }
  else { var %sectionName = $remove($rmSectionLabel(%section),&) }

  ; [Arcade][Missing ROMs 12/60760]
  if ($hget(rmrf.totals,totalDisks) > 0) { var %disks = , $+ %rm.c3 CHDs $+ %rm.c2 $hget(rmrf.totals,missingDisks) $+ / $+ %rm.c2 $+ $hget(rmrf.totals,totalDisks) }
  if ($hget(rmrf.totals,totalSamples) > 0) { var %samples = , $+ %rm.c3 Samples $+ %rm.c2 $hget(rmrf.totals,missingSamples) $+ / $+ %rm.c2 $+ $hget(rmrf.totals,totalSamples) }
  var %s = $bracket(%rm.c3 $+ %sectionName) $+ $bracket(%rm.c3 $+ Missing %rmrf.gms $+ %rm.c2 $hget(rmrf.totals,missingGMS) $+ / $+ %rm.c2 $+ $hget(rmrf.totals,totalGMS) $+ %disks $+ %samples)
  if (%rmrf.showZeros == $true) { hadd rmrf.pages 1 %s } | else { hadd rmrf.pages 1 %s $+ $hget(rmrf.pages,1) }
  ; [Complete Systems 11/12]
  if ((%rmrf.write != $true) && (%rmrf.showZeros == $true) && ($hget(rmrf.totals,missingGMS) > 0) && ($hget(rmrf.pages,%x) != $null)) { inc %x }
  hadd rmrf.pages %x $hget(rmrf.pages,%x) $+ $bracket(%rm.c3 $+ Complete Systems $+ %rm.c2 $hget(rmrf.totals,completeSystems) $+ / $+ %rm.c2 $+ $hget(rmrf.totals,totalSystems))
  if ($hget(rmrf.totals,emptySystems) > 0) { hadd rmrf.pages %x $hget(rmrf.pages,%x) $+ $bracket(%rm.c1 $+ Empty $+ %rm.c2 $hget(rmrf.totals,emptySystems)) }
  if ($hget(rmrf.totals,unscannedSystems) > 0) { hadd rmrf.pages %x $hget(rmrf.pages,%x) $+ $bracket(%rm.c1 $+ Unscanned $+ %rm.c2 $hget(rmrf.totals,unscannedSystems)) }
  if ($hget(rmrf.totals,excludedGMS) > 0) { hadd rmrf.pages %x $hget(rmrf.pages,%x) $+ $bracket(%rm.c3 $+ Excluded ROMs $+ %rm.c2 $hget(rmrf.totals,excludedGMS)) }
  ;if ($hget(rmrf.totals,totalMBytes) > 0) { hadd rmrf.pages %x $hget(rmrf.pages,%x) $+ $bracket(%rm.c3 $+ missing at least $+ %rm.c2 $convert($hget(rmrf.totals,missingMBytes)) $+ / $+ %rm.c2 $+ $convert($hget(rmrf.totals,totalMBytes))) }
}

; *** read the log file for the given system and put the info in the %rm.* vars
alias -l rm.zget {
  var %rm.type = $rmLogType($1,$2)
  var %logFile = $rmLogFile($1,$2)
  %rm.zmissing = 0 | %rm.ztotal = 0 | %rm.zexcluded = 0
  %rm.zmissing.disks = 0 | %rm.ztotal.disks = 0
  %rm.zmissing.samples = 0 | %rm.ztotal.samples = 0
  %rm.zmissing.mb = 0 | %rm.ztotal.mb = 0
  ;if the log file does not exist, return
  if ($exists(%logFile) == $false) { return }
  ;GoodMiss.txt
  if ((%rm.type == 1) || (%rm.type == 4) || (%rm.type == 6)) {
    var %x = $read(%logFile,1)
    %rm.zmissing = $gettok(%x,4,32)
    %rm.ztotal = $gettok(%x,6,32)
    if ($count(%x,excluded) == 1) {
      %rm.zexcluded = $right($gettok(%x,-2,32),-1)
      inc %rm.ztotal %rm.zexcluded
    }
  }
  ;ClrMAME log file
  elseif (%rm.type == 2) {
    var %x = $read(%logFile,ns,Missing Roms:)
    %rm.zmissing = $gettok(%x,1,32)

    ; read in Missing Bytes while we are here
    var %y = $read(%logFile,ns,Missing Bytes:,$readn)
    if ($readn != 0) {
      %rm.zmissing.mb = $convert($gettok(%y,1,32))
      %rm.ztotal.mb = $convert($gettok(%y,-1,32))
    }

    ;make sure Missing Roms isn't <n/a>
    if ((%x > 0) && (%x < 999999)) {
      %rm.ztotal = $gettok(%x,-1,32)
      ;adjust %rm.zmissing based on ROM errors
      var %x = $read(%logFile,ns,Wrong Sized Roms:,$readn)
      var %x = $gettok(%x,1,32)
      if ((%x > 0) && (%x < 999999)) { inc %rm.zmissing %x }
      var %x = $read(%logFile,ns,Wrong CRC32s:,$readn)
      var %x = $gettok(%x,1,32)
      if ((%x > 0) && (%x < 999999)) { inc %rm.zmissing %x }
      var %x = $read(%logFile,ns,Wrong MD5s:,$readn)
      var %x = $gettok(%x,1,32)
      if ((%x > 0) && (%x < 999999)) { inc %rm.zmissing %x }
      var %x = $read(%logFile,ns,Wrong SHA1s:,$readn)
      var %x = $gettok(%x,1,32)
      if ((%x > 0) && (%x < 999999)) { inc %rm.zmissing %x }
    }
    ;no roms in this log file
    else {
      %rm.zmissing = n/a
      %rm.ztotal = n/a
    }
    ; Samples
    var %x = $read(%logFile,ns,Missing Samples:,$readn)
    var %y = $gettok(%x,1,32)
    if ((%y >= 0) && (%y < 999999)) {
      %rm.zmissing.samples = %y
      %rm.ztotal.samples = $gettok(%x,-1,32)
    }
    ; CHDs
    var %x = $read(%logFile,ns,Missing CHDs:,$readn)
    var %y = $gettok(%x,1,32)
    if ((%y >= 0) && (%y < 999999)) {
      %rm.zmissing.disks = %y
      %rm.ztotal.disks = $gettok(%x,-1,32)
      ;adjust %rm.zmissing.disks if there are any MD5 errors
      var %x = $read(%logFile,ns,Wrong CHD_MD5s:,$readn)
      var %x = $gettok(%x,1,32)
      if ((%x > 0) && (%x < 999999)) { inc %rm.zmissing.disks %x }
    }
  }
  ;RomCenter log file
  elseif (%rm.type == 3) {
    var %x = $read(%logFile,1)
    %rm.zmissing = $gettok(%x,4,32)
    %rm.ztotal = $gettok(%x,9,32)
  }
  ;TUGID log file
  elseif (%rm.type == 5) {
    var %x = $read(%logFile,2)
    %rm.zmissing = $gettok(%x,2,32)
    %rm.ztotal = $gettok(%x,4,32)
  }
  if ($3 == g) {
    ;TUGID log file
    if (%rm.type == 5) { echo WARNING: TUGID missing lists are not compatible with the "Display Games" option }
    ;ClrMAME log file
    elseif (%rm.type == 2) {
      var %x = $read(%logFile,ns,Missing Sets:)
      if (%x == $null) { var %x = $read($rmLogFile($1,$2),ns,Missing Games:) }
      %rm.zmissing = $gettok(%x,1,32)
      %rm.ztotal = $gettok(%x,-1,32)
    }
    ;RomCenter log file
    elseif (%rm.type == 3) {
      var %x = $read(%logFile,1)
      %rm.zmissing = $right($gettok(%x,5,32),-1)
      %rm.ztotal = $right($gettok(%x,-2,32),-1)
    }
  }
  ; if disks or samples are in the log, allow 0 total roms
  if ((%rm.ztotal == n/a) && ((%rm.ztotal.disks > 0) || (%rm.ztotal.samples > 0))) {
    %rm.ztotal = 0
    %rm.zmissing = 0
  }
  elseif ((%rm.zmissing < 0) || (%rm.zmissing > 999999) || (%rm.ztotal <= 0) || (%rm.ztotal > 999999) || (%rm.zmissing == $null) || (%rm.ztotal == $null)) {
    remLogInfo $1 $rmSystem($1,$2)
    %rm.ztotal = 0
    %rm.zmissing = 0
  }
}

; *** displays the abbreviations of a custom section
; rm.gca <section> <notice,echo,describe> <nick>
alias -l rm.gca {
  if $hget(rm.gca.pages) { .hfree rm.gca.pages }
  .hmake rm.gca.pages 1
  var %linelength = 300
  var %section = $1
  var %systems = $rmSystemCount(%section)
  hadd rm.gca.pages 1 has $chr(40) $+ %systems $+ $chr(41) $remove($rmSectionLabel(%section),&) systems:
  var %x = 1
  var %i = 1
  while (%i <= %systems) {
    hadd rm.gca.pages %x $hget(rm.gca.pages,%x) $rmSystem(%section,%i) $+ $chr(44)
    if ($len($hget(rm.gca.pages,%x)) > %linelength) { inc %x }
    inc %i
  }
  var %lastpage = $hget(rm.gca.pages,0).item
  hadd rm.gca.pages %lastpage $left($hget(rm.gca.pages,%lastpage),-1)
  $2 $3 $hget(rm.gca.pages,1)
  if ($2 == echo) { var %interval = .2 } | else { var %interval = .5 }
  var %i = 2
  while (%i <= %lastpage) {
    .timer 1 $calc(%i * %interval) $2 $3 $chr(32) $hget(rm.gca.pages,%i)
    if (%i == 3) { var %interval = .8 }
    inc %i
  }
}

; ***  the bracket alias makes it easier to make text look like [text]
alias -l bracket { return [ $+ $1- $+ ] }

; ***  format a number from megabytes to a pretty GB, MB, KB, or plain old Bytes
alias -l convert {
  if ($1 == 0) { return 0 }
  if ($right($1,1) == b) {
    var %t = $right($1,2)
    if (%t == kb) { return $calc($remove($1,kb) / 1024) }
    if (%t == mb) { return $remove($1,mb) }
    if (%t == gb) { return $calc($remove($1,gb) * 1024) }
    return 0
  }
  if (($1 !isnum) || ($1 < 0)) { return n/a }
  if ($calc($1 / 1024) >= 1) { return $round($calc($1 / 1024),1) $+ gb }
  if ($1 >= 1) { return $1 $+ mb }
  if ($calc($1 * 1024) >= 1) { return $round($calc($1 * 1024),1) $+ kb }
  return $round($calc($1 * 1048576),1) $+ b
}

; ***  rm.color_check sets %rm.c1 for names, %rm.c2 for numbers, and %rm.c3 for information.
alias -l rm.color_check {
  if ($readini(%rm.rmp,C,c1) == $null) {
    writeini %rm.rmp C c1 04
    writeini %rm.rmp C c2 03
    writeini %rm.rmp C c3 12
  }
  %rm.c1 =  $+ $readini(%rm.rmp,C,c1)
  %rm.c2 =  $+ $readini(%rm.rmp,C,c2)
  %rm.c3 =  $+ $readini(%rm.rmp,C,c3)
  if (($right(%rm.c1,2) < 2) || ($right(%rm.c1,2) > 16)) { %rm.c1 04 }
  if (($right(%rm.c2,2) < 2) || ($right(%rm.c2,2) > 16)) { %rm.c2 03 }
  if (($right(%rm.c3,2) < 2) || ($right(%rm.c3,2) > 16)) { %rm.c3 12 }
  if ($right(%rm.c1,2) > 15) { %rm.c1  }
  if ($right(%rm.c2,2) > 15) { %rm.c2  }
  if ($right(%rm.c3,2) > 15) { %rm.c3  }
}

; *** Create a database checkfile from the data in the rlm.ini file
; if $1 = Custom, it will ask the user to select a checkfile
; if $1 is empty, it will use the default checkfile.ini
alias -l rm.CreateCheckfile {
  var %rm.path = $scriptdir
  var %rmcheck.ini = " $+ %rm.path $+ rmcheck.ini $+ "
  if ($1 != $null) {
    if ($readini(%rm.rmp,PREF,w) != $null) { var %rm.path = $readini(%rm.rmp,PREF,w) }
    var %rmcheck.ini = " $+ $$sfile(%rm.path $+ rmcheck.ini,- Select a place to write your checkfile...,Save Here) $+ "
    writeini %rm.rmp PREF w $nofile(%rmcheck.ini)
  }
  echo -a 12
  echo -a Please wait, writing checkfile...
  write -c %rmcheck.ini [RM4-Checkfile]
  write %rmcheck.ini version= $+ %rm.version
  var %section = 9
  while (%section < 21) {
    var %i = 1
    var %system_count = $rmSystemCount(%section)
    while ((%i <= %system_count) && (%system_count > 0)) {
      rm.zget %section %i
      if (%rm.ztotal > 0) { write %rmcheck.ini $rmSystem(%section,%i) $+ = $+ %rm.ztotal }
      inc %i
    }
    inc %section
  }
  write %rmcheck.ini signature= $+ $me
  if $isfile(%rmcheck.ini) { echo -a %rmcheck.ini was created succesfully! }
  else { echo -a ERROR: could not write %rmcheck.ini !! }
  echo -a 12
}

; *** Compare the database info in the rlm.ini file with that stored in a checkfile
; if $1 = Custom, it will ask the user to select a checkfile
; if $1 is empty, it will use the default checkfile.ini (if it doesnt exist, it will be created)
alias -l rm.VerifyCheckfile {
  var %rm.path = $scriptdir
  var %rmcheck.ini = " $+ %rm.path $+ rmcheck.ini $+ "
  if ($1 == $null) { if ($isfile(%rmcheck.ini) == $false) { rm.CreateCheckfile } }
  else {
    if ($readini(%rm.rmp,PREF,r) != $null) { var %rm.path = $readini(%rm.rmp,PREF,r) }
    var %rmcheck.ini = " $+ $$sfile(%rm.path $+ rmcheck.ini,- Select a checkfile to analyze...,Compare) $+ "
    writeini %rm.rmp PREF r $nofile(%rmcheck.ini)
  }
  var %rmcheck.tmp = " $+ $scriptdir $+ rmcheck.tmp $+ "

  var %s = $read(%rmcheck.ini,1)
  if (%s != [RM4-Checkfile]) { echo ERROR: %rmcheck.ini is not a valid RomManager Checkfile | halt }
  if ($readini(%rmcheck.ini,RM4-Checkfile,signature) == $null) { echo ERROR: couldn't read data from %rmcheck.ini | halt }
  echo -a 12
  echo -a Please wait, verifying totals from $readini(%rmcheck.ini,RM4-Checkfile,signature) $+ ...
  write -c %rmcheck.tmp %s
  var %i = 2
  while (%i <= $lines(%rmcheck.ini)) {
    write %rmcheck.tmp $read(%rmcheck.ini,%i)
    inc %i
  }
  if ($readini(%rmcheck.tmp,RM4-Checkfile,version) != %rm.version) {
    echo -a WARNING: Version mismatch: $readini(%rmcheck.tmp,RM4-Checkfile,version) (you are using v $+ %rm.version $+ )
  }
  var %rm.checked = 0
  var %rm.flag = 0
  var %section = 9
  while (%section < 21) {
    var %i = $rmSystemCount(%section)
    while (%i > 0) {
      var %system = $rmSystem(%section,%i)
      var %testval = $readini(%rmcheck.tmp,RM4-Checkfile,%system)
      if (%testval != $null) {
        rm.zget %section %i
        if ((%rm.ztotal != %testval) && (%rm.ztotal < 999999) && (%rm.ztotal > 0)) {
          echo -a Different total ( $+ you: %rm.ztotal - checkfile: %testval $+ ) found in $rmSystemName(%section,%i)
        }
        elseif (%rm.ztotal == %testval) { inc %rm.checked }
        else { inc %rm.flag }
        remini %rmcheck.tmp RM4-Checkfile %system
      }
      dec %i
    }
    inc %section
  }
  var %i = 3
  while (%i < $lines(%rmcheck.tmp)) {
    var %s = $read(%rmcheck.tmp,%i)
    echo -a WARNING: Unrecognized system " $left(%s,$calc($pos(%s,=,1) - 1)) "
    inc %i
  }
  remini %rmcheck.tmp RM4-Checkfile
  if (%rm.flag > 0) { echo -a WARNING: You have %rm.flag systems with misconfigured logs or unreadable stats. }
  echo -a Matching systems: %rm.checked / $calc($lines(%rmcheck.ini) - 3)
  echo -a 12
}

; if the Fix.Dat option is selected in View/Transfer mode, convert a ClrMamePro log file to a ClrMamePro compatible fix.dat
; and return the path to it (and set it to be deleted once the calling function finishes), otherwise return $1 unchanged
; needs: <$1=section, $2=N> or <$1=0, $2- =log file>
alias -l rmFixDat {
  if ($1 > 0) { var %logFile = $rmLogFile($1,$2) }
  ;i know nothing! about the section/system
  else { var %logFile = $2- }
  var %file = $nopath(%logFile)
  if ($gettok(%file,-1,46) == log) {
    var %s = $read(%logFile,ntw,*missing rom:*)
    if ($readn == 0) { return %logFile }
    var %dat = $deltok(%file,-1,46)
    var %filename = %dat $+ $chr(32) $+ fix.dat
    var %file = " $+ %filename $+ "
    .fopen -o fixdat %file
    if $ferr { .fclose fixdat | .fopen -o fixdat %file }
    .fwrite -n fixdat clrmamepro ( $+ $crlf $+ $chr(9) $+ name " $+ $me $+ 's %dat fix" $+ $crlf $+ $chr(9) $+ description " $+ $me $+ 's %dat fix"
    .fwrite -n fixdat $chr(9) $+ category DATFILE $+ $crlf $+ $chr(9) $+ version " $+ $adate $time $+ "
    .fwrite -n fixdat $chr(9) $+ author "created by RomManager v $+ %rm.version $+ "
    var %total_lines = $lines(%logFile)
    var %i = 1
    var %s = $read(%logFile,nt,%i)
    while (%i <= %total_lines) {
      var %linetest = $gettok($gettok(%s,1,58),-1,32)
      if (%linetest == [folder) {
        var %name = $gettok(%s,2,58)
        if ($numtok(%s,58) > 2) { var %name = $deltok($deltok(%name,-1,32),-1,32) }
        else { var %name = $left(%name,-1) }
        var %description = $deltok($gettok(%s,1,58),-1,32)
        var %description = " $+ %description $+ "
        var %name = " $+ %name $+ "
        .fwrite -n fixdat ) $+ $crlf $+ $crlf $+ game ( $+ $crlf $+ $chr(9) $+ name %name $+ $crlf $+ $chr(9) $+ description %description
      }
      elseif (%linetest == rom) {
        var %size = - | var %crc32 = - | var %sha1 | var %md5
        var %rom = $deltok($gettok(%s,2,58),-1,91)
        var %rom " $+ $right(%rom,-1) $+ "
        var %pos = $findtok(%s,[size:,1,32)
        if (%pos != $null) { inc %pos | var %size = $gettok($gettok(%s,%pos,32),1,93) }
        var %pos = $findtok(%s,[CRC32:,1,32)
        if (%pos != $null) { inc %pos | var %crc32 = $gettok($gettok(%s,%pos,32),1,93) }
        var %pos = $findtok(%s,[SHA1:,1,32)
        if (%pos != $null) {
          inc %pos | var %sha1 = $gettok($gettok(%s,%pos,32),1,93)
          ;strip any leading 0x
          if ($left(%sha1,2) == 0x) { var %sha1 = $right(%sha1,-2) }
          var %sha1 = sha1 %sha1
        }
        var %pos = $findtok(%s,[MD5:,1,32)
        if (%pos != $null) {
          inc %pos | var %md5 = $gettok($gettok(%s,%pos,32),1,93)
          ;strip any leading 0x
          if ($left(%md5,2) == 0x) { var %md5 = $right(%md5,-2) }
          var %md5 = md5 %md5
        }
        .fwrite -n fixdat $chr(9) $+ rom ( name %rom size %size crc %crc32 %sha1 %md5 )
      }
      ;wrong xxxx: bla.rom [wrong: xxxxxxxxx] [right: xxxxxxxxxx]
      elseif ((%linetest == crc32) || (%linetest == size) || (%linetest == sha1) || (%linetest == md5)) {
        var %right = $gettok($gettok(%s,-1,32),1,93)
        var %rom = $deltok($gettok(%s,2,58),-1,91)
        var %rom = " $+ $right(%rom,-1) $+ "
        ;try to find a matching dat file
        if (%rmFindDat == $null) { %rmFindDat = $rmFindDat($1,$2-) }
        ;if a dat was found, try and read the rom info from the dat
        if (%rmFindDat != $null) {
          ; if it is a size problem, need to search the dat using the rom name
          if (%linetest == size) {
            var %x = $read(%rmFindDat,ntw,* %rom *)
            if ($istok(%x,%right,32) == $false) { var %x = $null }
          }
          ;this should work for everything else
          else {
            var %x = $read(%rmFindDat,ntw,* %right *)
            ;if its a crc32 strip the 0x and try again
            if ((%x == $null) && (%linetest == crc32)) { var %x = $read(%rmFindDat,ntw,* $right(%right,-2) *) }
          }
          ;a matching rom was found, write that line to the fixdat. no formating required! may be missing sha1 or md5, but shouldn't matter
          if (%x != $null) { .fwrite -n fixdat %x }
        }
        ;no dat was found or no match was found in the dat, so can only fix crc32, without any other rom info
        if ((%x == $null) && (%linetest == crc32)) { .fwrite -n fixdat rom ( name %rom size - crc %right sha1 - md5 - ) }
      }
      inc %i
      var %s = $read(%logFile,n,%i)
    }
    .fwrite -n fixdat ) $+ $crlf
    .fclose fixdat
    unset %rmFindDat
    return %filename
  }
  return %logFile
}

; find a dat that matches the log file.
; needs: <$1=section, $2=N> or <$1=0, $2- =log file>
alias rmFindDat {
  if ($1 > 0) {
    var %system = $rmSystem($1,$2)
    if ($hget(rmDats) == $null) { .hmake rmDats 10 }
    ;if the system is already in the hash table, return the dat
    if ($hget(rmDats,%system) != $null) { return $hget(rmDats,%system) }
    ;no such luck

    var %logFile = $rmLogFile($1,$2)
    if ($gettok(%logFile,-1,46) == txt) { return }

    %logFile = $deltok(%logFile,-1,46) $+ *.dat
    var %SystemName = $rmSystemName($1,$2) $+ *.dat
    var %AltName = $rmSystemAlt($1,$2) $+ *.dat

    var %datFile = $rmFindDatDat($1, %logFile)
    if (%datFile == $null) { %datFile = $rmFindDatDat($1, %AltName) }
    if (%datFile == $null) { %datFile = $rmFindDatDat($1, %SystemName) }

    if (%datFile != $null) { hadd rmDats %system %datFile }
  }

  ;else all i know is the log file
  else {
    var %logFile = $deltok($replace($2-,$chr(95),$chr(32)),-1,46) $+ *.dat
    var %datFile = $rmFindDatDat($1, %logFile)
  }

  return %datFile
}

alias -l rmFindDatDat {
  var %search = $nopath($2-)
  var %datFile
  if (%search == *.dat) { return %datFile }

  ;if the datfile path was set for this section, try and use it first
  if ($1 > 0) {
    var %folder = $readini(%rm.rmp,PREF,datroot $+ $1)
    if ($isdir(%folder)) { var %datFile = $findfile(%folder,%search,1,1) }
  }

  ;if the log folder looks like *\ClrMamePro\logs\*
  if ((%datFile == $null) && ($istok($2-,ClrMamePro,92)) && ($istok($2-,logs,92))) {
    ;remove the file name & set the folder to *\ClrMamePro\datfiles\*
    var %folder = $nofile($reptok($2-,logs,datfiles,1,92))
    if ($isdir(%folder)) { var %datFile = $findfile(%folder,%search,1,3) }
  }

  ;just hope ClrMamePro is in its default folder
  if (%datFile == $null) {
    var %folder = C:\Program Files\ClrMamePro\datfiles\
    if ($isdir(%folder)) { var %datFile = $findfile(%folder,%search,1,3) }
  }
  return %datFile
}


; find a dat that matches the log file and then determine the dat version.
; needs: <$1=section, $2=N> or <$1=0, $2- =log file>
alias rmGetDatVersion {
  if ($1 > 0) {
    var %system = $rmSystem($1,$2)
    if ($hget(rmDatVersions) == $null) { .hmake rmDatVersions 10 }
    ;if the system is already in the hash table, return the dat
    if ($hget(rmDatVersions,%system) != $null) { return $hget(rmDatVersions,%system) }

    var %type = $rmLogType($1,$2)
  }
  else { %type = 0 }
  var %version
  ;GoodMiss.txt
  if ((%type == 1) || (%type == 4) || (%type == 6)) {
    var %log = $rmLogFile($1,$2)
    var %version = $read(%log,1)
    %version = $gettok(%version,2,40)
    %version = $gettok(%version,1,41)
    %version = $gettok(%version,1,32)
  }
  ;ClrMAME log file
  else {
    ;try to find a matching dat file
    var %dat = $rmFindDat($1,$2-)
    ;try and extract the version from the dat name
    if (%dat != $null) { var %version = $gettok($rmExtractInfo($nopath(%dat)),-1,9) }

    ;try and extract the version line from insided the dat
    if (%version == (not found) ) {
      var %version = $read(%dat,ntw,*version *)
      ;remove leading spaces & any tabs
      var %version = $removeLeadingSpaces($remove(%version,$chr(9)))
      ;make sure it is the version line and not part of some ROM name...
      if ($gettok(%version,1,32) == version) { var %version = $deltok(%version,1,32) } | else { var %version }
      ;make sure it is the version line and not part of some ROM name...
      if ($gettok(%version,1,32) == version) { var %version = $deltok(%version,1,32) } | else { var %version }
    }
  }
  if (%version == $null) { var %version = (not found) }
  else { var %version = $remove(%version, v, -) }
  if ($1 > 0) { hadd rmDatVersions %system %version }
  return %version
}

;extract the systemName, dat type, & version from the given string.
alias rmExtractInfo {
  var %s = $1-
  var %type = $rmFindType(%s)
  var %s = $nopath($remove(%s,$chr(34)))
  var %s = $remove(%s,.dat,.zip,.rar,.7z,_CM,_RC)
  var %s = $remove(%s,.udb,_TD,CM)
  var %s = $remove(%s,$chr(40) $+ $chr(41),$chr(91) $+ $chr(93))
  ;replace all   ')('  with  ') ('
  var %s = $replace(%s,$chr(41) $+ $chr(40), $chr(41) $+ $chr(32) $+ $chr(40))

  if ($numtok(%s,32) == 1) {
    if ($left(%s,4) == Good) { var %s = $gettok(%s,1,95) $+ $chr(32) $+ $deltok(%s,1,95) }
    else { var %s = $deltok(%s,-1,95) $+ $chr(32) $+ $gettok(%s,-1,95) }
  }
  var %systemName = $deltok(%s,-1,32)
  var %version = $gettok(%s,-1,32)
  ;if there is a ) in the version but no (, split based on () instead of spaces
  if (($pos(%version,$chr(41),1) != $null) && ($pos(%version,$chr(40),1) == $null)) {
    var %systemName = $deltok(%s,-1,40)
    var %version = $chr(40) $+ $gettok(%s,-1,40)
  }
  if (%type = 1) {
    var %systemName = $remove(%systemName,Good)
    var %version = $remove(%version,$chr(95))
    var %version = $left(%version,1) $+ . $+ $replace($right(%version,-1),999,999.)
    if (%version == .) { var %version = (not found) }
  }
  else {
      ;remove chars: ", (, ), [, ], _, -, TOSEC, v
      var %version = $remove(%version,$chr(34),$chr(40),$chr(41),$chr(91),$chr(93))
      var %version = $replace(%version,$chr(95),$chr(32))
      var %version = $remove(%version,TOSEC,EE,r8,Trout,v,-)
  }
  if (%systemName == $null) { var %systemName = %version | var %version }
  if (%systemName == $null) { var %systemName = (not found) }
  if (%version == $null) { var %version = (not found) }
  return %systemName $+ $chr(9) $+ %type $+ $chr(9) $+ %version
}

;determine the dat type from the given string, then cheat and assume it is 2
alias -l rmFindType {
  if ($pos($1-,CM,1) != $null) { return 2 }
  if ($pos($1-,RC,1) != $null) { return 3 }
  if ($pos($1-,TD,1) != $null) { return 5 }
  if ($pos($1-,Good,1) != $null) { return 1 }
  return 2
}

;###################
;#     Dialogs     #
;###################

;######################################
;# ***** MAIN ROMMANAGER DIALOG ***** #
;######################################
dialog rmmngr {
  title "rmmngr"
  size -1 -1 238 220
  option dbu

  ;Categories area box
  box Categories and Systems List, 31, 1 2 158 46
  text System Count, 5, 76 31 80 7
  text , 6, 76 38 70 7
  icon 9, 5 10 16 16,  %rm.icon, 0
  icon 10, 23 10 16 16,  %rm.icon, 1
  icon 11, 41 10 16 16,  %rm.icon, 2
  icon 12, 59 10 16 16,  %rm.icon, 3
  icon 13, 77 10 16 16,  %rm.icon, 4
  icon 14, 95 10 16 16,  %rm.icon, 5
  icon 15, 113 10 16 16,  %rm.icon, 6
  icon 16, 131 10 16 16,  %rm.icon, 7
  ;box , 170, 132 7 15 19
  icon 17, 5 29 16 16,  %rm.icon, 8
  icon 18, 23 29 16 16,  %rm.icon, 9
  icon 19, 41 29 16 16,  %rm.icon, 10
  icon 20, 59 29 16 16,  %rm.icon, 11

  ;Systems area box
  box , 32, 1 44 158 134
  list 1, 2 48 155 122, vsbar, hsbar

  ;"Control -" area box
  box Control, 33, 161 2 76 116
  icon 21, 164 10 16 16,  %rm.icon, 12
  icon 22, 182 10 16 16,  %rm.icon, 13
  icon 23, 200 10 16 16,  %rm.icon, 14
  icon 24, 218 10 16 16,  %rm.icon, 15
  button One, 51, 166 31 66 11
  button Two, 52, 166 43 66 11
  button Three, 53, 166 55 66 11
  button Four, 54, 166 67 66 11
  button Five, 55, 166 79 66 11
  button Six, 56, 166 91 66 11
  edit , 62, 166 79 66 11, hide read autohs center
  edit , 63, 166 103 66 11, hide read autohs center
  text , 64, 166 34 66 7, hide center
  text , 65, 166 41 66 14, hide center

  ;"Display Type" / "File Type" area boxes
  box File Type, 68, 161 27 76 91
  check &Manually Select File, 69, 166 106 65 8
  box Display Type, 70, 161 27 76 69
  radio , 71, 201 36 35 8, group
  radio , 72, 166 36 35 8
  radio &Totals, 73, 166 44 35 8
  radio Summar&y, 74, 201 44 35 8

  ;"Format" area box
  box Format, 76, 161 92 76 26
  radio St&andard, 77, 166 100 35 8, group
  radio &Complete, 78, 166 108 35 8
  check E&xclusive, 79, 201 108 34 8
  check Com&bined, 80, 201 100 34 8

  ;"Channel Preferences" area box
  box Channel Preferences, 90, 161 120 76 19
  ;display ROMs or Games
  check &Gamesets, 91, 166 129 32 7
  ;allow !rmiss requests
  check Re&quests, 92, 201 129 35 7

  ;"Dialog Preferences" area box
  box Dialog Preferences, 100, 161 141 76 37
  ;show on desktop or inside mirc
  check Des&ktop, 101, 166 150 30 7
  ;show system versions
  check &Versions, 102, 201 150 35 7
  ;show system stats in the system list
  check Statistics:, 103, 166 159 35 7
  ;statistics display options
  radio "Left", 104, 200 159 16 8, hide group push
  radio "Right", 105, 217 159 18 8, hide push
  check Complete, 106, 10 168 40 7, hide
  check Incomplete, 107, 60 168 40 7, hide
  check Missing Logs, 108, 110 168 40 7, hide
  check Si&ze of missing items, 109, 166 168 68 7, hide

  ;"Messages" area box
  box Messages, 34, 1 179 236 19
  text , 200, 4 187 230 7

  ;Bottom section
  box Source/Destinatio&n, 250, 1 198 105 22
  edit , 60, 4 206 100 11, autohs
  button RELOAD, 252, 108 199 27 21
  button Custom &EDITOR, 253, 136 199 27 21, multi
  button Quick &Help, 254, 164 199 45 10
  button Doc&umentation, 255, 164 210 45 10
  button D&ONE, 256, 210 199 27 21, ok
}

on *:dialog:rmm:mouse:* {
  if ($did != %rm.msovr) {
    if ($did == 32) { %rm.msovr = 32 }
    elseif ((($did > 8) && ($did < 28)) || ($did > 200)) {
      did -ra rmm 200 $readini(%rm.rlm,TIPS,$did)
      %rm.msovr = $did
    }
    elseif ((%rm.mode == 21) && ($did > 33)) { %rm.msovr = $did }
    elseif ((%rm.mode == 23) && (%rm.trans_file != $null) && ($did > 32)) {
      did -ra rmm 200 %rm.trans_file
      %rm.msovr = $did
    }
    else { did -r rmm 200 | unset %rm.msovr }
  }
}

on *:dialog:rmm:init:0 {
  rm.mode %rm.mode
  did -g rmm %rm.current_section $calc(%rm.current_section + 7) %rm.icon
  rm.updateDialogTitle
  did -b rmm 80
  if ($readini(%rm.rmp,PREF,g) == 1) { did -c rmm 91 }
  if ($readini(%rm.rmp,PREF,AllowRequests) == 1) { did -c rmm 92 }
  if ($readini(%rm.rmp,PREF,m) == 1) { did -c rmm 101 }
  if ($readini(%rm.rmp,PREF,ShowVersions) == 1) { did -c rmm 102 }
  if ($readini(%rm.rmp,PREF,ShowDialogStats) == 1) { did -c rmm 103 | did -v rmm 104,105,109 | did -vc rmm 106,107,108 }
  if ($readini(%rm.rmp,PREF,ShowDialogStatsOnLeft) == 1) { did -c rmm 104 } | else { did -c rmm 105 }
  if ($readini(%rm.rmp,PREF,ShowSizes) == 1) { did -c rmm 109 }
  if (%rm.mode == 22) {
    did -c rmm 72,77
    if (%rm.current_section >= 18) {
      did -e rmm 80
      if ($readini(%rm.rmp,PREF,CombineCustomStats) == 1) { did -c rmm 80 } | else { did -u rmm 80 }
    }
    elseif ((%rm.current_section >= 12) && (%rm.current_section <= 13)) { did -e rmm 80 | did -c rmm 80 }
    else { did -u rmm 80 | did -b rmm 80 }
  }
  elseif (%rm.mode == 23) { did -c rmm 72 }
  rm.reloadSystemsList
}

on *:dialog:rmm:*:* {
  ;convert the selected line to a system number
  var %rm.line = $did(1).sel
  if (%rm.line != $null) { var %rm.sel = $hget(rmSELECTION, %rm.line) } | else { var %rm.sel }
  ;section changed
  if (($did > 8) && ($did < 21) && (%rm.current_section != $did) && (%rm.~wait~ == $null)) {
    did -g rmm %rm.current_section $calc(%rm.current_section - 9) %rm.icon
    %rm.current_section = $did
    did -g rmm %rm.current_section $calc(%rm.current_section + 7) %rm.icon
    rm.reloadSystemsList
    rm.tip $did
    ;enable buttons that might have been disabled
    did -e rmm 71,72 | did -ec rmm 77 | did -eu rmm 78,79
    if (%rm.current_section >= 18) {
      did -e rmm 80
      if ($readini(%rm.rmp,PREF,CombineCustomStats) == 1) { did -c rmm 80 } | else { did -u rmm 80 }
    }
    elseif ((%rm.current_section >= 12) && (%rm.current_section <= 13)) { did -e rmm 80 | did -c rmm 80 }
    else { did -u rmm 80 | did -b rmm 80 }
    if (%rm.mode == 21) { rm.displaySectionRootPath }
    if (%rm.mode == 24) { did -r rmm 64,65 | did -vra rmm 63 $readini(%rm.rmp,PREF,datroot $+ %rm.current_section) }
    rm.updateDialogTitle
    %rm.msovr = $did
  }
  ;mode changed
  elseif (($did > 20) && ($did < 25) && (%rm.mode != $did)) {
    rm.mode $did
    ;enable buttons that might have been disabled
    did -e rmm 54 | did -ec rmm 77 | did -eu rmm 78,79
    did -eu rmm 71,72,73,74
    if ($did == 22) {
      if (%rm.sel != $null) { did -ec rmm 71 }
      else did -ec rmm 72
    }
    if ($did == 23) {
      if ($did(69).state) { did -b rmm 54 }
      did -ec rmm 72
    }
    if ($did == 24) { did -u rmm 1 | did -c rmm 1 %rm.line }
    rm.updateDialogTitle
    %rm.msovr = $did
  }
  ;display gamesets/ROMs state changed
  elseif ($did == 91) {
    writeini %rm.rmp PREF g $did(91).state
    if ($did(91).state) { did -ra rmm 200 When displaying stats, show the number of Games instead of ROM totals }
    else { did -ra rmm 200 When displaying stats, show ROM totals }
  }
  ;allow requests state changed
  elseif ($did == 92) {
    writeini %rm.rmp PREF AllowRequests $did(92).state
    if ($did(92).state) { did -ra rmm 200 Enable !rmiss Requests from all channels | unset %rm.AllowRequests }
    else { did -ra rmm 200 Disable !rmiss Requests from all channels | %rm.AllowRequests = No Thanks! }
  }
  ;desktop state changed
  elseif ($did == 101) {
    writeini %rm.rmp PREF m $did(101).state
    if ($did(101).state) { did -ra rmm 200 The RomManager Dialog will appear in the Windows taskbar }
    else { did -ra rmm 200 The RomManager Dialog will appear in the mIRC switchbar }
  }
  ;show system versions in the system list
  elseif ($did == 102) {
    writeini %rm.rmp PREF ShowVersions $did(102).state
    if ($did(102).state) { did -ra rmm 200 The system versions will be displayed (when available) }
    else { did -ra rmm 200 The system versions will not be displayed }
    rm.reloadSystemsList noscan
  }
  ;show rom stats in the system list
  elseif ($did == 103) {
    writeini %rm.rmp PREF ShowDialogStats $did(103).state
    if ($did(103).state) {
      did -v rmm 104,105,109 | did -vc rmm 106,107,108
      did -ra rmm 200 Current [missing/total] ROM statistics will be displayed in the Systems List
    }
    else {
      did -h rmm 6,104,105,106,107,108,109
      did -ra rmm 200 ROM statistics in the Systems List have been turned OFF
    }
    rm.reloadSystemsList
  }
  ;show rom stats on left or right
  elseif (($did == 104) || ($did == 105)) {
    writeini %rm.rmp PREF ShowDialogStatsOnLeft $did(104).state
    rm.reloadSystemsList noscan
  }
  ;hide some rom stats (complete, incomplete, missing)
  elseif (($did == 106) || ($did == 107) || ($did == 108)) { rm.reloadSystemsList noscan }

  ;show missing system sizes in the system list
  elseif ($did == 109) {
    writeini %rm.rmp PREF ShowSizes $did(109).state
    if ($did(109).state) { did -ra rmm 200 The size of the missing items will be displayed (when available) }
    else { did -ra rmm 200 The missing item sizes will only be displayed in statistics sent to channels }
    rm.reloadSystemsList noscan
  }
  ;reload button clicked
  elseif ($did == 252) { .timer 1 1 rmmngr $did(rmm,60) | load -rs " $+ $script $+ " }
  ;custom editor button clicked
  elseif ($did == 253) { %rm.yoyo = $did(60) | rmcus }
  ;help button clicked
  elseif ($did == 254) { rmhelp %rm.mode }
  ;documentation button clicked
  elseif ($did == 255) { rmhelp documentation }
  ;Done button clicked
  elseif ($did == 256) {
    if ($dialog(rmu) == $null) {
      if $hget(rmDats) { .hfree rmDats }
      if $hget(rmDatVersions) { .hfree rmDatVersions }
    }
    unset %rm.msovr
    ;save the current position & size
    %rm.pos = $dialog(rmm).x $dialog(rmm).y $dialog(rmm).cw $dialog(rmm).ch
  }

  ; ***** Setup Mode *****
  elseif (%rm.mode == 21) {
    if ((($did == 51) || ($did == 55) || (($did == 1) && ($devent == dclick))) && ($did(63) == <<none>>)) { rm.err root }
    elseif (($did > 50) && ($did < 53) && (%rm.sel == $null)) { rm.err noset }
    elseif ($did == 1) {
      if ($devent == sclick) { rm.displaySystemPath %rm.sel | rm.displaySystemStats %rm.sel }
      elseif ($devent == dclick) {
        if ($rm.setSystemLogPath(%rm.sel, %rm.line) == $false) { rm.err ftype }
        did -c rmm 1 %rm.line
      }
    }
    elseif ($did == 51) {
      if ($rm.setSystemLogPath(%rm.sel, %rm.line) == $false) { rm.err ftype }
      did -o rmm 1 %rm.line $readini(%rm.rlm,TOOL,$rmLogType(%rm.current_section,%rm.sel)) : $rmSystemName(%rm.current_section,%rm.sel)
      did -c rmm 1 %rm.line
    }
    elseif ($did == 52) {
      var %system = $rmSystem(%rm.current_section,%rm.sel)
      remLogInfo %rm.current_section %system
      did -o rmm 1 %rm.line $readini(%rm.rlm,TOOL,0) : $rmSystemName(%rm.current_section,%rm.sel)
      did -c rmm 1 %rm.line
    }
    elseif ($did == 53) {
      remLogInfo %rm.current_section
      rm.reloadSystemsList
      rm.displaySectionRootPath
    }
    elseif ($did == 54) {
      did -ra rmm 200 Working...
      var %i = $rmSystemCount(%rm.current_section)
      while (%i > 0) {
        var %system = $rmSystem(%rm.current_section,%i)
        var %logFile = $rmLogFile(%rm.current_section,%i)
        if ($isfile(%logFile) == $false) {
          remLogInfo %rm.current_section %system
        }
        dec %i
      }
      rm.reloadSystemsList | rm.err cbp
    }
    elseif ($did == 55) {
      remLogInfo %rm.current_section
      if $hget(rmLogType) { .hfree rmLogType }
      .hmake rmLogType 1
      var %logRoot = $rmLogRoot(%rm.current_section)
      var %i = $rmSystemCount(%rm.current_section)
      while (%i > 0) {
        var %systemName = $rmSystemName(%rm.current_section,%i)
        var %system = $rmSystem(%rm.current_section,%i)
        did -ra rmm 200 Searching for the %systemName log file....
        hadd rmLogType 1 %system $+ miss.txt
        hadd rmLogType 2 %systemName $+ .log
        hadd rmLogType 3 %systemName $+ missrom.txt
        hadd rmLogType 4 %systemName $+ miss.txt
        hadd rmLogType 5 %systemName $+ _miss.txt
        hadd rmLogType 6 %systemName $+ *_miss.txt
        var %logType = 0
        var %x = 1
        while (%x < 7) {
          var %logFile = $findfile(%logRoot,$hget(rmLogType,%x),1,3)
          if (%logFile != $null) {
            var %logType = %x
            saveLogInfo %rm.current_section %system %logType $remove(%logFile,%logRoot)
            var %x = 7
          }
          inc %x
        }
        dec %i
      }
      .hfree rmLogType
      rm.reloadSystemsList
      rm.err gp
    }
    elseif ($did == 56) {
      var %rootLastPath = $readini(%rm.rmp,PREF,rootLastPath)
      var %rootCurrentPath = $rmLogRoot(%rm.current_section)
      if (%rootCurrentPath == $null) {
        if (%rootLastPath != $null) { var %rootCurrentPath = %rootLastPath }
        else { var %rootCurrentPath = '' }
      }
      var %rootCurrentPath = $$sdir(%rootCurrentPath, Select the Root Path)
      writeini %rm.rmp PREF root $+ %rm.current_section %rootCurrentPath
      writeini %rm.rmp PREF rootLastPath %rootCurrentPath
      rm.displaySectionRootPath
    }
  }

  ; ***** Display / Request Mode *****
  elseif (%rm.mode == 22) {
    if (($did == 71) || ($did == 72)) {
      if ($did == 71) { did -ra rmm 200 Display/Request stats for the selected System }
      else { did -ra rmm 200 Display/Request stats for this Section (Default) }
      did -c rmm 77 | did -u rmm 78,79
      did -e rmm 78,79
    }
    elseif (($did == 73) || ($did == 74)) {
      if ($did == 73) { did -ra rmm 200 Display/Request the total ROMs and the total completed Systems }
      else { did -ra rmm 200 Display/Request a summary of all Sections }
      did -c rmm 77 | did -u rmm 78,79
      did -b rmm 78,79
    }
    elseif (($did == 1) && ($devent == sclick)) {
      did -c rmm 71 | did -u rmm 72 | did -u rmm 73 | did -u rmm 74
      rm.displaySystemPath %rm.sel | rm.displaySystemStats %rm.sel
    }
    elseif (($did > 9) && ($did < 21)) {
      did -c rmm 72 | did -u rmm 71,73,74
    }
    elseif (($did > 50) && ($did < 58)) {
      if ($did(60) == $null) { rm.err nosd }
      elseif (($did(71).state == 1) && (%rm.sel == $null)) { rm.err noset }
      elseif (($did(71).state == 1) && ($rmLogFile(%rm.current_section,%rm.sel) == $null)) { rm.err unav }
      ;Private & Standard Display
      elseif (($did == 53) || ($did == 54)) {
        if ($did == 53) { var %action = rm.echome $did(60) }
        else {
          var %action = describe $did(60)
          ; dont allow complete TOSEC stats to be displayed
          if (($did(78).state == 1) && (%rm.current_section >= 12) && (%rm.current_section <= 13)) { did -u rmm 78 | did -c rmm 77 }
        }
        if ($did(71).state == 1) { rm.disp %rm.current_section %rm.sel %action }
        elseif ($did(72).state == 1) {
          if ($did(80).state == 1) {
            if (%rm.current_section >= 18) { var %section = Custom }
            else { var %section = TOSEC }
          }
          else { var %section = %rm.current_section }
          if ($did(78).state == 1) { rm.dispage %section %action zeros }
          else { rm.dispage %section %action }
        }
        elseif ($did(73).state == 1) { rm.ttl %action }
        elseif ($did(74).state == 1) { rm.shortstats %action }
      }
      ;Requests
      elseif ($did == 55) {
        if ($count($did(60),$chr(35)) > 0) { var %msg = msg $did(60) !rmiss } | else { var %msg = ctcp $did(60) rmiss }
        ;System
        if ($did(71).state == 1) {
          if ($did(79).state == 1) { rm.zget %rm.current_section %rm.sel } | else { %rm.ztotal = $null }
          %msg $rmSystem(%rm.current_section,%rm.sel) %rm.ztotal
        }
        ;Section
        elseif ($did(72).state == 1) {
          ; dont allow complete TOSEC stats to be requested
          if (($did(78).state == 1) && (%rm.current_section >= 12) && (%rm.current_section <= 13)) { did -u rmm 78 | did -c rmm 77 }

          ;combined stats
          if ($did(80).state == 1) {
            if (%rm.current_section >= 18) { var %section = Custom | var %sectionName = Custom }
            else { var %section = TOSEC | var %sectionName = TOSEC }
          }
          else { var %section = %rm.current_section | var %sectionName = $rmSectionName(%rm.current_section) }

          if ($did(79).state == 1) { rmrf %section | %msg %sectionName $hget(rmrf.totals,totalGMS) }
          elseif ($did(78).state == 1) { %msg %sectionName $+ 0 }
          else { %msg %sectionName }
        }
        elseif ($did(73).state == 1) { msg $did(60) !rmtotal }
        elseif ($did(74).state == 1) { %msg all }
      }
    }
    elseif ($did == 77) { did -ra rmm 200 Display/Request stats with completed systems hidden (Default) }
    elseif ($did == 78) { did -ra rmm 200 Display/Request stats including completed systems }
    elseif ($did == 79) { did -ra rmm 200 Request stats with only your specific ROM counts }
    elseif ($did == 80) {
      if (%rm.current_section >= 18) { writeini %rm.rmp PREF CombineCustomStats $did(80).state | var %sectionName = Custom }
      else { var %sectionName = TOSEC }
      if ($did(80).state) { did -ra rmm 200 Display/Request %sectionName stats combined from all %sectionName sections }
      else { did -ra rmm 200 Display/Request %sectionName stats showing only the current section }
    }
  }

  ; ***** Transfer / View Mode *****
  elseif (%rm.mode == 23) {
    if (($did == 1) && ($devent == sclick)) {
      did -u rmm 69 | rm.displaySystemPath %rm.sel | rm.displaySystemStats %rm.sel | unset %rm.trans_file }
    elseif (($did > 51) && ($did < 57) && (%rm.sel == $null) && ($did(69).state == 0)) { rm.err noset }
    elseif ((($did == 53) || ($did == 54)) && ($did(60) == $null)) { rm.err nosd }
    elseif ((($did == 53) || ($did == 54)) && ($count($did(60),$chr(35)) != 0)) { rm.err nochn }
    elseif ($did == 54) {
      if ($did(71).state == 1) { ctcp $did(60) RMGET FIXDAT $rmSystem(%rm.current_section,%rm.sel) }
      else { ctcp $did(60) RMGET $rmSystem(%rm.current_section,%rm.sel) }
    }
    elseif (($did == 53) || ($did == 55) || ($did == 56) || (($did == 1) && ($devent == dclick))) {
      if (($left($did(1).seltext,1) == N) && ($did(69).state == 0)) { rm.err unav }
      else {
        if ($did(69).state == 1) {
          if ($did(71).state == 1) { var %t = $rmFixDat(0,%rm.transfer_file) }
          else { var %t = %rm.transfer_file }
        }
        elseif ($did(71).state == 1) { var %t = $rmFixDat(%rm.current_section,%rm.sel) }
        else { var %t = $rmLogFile(%rm.current_section,%rm.sel) }

        var %t.type = $gettok(%t,-1,46)
        if (($did(71).state == 1) && (%t.type != dat)) {
          if (%t.type == log) { did -ra rmm 200 No missing ROMs. A fix.dat file was not created. }
          else { did -ra rmm 200 Only ClrMamePro LOG files are supported at this time. }
        }
        if ($isfile(%t) == $true) {
          if ($did == 53) { rm.sendfile $did(60) %t }
          elseif ($did == 55) { rm.sendfile notepad %t }
          elseif (($did == 56) || (($did == 1) && ($devent == dclick))) { rm.sendfile rmhelp %t }
        }
        else { rm.err nofile }
      }
    }
    elseif ($did == 69) {
      if ($did(69).state) {
        did -ra rmm 200 View/Send/Convert a manually selected file
        var %folder = $readini(%rm.rmp,PREF,zipfolder)
        if (%folder == $null) { var %folder = $getdir }
        %rm.transfer_file = $sfile(%folder $+ *.*,Select the file you wish to View/Send/Convert)
        if (%rm.transfer_file == $null) { unset %rm.transfer_file | unset %rm.trans_file | did -u rmm 69 }
        else {
          %rm.trans_file = %rm.transfer_file
          if ($len(%rm.trans_file) > 63) {
            %rm.trans_file = $puttok(%rm.trans_file,...,1,92)
            while (($len(%rm.trans_file) > 63) && ($numtok(%rm.trans_file,92) > 2)) { %rm.trans_file = $deltok(%rm.trans_file,2,92) }
          }
          did -b rmm 54 | did -e rmm 71 | did -u rmm 1
        }
      }
      else { unset %rm.transfer_file | unset %rm.trans_file }
    }
    elseif ($did == 71) { did -ra rmm 200 Create a ClrMamePro compatible fix.dat for the selected System }
    elseif ($did == 72) { did -ra rmm 200 Transfer/View the log file for the selected System }
  }

  ; ***** Update Mode *****
  elseif (%rm.mode == 24) {
    if (%rm.sel) {
      var %system = $rmSystem(%rm.current_section,%rm.sel)
      did -ra rmm 64 %system
      did -ra rmm 65 $rmGetDatVersion(%rm.current_section,%rm.sel)
      rm.displaySystemPath %rm.sel dat
    }
    if (($did == 1) && ($devent == sclick)) { rm.displaySystemStats %rm.sel }
    elseif ($did == 53) {
      if ($script(rmupdate.mrc) == $null) { .load -rs " $+ $scriptdir $+ rmupdate.mrc" }
      rmupdate
    }
    elseif ($did == 54) {
      var %folder = $readini(%rm.rmp,PREF,zipfolder)
      if (%folder == $null) { var %folder = $getdir }
      var %folder = $$sdir(%folder,Pick a Folder to save new dats & fixdats)
      writeini %rm.rmp PREF zipfolder %folder
      did -ra rmm 62 %folder
    }
    elseif ($did == 56) {
      var %folder = $readini(%rm.rmp,PREF,datroot $+ %rm.current_section)
      if (%folder == $null) { var %folder = C:\Program Files\ }
      var %folder = $$sdir(%folder,Pick the Folder where most of these DATs are located)
      writeini %rm.rmp PREF datroot $+ %rm.current_section %folder
      did -ra rmm 63 %folder
    }
  }
}

; *** start the main rommanager dialog
alias rmmngr {
  %rm.icon = " $+ $scriptdir $+ rmicons.dll"
  if ($dialog(rmm) == $null) {
    if ($readini(%rm.rmp,PREF,m) == 1) { dialog -mdie rmm rmmngr }
    else { dialog -ma rmm rmmngr }
    if (%rm.pos != $null) { dialog -s rmm %rm.pos }
  }
  else {
    ;save the current position & size
    %rm.pos = $dialog(rmm).x $dialog(rmm).y $dialog(rmm).cw $dialog(rmm).ch
    ;close/open rmm again
    dialog -x rmm
    rmm.refresh $1-
  }
  did -ra rmm 60 $1-
}

alias -l rmm.refresh { rmmngr $1- }

; *** Updates the GUI (icons and GUI elements) according to the selected mode (NOTE: to add a new section it's necessary add +1 to icon counting gap intervals)
alias -l rm.mode {
  did -g rmm %rm.mode $calc(%rm.mode - 9) %rm.icon
  did -g rmm $1 $calc($1 + 7) %rm.icon
  %rm.mode = $1
  rm.tip $1

  did -h rmm 51,52,53,54,55,56,62,63,64,65,68,69,70,71,72,73,74,76,77,78,79,80
  if ($1 == 22) {
    did -ra rmm 33 Control - Display/Request
    did -vra rmm 53 Display &Privately
    did -vra rmm 54 Display to &Destination
    did -vra rmm 55 &Request from Source
    did -vra rmm 71 Syste&m
    did -vra rmm 72 &Section
    did -v rmm 70,73,74,76,77,78,79,80
  }
  else {
    if ($1 == 21) {
      did -ra rmm 33 Control - Setup
      did -vra rmm 51 &Set Selected
      did -vra rmm 52 &Clear Selected
      did -vra rmm 53 Clear &All Logs
      did -vra rmm 54 Clear &Missing Logs
      did -vra rmm 55 &Find All Logs
      did -vra rmm 56 Set &Log Folder:
      did -v rmm 63
      rm.displaySectionRootPath
    }
    elseif ($1 == 23) {
      did -ra rmm 33 Control - Transfer/View
      did -vra rmm 53 &Send to Destination
      did -vra rmm 54 &Request from Source
      did -vra rmm 55 View in Note&pad
      did -vra rmm 56 View &Internally
      did -vra rmm 68 File Type:
      did -v rmm 69
      did -vra rmm 71 &Fix.Dat
      did -vra rmm 72 &Log File
    }
    ; else $1 == 24
    else {
      did -ra rmm 33 Control - Updates/Info
      did -vra rmm 68 System Information:
      did -vra rmm 53 DAT Update &Manager
      did -vra rmm 54 &Fix.DAT Folder:
      did -vra rmm 56 &DAT Folder:
      var %zipfolder = $readini(%rm.rmp,PREF,zipfolder)
      if (%zipfolder == $null) { var %zipfolder = $getdir }
      did -vra rmm 62 %zipfolder
      did -vra rmm 63 $readini(%rm.rmp,PREF,datroot $+ %rm.current_section)
      did -v rmm 64,65
    }
  }
}

;####################################
;# ***** Custom Editor Dialog ***** #
;####################################

dialog rmcustom {
  title "Custom Section Editor"
  size -1 -1 194 173
  option dbu
  icon 18, 4 5 16 16, %rm.icon, 9
  icon 19, 23 5 16 16, %rm.icon, 10
  icon 20, 42 5 16 16, %rm.icon, 11
  text System Count,5,66 5 50 10
  box Custom Systems, 10, 3 22 142 124
  button Change Label, 101, 101 17 39 8, hide
  edit , 102, 6 20 81 11, hide autohs
  button Save, 103, 88 20 26 10, hide
  button Remove, 104, 114 20 26 10, hide
  list 1, 6 30 135 115, vsbar
  box Type an abbreviation first, 11, 3 146 92 22
  edit , 50, 7 154 41 11, autohs
  button &ADD a Dat, 51, 52 154 40 11
  box Get from chan, 12, 98 146 46 22
  button Abbreviations, 52, 101 154 40 11
  button Edit Item, 53, 148 5 40 11
  button DELete Item, 56, 148 17 40 11
  button Move Up, 54, 148 32 40 11
  button Move Down, 55, 148 44 40 11
  button Move Left, 62, 148 59 40 11
  button Move Right, 63, 148 71 40 11
  box Sort List by, 13, 146 85 44 34
  button Abbreviation, 57, 148 93 40 11
  button Description, 58, 148 105 40 11
  button Import List, 60, 148 122 40 11
  button Export List, 61, 148 134 40 11
  button &DONE, 1000, 148 149 40 18, ok
}

on *:dialog:rmcus:mouse:* { haltdef }

on *:dialog:rmcus:init:0 {
  if (%rm.current_section >= 18) { %rm.custom_section = %rm.current_section }
  else { %rm.custom_section = 18 }
  did -g rmcus %rm.custom_section $calc(%rm.custom_section + 7) %rm.icon
  did -ra rmcus 10 $rmSectionLabel(%rm.custom_section)
  did -v rmcus 101
  reloadCustomSystemsList
}

on *:dialog:rmcus:*:* {
  var %custom.sel = $did(1).sel
  if (($did == 1) && ($devent == dclick) && (%custom.sel != $null)) { rmCustomEdit }
  ; Custom Tabs
  elseif (($did >= 18) && ($did < 21) && (%rm.custom_section != $did)) {
    did -g rmcus %rm.custom_section $calc(%rm.custom_section - 9) %rm.icon
    %rm.custom_section = $did
    did -g rmcus %rm.custom_section $calc(%rm.custom_section + 7) %rm.icon
    did -u rmcus 1
    did -ra rmcus 10 $rmSectionLabel(%rm.custom_section)
    reloadCustomSystemsList
  }
  ; Add a Dat button, something in the edit box as well
  elseif (($did == 51) && ($did(50) != $null)) {
    var %system = $remove($did(50),$chr(32))
    if ($rmSystemExists(%system) == $false) {
      var %systemName = $$sfile($rmLogRoot(%rm.custom_section) $+ *.dat,Pick a DAT,ADD it !)
      if ((%systemName != $null) && ($istok(%systemName,dat,46))) {
        var %systemName = $deltok($nopath(%systemName),-1,46)
        var %systemName = $gettok($gettok(%systemName,1,40),1,91)
        var %n = $rmSystemCount(%rm.custom_section)
        var %i = %n
        if (%custom.sel == $null) { %custom.sel = %n }
        while (%i > %custom.sel) {
          saveSystemInfo %rm.custom_section $calc(%i + 1) $rmSystem(%rm.custom_section,%i) $rmSystemName(%rm.custom_section,%i)
          dec %i
        }
        inc %n
        inc %custom.sel
        saveSystemInfo %rm.custom_section %custom.sel %system %systemName
        saveSystemCount %rm.custom_section %n
        reloadCustomSystemsList
        did -c rmcus 1 %custom.sel
      }
    }
  }
  ;Get Abbreviations from chan button
  elseif ($did == 52) {
    var %cust123 = %rm.custom_section - 17
    if ($count($did(rmm,60),$chr(35)) != 0) { msg $did(rmm,60) !rmgca $+ %cust123 }
    else { ctcp $did(rmm,60) rmgca $+ %cust123 }
  }
  ;Edit Item button
  elseif (($did == 53) && (%custom.sel != $null)) { rmCustomEdit }
  ;Move Up button
  elseif (($did == 54) && (%custom.sel > 1)) {
    var %tmpSys = $rmSystem(%rm.custom_section,$calc(%custom.sel - 1))
    var %tmpName = $rmSystemName(%rm.custom_section,$calc(%custom.sel - 1))
    saveSystemInfo %rm.custom_section $calc(%custom.sel - 1) $rmSystem(%rm.custom_section,%custom.sel) $rmSystemName(%rm.custom_section,%custom.sel)
    saveSystemInfo %rm.custom_section %custom.sel %tmpSys %tmpName
    reloadCustomSystemsList
    did -c rmcus 1 $calc(%custom.sel - 1)
  }
  ;Move Down button
  elseif (($did == 55) && (%custom.sel < $rmSystemCount(%rm.custom_section))) {
    var %tmpSys = $rmSystem(%rm.custom_section,$calc(%custom.sel + 1))
    var %tmpName = $rmSystemName(%rm.custom_section,$calc(%custom.sel + 1))
    saveSystemInfo %rm.custom_section $calc(%custom.sel + 1) $rmSystem(%rm.custom_section,%custom.sel) $rmSystemName(%rm.custom_section,%custom.sel)
    saveSystemInfo %rm.custom_section %custom.sel %tmpSys %tmpName
    reloadCustomSystemsList
    did -c rmcus 1 $calc(%custom.sel + 1)
  }
  ;DELete button
  elseif ($did == 56) { rmDeleteCustomItem }

  ; Sort list by Abbreviation button
  elseif ($did == 57) { rmSortCustomList Abbreviation | reloadCustomSystemsList | did -c rmcus 1 $calc(%custom.sel - 1) }
  ; Sort list by Description button
  elseif ($did == 58) { rmSortCustomList Description | reloadCustomSystemsList | did -c rmcus 1 $calc(%custom.sel + 1) }

  ;Import systems button
  elseif ($did == 60) {
    var %rm.file = " $+ $$sfile(*.ini,Please select a valid custom settings file...,Import) $+ "
    var %system_count = $readini(%rm.file,CUSTOM,n)
    echo -a 12
    echo -a Importing custom system abbreviations and descriptions from %rm.file
    if (%system_count == $null) { echo -a %rm.file has no CUSTOM systems to import. }
    var %i = 1
    var %imported_count = 0
    while (%i <= %system_count) {
      var %abbr = $readini(%rm.file,CUSTOM,d $+ %i)
      if ($rmSystemExists(%abbr) == $false) {
        var %x = $calc($rmSystemCount(%rm.custom_section) + 1)
        saveSystemInfo %rm.custom_section %x %abbr $readini(%rm.file,CUSTOM,n $+ %i)
        saveSystemCount %rm.custom_section %x
        inc %imported_count
        reloadCustomSystemsList
        did -c rmcus 1 %x
      }
      inc %i
    }
    echo -a Successfully imported %imported_count systems from %rm.file
    if (%imported_count > 0) { echo -a and placed them in the $rmSectionName(%rm.custom_section) section. }
    echo -a 12
  }
  ;Export systems button
  elseif ($did == 61) {
    var %rm.file = " $+ $$sfile(*.ini,Please enter a new filename to store your custom settings...,Save) $+ "
    echo -a 12
    echo -a Exporting custom system abbreviations and descriptions from the $rmSectionName(%rm.custom_section) section to %rm.file
    if ($exists(%rm.file)) { var %old_n = $readini(%rm.file,CUSTOM,n) }
    if (%old_n == $null) {
      var %old_n = 0
      writeini %rm.file CUSTOM n 0
    }
    var %system_count = $rmSystemCount(%rm.custom_section)
    var %n = %old_n
    var %i = 1
    while (%i <= %system_count) {
      var %abbr = $rmSystem(%rm.custom_section,%i)
      var %x = 1
      var %rm.flag = 0
      while (%x <= %old_n) {
        if ($readini(%rm.file,CUSTOM,d $+ %x) == %abbr) { inc %rm.flag }
        inc %x
      }
      if (%rm.flag == 0) {
        inc %n
        writeini %rm.file CUSTOM n $+ %n $rmSystemName(%rm.custom_section,%i)
        writeini %rm.file CUSTOM d $+ %n %abbr
      }
      inc %i
    }
    writeini %rm.file CUSTOM n %n
    if $exists(%rm.file) { echo -a %rm.file has been successfully created/updated to a total of %n Custom systems. }
    else { echo -a ERROR: couldn't write %rm.file. }
    echo -a 12
  }
  ;Move Left and Right buttons
  elseif ((($did == 62) || ($did == 63)) && (%custom.sel != $null)) {
    if ($did == 62) {
      var %new_section = 20
      if (%rm.custom_section > 18) { %new_section = $calc(%rm.custom_section - 1) }
    }
    if ($did == 63) {
      var %new_section = 18
      if (%rm.custom_section < 20) { %new_section = $calc(%rm.custom_section + 1) }
    }
    var %n = $calc($rmSystemCount(%new_section) + 1)
    var %abbr = $rmSystem(%rm.custom_section,%custom.sel)
    var %desc = $rmSystemName(%rm.custom_section,%custom.sel)
    saveSystemInfo %new_section %n %abbr %desc
    saveSystemCount %new_section %n
    var %path = $rmLogFile(%rm.custom_section,%custom.sel)
    var %t = $rmLogType(%rm.custom_section,%custom.sel)
    if (%path != $null) { saveLogInfo %new_section %abbr %t %path }
    rmDeleteCustomItem
  }
  ;Custom Section Label Edit
  elseif ($did == 101) {
    did -h rmcus 10,101
    did -v rmcus 103,104
    did -vraf rmcus 102 $did(10)
  }
  ;Custom Section Label - Save or Remove
  elseif (($did == 103) || ($did == 104)) {
    if (($did == 103) && ($did(102) != $null)) { writeini %rm.rmp PREF CustomLabel_ $+ %rm.custom_section $did(102) }
    else { remini %rm.rmp PREF CustomLabel_ $+ %rm.custom_section }
    did -v rmcus 101
    did -h rmcus 102,103,104
    did -vra rmcus 10 $rmSectionLabel(%rm.custom_section)
  }
  elseif ($did == 1000) {
    ;save the current position & size
    %rmcus.pos = $dialog(rmcus).x $dialog(rmcus).y $dialog(rmcus).cw $dialog(rmcus).ch
    ;if the main rm window is on a custom section, reload that section
    if (%rm.current_section >= 18) { rm.reloadSystemsList }
  }
}

; *** start the custom section editor dialog
alias rmcus {
  if ($dialog(rmcus) == $null) {
    if ($readini(%rm.rmp,PREF,m) == 1) { dialog -mdie rmcus rmcustom }
    else { dialog -ma rmcus rmcustom }
    if (%rmcus.pos != $null) { dialog -s rmcus %rmcus.pos }
  }
  else { dialog -v rmcus }
}

alias -l reloadCustomSystemsList {
  did -r rmcus 1
  var %i = $rmSystemCount(%rm.custom_section)
  while (%i > 0) {
    did -i rmcus 1 1 $rmSystemName(%rm.custom_section,%i) $+ $chr(32) $+ ( $+ $rmSystem(%rm.custom_section,%i) $+ )
    dec %i
  }
  did -i rmcus 5 1 System count: $did(rmcus,1).lines
}

;*** this alias is used by the rmcus dialog DELete, Move Left, & Move Right buttons
alias -l rmDeleteCustomItem {
  var %custom.sel = $did(rmcus,1).sel
  if (%custom.sel != $null) {
    var %n = $rmSystemCount(%rm.custom_section)
    var %x = %custom.sel
    var %old_abbr = $rmSystem(%rm.custom_section,%x)
    var %y = $calc(%custom.sel + 1)
    while (%x < %n) {
      var %abbr = $rmSystem(%rm.custom_section,%y)
      var %desc = $rmSystemName(%rm.custom_section,%y)
      saveSystemInfo %rm.custom_section %x %abbr %desc
      inc %x
      inc %y
    }
    deleteSystemInfo %rm.custom_section %n
    remLogInfo %rm.custom_section %old_abbr
    dec %n
    saveSystemCount %rm.custom_section %n
    reloadCustomSystemsList
    if (%custom.sel > %n) { %custom.sel = %n }
    did -c rmcus 1 %custom.sel
  }
}

;*** this alias is used by the rmcus dialog 'Add a Dat', 'Edit Item', & 'Import Custom' buttons
alias -l rmSystemExists {
  var %section = 10
  while (%section < 21) {
    var %i = $rmSystemCount(%section)
    while (%i > 0) {
      if ($rmSystem(%section,%i) == $1) {
        echo -a The $1 system is already defined in the $rmSectionName(%section) section as " $+ $rmSystemName(%section,%i) $+ ".
        return $true
      }
      dec %i
    }
    inc %section
  }
  return $false
}

;*** this alias will sort the custom systems in both rmp.ini and rlm.ini
alias -l rmSortCustomList {
  var %n = $rmSystemCount(%rm.custom_section)
  if (%n > 0) {
    if $hget(rmSystemList) { .hfree rmSystemList } | .hmake rmSystemList 10
    if $hget(rmSystemNameList) { .hfree rmSystemNameList } | .hmake rmSystemNameList 10

    ;make a list of systems with the current position number attached
    var %i = 1
    while (%i <= %n) {
      hadd rmSystemList %i $rmSystem(%rm.custom_section,%i) $+ $chr(9) $+ %i
      hadd rmSystemNameList %i $rmSystemName(%rm.custom_section,%i) $+ $chr(9) $+ %i
      inc %i
    }
    ;sort the list
    if ($1 == Abbreviation) { bubbleSort rmSystemList %n }
    else { bubbleSort rmSystemNameList %n }
    ;write the systems back to the ini files in the new order
    var %i = 1
    while (%i <= %n) {
      if ($1 == Abbreviation) {
        var %system = $gettok($hget(rmSystemList,%i),1,9)
        var %x = $gettok($hget(rmSystemList,%i),2,9)
        var %systemName = $gettok($hget(rmSystemNameList,%x),1,9)
      }
      else {
        var %systemName = $gettok($hget(rmSystemNameList,%i),1,9)
        var %x = $gettok($hget(rmSystemNameList,%i),2,9)
        var %system = $gettok($hget(rmSystemList,%x),1,9)
      }
      saveSystemInfo %rm.custom_section %i %system %systemName
      inc %i
    }
    ;remove the hash tables
    .hfree rmSystemList | .hfree rmSystemNameList
  }
}

;*** sorts a hashtable alphabetically by the data in each item. assumes the items are named 1 thru N
alias -l bubbleSort {
  ;bubbleSort hashtable itemcount
  var %i = $2
  while (%i >= 1) {
    var %x = 2
    var %y = 1
    while (%x <= %i) {
      if ($hget($1,%y) > $hget($1,%x)) {
        var %s = $hget($1,%y)
        hadd $1 %y $hget($1,%x)
        hadd $1 %x %s
      }
      inc %x
      inc %y
    }
    dec %i
  }
}

;###########################################
;# ***** Custom System Editor Dialog ***** #
;###########################################

dialog rmCustomEdit {
  title "Custom System Editor"
  size -1 -1 169 78
  option dbu
  box &Abbreviation, 10, 3 4 56 22
  edit , 11, 6 12 50 11, autohs
  box &Description, 20, 60 4 106 22
  edit , 21, 63 12 100 11, autohs
  box Sample Output, 30, 3 31 163 25
  text , 31, 6 38 157 15
  button &OK, 100, 114 60 25 15, default ok
  button &Cancel, 101, 141 60 25 15, cancel
}

alias -l rmCustomEdit {
  if ($dialog(rmCustomEdit) == $null) {
    dialog -md rmCustomEdit rmCustomEdit
    if (%rmCustomEdit.pos != $null) { dialog -s rmCustomEdit %rmCustomEdit.pos }
  }
  else { dialog -v rmCustomEdit }
}

on *:dialog:rmCustomEdit:mouse:* {
  if (($did == 30) && ($did != %rm.msovr)) {
    %rm.msovr = 30
    did -ra $dname 31  $me is missing 100 of 1000 known $did($dname,21).text $iif($did(rmm,91).state,gamesets,ROMs) $chr(91) $+ Custom: $did($dname,11).text $+ $chr(93)
  }
  elseif ($did != %rm.msovr) { did -r $dname 31 | unset %rm.msovr }
}

on *:dialog:rmCustomEdit:init:0 {
  var %custom.sel = $did(rmcus,1).sel
  did -ra $dname 21 $rmSystemName(%rm.custom_section,%custom.sel)
  did -ra $dname 11 $rmSystem(%rm.custom_section,%custom.sel)
}

On *:dialog:rmCustomEdit:*:*:{
  var %custom.sel = $did(rmcus,1).sel
  if ($did == 101) {  }
  if ($did == 100) {
    var %system = $rmSystem(%rm.custom_section,%custom.sel)
    var %abbr = $did(11).text
    if (%system != %abbr) {
      if ($rmSystemExists(%abbr) == $false) {
        if ($rmLogFile(%rm.custom_section,%custom.sel) != $null) {
          saveLogInfo %rm.custom_section %abbr $rmLogType(%rm.custom_section,%custom.sel) $rmLogFile(%rm.custom_section,%custom.sel)
          remLogInfo %rm.custom_section %system
        }
        var %system = %abbr
      }
    }
    saveSystemInfo %rm.custom_section %custom.sel %system $did(21).text
    reloadCustomSystemsList
    did -c rmcus 1 %custom.sel
    ;save the current position & size
    %rmCustomEdit.pos = $dialog(rmCustomEdit).x $dialog(rmCustomEdit).y $dialog(rmCustomEdit).cw $dialog(rmCustomEdit).ch
  }
}

;############################################
;#    Documentation/Help System/Log Viewer  #
;############################################

dialog rmhelp {
  title "RomManager"
  size -1 -1 210 160
  option dbu
  edit "", 1, 1 15 208 130, read multi return vsbar
  text "Select Section:", 2, 11 4 38 8
  combo 3, 54 3 72 66, size drop
  button "OK", 100, 163 147 45 12, ok cancel
}

on *:DIALOG:rmhelp:sclick:*:{
  if ($did == 3) {
    if (%rm.help == help) { var %x = $calc($did(3).sel + 20) }
    else { var %x = $did(3).sel }
    did -r $dname 1
    if ($did(3).text) { loadbuf -ot $+ %x $dname 1 " $+ $scriptdir $+ rmread.txt $+ " }
    else { halt }
  }
}

; *** display the rommanager help dialog
alias rmhelp {
  if ($dialog(rmhelp) == $null) { dialog -ma rmhelp rmhelp }
  else { dialog -v rmhelp }

  ;show the RM documentation
  if ($1 == documentation) {
    %rm.help = documentation
    dialog -t rmhelp Welcome to RomManager v $+ %rm.version $readini(%rm.rlm,V,d)
    loadbuf -otTopics rmhelp 3 " $+ $scriptdir $+ rmread.txt $+ "
    did -c rmhelp 3 1
    loadbuf -ot1 rmhelp 1 " $+ $scriptdir $+ rmread.txt $+ "
  }
  ; show the selected log file
  elseif ($isfile($1-) == $true) {
    %rm.help = logviewer
    did -h rmhelp 2,3
    if ($file($1-).size > 60000) { rm.err ftb | halt }
    dialog -t rmhelp Log Viewer - $nopath($1-)
    if ($left($1,1) != $chr(34)) { loadbuf 1- $+ $lines($1-) -o rmhelp 1 " $+ $1- $+ " }
    else { loadbuf 1- $+ $lines($1-) -o rmhelp 1 $1- }
  }
  ; show the help info for the current tab
  else {
    %rm.help = help
    dialog -t rmhelp RomManager - Help System
    loadbuf -otHelpTopics rmhelp 3 " $+ $scriptdir $+ rmread.txt $+ "
    did -c rmhelp 3 $calc($1 - 20)
    loadbuf -ot $+ $1 rmhelp 1 " $+ $scriptdir $+ rmread.txt $+ "
  }
}

;##################
;#     Events     #
;##################

; *** Public Requests ***
on ^*:text:!rmiss*:* {
  if (%rm.AllowRequests == $null) {
    if (($2 == Tosec) || ($left($2,-1) == Tosec) || ($2 == all)) { set -u20 %rm.AllowRequests No | rmiss $1- }
    else { set -u5 %rm.AllowRequests No | rmiss $1- }
  }
}
on ^*:text:!rmgca1:*: { if (%rm.AllowRequests == $null) { set -u5 %rm.AllowRequests No | rm.gca 18 notice $nick } }
on ^*:text:!rmgca2:*: { if (%rm.AllowRequests == $null) { set -u5 %rm.AllowRequests No | rm.gca 19 notice $nick } }
on ^*:text:!rmgca3:*: { if (%rm.AllowRequests == $null) { set -u5 %rm.AllowRequests No | rm.gca 20 notice $nick } }
on ^*:text:!rmtotal:*: { if (%rm.AllowRequests == $null) { set -u5 %rm.AllowRequests No | rm.ttl .notice $nick ROMs } }
on ^*:text:!rmver*:*: { if (%rm.AllowRequests == $null) { set -u2 %rm.AllowRequests No | .notice $nick RomManager Database v $+ %rm.version } }
on ^*:text:!rmbuild*:*: { if (%rm.AllowRequests == $null) { set -u2 %rm.AllowRequests No | .notice $nick RomManager.mrc Code Revision (build %rm.build $+ ) } }

; *** Private Replies ***
on *:CTCPREPLY:*RMGET*:{ haltdef }
on *:CTCPREPLY:*RMISS*:{ haltdef }
on *:CTCPREPLY:*RMTOTAL*:{ haltdef }
on *:CTCPREPLY:*RMVER*:{ haltdef }
on *:CTCPREPLY:*RMBUILD*:{ haltdef }
on *:CTCPREPLY:*RMGCA*:{ haltdef }

; *** Private Requests ***
ctcp ^*:rmiss:* {
  if (%rm.AllowPrivate == $null) {
    if (($2 == Tosec) || ($left($2,-1) == Tosec) || ($2 == all)) { set -u20 %rm.AllowPrivate No | rmiss $1- }
    else { set -u5 %rm.AllowPrivate No | rmiss $1- }
  }
}
ctcp ^*:rmgca1:* { if (%rm.AllowPrivate == $null) { set -u5 %rm.AllowPrivate No | rm.gca 18 notice $nick } }
ctcp ^*:rmgca2:* { if (%rm.AllowPrivate == $null) { set -u5 %rm.AllowPrivate No | rm.gca 19 notice $nick } }
ctcp ^*:rmgca3:* { if (%rm.AllowPrivate == $null) { set -u5 %rm.AllowPrivate No | rm.gca 20 notice $nick } }
ctcp ^*:rmtotal:* { if (%rm.AllowPrivate == $null) { set -u5 %rm.AllowPrivate No | rm.ttl .notice $nick ROMs | haltdef } }
ctcp ^*:rmver:* { if (%rm.AllowPrivate == $null) { set -u2 %rm.AllowPrivate No | .notice $nick RomManager Database v $+ %rm.version | .notice $nick RomManager.mrc Code Revision (build %rm.build $+ ) } }
ctcp ^*:rmbuild:* { if (%rm.AllowPrivate == $null) { set -u2 %rm.AllowPrivate No | .notice $nick RomManager Database v $+ %rm.version | .notice $nick RomManager.mrc Code Revision (build %rm.build $+ ) } }

ctcp ^*:rmget:* {
  ; send a complete stats.txt file
  if ($right($2,1) == 0) {
    var %sectionName = $left($2,-1)
    if ((%sectionName == Custom) || (%sectionName == TOSEC)) { rm.dispage %sectionName write $nick zeros }
    else {
      var %section = 9
      while (%section < 21) {
        if ($rmSectionName(%section) == %sectionName) { rm.dispage %section write $nick zeros }
        inc %section
      }
    }
  }
  else {
    var %file = $null
    if ($2 == checkfile) {
      var %file = " $+ $readini(%rm.rmp,PREF,w) $+ rmcheck.ini"
      if ($isfile(%file) == $false) {
        var %file = " $+ $scriptdir $+ rmcheck.ini"
        writeini %rm.rmp PREF w $nofile(%file)
      }
      write -c %file [RM4-Checkfile]
      write %file version= $+ %rm.version
      var %section = 9
      while (%section < 21) {
        if ($rmSectionName(%section) != $null) {
          var %i = 1
          var %sectionNumber = $rmSystemCount(%section)
          while ((%i <= %sectionNumber) && (%sectionNumber > 0)) {
            rm.zget %section %i
            if (%rm.ztotal > 0) { write %file $rmSystem(%section,%i) $+ = $+ %rm.ztotal }
            inc %i
          }
        }
        inc %section
      }
      write %file signature= $+ $me
    }
    elseif ($2 == fixdat) {
      var %result = $rmFindSystem($3)
      if (%result != $null) { var %file = $rmFixDat($gettok(%result,1,32),$gettok(%result,2,32)) }
    }
    else {
      var %result = $rmFindSystem($2)
      if (%result != $null) { var %file = $rmLogFile($gettok(%result,1,32),$gettok(%result,2,32)) }
    }
    rm.sendfile $nick %file
  }
}

; called by ctcp rmiss & on text !rmiss
alias -l rmiss {
  ; rmiss all
  if ($2 == all) { rm.shortstats .notice $nick ROMs }
  var %metatrigger = 0
  var %section = 9
  var %sectionName = $2
  var %showZeros = $false
  ; find out if we should display zero missing systems as well
  if ($right($2,1) == 0) { var %sectionName = $left($2,-1) | var %showZeros = $true }
  if (($3 == $null) && ($2 != $null)) {
    ; rmiss Arcade , rmiss Arcade0 , ..., rmiss Custom
    while (%section < 21) {
      if ($rmSectionName(%section) == %sectionName) {
        ; if you want others to have the ability to flood you off the network, remove the tosec section test ;)
        if ((%showZeros) && ((%section < 12) || (%section > 13))) { rm.dispage %section .notice $nick ROMs zeros hideUnscannedSections }
        else { rm.dispage %section .notice $nick ROMs hideUnscannedSections }
        var %metatrigger = 1
      }
      inc %section
    }
    if (%sectionName == Custom) {
      if (%showZeros) { rm.dispage %sectionName .notice $nick ROMs zeros hideUnscannedSections }
      else { rm.dispage %sectionName .notice $nick ROMs hideUnscannedSections }
      var %metatrigger = 1
    }
    elseif (%sectionName == TOSEC) {
      rm.dispage %sectionName .notice $nick ROMs hideUnscannedSections
      var %metatrigger = 1
    }
    ; rmiss MAME , rmiss GBA , etc.
    if (%metatrigger == 0) {
      var %result = $rmFindSystem($2)
      if (%result != $null) { rm.disp %result .notice $nick ROMs }
    }
  }
  elseif ($3 != $null) {
    ; rmiss Arcade 62167 , rmiss Arcade0 62167 , ..., rmiss Custom 13315
    while (%section < 21) {
      if ($rmSectionName(%section) == %sectionName) {
        rmrf %section
        if ($hget(rmrf.totals,totalGMS) == $3) {
          ; if you want others to have the ability to flood you off the network, remove the tosec section test ;)
          if ((%showZeros) && (%section < 12) || (%section > 13)) { rm.dispage %section .notice $nick ROMs zeros hideUnscannedSections }
          else { rm.dispage %section .notice $nick ROMs hideUnscannedSections }
        }
        ;else { .notice $nick has a different total : $hget(rmrf.totals,totalGMS) }
        var %metatrigger = 1
      }
      inc %section
    }
    if (%sectionName == Custom) {
      rmrf Custom
      if ($hget(rmrf.totals,totalGMS) == $3) {
        if (%showZeros) { rm.dispage Custom .notice $nick ROMs zeros hideUnscannedSections }
        else { rm.dispage Custom .notice $nick ROMs hideUnscannedSections }
      }
      var %metatrigger = 1
    }
    elseif (%sectionName == TOSEC) {
      rmrf TOSEC
      if ($hget(rmrf.totals,totalGMS) == $3) { rm.dispage TOSEC .notice $nick ROMs hideUnscannedSections }
      var %metatrigger = 1
    }
    ; rmiss MAME 58718 , rmiss GBA 3465 , etc.
    if (%metatrigger == 0) {
      var %result = $rmFindSystem($2)
      rm.zget %result
      if (%rm.ztotal == $3) { rm.disp %result .notice $nick ROMs }
    }
  }
  haltdef
}

;##################
;#      Menus     #
;##################

menu menubar {
  &RomManager v $+ %rm.version:rmmngr
}
menu nicklist {
  &RomManager v $+ %rm.version :rmmngr $snicks
  RM Quick &Actions
  .- Actions for All Selected Nicks -:echo -a $me $+ , you clicked on a label. Try something else :)
  .&Get Stats
  ..$rmSectionLabel(9):ctcp $snicks rmiss $rmSectionName(9)
  ..$rmSectionLabel(10):ctcp $snicks rmiss $rmSectionName(10)
  ..$rmSectionLabel(11):ctcp $snicks rmiss $rmSectionName(11)
  ..$rmSectionLabel(12):ctcp $snicks rmiss $rmSectionName(12)
  ..$rmSectionLabel(13):ctcp $snicks rmiss $rmSectionName(13)
  ..&TOSEC ROMs [Combined]:ctcp $snicks rmiss TOSEC
  ..$rmSectionLabel(14):ctcp $snicks rmiss $rmSectionName(14)
  ..$rmSectionLabel(15):ctcp $snicks rmiss $rmSectionName(15)
  ..$rmSectionLabel(16):ctcp $snicks rmiss $rmSectionName(16)
  ..$rmSectionLabel(17):ctcp $snicks rmiss $rmSectionName(17)
  ..&Custom [Combined]:ctcp $snicks rmiss Custom
  ..$rmSectionLabel(18):ctcp $snicks rmiss $rmSectionName(18)
  ..$rmSectionLabel(19):ctcp $snicks rmiss $rmSectionName(19)
  ..$rmSectionLabel(20):ctcp $snicks rmiss $rmSectionName(20)
  ..-
  ..&Summary Stats:ctcp $snicks rmiss all
  ..Total &ROMs:ctcp $snicks rmtotal
  ..-
  ..Custom 1 Abbreviations:ctcp $snicks rmgca1
  ..Custom 2 Abbreviations:ctcp $snicks rmgca2
  ..Custom 3 Abbreviations:ctcp $snicks rmgca3
  .Get &Complete Stats
  ..$rmSectionLabel(9):ctcp $snicks rmiss $rmSectionName(9) $+ 0
  ..$rmSectionLabel(10):ctcp $snicks rmiss $rmSectionName(10) $+ 0
  ..$rmSectionLabel(11):ctcp $snicks rmiss $rmSectionName(11) $+ 0
  ..$rmSectionLabel(15):ctcp $snicks rmiss $rmSectionName(15) $+ 0
  ..$rmSectionLabel(16):ctcp $snicks rmiss $rmSectionName(16) $+ 0
  ..$rmSectionLabel(17):ctcp $snicks rmiss $rmSectionName(17) $+ 0
  ..&Custom [Combined]:ctcp $snicks rmiss Custom0
  ..$rmSectionLabel(18):ctcp $snicks rmiss $rmSectionName(18) $+ 0
  ..$rmSectionLabel(19):ctcp $snicks rmiss $rmSectionName(19) $+ 0
  ..$rmSectionLabel(20):ctcp $snicks rmiss $rmSectionName(20) $+ 0
  .Get RM &Versions and Builds:{ ctcp $snicks RMVER | ctcp $snicks RMBUILD }
  .-
  .- Actions applying to $snick($active,1) Only -:echo -a $me $+ , you clicked on a label. Try something else :)
  .&Send a CompleteStats.txt file
  ..$rmSectionLabel(9):rm.dispage 9 write zeros
  ..$rmSectionLabel(10):rm.dispage 10 write zeros
  ..$rmSectionLabel(11):rm.dispage 11 write zeros
  ..$rmSectionLabel(12):rm.dispage 12 write zeros
  ..$rmSectionLabel(13):rm.dispage 13 write zeros
  ..&TOSEC ROMs [Combined]:rm.dispage TOSEC write zeros
  ..$rmSectionLabel(14):rm.dispage 14 write zeros
  ..$rmSectionLabel(15):rm.dispage 15 write zeros
  ..$rmSectionLabel(16):rm.dispage 16 write zeros
  ..$rmSectionLabel(17):rm.dispage 17 write zeros
  ..&Custom [Combined]:rm.dispage Custom write zeros
  ..$rmSectionLabel(18):rm.dispage 18 write zeros
  ..$rmSectionLabel(19):rm.dispage 19 write zeros
  ..$rmSectionLabel(20):rm.dispage 20 write zeros
  .&Request a CompleteStats.txt file
  ..$rmSectionLabel(9):ctcp $snick($active,1) RMGET $rmSectionName(9) $+ 0
  ..$rmSectionLabel(10):ctcp $snick($active,1) RMGET $rmSectionName(10) $+ 0
  ..$rmSectionLabel(11):ctcp $snick($active,1) RMGET $rmSectionName(11) $+ 0
  ..$rmSectionLabel(12):ctcp $snick($active,1) RMGET $rmSectionName(12) $+ 0
  ..$rmSectionLabel(13):ctcp $snick($active,1) RMGET $rmSectionName(13) $+ 0
  ..&TOSEC ROMs [Combined]:ctcp $snick($active,1) RMGET TOSEC0
  ..$rmSectionLabel(14):ctcp $snick($active,1) RMGET $rmSectionName(14) $+ 0
  ..$rmSectionLabel(15):ctcp $snick($active,1) RMGET $rmSectionName(15) $+ 0
  ..$rmSectionLabel(16):ctcp $snick($active,1) RMGET $rmSectionName(16) $+ 0
  ..$rmSectionLabel(17):ctcp $snick($active,1) RMGET $rmSectionName(17) $+ 0
  ..&Custom [Combined]:ctcp $snick($active,1) RMGET Custom0
  ..$rmSectionLabel(18):ctcp $snick($active,1) RMGET $rmSectionName(18) $+ 0
  ..$rmSectionLabel(19):ctcp $snick($active,1) RMGET $rmSectionName(19) $+ 0
  ..$rmSectionLabel(20):ctcp $snick($active,1) RMGET $rmSectionName(20) $+ 0
  .Request a Check&file:ctcp $snick($active,1) RMGET checkfile
}

menu query,channel,status {
  -
  &RomManager v $+ %rm.version:if ($menu == query) { rmmngr $1 } | else { rmmngr # }
  RM Quick &Actions for $active
  .&Get Stats
  ..$rmSectionLabel(9):.say !rmiss $rmSectionName(9)
  ..$rmSectionLabel(10):.say !rmiss $rmSectionName(10)
  ..$rmSectionLabel(11):.say !rmiss $rmSectionName(11)
  ..$rmSectionLabel(12):.say !rmiss $rmSectionName(12)
  ..$rmSectionLabel(13):.say !rmiss $rmSectionName(13)
  ..&TOSEC ROMs [Combined]:.say !rmiss TOSEC
  ..$rmSectionLabel(14):.say !rmiss $rmSectionName(14)
  ..$rmSectionLabel(15):.say !rmiss $rmSectionName(15)
  ..$rmSectionLabel(16):.say !rmiss $rmSectionName(16)
  ..$rmSectionLabel(17):.say !rmiss $rmSectionName(17)
  ..&Custom [Combined]:.say !rmiss Custom
  ..$rmSectionLabel(18):.say !rmiss $rmSectionName(18)
  ..$rmSectionLabel(19):.say !rmiss $rmSectionName(19)
  ..$rmSectionLabel(20):.say !rmiss $rmSectionName(20)
  ..-
  ..&Summary Stats:.say !rmiss all
  ..T&otal ROMs:.say !rmtotal
  ..-
  ..Custom 1 Abbreviations:.say !rmgca1
  ..Custom 2 Abbreviations:.say !rmgca2
  ..Custom 3 Abbreviations:.say !rmgca3
  .&Show My Stats
  ..$rmSectionLabel(9):rm.dispage 9 describe $active
  ..$rmSectionLabel(10):rm.dispage 10 describe $active
  ..$rmSectionLabel(11):rm.dispage 11 describe $active
  ..$rmSectionLabel(12):rm.dispage 12 describe $active
  ..$rmSectionLabel(13):rm.dispage 13 describe $active
  ..&TOSEC ROMs [Combined]:rm.dispage TOSEC describe $active
  ..$rmSectionLabel(14):rm.dispage 14 describe $active
  ..$rmSectionLabel(15):rm.dispage 15 describe $active
  ..$rmSectionLabel(16):rm.dispage 16 describe $active
  ..$rmSectionLabel(17):rm.dispage 17 describe $active
  ..&Custom [Combined]:rm.dispage Custom describe $active
  ..$rmSectionLabel(18):rm.dispage 18 describe $active
  ..$rmSectionLabel(19):rm.dispage 19 describe $active
  ..$rmSectionLabel(20):rm.dispage 20 describe $active
  ..-
  ..&Summary Stats:{ rm.shortstats describe $active }
  ..D&etailed Stats:{ rm.all describe $active }
  ..T&otal ROMs:{ rm.ttl describe $active }
  ..-
  ..$rmSectionLabel(18) Abbreviations:rm.gca 18 describe $active
  ..$rmSectionLabel(19) Abbreviations:rm.gca 19 describe $active
  ..$rmSectionLabel(20) Abbreviations:rm.gca 20 describe $active
  .&Privately View My Stats
  ..$rmSectionLabel(9):rm.dispage 9 echo $me
  ..$rmSectionLabel(10):rm.dispage 10 echo $me
  ..$rmSectionLabel(11):rm.dispage 11 echo $me
  ..$rmSectionLabel(12):rm.dispage 12 echo $me
  ..$rmSectionLabel(13):rm.dispage 13 echo $me
  ..&TOSEC ROMs [Combined]:rm.dispage TOSEC echo $me
  ..$rmSectionLabel(14):rm.dispage 14 echo $me
  ..$rmSectionLabel(15):rm.dispage 15 echo $me
  ..$rmSectionLabel(16):rm.dispage 16 echo $me
  ..$rmSectionLabel(17):rm.dispage 17 echo $me
  ..&Custom [Combined]:rm.dispage Custom echo $me
  ..$rmSectionLabel(18):rm.dispage 18 echo $me
  ..$rmSectionLabel(19):rm.dispage 19 echo $me
  ..$rmSectionLabel(20):rm.dispage 20 echo $me
  ..-
  ..&Summary Stats:{ rm.shortstats echo $me }
  ..D&etailed Stats:{ rm.all echo $me }
  ..T&otal ROMs:{ rm.ttl echo $me }
  ..-
  ..$rmSectionLabel(18) Abbreviations:rm.gca 18 echo $me
  ..$rmSectionLabel(19) Abbreviations:rm.gca 19 echo $me
  ..$rmSectionLabel(20) Abbreviations:rm.gca 20 echo $me
  .-
  .&Complete Stats
  ..&Get Stats
  ...$rmSectionLabel(9):.say !rmiss $rmSectionName(9) $+ 0
  ...$rmSectionLabel(10):.say !rmiss $rmSectionName(10) $+ 0
  ...$rmSectionLabel(11):.say !rmiss $rmSectionName(11) $+ 0
  ...$rmSectionLabel(15):.say !rmiss $rmSectionName(15) $+ 0
  ...$rmSectionLabel(16):.say !rmiss $rmSectionName(16) $+ 0
  ...$rmSectionLabel(17):.say !rmiss $rmSectionName(17) $+ 0
  ...&Custom [Combined]:.say !rmiss Custom0
  ...$rmSectionLabel(18):.say !rmiss $rmSectionName(18) $+ 0
  ...$rmSectionLabel(19):.say !rmiss $rmSectionName(19) $+ 0
  ...$rmSectionLabel(20):.say !rmiss $rmSectionName(20) $+ 0
  ..&Show My Stats
  ...$rmSectionLabel(9):rm.dispage 9 describe $active zeros
  ...$rmSectionLabel(10):rm.dispage 10 describe $active zeros
  ...$rmSectionLabel(11):rm.dispage 11 describe $active zeros
  ...$rmSectionLabel(15):rm.dispage 15 describe $active zeros
  ...$rmSectionLabel(16):rm.dispage 16 describe $active zeros
  ...$rmSectionLabel(17):rm.dispage 17 describe $active zeros
  ...&Custom [Combined]:rm.dispage Custom describe $active zeros
  ...$rmSectionLabel(18):rm.dispage 18 describe $active zeros
  ...$rmSectionLabel(19):rm.dispage 19 describe $active zeros
  ...$rmSectionLabel(20):rm.dispage 20 describe $active zeros
  ..&Privately View My Stats
  ...$rmSectionLabel(9):rm.dispage 9 echo $me zeros
  ...$rmSectionLabel(10):rm.dispage 10 echo $me zeros
  ...$rmSectionLabel(11):rm.dispage 11 echo $me zeros
  ...$rmSectionLabel(12):rm.dispage 12 echo $me zeros
  ...$rmSectionLabel(13):rm.dispage 13 echo $me zeros
  ...&TOSEC ROMs [Combined]:rm.dispage TOSEC echo $me zeros
  ...$rmSectionLabel(14):rm.dispage 14 echo $me zeros
  ...$rmSectionLabel(15):rm.dispage 15 echo $me zeros
  ...$rmSectionLabel(16):rm.dispage 16 echo $me zeros
  ...$rmSectionLabel(17):rm.dispage 17 echo $me zeros
  ...&Custom [Combined]:rm.dispage Custom echo $me zeros
  ...$rmSectionLabel(18):rm.dispage 18 echo $me zeros
  ...$rmSectionLabel(19):rm.dispage 19 echo $me zeros
  ...$rmSectionLabel(20):rm.dispage 20 echo $me zeros
  .-
  .See RM Database &Versions:{ .notice $me RomManager Database v $+ %rm.version | .say !rmver }
  .See RM Code Revisions (Builds):{ .notice $me RomManager.mrc Code Revision (build %rm.build $+ ) | .say !rmbuild }
  .-
  .Check&file Actions
  ..Verify &Default Checkfile: rm.VerifyCheckfile
  ..&Verify Custom Checkfile: rm.VerifyCheckfile Custom
  ..&Create Checkfile: rm.CreateCheckfile Custom
  .-
  .&Unload RomManager:{ .unload -rs " $+ $script $+ " }
  .&Reload RomManager:{
    if ($dialog(rmm) != $null) { .timer 1 1 rmmngr $did(rmm,60) }
    .load -rs " $+ $script $+ "
  }
}

