;##################################################################
;#     RomManager DAT Update Manager build 73 for mIRC > 6.1      #
;##################################################################
;Created by b1u3j

on *:LOAD {
  ;this is to track script versions only. do not change unless script code has been changed.
  %rmu.build = build 73
  echo -s 11DAT Update Manager 04 $+ %rmu.build 11has been loaded
}

dialog rmupdate {
  title "DAT Update Manager"
  size -1 -1 245 246
  option dbu

  box Categories, 30, 3 2 240 29
  icon 9, 7 10 16 16,  %rm.icon, 0
  icon 10, 25 10 16 16,  %rm.icon, 1
  icon 11, 43 10 16 16,  %rm.icon, 2
  icon 12, 67 10 16 16,  %rm.icon, 3
  icon 13, 85 10 16 16,  %rm.icon, 4
  icon 14, 103 10 16 16,  %rm.icon, 5
  icon 15, 127 10 16 16,  %rm.icon, 6
  icon 16, 145 10 16 16,  %rm.icon, 7
  icon 17, 163 10 16 16,  %rm.icon, 8
  icon 18, 187 10 16 16,  %rm.icon, 9
  icon 19, 205 10 16 16,  %rm.icon, 10
  icon 20, 223 10 16 16,  %rm.icon, 11

  box "Systems:", 31, 1 36 167 141
  list 1, 2 43 115 133, sort size

  box "Local:", 32, 117 36 51 141
  list 2, 117 43 50 133, size

  box "Version Info:", 33, 170 36 73 133
  text "Local:", 331, 173 45 20 8
  edit "", 332, 188 44 52 10, read autohs center
  text "Web:", 333, 174 56 20 8
  edit "", 334, 188 55 52 10, read autohs center

  box "Update:", 34, 170 66 73 103
  button "Check for Updates", 341, 173 76 67 12
  button "Download", 342, 173 90 67 12, default
  button "Show Unknown", 343, 173 104 67 12

  box "Display:", 35, 170 119 73 34, hide
  check "Updated", 351, 173 127 31 9, hide
  check "(current)", 352, 173 137 31 9, hide
  check "(notfound)", 353, 205 127 35 9, hide
  check "(newerfile)", 354, 205 137 35 9, hide

  box "Last Checked on:", 36, 170 149 73 20
  text "", 361, 172 158 68 10, center
  text "Total Systems:", 362, 172 171 42 8, right
  text "", 363, 214 171 24 8, center
  text "(current):", 364, 172 178 42 8, right
  text "", 365, 214 178 24 8, center
  text "(not found):", 366, 172 185 42 8, right
  text "", 367, 214 185 24 8, center
  text "(newer file):", 368, 172 192 42 8, right
  text "", 369, 214 192 24 8, center

  box "Web location for Updates:", 38, 1 179 166 21
  edit "", 380, 3 186 129 11, read autohs center
  button "Change", 381, 134 186 30 10

  box "Messages:", 39, 1 201 242 32
  text "", 390, 4 208 237 24

  button "Reset Data", 990, 1 235 37 10
  button "RM", 991, 40 235 37 10
  button "Help", 999, 167 235 37 10
  button "Done", 1000, 206 235 37 10, ok cancel
}

on *:dialog:rmu:mouse:* { }

on *:dialog:rmu:init:0 {
  %rmu.current_section = %rm.current_section
  did -g rmu %rmu.current_section $calc(%rmu.current_section + 7) %rm.icon
  did -b rmu 342,343
  did -h rmu 364,366,368
  dialog -t rmu DAT Update Manager - $remove($rmSectionLabel(%rmu.current_section),&)
  var %url = $readini(%rm.rmp,PREF,webupdate $+ %rmu.current_section)
  if (%url == $null) { var %url = $readini(%rm.rlm,%rmu.current_section,webupdate) }
  if (%url != $null) { did -ra rmu 380 %url }
  rmu.findFamily
  if ($hget(rmZiplist) && ($istok(%rmu.Family,$gettok($hget(rmZiplist,0),2,9),9) == $true)) { rmu.FilterUnknown }
  rmu.loadSystemsList
}

on *:dialog:rmu:*:* {
  var %rmu.sel = $did(1).sel
  if (($did == 1 || $did == 2)) {
    if ($devent == dclick) { rmu.DownloadFile }
    if ($did(rmu,32) == Web:) { did -e rmu 342 }
    if ($did == 1) { did -c rmu 2 $did(1).sel }
    if ($did == 2) { did -c rmu 1 $did(2).sel }
    var %rmu.sel = $did(1).sel
    rmu.displaySystemPath
  }
  ;section changed
  if (($did > 8) && ($did < 21) && (%rmu.current_section != $did)) {
    did -g rmu %rmu.current_section $calc(%rmu.current_section - 9) %rm.icon
    %rmu.current_section = $did
    did -g rmu %rmu.current_section $calc(%rmu.current_section + 7) %rm.icon
    rmu.refresh
  }
  ;refresh display
  if (($did >= 350 && $did < 360)) { if ($did(31) == Systems:) { rmu.loadSystemsList } | else { rmu.loadUnknownSystemsList } }
  ;check for updates button clicked
  elseif ($did == 341) { if ($did(31) == Systems:) { rmu.CheckForUpdates } | else { rmu.refresh } }
  ;try and download a file
  elseif ($did == 342) { rmu.DownloadFile }
  ;show the unknown zips
  elseif ($did == 343) { rmu.loadUnknownSystemsList }
  ;change web location for updated dats
  elseif ($did == 381) {
    if (%rmu.380 == enabled) {
      if ($did(380).edited == $true) {
        if ($did(380) == $null) { remini %rm.rmp PREF webupdate $+ %rmu.current_section }
        else { writeini %rm.rmp PREF webupdate $+ %rmu.current_section $remove($remove($did(380),http://),http:) }
      }
      var %url = $readini(%rm.rmp,PREF,webupdate $+ %rmu.current_section)
      if (%url == $null) { var %url = $readini(%rm.rlm,%rmu.current_section,webupdate) }
      if (%url != $null) { did -ra rmu 380 %url }
      did -vra rmu 381 Change
      did -m rmu 380
      unset %rmu.380
      did -r rmu 390
    }
    else {
      %rmu.380 = enabled | did -vra rmu 381 Save | did -fn rmu 380
      did -ra rmu 390 Erase the Web location and click on Save to reset it to the RomManager default
    }
  }
  ;reset button clicked
  elseif ($did == 990) {
    if $hget(rmUpdates) { .hfree rmUpdates }
    if $hget(rmZiplist) { .hfree rmZiplist }
    rmu.refresh
  }
  ;RM button clicked
  elseif ($did == 991) {
    if ($dialog(rmm) != $null) { rmmngr $did(rmm,60) } | else { rmmngr }
  }
  ;help button clicked
  elseif ($did == 999) { rmhelp documentation }
  ;Done button clicked
  elseif ($did == 1000) {
    if $hget(rmDats) { .hfree rmDats }
    if $hget(rmDatVersions) { .hfree rmDatVersions }
    ;save the current position & size
    %rmu.pos = $dialog(rmu).x $dialog(rmu).y $dialog(rmu).cw $dialog(rmu).ch
    var %rmu.current_section
  }
}

;start the dat updater manager dialog
alias rmupdate {
  if ($dialog(rmu) == $null) {
    if ($readini(%rm.rmp,PREF,m) == 1) { dialog -mdie rmu rmupdate }
    else { dialog -ma rmu rmupdate }
    if (%rmu.pos != $null) { dialog -s rmu %rmu.pos }
  }
  else {
    ;save the current position & size
    %rmu.pos = $dialog(rmu).x $dialog(rmu).y $dialog(rmu).cw $dialog(rmu).ch
    ;close/open rmu again
    dialog -x rmu
    rmu.restart
  }
}

;called by rmupdate to restart itself
alias -l rmu.restart { rmupdate }

;used to reset all the dialog items without reloading
alias -l rmu.refresh {
  did -ra rmu 31 Systems:
  did -ra rmu 32 Local:
  did -ra rmu 343 Show Unknown
  did -b rmu 342,343
  did -rah rmu 351 Updated
  did -rah rmu 352 (current)
  did -rah rmu 353 (notfound)
  did -rah rmu 354 (newerfile)
  did -h rmu 35,364,366,368
  did -r rmu 332,334,361,363,365,367,369,390
  did -ra rmu 362 Total Systems:
  dialog -t rmu DAT Update Manager - $remove($rmSectionLabel(%rmu.current_section),&)
  var %url = $readini(%rm.rmp,PREF,webupdate $+ %rmu.current_section)
  if (%url == $null) { var %url = $readini(%rm.rlm,%rmu.current_section,webupdate) }
  if (%url != $null) { did -ra rmu 380 %url }
  rmu.findFamily
  if ($hget(rmZiplist) && ($istok(%rmu.Family,$gettok($hget(rmZiplist,0),2,9),9) == $true)) { rmu.FilterUnknown }
  rmu.loadSystemsList
}

;Writes into main dialog "Messages" text box the selected system dat (and zip) path
alias -l rmu.displaySystemPath {
  var %rmu.sel = $did(rmu,1).sel
  if ($did(rmu,31) == Systems:) {
    var %rmu.sel = $hget(rmIndex,%rmu.sel)
    var %selected_system = $rmSystem(%rmu.current_section,%rmu.sel)
    ;try to find a matching dat file
    var %datFile = $rmFindDat(%rmu.current_section,%rmu.sel)

    if $hget(rmUpdates) {
      var %webdate = $gettok($hget(rmUpdates,%selected_system),6,9)
      if ((%webdate != $null) && ($did(rmu,2,%rmu.sel) == (newer file)))  {
        did -ra rmu 332 $asctime($file($rmFindDat(%rmu.current_section,%rmu.sel)).mtime,yyyymmdd HH:mm)
        did -ra rmu 334 %webdate
      }
      else {
        did -ra rmu 332 $rmGetDatVersion(%rmu.current_section,%rmu.sel)
        did -ra rmu 334 $gettok($hget(rmUpdates,%selected_system),3,9)
      }
      var %zip = $gettok($hget(rmUpdates,%selected_system),4,9)
      did -ra rmu 390 DAT: $nopath(%datFile) $crlf $crlf ZIP: $gettok($gettok(%zip,1,34),-1,47)
    }
    else {
      did -ra rmu 332 $rmGetDatVersion(%rmu.current_section,%rmu.sel)
      did -ra rmu 390 %datFile
    }
  }
  else {
    var %zip = $gettok($hget(rmZiplist,$hget(rmIndex,%rmu.sel)),4,9)
    did -ra rmu 332
    did -ra rmu 334 $did(rmu,2,%rmu.sel)
    did -ra rmu 390 DAT: $crlf $crlf ZIP: $nopath($gettok(%zip,1,34))
  }
}

;Loads the main dialog with the current section system list and local/web versions
alias -l rmu.loadSystemsList {
  did -r rmu 1
  did -r rmu 2
  if ($hget(rmUpdates) && $hget(rmUpdates,%rmu.current_section)) {
    var %rmUpdates = $true
    var %total_updates = 0
    var %current = 0
    var %not_found = 0
    var %newer_file = 0
    did -v rmu 35,351,352,353
    if ($did(rmu,32) == Local:) { did -ra rmu 32 Web: | did -c rmu 351,352,353,354 }
    did -v rmu 364,366
    did -i rmu 361 1 $hget(rmUpdates,%rmu.current_section)
  }
  else { var %rmUpdates | did -b rmu 342 }

  if ($hget(rmIndex) != $null) { hfree rmIndex }
  hmake rmIndex 10
  var %index = 0
  var %n = $rmSystemCount(%rmu.current_section)
  var %i = 1
  while (%i <= %n) {
    var %system = $rmSystem(%rmu.current_section,%i)
    var %type = $rmLogType(%rmu.current_section,%i)
    var %show = $true
    if (%rmUpdates == $true) {
      var %version = $gettok($hget(rmUpdates,%system),3,9)
      if (%version == (not found)) { inc %not_found }
      elseif (%version != $rmGetDatVersion(%rmu.current_section,%i)) { inc %total_updates }
      else {
        var %version = $gettok($hget(rmUpdates,%system),6,9)
        if (%version != $null) {
          var %datdate = $asctime($file($rmFindDat(%rmu.current_section,%i)).mtime,yyyymmdd HH:mm)
          if (%version > %datdate) { var %version = (newer file) | inc %newer_file }
          else { var %version }
        }
        if (%version == $null) { inc %current | var %version = (current) }
      }
      if (($did(rmu,351).state == 0) && ($pos(%version,$chr(40),1) == $null)) { var %show = $false }
      if (($did(rmu,352).state == 0) && (%version == (current))) { var %show = $false }
      if (($did(rmu,353).state == 0) && (%version == (not found))) { var %show = $false }
      if (($did(rmu,354).state == 0) && (%version == (newer file))) { var %show = $false }
    }
    else { var %version = $rmGetDatVersion(%rmu.current_section,%i) }
    if (%show == $true) {
      inc %index
      hadd rmIndex %index %i
      did -i rmu 1 %index $readini(%rm.rlm,TOOL,%type) : $rmSystemName(%rmu.current_section,%i)
      did -i rmu 2 %index %version
    }
    inc %i
  }
  if (%rmUpdates == $true) {
    did -i rmu 362 1 Updates Found:
    did -i rmu 363 1 %total_updates $+ / $+ $rmSystemCount(%rmu.current_section)
    did -i rmu 365 1 %current
    did -i rmu 367 1 %not_found
    if (%newer_file > 0) { did -v rmu 354,368 | did -i rmu 369 1 %newer_file }
  }
  else { did -i rmu 363 1 %n }
}

;find all sections using the same update url
alias -l rmu.findFamily {
  var %url = $readini(%rm.rmp,PREF,webupdate $+ %rmu.current_section)
  if (%url == $null) { var %url = $readini(%rm.rlm,%rmu.current_section,webupdate) }
  unset %rmu.family
  var %section = 9
  while (%section < 21) {
    var %section_url = $readini(%rm.rmp,PREF,webupdate $+ %section)
    if (%section_url == $null) { var %section_url = $readini(%rm.rlm,%section,webupdate) }
    if (%section_url == %url) { %rmu.family = $addtok(%rmu.family,%section,9) }
    inc %section
  }
}

;create an update hash table with the web info for all systems in
;all sections that use the same update url as the current section
alias -l rmu.CompareSystems {
  var %family = %rmu.family
  if ($hget(rmUpdates) == $null) { hmake rmUpdates }
  var %section = $gettok(%family,1,9)
  while (%section != $null) {
    hadd rmUpdates %section $asctime($ctime,yyyymmdd HH:mm)
    var %family = $deltok(%family,1,9)
    var %i = $rmSystemCount(%section)
    while (%i > 0) {
      var %system = $rmSystem(%section,%i)
      var %type = $rmLogType(%section,%i)

      if ((%type == 1) || (%section == 11)) { var %systemName = %system }
      else { var %systemName = $deltok($nopath($rmLogFile(%section,%i)),-1,46) }

      if (%systemName != $null) {
        var %search = %systemName $+ $chr(9) $+ %type $+ *
        var %update = $hfind(rmZiplist,%search,1,w).data
      }

      var %alt = $rmSystemAlt(%section,%i)
      if ((%update == $null) && (%alt != $null)) {
        %search = %alt $+ $chr(9) $+ %type $+ *
        %update = $hfind(rmZiplist,%search,1,w).data
      }

      if (%update == $null) {
        var %systemName = $rmSystemName(%section,%i)
        %search = %systemName $+ $chr(9) $+ %type $+ *
        %update = $hfind(rmZiplist,%search,1,w).data
      }

      if (%update == $null) { hadd rmUpdates %system 0 $+ $chr(9) $+ 0 $+ $chr(9) $+ (not found) }
      else { hadd rmUpdates %system $hget(rmZiplist,%update) }
      dec %i
    }
    var %section = $gettok(%family,1,9)
  }
}

;download the selected update. (currently just sends the url to the default web browser)
alias -l rmu.DownloadFile {
  if ($did(rmu,342).enabled == $false) { return }
  var %rmu.sel = $hget(rmIndex,$did(rmu,1).sel)
  if ($did(rmu,31) == Systems:) {
    var %x = $rmSystem(%rmu.current_section,%rmu.sel)
    var %zippath = $gettok($hget(rmUpdates,%x),4,9)
    var %host = $gettok($hget(rmUpdates,%x),5,9)
  }
  else {
    var %x = $hget(rmZiplist,%rmu.sel)
    var %zippath = $gettok(%x,4,9)
    var %host = $gettok(%x,5,9)
  }
  var %zippath = $gettok(%zippath,1,34)
  if ($left(%zippath,1) != $chr(47)) { var %zippath = / $+ %zippath }
  var %zippath = $replace(%zippath,$chr(32),$chr(37) $+ 20)
  ;var %zippath = $replace(%zippath,$chr(38),&amp;)
  run http:// $+ %host $+ %zippath
}

;Loads the main dialog with the unknown system list and web versions
alias -l rmu.loadUnknownSystemsList {
  did -r rmu 1,2,332,334,390
  if ($hget(rmIndex) != $null) { hfree rmIndex }
  hmake rmIndex 10
  did -hi rmu 367 1
  did -v rmu 35
  did -vra rmu 351 CM
  did -vra rmu 352 RC
  did -vra rmu 353 Gd
  did -vra rmu 354 TD
  if ($did(rmu,31) == Systems:) { did -c rmu 351 | did -u rmu 352,353,354 | rmu.FilterUnknown }
  did -ra rmu 31 Unknown Systems:
  did -ra rmu 32 Web:
  did -ra rmu 341 Show Updates
  if ($did(rmu,1).sel == $null) { did -b rmu 342 }
  did -b rmu 343
  did -i rmu 362 1 (displayed):
  did -i rmu 364 1 (total):
  did -hi rmu 366 1
  var %unknown_subtotal = 0
  var %unknown_total = 0
  var %t0 = 0 | var %t1 = 0 | var %t2 = 0 | var %t3 = 0 | var %t5 = 0
  var %i = 1
  var %zips = $gettok($hget(rmZiplist,0),1,9)
  while (%i <= %zips) {
    var %x = $hget(rmZiplist,%i)
    var %systemName = $gettok(%x,1,9)
    if ((%x != $null) && (%systemName != zzzzz)) {
      var %type = $gettok(%x,2,9)
      inc [ %t $+ [ %type ] ]
      var %show = $true
      if (($did(rmu,351).state == 0) && (%type == 2)) { var %show = $false }
      if (($did(rmu,352).state == 0) && (%type == 3)) { var %show = $false }
      if (($did(rmu,353).state == 0) && (%type == 1)) { var %show = $false }
      if (($did(rmu,354).state == 0) && (%type == 5)) { var %show = $false }
      inc %unknown_total
      if (%show == $true) {
        inc %unknown_subtotal
        hadd rmIndex %unknown_subtotal %i
        did -i rmu 1 %unknown_subtotal $readini(%rm.rlm,TOOL,%type) : %systemName
        var %version = $gettok(%x,3,9)
        did -i rmu 2 %unknown_subtotal %version
      }
    }
    inc %i
  }
  did -i rmu 363 1 %unknown_subtotal
  did -i rmu 365 1 %unknown_total
  if (%t2 > 0) { did -vra rmu 351 CM ( $+ %t2 $+ ) }
  if (%t3 > 0) { did -vra rmu 352 RC ( $+ %t3 $+ ) }
  if (%t1 > 0) { did -vra rmu 353 Gd ( $+ %t1 $+ ) }
  if (%t5 > 0) { did -vra rmu 354 TD ( $+ %t5 $+ ) }
}

;sorts a hashtable alphabetically z-a by the data in each item. assumes the items are named 1 thru N
alias -l rmu.bubbleSort {
  ;rmu.bubbleSort hashtable itemcount
  var %i = $2
  if (%i > 100) { return }
  while (%i >= 1) {
    var %x = 1
    var %y = 2
    while (%x < %i) {
      var %sort = $sorttok($gettok($hget($1,%y),1,9) $+ $chr(63) $+ $gettok($hget($1,%x),1,9),63)
      if ($gettok(%sort,1,63) == $gettok($hget($1,%y),1,9)) {
        var %s = $hget($1,%y)
        hadd $1 %y $hget($1,%x)
        hadd $1 %x %s
      }
      inc %x
      inc %y
    }
    dec %i
  }
}

;remove all update info for any system in the current family from the rmZiplist hash table
alias -l rmu.FilterUnknown {
  if ($numtok($hget(rmZiplist,0),9) == 3) { did -era rmu 343 Show Unknown ( $+ $gettok($hget(rmZiplist,0),3,9) $+ ) | return }
  var %family = %rmu.family
  var %section = $gettok(%family,1,9)
  while (%section != $null) {
    var %family = $deltok(%family,1,9)
    var %i = $rmSystemCount(%section)
    while (%i > 0) {
      var %system = $rmSystem(%section,%i)
      var %type = $rmLogType(%section,%i)

      if ((%type == 1) || (%section == 11)) { var %systemName = %system }
      else { var %systemName = $deltok($nopath($rmLogFile(%section,%i)),-1,46) }

      if (%systemName != $null) {
        var %search = %systemName $+ $chr(9) $+ *
        var %x = $hfind(rmZiplist,%search,1,w).data
        while (%x != $null) { hadd rmZiplist %x zzzzz | var %x = $hfind(rmZiplist,%search,1,w).data }
      }

      var %alt = $rmSystemAlt(%section,%i)
      if (%alt != $null) {
        var %search = %alt $+ $chr(9) $+ *
        var %x = $hfind(rmZiplist,%search,1,w).data
        while (%x != $null) { hadd rmZiplist %x zzzzz | var %x = $hfind(rmZiplist,%search,1,w).data }
      }

      var %systemName = $rmSystemName(%section,%i)
      var %search = %systemName $+ $chr(9) $+ *
      var %x = $hfind(rmZiplist,%search,1,w).data
      while (%x != $null) { hadd rmZiplist %x zzzzz | var %x = $hfind(rmZiplist,%search,1,w).data }

      dec %i
    }
    var %section = $gettok(%family,1,9)
  }
  var %zips = $gettok($hget(rmZiplist,0),1,9)
  rmu.bubbleSort rmZiplist %zips
  var %unk = 0
  var %i = 1
  while (%i <= %zips) {
    var %x = $hget(rmZiplist,%i)
    if ((%x != $null) && (%x != zzzzz)) { inc %unk }
    inc %i
  }
  hadd rmZiplist 0 $hget(rmZiplist,0) $+ $chr(9) $+ %unk
  did -ra rmu 343 Show Unknown ( $+ %unk $+ )
}

;get ready to open the webupdate site
alias -l rmu.CheckForUpdates {
  did -b rmu 342
  did -e rmu 343
  did -i rmu 363,365,367,369 1
  var %url = $readini(%rm.rmp,PREF,webupdate $+ %rmu.current_section)
  if (%url == $null) { var %url = $readini(%rm.rlm,%rmu.current_section,webupdate) }
  if (%url == $null) { did -ra rmu 390 Error: Web location for Updates is not defined | Return }
  ;clean up the url and split it into host & url
  var %url = $remove(%url,http://)
  var %url = $remove(%url,http:)
  if ($numtok(%url,47) > 1) {
    var %host = $gettok(%url,1,47)
    var %url = / $+ $deltok(%url,1,47)
  }
  var %host = $remove(%host,/)
  if (%url == $null) { var %url = / }
  ;open the web page
  rmu.OpenSock %host %url
}

;open the webupdate site
alias rmu.OpenSock {
  if ($sock(rmSite)) { sockclose rmSite }
  if ($dialog(rmu) == $null) { rmCloseSock | return }
  %rmSite.host = $1
  if ($numtok(%rmSite.host,58) == 2) {
    var %port = $gettok(%rmSite.host,2,58)
    %rmSite.host = $deltok(%rmSite.host,2,58)
  }
  else { var %port = 80 }
  %rmSite.url = $2-
  unset %rmu.saved
  %rmSiteZips = 0
  if $hget(rmZiplist) { .hfree rmZiplist }
  hmake rmZiplist 50
  did -ra rmu 390 Connection Status: Opening %rmSite.host $+ ...
  sockopen rmSite %rmSite.host %port
}

;close the update socket and parse the ziplist
alias rmu.CloseSock {
  unset %rmSite.host
  unset %rmSite.url
  sockclose rmSite
  rmu.findFamily
  rmu.CompareSystems
  rmu.loadSystemsList
  rmu.FilterUnknown
}

;not used atm
on 1:sockclose:rmSite:{ }

;send the request to the webupdate site
on 1:sockopen:rmSite:{
  did -ra rmu 390 Connection Status: Requesting Data...
  if ($sockerr) {
    if ($sockerr == 3) { did -ra rmu 390 Connection Status: Timeout while Attemping to Open Connection }
    elseif ($sockerr == 4) { did -ra rmu 390 Connection Status: Could Not Open Connection }
    else { did -ra rmu 390 Connection Status: Error $sockerr }
    halt
  }
  sockwrite -n rmSite GET %rmSite.url HTTP/1.1
  sockwrite -n rmSite Host: %rmSite.host
  sockwrite -n rmSite User-Agent: RomManager/v $+ %rm.version
  sockwrite -n rmSite $crlf
}

;read the webupdate page and parse it into the rmZiplist
on 1:sockread:rmSite:{
  if ($sockerr > 0) { did -ra rmu 390 Connection Status: Socket Error $sockerr | rmu.CloseSock | halt }
  var %s
  sockread %s

  ;parse the header
  if (%rmSockHead == $null) {
    while (($sockbr > 0) && (%rmSockHead == $null)) {
      if ((</head> isin %s) || (<body isin %s)) { %rmSockHead = finished }
      ;<BASE href="http://www.clrmame.com/datfiles/">
      if (<BASE HREF isin %s) {
        var %pos = $pos(%s,<BASE HREF=,1)
        %rmURL = $chr(47) $+ $gettok($remove($remove($gettok($right(%s,- $+ $calc(%pos + 7)),1,62),http://),$chr(34)),2-,47) $+ $chr(47)
      }
      sockread %s
    }
    %rmSockHead = finished
    if ((%rmURL == $null) && ($numtok(%rmSite.url,47) > 1)) {
      if ($right(%rmSite.url,1) == $chr(47)) { %rmURL = %rmSite.url }
      else { %rmURL = $chr(47) $+ $deltok(%rmSite.url,-1,47) $+ $chr(47) }
    }
  }

  if ((</body> isin %s) || (</html> isin %s)) { %rmSockEnd = found }
  while ($sockbr > 0) {
    ;<A HREF="Dats/MAME%20(0.81_CM).zip">CM</A></TD>
    var %count = $count(%s,<A HREF=)
    ; <=60, >=62
    var %i = 1
    while (%i <= %count) {
      var %pos = $pos(%s,<A HREF=,%i)
      var %dat = $gettok($right(%s,- $+ $calc(%pos + 7)),1,62)
      ;&nbsp;<a href="/files/Acorn [TOSEC_CM].dat.zip">Acorn [TOSEC_CM].dat.zip</a> (compiled: April 20 2004 01:42:26)<br>
      var %compiled = $gettok($right(%s,- $+ $calc(%pos + 7)),3,62)
      var %compiled = $asctime($ctime($gettok($gettok(%compiled,2-,58),1,41)),yyyymmdd HH:mm)
      if ((.zip isin %dat) || (.udb isin %dat) || (.dat isin %dat) || (.rar isin %dat) || (.7z isin %dat)) {
        var %dat = $replace(%dat,$chr(37) $+ 20,$chr(32))
        var %dat = $replace(%dat,&amp;,&)
        if (%rmURL != $null) {
          var %x = $remove(%dat,$chr(34))
          if ($left(%x,1) != $chr(47)) { var %dat = $chr(34) $+ %rmURL $+ %x $+ $chr(34) }
        }
        inc %rmSiteZips
        hadd rmZiplist %rmSiteZips $rmExtractInfo(%dat) $+ $chr(9) $+ %dat $+ $chr(9) $+ %rmSite.host $+ $chr(9) $+ %compiled
        did -ra rmu 390 Connection Status: Zips found: %rmSiteZips
      }
      inc %i
    }
    sockread %s
    if ((</body> isin %s) || (</html> isin %s)) { %rmSockEnd = found }
  }
  if (%rmSockEnd == found) {
    unset %rmSockHead
    unset %rmSockEnd
    unset %rmURL
    if (%rmSiteZips == 0) { did -ra rmu 390 Connection Status: Error! No Zips were found at this URL. $crlf $crlf (Note: If you don't see zips when you go there yourself, then RM will not either!)  }
    hadd rmZiplist 0 %rmSiteZips $+ $chr(9) $+ %rmu.current_section
    unset %rmSiteZips
    rmu.CloseSock
  }
}
