#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void strip(char *inp)
{
	int i;
	for (i = 0; i < (int)strlen(inp); i++)
	{
		if (inp[i] == ',' || inp[i] == ' ' || inp[i] == '}' || inp[i] == 0x09 || inp[i] == '{' || inp[i] == '\"')
		{
			memcpy (inp + i, inp + i + 1, strlen(inp)-(i+1));
			inp[strlen(inp)-1] = '\0';
			i--;
		}

		if (strncmp("0x", inp + i, 2) == 0)
		{
			memcpy (inp + i, inp + i + 2, strlen(inp)-(i+2));
			inp[strlen(inp)-2] = '\0';
			i--;
		}
	}
}

unsigned int sscanf_annoys_me(char *inp)
{
	unsigned int i, k;

	for (i = 0, k = 0; i < 8; i++)
	{
		if ((inp[i] & 0xf0) == 0x30)
		{
			k |=  (inp[i] & 0x0f)      << (28 - (4 * i));
		}

		if ((inp[i] & 0xd0) == 0x40 && (inp[i] & 0x0f) < 7)
		{
			k |= ((inp[i] & 0x0f) + 9) << (28 - (4 * i));
		}
	}

	return k;
}


unsigned int key[2];
unsigned int uppr = 0;

void getcrypt(char *nam)
{
	int i;
	FILE *fz;
	int szLen;
	char szLine[256];

	fz = fopen("cps2crpt.c", "rt");


	if (fz == NULL) {
		printf ("cps2crpt.c not found\n");
		return;
	}

	int cFound = 0;

	while (1)
	{
		if (fgets(szLine, 256, fz) == NULL)
			break;

		szLen = strlen( szLine );

		if (strncmp ("static const struct game_keys keys_table[] =", szLine, szLen-1) == 0)
			cFound = 1;

		if (cFound == 0) 	// skip
			continue;

		if (strncmp ("	{ \"", szLine, strlen("	{ \"")) == 1)
			continue;

		if (strncmp (nam, szLine + 4, strlen(nam)) == 0 && szLine[4 + strlen(nam)] == '\"')
		{
			char tmp[32];
			int c0 = 0, c1 = 0;
			for (i = 0; i < szLen; i++)
			{
				if (szLine[i] == ',' && c0 == 3) {

					memcpy (tmp, szLine + c1, i-c1);
					strip(tmp);
					tmp[i-c1] = '\0';

					uppr = sscanf_annoys_me(tmp) >> 8;
					if (uppr < 0x80000 || uppr > 0x400000) uppr = 0x400000;

					c0++;
					c1 = i;
				}

				if (szLine[i] == ',' && c0 == 2) {

					memcpy (tmp, szLine + c1, i-c1);
					strip(tmp);
					tmp[8] = '\0';

					key[1] = sscanf_annoys_me(tmp);

					c0++;
					c1 = i;
				}

				if (szLine[i] == ',' && c0 == 1) {

					memcpy (tmp, szLine + c1, i-c1);
					strip(tmp);
					tmp[8] = '\0';

					key[0] = sscanf_annoys_me(tmp);

					c0++;
					c1 = i;
				}

				if (szLine[i] == ',' && c0 == 0) {
					c0++;
					c1 = i;
				}
			}

			break;
		}
	}

//	printf ("%x, %x, %x\n", key[0], key[1], uppr);

	fclose (fz);
}

int main()
{
	int i,j;
	FILE *fp, *fz, *fk;

	fz = fopen("cps2.c", "rt");

	if (fz == NULL) {
		printf ("cps2.c not found\n");
		return 1;
	}

	fp = fopen("CPS2.dat", "wt");

	int nPrg = 0;
	char szLine[256];
	char tmp[256];

	while (1)
	{
		if (fgets(szLine, 256, fz) == NULL)
			break;

		int szLen = strlen (szLine);

		if (szLen < 3) continue;

		if (strncmp ("ROM_START( ", szLine, 11) == 0)
		{
			memcpy (tmp, szLine + 11, szLen - 3);
			tmp[szLen-14] = '\0';

			fprintf (fp, "begin %s\n", tmp);

			getcrypt(tmp);
			continue;
		}

		if (strncmp ("	ROM_REGION( CODE_SIZE, REGION_CPU1", szLine, strlen("	ROM_REGION( CODE_SIZE, REGION_CPU1")) == 0 ||
			strncmp ("	ROM_REGION(CODE_SIZE", szLine, strlen("	ROM_REGION(CODE_SIZE")) == 0)
		{
			nPrg = 1;
			continue;
		}

		if (nPrg)
		{
			if (strncmp("	ROM_REGION(", szLine, strlen("	ROM_REGION(")) == 0)
			{
				fprintf (fp, "decrypt\n%8.8x,%8.8x,%6.6x\nend\n\n", key[0], key[1], uppr);
				nPrg = 0;
				continue;
			}

			for (i = 0; i < szLen; i++)
			{
				if (strncmp(szLine + i, "( \"", 3) == 0)
				{
					memcpy (szLine, szLine + i+3, szLen - (i+3));
					szLine[szLen-(i+3)] = '\0';
					break;
				}
			}

			szLen = strlen(szLine);

			for (i = 0; i < szLen-5; i++)
			{
				if (strncmp (szLine + i, ") SHA1(", 7) == 0) {
					szLine[i] = '\0';
					break;
				}
			}

			szLen = strlen(szLine);

			for (i = 0; i < szLen; i++)
			{
				if (strncmp (szLine + i, "\"", 1) == 0)
				{
					memcpy (szLine + i, szLine + i+1, (szLen - (i+1)));
					szLen--;
				}
			}

			for (i = 0; i < szLen; i++)
			{
				if (szLine[i] == ' ' || szLine[i] == '\t')
				{
					memcpy (szLine + i, szLine + i + 1, (szLen - (i+1)));
					szLen--;
				}
			}

			for (i = 0; i < szLen; i++)
			{
				if (strncmp (szLine + i, "0x", 2) == 0)
				{
					memcpy (szLine + i, szLine + i+2, (szLen - (i+2)));
					szLen-=2;
				}
				if (strncmp (szLine + i, "CRC(", 4) == 0)
				{
					memcpy (szLine + i, szLine + i + 4, (szLen - (i+4)));
					szLen-=4;
				}
			}

			for (i = 0; i < szLen; i++)
			{
				if (strncmp (szLine + i, ", ", 2) == 0)
				{
					memcpy (szLine + i+1, szLine + i+2, (szLen - (i+2)));
					szLen--;
				}
			}

			for (i = 0, j = 0; i < szLen; i++)
			{
				if (strncmp (szLine + i, ",", 1) == 0)
				{
					if (j)
					{
						memcpy (szLine + j, szLine + i, (szLen - i));
						szLine[j + (szLen-i)] = '\0';
						szLen = strlen(szLine);
						i = szLen;
					}
					else
					{
						j = i;
					}
				}
			}

			szLine[szLen] = ',';
			szLine[szLen+1] = '\0';

			fprintf (fp, "%s\n", szLine);
			continue;
		}
	}

	fclose (fz);
	fclose (fp);
}
