// IQ_132 - http://neosource.1emu.net/
// Licensed under the wtfpl - http://sam.zoy.org/wtfpl/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

// Most info based on analysis of files, others based on this:
// http://www.techpathways.com/uploads/ExIF.pdf

#define CLUSTERSIZE	4096
#define MANUFACTURER	0xe1 // olympus

#define CLUSTERMASK	(CLUSTERSIZE-1) // don't change this

int main()
{
	FILE *fi = fopen("raw.bin", "rb");
	if (fi == NULL) {
		printf ("raw.bin not found.\n");
		return 1;
	}

	fseek (fi, 0, SEEK_END);
	int len = ftell (fi); // raw file size
	rewind (fi);

	unsigned char *src = (unsigned char*)malloc(len);
	if (src == NULL) {
		printf ("Failed to allocate enough ram.\n");
		return 1;
	}

	unsigned char *ptr = src;

	fread (src, len, 1, fi);
	fclose (fi);

	int counter = 0;
	char fname[128];

	while (1)
	{
		// This is this is the standard header
		if (ptr[0] == 0xFF && ptr[1] == 0xD8 && ptr[2] == 0xFF && ptr[3] == MANUFACTURER)
		{
			// Make sure files are aligned by cluster size
			if (((ptr-src) & CLUSTERMASK) == 0)
			{
				printf ("found %d\n", counter);

				unsigned char *ptr2 = ptr + 4;

				while (1)
				{
					ptr2++;

					// the image should stop at ffd9, but for some reason, olympus ignores spec...
					// so instead, we look for either the next image or we look for the end of the data
					if (ptr2[0] == 0xff && ptr2[1] == 0xd8 && ptr2[2] == 0xff && ptr2[3] == MANUFACTURER) {
						// also make sure it's aligned by cluster size
						if (((ptr2-src) & CLUSTERMASK) == 0) {
							break;
						}
					}

					if ((ptr2-src) >= len) break;
				}

				ptr2--;

				while (ptr2[0] == 0xff) {
					ptr2--;
				}

				int size = ptr2 - ptr;

				// file name is just a simple count, from 0 -> ~0
				sprintf (fname, "%4.4d.jpg", counter);
	
				FILE *fz = fopen(fname, "wb");
				fwrite (ptr, size, 1, fz);
				fclose (fz);

				counter++;
				ptr+=size;
			}
		}
		
		ptr++;
		if ((ptr-src) >= len) break;
	}

	free (src);

	return 0;
}
