
var store;		// Line storage
var input;		// Store everything

var pick_gen = "f";	// Driver type (default: fba)
var sma_pos = 5;	// SMA rom position (if present)

function find_other(form, type)
{
	for (i = 0; i < input.length; i++) {
		var tmp = input.slice(i, i+type.length);
		if (tmp.toUpperCase() == type.toUpperCase()) {
			for (j = 0; j < 100; j++) {
				if (input.slice(i+j+type.length, i+j+type.length+1) == "\n") {
					return input.slice(i+type.length, i+j+type.length);
				}
			}
		}
	}

	return "";
}

function gets_for_checkbox(form, value, where)
{
	form[where].checked = false;

	for (i = 0; i < input.length; i++) {
		if (input.slice(i, i+value.length) == value) {
			form[where].checked = true;
			return 1;
		}
	}

	return 0;
}


function mame_get_ms_size(type)
{
	for (i = 0; i < store.length; i++) {
		if (store.slice(i, i+ type.length) == type) {
			for (j = 0; j < 5; j++) {
				if (store.slice(i + type.length + j, i + type.length + j + 2) == "K(") {
					var size = store.slice(i + type.length, i + type.length + j);
					return eval(size) * 1024;
				}
			}
		}
	}

	return 0;
}

function clrmame_do(nfo, i)
{
	if (store.slice(i, i+nfo.length) == nfo)
	{
		for (j = 0; j < store.length; j++)
		{
			if (store.slice(i+j+nfo.length, i+j+nfo.length+1) == " ")
			{
				var rtrn = store.slice(i+nfo.length, i+j+nfo.length);
				return rtrn;
			}
		}
	}

	return 0;
}

function clrmamepro_get_roms(form, type)
{
	var clrp = new Array(0, 0, 0, 0);

	for (i = 0; i < store.length; i++) {
		if (store.slice(i, i+7) == " merge ") {
			form["merged" + type].value = 1;
		}
	}

	for (i = 0; i < store.length; i++)
	{
		if (clrp[0] == 0) {
			clrp[0] = clrmame_do(" name ", i);
			form[type + "name"].value = clrp[0];
			form["chxbx" + type].checked = true;
		}

		if (clrp[1] == 0) {
			clrp[1] = clrmame_do(" size ", i);
			form[type + "size"].value = clrp[1];
		}

		if (clrp[2] == 0) {
			clrp[2] = clrmame_do(" crc ", i);
			form[type + "crc"].value = clrp[2];
		}

		if (clrp[3] == 0) {
			clrp[3] = clrmame_do(" sha1 ", i);
			if ((clrp[3]) && (clrp[3].slice(0,2) == "0x"))
				clrp[3] = clrp[3].slice(2, clrp[3].length);
			form[type + "sha1"].value = clrp[3];
		}

		if (clrp[0] && clrp[1] && clrp[2]/* && clrp[3]*/) {
			return 1;
		}
	}

	return 0;
}

function romcenter_get_roms(form, type)
{
	var rc = new Array(0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
	var cntr = 0;

	for (i = 0; i < store.length; i++) {
		if (store.slice(i, i+1) == "")	{
			rc[cntr] = i;
			cntr++;
		}
	}

	if (rc[9] == 0) return 0; // fail

	form[type + "size"].value = store.slice(rc[6]+1, rc[7]);
	form[type + "crc"].value  = store.slice(rc[5]+1, rc[6]);
	form[type + "name"].value = store.slice(rc[4]+1, rc[5]);

	form.realname.value = store.slice(rc[3]+1, rc[4]);
	form.setname.value = store.slice(rc[2]+1, rc[3]);
	document.gen.ptitle.value = "";
	form.ptitle.value = store.slice(rc[1]+1, rc[2]); // parent title

	if (form.setname.value != store.slice(rc[0]+1, rc[1]))
	{
		form.parentname.value = store.slice(rc[0]+1, rc[1]);
		form.bdfclone.value = 1;
	}

	if (eval(rc[8]) != eval(rc[9])-1)
	{
		form["merged" + type].value = 1;
	}

	form["chxbx" + type].checked = true;

	return 1; // success
}

function find_line(form, type)
{
	store = ""; // clear out storage

	for (i = 0; i < input.length; i++)
	{
		var tmp = input.slice(i, i + type.length + 1);

		if (((type == "m1d")&&(input.slice(i, i+5) == "-m1_d"))||((tmp.toUpperCase() == ("-" + type.toUpperCase()))||(tmp.toUpperCase() == ("_" + type.toUpperCase()))))
		{
			var m1_fix = 0;
			var nl = new Array(0, 0);

			if (type == "m1") {
				for (j = 0; j < 4; j++) {
					if (input.slice(i + type.length + j, i + type.length + j + 1) == "d") {
						m1_fix = 1;
					}
				}
			}

			for (j = 0; j < 150; j++) {
				if ((nl[0] == 0) && (input.slice(i-j, i-j+1) == "\n")) nl[0] = i-j;
				if ((nl[1] == 0) && (input.slice(i+j, i+j+1) == "\n")) nl[1] = i+j;
			}

			tmp = input.slice(nl[0]+1, nl[1]);
			var tmp2 = tmp.replace(/ /gi, "");		// remove space
			    tmp2 = tmp2.replace(/	/gi, "");	// remove tab

			if ((tmp2.slice(0, 2) == "//") || (tmp2.slice(0, 2) == "/*") || (m1_fix == 1)) { // skip this line
				nl[0] = nl[1] = 0;
			}

			if ((nl[0]) && (nl[1])) {
				store = tmp;
				return 0;
			}
		}
	}

	return 1;
}

function get_rom(form, type)
{
	var c = new Array(0,0,0,0); // store comma locations
	var v1 = 0;

	var find_ln = find_line(form, type); // Find line

	if ((type == "pg1")||(type == "ep1")||(type == "ph1")||(type == "hp1")) type = "p1";
	if ((type == "pg2")||(type == "ep2")||(type == "ph2")) type = "p2";
	if (type == "ep3") type = "p3";
	if (type == "ep4") type = "p4";
	if ((type == "ep5")||(type == "sma")) type = "p" + sma_pos;
	if (type == "sg1") type = "s1";		// pspikes2
	if (type == "mg1") type = "m1d";	// pspikes2

	if ((form.chxbxm1d.checked == false)&&(type == "m1")) { // m1/m1d
		type = "m1d";
	}

	if (type.slice(0,1) == "v") {				// Vx Fix
		for (var i = 1; i < 7; i++) {
			if (form["chxbxv" + i].checked == false) {
				type = "v" + i;
				i = 7;
			}
			if ((i==6) && (type.slice(1, type.length) > 6)) return;
		}
	}

	// decide where to store things
	var name = type + "name";
	var offset = type + "ofst";
	var size = type + "size";
	var crc = type + "crc";
	var checkbox = "chxbx" + type;
	
	form["merged" + type].value = 0;
	form[checkbox].checked = false;

	if (find_ln) return 0;

	if (pick_gen == "c") {
		clrmamepro_get_roms(form, type);
		return 1;
	}

	if (pick_gen == "r") {
		romcenter_get_roms(form, type);
		return 1;
	}

	// Find the commas in the line
	for (i = 0; i < store.length; i++) {
		if ((store.slice(i, i+1) == ",") && (v1 < 4)) {
			c[v1] = i;
			v1++;
		}
	}

	if (pick_gen == "n")
	{
		form[name].value = store.slice(0, c[0]);		// Get Name
		var tmp = store.slice(c[1]+1, c[2]);			// Get size
		form[size].value = parseInt(tmp, 16);			// Convert from hex and store

		tmp = store.slice(c[2]+1, c[3]);			// Get CRC
		if (tmp == "0") tmp = "";				// If CRC is 0 (dummy) return no value
		form[crc].value = tmp;					// Send CRC to form

		tmp = store.slice(store.length-3, store.length-1);	// get swap
		if ((type == "p1")&&(tmp == ",1")) {			// swap p1
			if (!form.swapp.checked)
				form.swapp.checked = !form.swapp.checked;
		}
		if ((type.slice(0,1) == "c") && (tmp == ",2")) {	// swap C
			if (!form.swapc.checked)
				form.swapc.checked = !form.swapc.checked;
		}
	}

	if (pick_gen == "f")
	{
		var tmp = store.slice(0, c[0]);			// Get Name
		tmp = tmp.replace(/\t/gi, "");			// Replace tab
		tmp = tmp.replace(/"/gi, "");			// Replace Quotes
		tmp = tmp.replace(/ /gi, "");			// Replace spaces
		tmp = tmp.replace(/{/gi, "");			// Replace bracket
		form[name].value = tmp;				// Send Name to form
	
		tmp = store.slice(c[0]+1, c[1]);		// Get Size
		form[size].value = parseInt(tmp, 16);		// Convert from hex and send size to form
	
		tmp = store.slice(c[1]+1, c[2]);		// Get CRC
		tmp = tmp.replace(/0x/gi, "");			// Replace 0x
		tmp = tmp.replace(/ /gi, "");			// Replace Spaces
		if (tmp == "0") tmp = "";			// If CRC is 0 (dummy) return no value
		form[crc].value = tmp;				// Send crc to form
	}

	if (pick_gen == "m")
	{
		var tmp = store.slice(0, c[0]);			// Get Name
		tmp = tmp.replace(/ /gi, "");			// Replace spaces

		for (j=0; j < 20; j++) { 			// Trim length (end at quotes)
			if (store.slice(tmp.length-j-2, tmp.length-j-1) == "\"") {
				tmp = tmp.slice(tmp.length-j-2, tmp.length-1);
			}
		}

		tmp = tmp.replace(/\"/gi, "");			// Replace Quotes
		form[name].value = tmp;				// Send Name to form
		tmp = store.slice(c[1]+1, c[2]);		// Get size
		form[size].value = parseInt(tmp, 16);		// Convert size to decimal, and send to form

		var f_stop = 0;
		tmp = store.slice(c[2]+1, store.length);	// Get last section
		for (j=0; j < tmp.length-f_stop; j++)		// Clean it up
		{
			if (tmp.slice(j, j+4) == "CRC(")	// Find "CRC("
			{
				var crc32 = tmp.slice(j+4, j+12);	// Trim
				form[crc].value = crc32.replace(/\)/gi, "");	// Remove slashes and send to form
			}

			if (tmp.slice(j, j+5) == "SHA1(")	// Find "SHA1("
			{
				var sha = tmp.slice(j+5, j+45);
				form[type + "sha1"].value = sha.replace(/\)/gi, "");
				if (f_stop == 0) f_stop = tmp.length-j+1;		// Make it stop (speedup!)
			}
		}

		// older mame versions
		if ((form[crc].value == "")&&(form[type + "sha1"].value == ""))
		{
			var fstop = 0;
			tmp = store.slice(c[2]+1, store.length);		// Get last section
			for (j = 0; j < tmp.length-fstop; j++) {
				if (tmp.slice(j, j+2) == "0x") {
					fstop = tmp.length-j+1;
					var crc32 = tmp.slice(j+2, j+10);
					form[crc].value = crc32.replace(/ /gi, "");
				}
			}
		}
		if (type == "s1") { // Special handling for S1
			var ssiz = mame_get_ms_size("NEO_SFIX_");
			if (ssiz) form.s1size.value = ssiz;
		}

		if ((type == "m1")||(type == "m1d")) { // Special handling for M1 / m1d
			var msiz = mame_get_ms_size("NEO_BIOS_SOUND_");
			if (msiz) form[type + "size"].value = msiz;
		}	
	}

	if (form[name].value) form[checkbox].checked = true;

	return 1;
}

function nebula_extras(form)
{
	// Ignore system (it may be necessary in the future to find this...)

	form.setname.value = find_other(form, "RomName: ");	// Find the romset name
	form.realname.value = find_other(form, "Game: ");	// Find the game title
		form.parentname.value = find_other(form, "Parent: ");	// Find the parent rom
	if (form.parentname.value != "")
	{
		form.bdfclone.value = 1;
		form.parentname.disabled = false;
	} else {
		form.parentname.disabled = true;
	}

	form.cartidn.value = find_other(form, "CartridgeID: "); // Find the Cartridge ID #
	if (form.cartidn.value == "0") form.cartidn.value = "";

	var gfxcrypt = find_other(form, "GfxCrypt: ");		// Find the encryption type (kof2000 or kof99)
	form.criptsel.value = gfxcrypt.slice(0,1);

	form.GfxKey.value = find_other(form, "GfxKey: ");	// Find the decryption key (xor)
	if (form.GfxKey.value.length == 1) form.GfxKey.value = "0" + form.GfxKey.value;
	if ((form.GfxKey.value == "00") && (gfxcrypt=="0")) form.GfxKey.value = "";

	var butlayout = find_other(form, "ButLayout: ");	// Find the ButLayout (usually 9. 7 & 8 for gambling games)
	butlayout = butlayout.slice(0,1);
	if ((butlayout == 8)||(butlayout == 7))
	{
		form.gambling.checked = true;
	}
	
	form.nebfixn.value = find_other(form, "Fix: ");		// Find the "Fix" value
	if (form.nebfixn.value == "0") form.nebfixn.value = "";

	var PCM2 = find_other(form, "PCM2: ");			// Get PCM2 info
	if (PCM2 < 3) form.pcm2.value = "0" + PCM2;
	else if (PCM2 > 2) form.pcm2.value = eval(eval(PCM2) + 8);
}

function fba_extras(form)
{
	var tmp = input;
	var store_parent = "";
	form.criptsel.value = 0;
	form.GfxKey.value = "";

	for (i = 0; i < input.length; i++)
	{
		var large_char_set = "nNeoTextROMSize = 0x080000;"
		if (input.slice(i, i+large_char_set) == large_char_set) {
			if (form.chxbxs1.checked == "") {
				form.textromfix.checked = true;
			}
		}

		var PCM2 = "PCM2DecryptVInfo Info";					// pcm2 V2
		if (input.slice(i, i+PCM2.length) == PCM2) {
			for (j = 0; j < 15; j++) {
				if (input.slice(i+PCM2.length+j, i+PCM2.length+j+1) == ",") {
					var pcm2v = input.slice(i+PCM2.length+j-11, i+PCM2.length+j)
					pcm2v = pcm2v.replace(/ /gi, "");
					pcm2v = pcm2v.replace(/{/gi, ""); 
					if (pcm2v == "0x0A5000") form.pcm2.value = 11;
					if (pcm2v == "0x001000") form.pcm2.value = 12;
					if (pcm2v == "0x04E001") form.pcm2.value = 13;
					if (pcm2v == "0x0C2000") form.pcm2.value = 14;
					if (pcm2v == "0x00A000") form.pcm2.value = 15;
					if (pcm2v == "0x0A7001") form.pcm2.value = 16;
					if (pcm2v == "0x002000") form.pcm2.value = 17;
				}
			}
		}

		var PCM21 = "unsigned short buffer[";					// pcm2 v1
		if (input.slice(i, i+PCM21.length) == PCM21)
		{
			var pcm2v = input.slice(i+PCM21.length, i+PCM21.length+2)
			pcm2v = pcm2v.replace(/ /gi, "");
			if (pcm2v == "8")form.pcm2.value = "01";
			if (pcm2v == "16")form.pcm2.value = "02";
			if (pcm2v == "4")form.pcm2.value = "03";
		}

		var Xor = "nNeoProtectionXor";						// Get the Xor key
		if (input.slice(i, i+Xor.length) == Xor) {
			for (j = 0; j < 100; j++) {
				if (input.slice(i+j+Xor.length, i+j+Xor.length+1) == "\n") {
					var gfxkey = input.slice(i+Xor.length, i+j+Xor.length);
					gfxkey = gfxkey.replace(/ /gi, "");
					gfxkey = gfxkey.replace(/=/gi, "");
					gfxkey = gfxkey.replace(/;/gi, "");
					form.GfxKey.value = gfxkey.replace(/0x/gi, "");
					j = 101;
				}
			}
		}

		var getname = "BurnRomInfo ";						// get the Set name
		if (tmp.slice(i, i+getname.length) == getname) {
			for (j = 0; j < 40; j++) {
				if (tmp.slice(i+j+getname.length, i+j+getname.length+7) == "RomDesc") {
					form.setname.value = tmp.slice(i+getname.length, i+j+getname.length);
					j = 41;
				}
			}
		}

		var textsize = "nNeoTextROMSize";					// Get the S size
		if (tmp.slice(i, i+textsize.length) == textsize) {
			for (j = 0; j < 10; j++) {
				if (input.slice(i+j+textsize.length, i+j+textsize.length+1) == "8") {
					form.textromfix.checked = true;
					j = 11;
				}
			}
		}

		var input_chk = "InputInfo";						// Get the controller type
		if (tmp.slice(i, i+input_chk.length) == input_chk) {
			for (j = 0; j <15; j++) {
				if (input.slice(i-j, i-j+1) == " ") {
					form.controls.value = input.slice(i-j+1, i);
					j = 16;
				}
			}
		}

		var get_parent = "\"neogeo\"";						// Get parent rom name
		if (tmp.slice(i, i+get_parent.length) == get_parent) {
			var c1 = new Array(0, 0, 0);
			for (j = 0; j < 20; j++) {
				if ((input.slice(i-j, i-j+1) == ",") && (c1[2] < 2)) {
					c1[c1[2]] = i-j+c1[2];
					c1[2]++;
				}
			}
			store_parent = input.slice(c1[1], c1[0]).replace(/ /gi, "").replace(/\"/gi, "");
		}

		
		var clone = "BDF_CLONE";						// Get BDF_CLONE flag
		if (tmp.slice(i, i+clone.length) == clone) {
			if ((store_parent != "")&&(store_parent != "NULL")) {
				form.parentname.value = store_parent;
				form.bdfclone.value = 1;
			}
		}

		if ((tmp.slice(i+0, i+1) == "\"")&&(tmp.slice(i+5, i+6) == "\"")) {	// Get release date
			var tmp_date = tmp.slice(i+1, i+5);
			if ((tmp_date > 1989) && (tmp_date < 2010)) {
				form.yearname.value = tmp_date;
			}
		}

		var jtitle = "\tL\"";							// get japanese title
		if (tmp.slice(i, i+jtitle.length) == jtitle) {
			for (j = 0; j < 100; j++) {
				var jtitle2 = "0\",";
				if (tmp.slice(i+j, i+j+jtitle2.length) == jtitle2) {
					form.non_latin_text.value = input.slice(i+jtitle.length, i+j-1);
				}
			}
		}

		var ngdvnt = "\"NEO GEO\"";						// get notes, title, and dev.
		if (input.slice(i, i+ngdvnt.length).toUpperCase() == ngdvnt) {
			var c0 = new Array(0, 0, 0, 0, 0);
			for (j = 0; j < 150; j++) {
				if (input.slice(i-j, i-j+1) == ",") {
					c0[c0[4]] = i-j;
					c0[4]++;
				}
			}

			var title = input.slice(c0[3]+3, c0[2]-3).replace(/\"/gi, "");
			form.realname.value = title.replace(/\t/gi, "");

			var note = input.slice(c0[2]+2, c0[1]).replace(/\"/gi, "");
			if (note.slice(0, 4) == "NULL") note = l_noneop;
			form.notesname.value = note;

			var deval = input.slice(c0[1]+2, c0[0]).replace(/\"/gi, "");
			if (deval.slice(0,4) == "NULL") deval = l_noneop;
			form.devname.value = deval;
		}
	}

	var crypt = find_other(form, " | HARDWARE_SNK_ENCRYPTED_");	  // GFX Crypt
	crypt = parseInt(crypt.slice(0,1),16)-9;
	if (crypt) form.criptsel.value = crypt;

	gets_for_checkbox(form, "BDF_GAME_WORKING", "works");		  // Check for working flag
	gets_for_checkbox(form, "BDF_PROTOTYPE", "proto");		  // Check for prototype flag
	gets_for_checkbox(form, "BDF_BOOTLEG", "bootleg");		  // check for bootleg flag
	gets_for_checkbox(form, "HARDWARE_SNK_GAMBLING", "gambling");	  // Check for gambling flag
	gets_for_checkbox(form, "HARDWARE_SNK_SRAM", "sram");		  // Check for SRAM flag
	gets_for_checkbox(form, "HARDWARE_SNK_SWAPC", "swapc");		  // Check for SWAPC flag
	gets_for_checkbox(form, "HARDWARE_SNK_SWAPP", "swapp");		  // Check for SWAPP flag
	gets_for_checkbox(form, "HARDWARE_SNK_ALTERNATE_TEXT", "alttxt"); // Check for Alternate Text flag
}

function mame_extras(form)
{
	for (i = 0; i < input.length; i++)
	{
		// 512K s1
		var large_char_set = "ROM_REGION( 0x80000, REGION_GFX1, 0 )";
		if (input.slice(i, i+large_char_set.length) == large_char_set) {
			if (form.chxbxs1.checked == "") {
				form.textromfix.checked = true;
			}
		}

		// ROM Swaps
		var swap = "ROM_CONTINUE(";
		if (input.slice(i, i+swap.length) == swap) {
			var p_swap = "0x000000, 0x100000";
			var c_swap1= "0x400000, 0x100000";
			var c_swap2= "0x600000, 0x100000";
			for (j = 0; j < 40; j++) {
				if (input.slice(i+j, i+j+p_swap.length) == p_swap) {
					if (!form.swapp.checked) form.swapp.checked = !form.swapp.checked;
					j = 41;
				}
				if (input.slice(i+j, i+j+c_swap1.length) == c_swap1) {
					if (!form.swapc.checked) form.swapc.checked = !form.swapc.checked;
					j = 41;
				}
				if (input.slice(i+j, i+j+c_swap2.length) == c_swap2) {
					if (!form.swapc.checked) form.swapc.checked = !form.swapc.checked;
					j = 41;
				}
			}
		}

		// pcm2 V2
		var PCM2 = "neo_pcm2_swap(";
		if (input.slice(i, i+PCM2.length) == PCM2)
		{
			var pcm2v = input.slice(i+PCM2.length, i+PCM2.length+1)
			pcm2v = pcm2v.replace(/ /gi, "");
			form.pcm2.value = eval(pcm2v) + 11;
		}

		// pcm2 V1
		var PCM21 = "neo_pcm2_snk_1999(";
		if (input.slice(i, i+PCM21.length) == PCM21)
		{
			var pcm2v = input.slice(i+PCM21.length, i+PCM21.length+2)
			pcm2v = pcm2v.replace(/ /gi, "");
			pcm2v = pcm2v.replace(/\)/gi, "");
			alert(pcm2v);
			if (pcm2v == 8)form.pcm2.value = "01";
			if (pcm2v == 16)form.pcm2.value = "02";
			if (pcm2v == 4)form.pcm2.value = "03";
		}

		var rmstart = "ROM_START( ";
		if (input.slice(i, i+rmstart.length) == rmstart)
		{
			c1 = 0;
			for (j = 0; j < 25; j++)
			{
				if ((c1 == 0) && (input.slice(i+j+rmstart.length, i+j+rmstart.length+1) == ")"))
				{
					c1 = 1;
					var tmp = input.slice(i+rmstart.length, i+j+rmstart.length);
					tmp = tmp.replace(/ /gi, "");
					form.setname.value = tmp;
				}
			}
		}

		var game = "GAME ( ";
		var gameb= "GAMEB( ";
		if ((input.slice(i, i+game.length) == game)||(input.slice(i, i+gameb.length) == gameb))
		{
			var g1 = 0; var g3 = 0;
			var g0 = new Array (0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

			for (j = 0; j < 400; j++)
			{
				if (input.slice(i+game.length+j, i+game.length+j+1) == ",")
				{
					g0[g1] = i+game.length+j;
					g1++;
				}
				if (input.slice(i+game.length+j, i+game.length+j+1) == "\n")
				{
					j = 401;
				}
			}
			form.yearname.value = eval( input.slice(i+game.length, g0[0]) );

			// input.slice(g0[0], g0[1]) // set name again;

			var parent = input.slice(g0[1]+1, g0[2]).toLowerCase();
			parent=parent.replace(/ /gi, "");
			if ((parent != "neogeo") && (parent != "0")) {
				form.bdfclone.value = 1;
				form.parentname.value = parent;
			}
			if (parent == "0") g3 = 1; // no g[3]

			var ginput = input.slice(g0[4-g3]+1, g0[5-g3]).toLowerCase();
			if (ginput == "irrmaze")  form.controls.value = "neotrackball";
			if (ginput == "mjneogeo") form.controls.value = "neomahjong";
			// also kog, neogeo (default)

			var devl = input.slice(g0[7-g3]+1, g0[8-g3]);
			for (j = 0; j < 4; j++) {
				if (devl.slice(j, j+1) == " ")
					devl = devl.slice(j+1, devl.length);
				else
					j = 5;
			}
			form.devname.value = devl.replace(/\"/gi, "");

			var gname = input.slice(g0[8-g3]+1, g0[9-g3]);
			for (j = 0; j < 4; j++) {
				if (gname.slice(j, j+1) == " ")
					gname = gname.slice(j+1, gname.length);
				else
					j = 5;
			}
			form.realname.value = gname.replace(/\"/gi, "");
		}

		var m_crypt = "_neogeo_gfx_decrypt("
		if (input.slice(i, i+m_crypt.length) == m_crypt)
		{
			if (input.slice(i-1, i) == "9") form.criptsel.value = 1;
			if (input.slice(i-1, i) == "2") form.criptsel.value = 1;
			if (input.slice(i-1, i) == "0") form.criptsel.value = 2;

			var m_key = input.slice(i+m_crypt.length, i+m_crypt.length+6);
			m_key = m_key.replace(/ /gi, "");
			m_key = m_key.replace(/\)/gi, "");
			m_key = m_key.replace(/;/gi, "");
			form.GfxKey.value = m_key.replace(/0x/gi, "");
		}

		var m_alt_text = "neogeo_fix_bank_type";
		if (input.slice(i, i+m_alt_text.length) == m_alt_text) {
			for (k = 0; k < 6; k++) {
				if (input.slice(i+k+m_alt_text.length, i+k+m_alt_text.length+1) == ";") {
					if (input.slice(i+k+m_alt_text.length-1, i+k+m_alt_text.length) == "2") {
						form.alttxt.checked = true;
					}
				}
			}
		}
	}
}

function clrmxtra(input, x, a)
{
	for (i = x; i < x+a; i++)
		if (input.slice(i, i+1) == "\n")
			return input.slice(x, i);
}

function clrmamepro_extras(form)
{
	var name = 0;
	var found = new Array(0, 0, 0, 0, 0);
	for (i = 0; i < input.length; i++)
	{
		if ((input.slice(i, i+13) == "description \"") && (found[0] == 0)) {
			var tmp = clrmxtra(input, i+13, 100);
			form.realname.value = tmp.slice(0, tmp.length-1);
			found[0]=1;
		}

		if ((input.slice(i, i+13) == "manufacturer ") && (found[1] == 0)) {
			var tmp = clrmxtra(input, i+13, 50);
			form.devname.value = tmp.slice(1, tmp.length-1);
			found[1]=1;
		}

		if ((input.slice(i, i+5) == "year ") && (found[2] == 0)) {
			form.yearname.value = clrmxtra(input, i+5, 20);
			found[2]=1;
		}

		if ((input.slice(i, i+5) == "name ")&&(name != 1)&&(found[3]==0)) {
			form.setname.value = clrmxtra(input, i+5, 20);
			name++;
			found[3]=1;
		}

		if ((input.slice(i, i+8) == "cloneof ") && (found[4] == 0)) {
			clone = clrmxtra(input, i+8, 20);
			form.parentname.value = clone.replace(/ /gi, "");
			form.bdfclone.value = 1;
			found[4]=1;
		}
	}
}

function get_driver_type(form)
{
	var rc = 0;

	for (i = 0; i < input.length; i++)
	{
		// Check for nebula stuff
		var neb_prg = "[Program]";
		var neb_sys = "[System]";
		if (input.slice(i, i+neb_prg.length) == neb_prg) pick_gen = "n";
		if (input.slice(i, i+neb_sys.length) == neb_sys) pick_gen = "n";

		// Check for FBA stuff
		var struct = "static struct BurnRomInfo";
		var tmp = input.slice(i, i+struct.length);
		if (tmp.toUpperCase() == struct.toUpperCase()) pick_gen = "f";

		// check for newer fba versions:
		var brf = "| BRF_";
		if (input.slice(i, i+brf.length) == brf) pick_gen = "f";

		// Check for MAME
		var rmlod = "ROM_LOAD";
		var rmrgn = "ROM_REGION";
		if (input.slice(i, i+rmlod.length) == rmlod) pick_gen = "m";
		if (input.slice(i, i+rmrgn.length) == rmrgn) pick_gen = "m";

		// Check for ClrMAMEPro
		var clrm1 = "rom ( name ";
		var clrm2 = "description \"";
		if (input.slice(i, i+clrm1.length) == clrm1) pick_gen = "c";
		if (input.slice(i, i+clrm2.length) == clrm2) pick_gen = "c";

		// Check for romcenter
		if (input.slice(i, i+1) == "") {
			rc++;
			if (rc > 3) {
				pick_gen = "r";
			}
		}
	}
}

function parse_text(form)
{
	if (form.fbagen.value.length == 0)
	{
		alert (l_nothn2);
		return 1;						// Quit if length of input is 0
	}
	input = form.fbagen.value					// Store the input
	form.reset();							// Reset the whole form (Clear all values!)
	form.fbagen.value = input;					// Put the input back where it came from
	input = "\n\n" + input + "\n\n";				// Add some lines to the top and buttom

	get_driver_type(form);						// Find type of driver being parsed.

	get_rom(form, "p1");						// Find P1 rom info
	if (form.chxbxp1.checked == false) get_rom(form, "pg1");	// Find pg1 (p1) rom
	if (form.chxbxp1.checked == false) get_rom(form, "ph1");	// Find ph1 (p1) rom
	if (form.chxbxp1.checked == false) get_rom(form, "ep1");	// Find ep1 (p1) rom
	if (form.chxbxp1.checked == false) get_rom(form, "hp1");	// Find hp1 (p1) rom (kotmh)
	if (form.chxbxp1.checked == false) checkboxlabel("chxbxp1");	// if P1 isn't found, check it anyway

	get_rom(form, "p2");						// Find P2 rom info
	if (form.chxbxp2.checked == false) get_rom(form, "pg2");	// Find pg2 (p2) rom
	if (form.chxbxp2.checked == false) get_rom(form, "ph2");	// Find ph2 (p2) rom
	if (form.chxbxp2.checked == false) get_rom(form, "ep2");	// Find ep2 (p2) rom

	for (n = 3; n < 6; n++) {
		get_rom(form, "p" + n);					// Find Px rom info (2 < x < 6)
		if (form["chxbxp" + n].checked == false)
			get_rom(form, "ep" + n);			// Find epx rom info (2 < x < 6)
		if (form["chxbxp" + n].checked == false){
			sma_pos = n;
			get_rom(form, "sma");				// Find SMA rom info
			n = 7;
		}
	}

	for (n = 1; n < 9; n++) // Find Cx rom info
		get_rom(form, ("c" + n));

	get_rom(form, "s1");						// Find S1 rom info
	if (form.chxbxs1.checked == false) get_rom(form, "sg1");	// Find sg1 (s1) rom (pspikes2)

	get_rom(form, "m1d");						// Find M1d rom info
	get_rom(form, "m1");						// Find M1 rom info
	if (form.chxbxm1d.checked == false) get_rom(form, "mg1");	// Find mg1 (m1) rom (pspikes2)
	if (form.chxbxm1d.checked == false) checkboxlabel("chxbxm1d");	// if m1d isn't found, check it anyway

	for (i = 1; i < 7; i++)						// clear checks for the vx
		form["chxbxv" + i].checked = false;

	var vtypeab = 0;
	for (i = 0; i < input.length; i++) {				// Check for Vxx roms
		var tmp = input.slice(i, i+4);
		if ((tmp.toLowerCase() == ("-v11")) || (tmp.toLowerCase() == ("_v11"))) {
			vtypeab = 1;
		}
	}

	if (vtypeab != 1) {						// Find vX roms
		for (n = 1; n < 7; n++)
			get_rom(form, ("v" + n));
	} else {							// Find vXX roms
		for (n = 1; n < 7; n++)
			get_rom(form, ("v1" + n));

		for (n = 1; n < 7; n++)
			get_rom(form, ("v2" + n));
	}
									// Get extras for driver types
	if (pick_gen == "f") fba_extras(form);
	if (pick_gen == "n") nebula_extras(form);
	if (pick_gen == "m") mame_extras(form);
	if (pick_gen == "c") clrmamepro_extras(form);

	disableonreload();						// Disable/Enable roms

	store = "";
	input = "";
	sma_pos = 5;

	form.parsed.value = 1;
}
