// PAC archive file extraction tool (specifically for use with BlazBlue archives)
// IQ_132 - http://neosource.1emu.net
// License - http://creativecommons.org/licenses/by-nc/3.0/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define get_long(d, x) ((d[x+0] << 0) | (d[x+1] << 8) | (d[x+2] << 16) | (d[x+3] << 24))

int main(int argc, char *argv[])
{
	char fname[128];

	if (argc > 1) {
		memcpy (fname, argv[1], strlen(argv[1]));
	} else {
		printf ("Please type the name of the PAC file you wish to process\n");
		gets (fname);
	}

	FILE *fz = fopen(fname, "rb");
	if (fz == NULL) {
		printf ("%s not found\n", fname);
		return 1;
	}

	fname[strlen(fname)-4] = '\0'; // trim off extension

	unsigned int table_entries;
	unsigned int file_size;
	unsigned int header_size;
	unsigned int file_name_size;

	// get the configuration table and process it
	{
		unsigned char tmp[32];
		fread (tmp, 32, 1, fz);

		// First four bytes always spell out "FPAC"
		if (tmp[0] != 'F' || tmp[1] != 'P' || tmp[2] != 'A' || tmp[3] != 'C') {
			printf ("%s not a proper pac file?\n", fname);
			return;
		}

		header_size	= get_long(tmp, 0x04); // size of this config table and the file name/path/size table
		file_size	= get_long(tmp, 0x08); // size of the entire archive
		table_entries	= get_long(tmp, 0x0c); // number of files in the archive
		//		= get_long(tmp, 0x10); // seems to always be 01000000 (00000001)
		file_name_size	= get_long(tmp, 0x14); // size of the namespace of each file in the archive
					//	0x18-0x1f empty
	}

	// create an output directory based on the archive's name
	{
		char createdir[64];

		sprintf (createdir, "mkdir %s", fname);
		system (createdir);
	}

	// process the file info table and dump the files
	{
		char filename[64], fullname[256];
		unsigned int offset;
		unsigned int size;
		unsigned int file_number;

		int header_block_size = file_name_size + 0x0c;
		if (header_block_size & 0x0f) header_block_size = (header_block_size | 0x0f) + 1; // File info blocks are aligned to 0x10 (16) bytes

		unsigned char *table = (unsigned char*)malloc(header_size - 32);
		fread (table, header_size - 32, 1, fz);

		int i = 0;
		unsigned char *ptr = table;
		while(i < table_entries)
		{
			memset (filename, 0,   64);
			memcpy (filename, ptr, file_name_size);			// copy the filename

			file_number	= get_long(ptr, file_name_size + 0x00);	// get the file number
			offset		= get_long(ptr, file_name_size + 0x04); // get the offset in the archive of the file (does not include header size)
			file_size	= get_long(ptr, file_name_size + 0x08); // get the file's size

			sprintf (fullname, "%s\\%s", fname, filename);
	
			FILE *fo = fopen(fullname, "wb");

			unsigned char *out = (unsigned char*)malloc(file_size);

			fseek (fz, offset + header_size, SEEK_SET);
			fread (out, file_size, 1, fz);

			fwrite (out, file_size, 1, fo);
			fclose (fo);

			free (out);

			ptr += header_block_size;
			i++;
		}

		free (table);
	}

	fclose (fz);
}
