
#include <stdio.h>

#define BITSWAP8(n, 														\
		bit07, bit06, bit05, bit04, bit03, bit02, bit01, bit00)	\
		(((((n) >> (bit07)) & 1) <<  7) | 			\
		 ((((n) >> (bit06)) & 1) <<  6) | 			\
		 ((((n) >> (bit05)) & 1) <<  5) | 			\
		 ((((n) >> (bit04)) & 1) <<  4) | 			\
		 ((((n) >> (bit03)) & 1) <<  3) | 			\
		 ((((n) >> (bit02)) & 1) <<  2) | 			\
		 ((((n) >> (bit01)) & 1) <<  1) | 			\
		 ((((n) >> (bit00)) & 1) <<  0))

static void decrypt(unsigned char *src)
{
	const unsigned char xor2[ 0x20 ] = {
		0xb4, 0x0f, 0x40, 0x6c, 0x38, 0x07, 0xd0, 0x3f, 0x53, 0x08, 0x80, 0xaa, 0xbe, 0x07, 0xc0, 0xfa,
		0xd0, 0x08, 0x10, 0xd2, 0xf1, 0x03, 0x70, 0x7e, 0x87, 0x0b, 0x40, 0xf6, 0x2a, 0x0a, 0xe0, 0xf9
	};

	int i, ofst;
	unsigned char* dst = (unsigned char*)malloc(0x800000);

	for (i = 0x100000; i < 0x800000; i++)
		src[ i ] ^= xor2[ (i % 0x20) ];

	for (i = 0x100000; i < 0x800000; i += 4) {
		unsigned short *rom16 = (unsigned short*)&src[i + 1];
		*rom16 = (BITSWAP8((*rom16&0xFF0)>>4, 0,1,2,3,4,5,6,7)<<4)|(*rom16&0xF00F);
	}

	memcpy(dst, src, 0x800000);

	for (i = 0; i < 0x10; i++) {
		ofst = (i & 0xf0) + BITSWAP8((i & 0x0f), 7, 6, 5, 4, 1, 0, 3, 2);
		memcpy(&src[i * 0x10000], &dst[ofst * 0x10000], 0x10000);
	}

	for (i = 0x100000; i < 0x800000; i += 0x100) {
		ofst = (i & 0xf000ff) + ((i & 0x000f00) ^ 0x00300)
			+ (BITSWAP8(((i & 0x0ff000) >> 12), 4, 5, 6, 7, 1, 0, 3, 2) << 12);
		memcpy(&src[i], &dst[ofst], 0x100);
	}

	free(dst);
}

static void encrypt(unsigned char *src)
{
	int i, ofst;

	unsigned char xor1[0x20] = {
		0x3B, 0x6A, 0xF7, 0xB7, 0xE8, 0xA9, 0x20, 0x99, 0x9F, 0x39, 0x34, 0x0C, 0xC3, 0x9A, 0xA5, 0xC8,
		0xB8, 0x18, 0xCE, 0x56, 0x94, 0x44, 0xE3, 0x7A, 0xF7, 0xDD, 0x42, 0xF0, 0x18, 0x60, 0x92, 0x9F,
	};

	unsigned char xor2[0x20] = {
		0x2F, 0x02, 0x60, 0xBB, 0x77, 0x01, 0x30, 0x08, 0xD8, 0x01, 0xA0, 0xDF, 0x37, 0x0A, 0xF0, 0x65,
		0x28, 0x03, 0xD0, 0x23, 0xD3, 0x03, 0x70, 0x42, 0xBB, 0x06, 0xF0, 0x28, 0xBA, 0x0F, 0xF0, 0x7A
	};

	unsigned char *dst = (unsigned char*)malloc(0x800000);

	// copy everything to dst
	memcpy (dst, src, 0x800000);

	for( i = 0; i < 0x10; i++ ){
		ofst = (i & 0xf0) + BITSWAP8( (i & 0x0f), 4, 5, 6, 7, 0, 1, 2, 3);
		memcpy( src + i * 0x10000, dst + ofst * 0x10000, 0x10000 );
	}

	for( i = 0; i < 0x100000; i++ )
		src[ i ] ^= xor1[ (i % 0x20) ];

	for( i = 0x100000; i < 0x800000; i += 0x100 ){
		ofst = (i & 0xf000ff) + ((i & 0x000f00) ^ 0x00800) +
			(BITSWAP8( ((i & 0x0ff000) >> 12), 4, 5, 6, 7, 1, 0, 3, 2) << 12);
		memcpy( src + ofst, dst + i, 0x100 );
	}

	for( i = 0x100000; i < 0x800000; i += 4 ){
		unsigned short *rom16 = (unsigned short*)&src[ i + 1 ];
		*rom16 = (BITSWAP8((*rom16&0xFF0)>>4, 1,0,3,2,5,4,7,6)<<4)|(*rom16&0xF00F);
	}

	for( i = 0x100000; i < 0x800000; i++ )
		src[ i ] ^= xor2[ (i % 0x20) ];

	free (dst);
}

static void patch(unsigned char *src)
{
	int i;
	unsigned char patch_2[0x12] = {
		0x59, 0xF8, 0x2D, 0x0C, 0x00, 0x00, 0x59, 0xF8, 0x00, 0x66, 0x08, 0x00, 0x7C, 0x1B, 0x02, 0x00, 
		0x59, 0xF8
	};

	*((unsigned short*)(src + 0x00C0)) = 0x4638;
	*((unsigned short*)(src + 0x00C2)) = 0x5F50;
	*((unsigned short*)(src + 0x0408)) = 0x4465;
	*((unsigned short*)(src + 0x040A)) = 0x6320;
	*((unsigned short*)(src + 0x040C)) = 0x3031;
	*((unsigned short*)(src + 0x0412)) = 0x3133;
	*((unsigned short*)(src + 0x0414)) = 0x3A34;
	*((unsigned short*)(src + 0x0416)) = 0x3820;

	memcpy (src + 0x1C6, src + 0x1B6, 0xE8);

	for (i = 0; i < 0x12; i++)
		src[0x1B4 + i] = patch_2[i];

	for (i = 0; i < 0x100000; i+=2) // modify P data to use Zoom code in program
	{
		if (((src[i + 0] == 0xB9) || (src[i + 0] == 0xF9)) && ((src[i + 1]&0xf0) == 0x40) && (src[i + 2] == 0xC2))
		{
			src[i + 2] = 0x0F;
			src[i + 5] += 0x80;
		}

		if ((i > 0xF95B0) && (i < 0xF9720))
		{
			if ((src[i + 0] == 0xC2) && (src[i + 1] == 0x00))
			{
				src[i + 0] = 0x0F;
				src[i + 3] += 0x80;
			}
		}

		if ((src[i + 0] == 0xC1) && (src[i + 2] == 0x80) && (src[i + 3] == 0xFF)) // more bios code stuff
		{
			src[i + 0] = 0x0F;
			src[i + 2] = 0x00;
			src[i + 3] = 0xC0;
		}
	}
}

void print_info(int io)
{
	if (io == 0)
	{
		printf("These files are required as input:\n\n");
		printf("271-p1.bin\tsize 4194304\tcrc B9DA070C \n\t\tsha1 1A26325AF142A4DD221C336061761468598C4634\n\n");
		printf("271-p2.bin\tsize 4194304\tcrc DA3118C4 \n\t\tsha1 582E4F44F03276ADECB7B2848D3B96BF6DA57F1E\n\n");
		printf("271-bios.bin\tsize 262144\tcrc C521B5BC\n\t\tsha1 C9A5DB63523191DEDD1B39BAAB8772f64F09B77F\n\n");
	}

	if (io == 1)
	{
		printf("\nThese files should have been produced:\n\n");
		printf("271-p1c.bin\tsize 4194304\tcrc 530ECC14\n\t\tsha1 812CF7E9902AF3F5E9E330B7C05C2171B139AD2B\n\n");
		printf("271-p2c.bin\tsize 4194304\tcrc FD568DA9\n\t\tsha1 46364906A1E81DC251117E91A1A7B43AF1373ADA\n");
	}
}

int main(int argc, char **argv)
{
	int i;

	FILE *BIOS;
	FILE *P1_IN, *P2_IN;
	FILE *P1_OUT, *P2_OUT;

// allocate ram

	unsigned char *src = (unsigned char*)malloc(0x800000);
	unsigned char *bios = (unsigned char*)malloc(0x40000);

// check input files

	if ((BIOS=fopen("271-bios.bin","rb"))==NULL)
	{
		print_info(0);
		fprintf(stderr,"Error: cannot read 271-bios.bin.\n");
		return(1);
	}
	fseek (BIOS, 0, SEEK_END);
	if ((ftell (BIOS)) != 0x40000)
	{
		print_info(0);
		fclose (BIOS);
		return (1);
	}
	rewind (BIOS);

	if ((P1_IN=fopen("271-p1.bin","rb"))==NULL)
	{
		print_info(0);
		fprintf(stderr,"Error: cannot read 271-p1.bin.\n");
		return(1);
	}
	fseek (P1_IN, 0, SEEK_END);
	if ((ftell (P1_IN)) != 0x400000)
	{
		print_info(0);
		fclose (P1_IN);
		return (1);
	}
	rewind (P1_IN);

	if ((P2_IN=fopen("271-p2.bin","rb"))==NULL)
	{
		print_info(0);
		fprintf(stderr,"Error: cannot read 271-p2.bin.\n");
		return(1);
	}
	fseek (P2_IN, 0, SEEK_END);
	if ((ftell (P2_IN)) != 0x400000)
	{
		print_info(0);
		fclose (P2_IN);
		return (1);
	}
	rewind (P2_IN);

// check output files

	if ((P1_OUT=fopen("271-p1c.bin","wb"))==NULL)
	{
		fclose(P1_OUT); fprintf(stderr,"Error: cannot write to 271-p1c.bin");
		return(1);
	}
	if ((P2_OUT=fopen("271-p2c.bin","wb"))==NULL)
	{
		fclose(P2_OUT); fprintf(stderr,"Error: cannot write to 271-p2c.bin");
		return(1);
	}

// read files
	
	printf ("Reading input files...\n");

	fread (bios, 1, 0x40000, BIOS);
	fclose (BIOS);

	for (i = 0; i < 0x800000; i+=4)
	{
		fread (src + i + 0, 1, 2, P1_IN);
		fread (src + i + 2, 1, 2, P2_IN);
	}
	fclose (P1_IN);
	fclose (P2_IN);

// decrypt program data

	printf ("Decrypting input data...\n");

	decrypt(src);

// patch program data

	printf ("Patching input data...\n");

	memcpy (src + 0xF8000, bios + 0x20000, 0x27EE);
	memcpy (src + 0xFC000, bios + 0x1FF80, 0x001D);

	patch(src);

// encrypt program data

	printf ("Encrypting output data...\n");

	encrypt(src);

// write p1 and p2

	printf ("Writing output data...\n");

	for (i = 0; i < 0x800000; i+=4)
	{
		fwrite (src + i + 0, 1, 2, P1_OUT);
		fwrite (src + i + 2, 1, 2, P2_OUT);
	}

	fclose (P1_OUT);
	fclose (P2_OUT);

// deallocate ram

	free (src);
	free (bios);

	print_info(1);
}
