#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BITSWAP16(n, 														\
				  bit15, bit14, bit13, bit12, bit11, bit10, bit09, bit08,	\
				  bit07, bit06, bit05, bit04, bit03, bit02, bit01, bit00)	\
		(((((n) >> (bit15)) & 1) << 15) | 									\
		 ((((n) >> (bit14)) & 1) << 14) | 									\
		 ((((n) >> (bit13)) & 1) << 13) | 									\
		 ((((n) >> (bit12)) & 1) << 12) | 									\
		 ((((n) >> (bit11)) & 1) << 11) | 									\
		 ((((n) >> (bit10)) & 1) << 10) | 									\
		 ((((n) >> (bit09)) & 1) <<  9) | 									\
		 ((((n) >> (bit08)) & 1) <<  8) | 									\
		 ((((n) >> (bit07)) & 1) <<  7) | 									\
		 ((((n) >> (bit06)) & 1) <<  6) | 									\
		 ((((n) >> (bit05)) & 1) <<  5) | 									\
		 ((((n) >> (bit04)) & 1) <<  4) | 									\
		 ((((n) >> (bit03)) & 1) <<  3) | 									\
		 ((((n) >> (bit02)) & 1) <<  2) | 									\
		 ((((n) >> (bit01)) & 1) <<  1) | 									\
		 ((((n) >> (bit00)) & 1) <<  0))

static const unsigned char m1_address_8_15_xor[256] = {
        0x0a, 0x72, 0xb7, 0xaf, 0x67, 0xde, 0x1d, 0xb1, 0x78, 0xc4, 0x4f, 0xb5, 0x4b, 0x18, 0x76, 0xdd,
        0x11, 0xe2, 0x36, 0xa1, 0x82, 0x03, 0x98, 0xa0, 0x10, 0x5f, 0x3f, 0xd6, 0x1f, 0x90, 0x6a, 0x0b,
        0x70, 0xe0, 0x64, 0xcb, 0x9f, 0x38, 0x8b, 0x53, 0x04, 0xca, 0xf8, 0xd0, 0x07, 0x68, 0x56, 0x32,
        0xae, 0x1c, 0x2e, 0x48, 0x63, 0x92, 0x9a, 0x9c, 0x44, 0x85, 0x41, 0x40, 0x09, 0xc0, 0xc8, 0xbf,
        0xea, 0xbb, 0xf7, 0x2d, 0x99, 0x21, 0xf6, 0xba, 0x15, 0xce, 0xab, 0xb0, 0x2a, 0x60, 0xbc, 0xf1,
        0xf0, 0x9e, 0xd5, 0x97, 0xd8, 0x4e, 0x14, 0x9d, 0x42, 0x4d, 0x2c, 0x5c, 0x2b, 0xa6, 0xe1, 0xa7,
        0xef, 0x25, 0x33, 0x7a, 0xeb, 0xe7, 0x1b, 0x6d, 0x4c, 0x52, 0x26, 0x62, 0xb6, 0x35, 0xbe, 0x80,
        0x01, 0xbd, 0xfd, 0x37, 0xf9, 0x47, 0x55, 0x71, 0xb4, 0xf2, 0xff, 0x27, 0xfa, 0x23, 0xc9, 0x83,
        0x17, 0x39, 0x13, 0x0d, 0xc7, 0x86, 0x16, 0xec, 0x49, 0x6f, 0xfe, 0x34, 0x05, 0x8f, 0x00, 0xe6,
        0xa4, 0xda, 0x7b, 0xc1, 0xf3, 0xf4, 0xd9, 0x75, 0x28, 0x66, 0x87, 0xa8, 0x45, 0x6c, 0x20, 0xe9,
        0x77, 0x93, 0x7e, 0x3c, 0x1e, 0x74, 0xf5, 0x8c, 0x3e, 0x94, 0xd4, 0xc2, 0x5a, 0x06, 0x0e, 0xe8,
        0x3d, 0xa9, 0xb2, 0xe3, 0xe4, 0x22, 0xcf, 0x24, 0x8e, 0x6b, 0x8a, 0x8d, 0x84, 0x4a, 0xd2, 0x91,
        0x88, 0x79, 0x57, 0xa5, 0x0f, 0xcd, 0xb9, 0xac, 0x3b, 0xaa, 0xb3, 0xd1, 0xee, 0x31, 0x81, 0x7c,
        0xd7, 0x89, 0xd3, 0x96, 0x43, 0xc5, 0xc6, 0xc3, 0x69, 0x7f, 0x46, 0xdf, 0x30, 0x5b, 0x6e, 0xe5,
        0x08, 0x95, 0x9b, 0xfb, 0xb8, 0x58, 0x0c, 0x61, 0x50, 0x5d, 0x3a, 0xa2, 0x29, 0x12, 0xfc, 0x51,
        0x7d, 0x1a, 0x02, 0x65, 0x54, 0x5e, 0x19, 0xcc, 0xdc, 0xdb, 0x73, 0xed, 0xad, 0x59, 0x2f, 0xa3,
};

static const unsigned char m1_address_0_7_xor[256] = {
        0xf4, 0xbc, 0x02, 0xf7, 0x2c, 0x3d, 0xe8, 0xd9, 0x50, 0x62, 0xec, 0xbd, 0x53, 0x73, 0x79, 0x61,
        0x00, 0x34, 0xcf, 0xa2, 0x63, 0x28, 0x90, 0xaf, 0x44, 0x3b, 0xc5, 0x8d, 0x3a, 0x46, 0x07, 0x70,
        0x66, 0xbe, 0xd8, 0x8b, 0xe9, 0xa0, 0x4b, 0x98, 0xdc, 0xdf, 0xe2, 0x16, 0x74, 0xf1, 0x37, 0xf5,
        0xb7, 0x21, 0x81, 0x01, 0x1c, 0x1b, 0x94, 0x36, 0x09, 0xa1, 0x4a, 0x91, 0x30, 0x92, 0x9b, 0x9a,
        0x29, 0xb1, 0x38, 0x4d, 0x55, 0xf2, 0x56, 0x18, 0x24, 0x47, 0x9d, 0x3f, 0x80, 0x1f, 0x22, 0xa4,
        0x11, 0x54, 0x84, 0x0d, 0x25, 0x48, 0xee, 0xc6, 0x59, 0x15, 0x03, 0x7a, 0xfd, 0x6c, 0xc3, 0x33,
        0x5b, 0xc4, 0x7b, 0x5a, 0x05, 0x7f, 0xa6, 0x40, 0xa9, 0x5d, 0x41, 0x8a, 0x96, 0x52, 0xd3, 0xf0,
        0xab, 0x72, 0x10, 0x88, 0x6f, 0x95, 0x7c, 0xa8, 0xcd, 0x9c, 0x5f, 0x32, 0xae, 0x85, 0x39, 0xac,
        0xe5, 0xd7, 0xfb, 0xd4, 0x08, 0x23, 0x19, 0x65, 0x6b, 0xa7, 0x93, 0xbb, 0x2b, 0xbf, 0xb8, 0x35,
        0xd0, 0x06, 0x26, 0x68, 0x3e, 0xdd, 0xb9, 0x69, 0x2a, 0xb2, 0xde, 0x87, 0x45, 0x58, 0xff, 0x3c,
        0x9e, 0x7d, 0xda, 0xed, 0x49, 0x8c, 0x14, 0x8e, 0x75, 0x2f, 0xe0, 0x6e, 0x78, 0x6d, 0x20, 0xd2,
        0xfa, 0x2d, 0x51, 0xcc, 0xc7, 0xe7, 0x1d, 0x27, 0x97, 0xfc, 0x31, 0xdb, 0xf8, 0x42, 0xe3, 0x99,
        0x5e, 0x83, 0x0e, 0xb4, 0x2e, 0xf6, 0xc0, 0x0c, 0x4c, 0x57, 0xb6, 0x64, 0x0a, 0x17, 0xa3, 0xc1,
        0x77, 0x12, 0xfe, 0xe6, 0x8f, 0x13, 0x71, 0xe4, 0xf9, 0xad, 0x9f, 0xce, 0xd5, 0x89, 0x7e, 0x0f,
        0xc2, 0x86, 0xf3, 0x67, 0xba, 0x60, 0x43, 0xc9, 0x04, 0xb3, 0xb0, 0x1e, 0xb5, 0xc8, 0xeb, 0xa5,
        0x76, 0xea, 0x5c, 0x82, 0x1a, 0x4f, 0xaa, 0xca, 0xe1, 0x0b, 0x4e, 0xcb, 0x6a, 0xef, 0xd1, 0xd6,
};

static unsigned short generate_cs16(unsigned char *rom, int size)
{
	int i;
    unsigned short cs16 = 0;

    for (i = 0; i < size; i++) {
        cs16 += rom[i];
    }

    return cs16;
}

static int m1_address_scramble(int address, unsigned short key)
{
	const int p1[8][16] = {
		{15, 14, 10,  7,  1,  2,  3,  8,  0, 12, 11, 13,  6,  9,  5,  4},
		{ 7,  1,  8, 11, 15,  9,  2,  3,  5, 13,  4, 14, 10,  0,  6, 12},
		{ 8,  6, 14,  3, 10,  7, 15,  1,  4,  0,  2,  5, 13, 11, 12,  9},
		{ 2,  8, 15,  9,  3,  4, 11,  7, 13,  6,  0, 10,  1, 12, 14,  5},
		{ 1, 13,  6, 15, 14,  3,  8, 10,  9,  4,  7, 12,  5,  2,  0, 11},
		{11, 15,  3,  4,  7,  0,  9,  2,  6, 14, 12,  1,  8,  5, 10, 13},
		{10,  5, 13,  8,  6, 15,  1, 14, 11,  9,  3,  0, 12,  7,  4,  2},
		{ 9,  3,  7,  0,  2, 12,  4, 11, 14, 10,  5,  8, 15, 13,  1,  6},
	};

	int block = (address >> 16) & 7;
	int aux = address & 0xffff;

    aux ^= BITSWAP16(key, 12, 0, 2, 4, 8, 15, 7, 13, 10, 1, 3, 6, 11, 9, 14, 5);
	aux = BITSWAP16(aux,
		p1[block][15], p1[block][14], p1[block][13], p1[block][12],
		p1[block][11], p1[block][10], p1[block][9] , p1[block][8],
		p1[block][7] , p1[block][6] , p1[block][5] , p1[block][4],
		p1[block][3] , p1[block][2] , p1[block][1] , p1[block][0]);
        aux ^= m1_address_0_7_xor[(aux >> 8) & 0xff];
	aux ^= m1_address_8_15_xor[aux & 0xff] << 8;
	aux = BITSWAP16(aux, 7, 15, 14, 6, 5, 13, 12, 4, 11, 3, 10, 2, 9, 1, 8, 0);

	return (block << 16) | aux;
}

static void neogeo_cmc50_m1_decrypt(unsigned char *rom)
{
	int i;
	unsigned char *buffer = (unsigned char*)malloc(0x80000);
	unsigned short key = generate_cs16(rom, 0x10000);

	for (i = 0; i < 0x80000; i++) { 
		buffer[i] = rom[m1_address_scramble(i, key)];
	}

	memcpy(rom, buffer, 0x80000);
	free(buffer);
}

static void neogeo_cmc50_m1_encrypt(unsigned char *rom)
{
	int i;
	unsigned char *buffer = (unsigned char*)malloc(0x80000);
	unsigned short key = generate_cs16(rom, 0x10000);

	for (i = 0; i < 0x80000; i++) { 
		buffer[m1_address_scramble(i, key)] = rom[i];
	}

	memcpy(rom, buffer, 0x80000);
	free(buffer);
}

int main()
{
	int length;
	char name[128],crypt[4];
	unsigned char *rom = (unsigned char*)malloc(0x80000);

	printf ("Please enter name of the file you wish to en/de-crypt:\n");
	gets (name);

	printf ("(E)ncrypt or (D)ecrypt?\n");
	gets (crypt);
	
	int encrypt = crypt[0] & 1;

	printf("%scrypting file %s\n", (encrypt) ? "En" : "De", name);

	FILE *fa = fopen(name, "rb");
	if (fa == NULL) {
		printf ("Failed to open %s\n", name);
		free (rom);
		return 0;
	}	
	fseek (fa, 0, SEEK_END);
	length = ftell (fa);
	rewind (fa);
	fread (rom, length, 1, fa);
	fclose (fa);

	if (encrypt) {
		neogeo_cmc50_m1_encrypt(rom);
	} else {
		neogeo_cmc50_m1_decrypt(rom);
	}

	sprintf (name, "%s-%scrypted", name, (encrypt) ? "en" : "de");

	fa = fopen(name, "wb");
	fwrite (rom, length, 1, fa);
	fclose (fa);
	
	printf ("File %s created.\n");

	free (rom);
	
	return 1;
}
