#include "shared.h"

// masking function - combines decrypted opcodes and data
void mask(unsigned char *src)
{
	FILE *fz;
	int i, j, a, b;
	unsigned short *mem16, *d0, *d1, *o0, *o1, *m0;

	mem16 = (unsigned short*)mem;

	o0 = mem16 + ((nLen / 2) * 0);	// opcode - set ram regions
	o1 = mem16 + ((nLen / 2) * 1);			
	d0 = mem16 + ((nLen / 2) * 2);	// data
	d1 = mem16 + ((nLen / 2) * 3);
	m0 = mem16 + ((nLen / 2) * 4);	// mask

	printf ("Creating mask");

	// Begin the masking process.  Count the matching bits for each word (16 bits) and use
	// the data or opcode depending on this.
	for (i = 0; i < dLen / 2; i++)
	{
		for (j = 0, a = 0, b = 0; j < 16; j++)
		{
			if ((d0[i] & (1 << j)) == (d1[i] & (1 << j)))	// compare data
				a++;

			if ((o0[i] & (1 << j)) == (o1[i] & (1 << j)))	// compare opcode
				b++;
		}

		if (a >  b) m0[i] = 0xFFFF;	// data
		if (a == b) m0[i] = 0x5555;	// no clear match, fix in the next step
						// opcode (0)

		if (i == (((dLen / 2) / 3) * 1) || i == (((dLen / 2) / 3) * 2) || i == ((dLen / 2) - 1))
			printf (".");
	}

	printf ("\n\n");

#ifdef WRITE_MASK
	// The original mask, write it to compare against the fixed version
	fz = fopen("mask.bin", "wt");
	fwrite (src + (nLen * 4), 1, dLen, fz);
	fclose (fz);
#endif

#ifdef LOG
	fz = fopen("info.log", "wt");
#endif

	printf ("Fixing mask");

	// Fix cases in which there is not a clear match
	for (i = 1; i < (dLen / 2)-2; i++)
	{
		if (m0[i] == 0x5555)
		{
			fprintf (fz, "Double match at address (%5.5x); ", i << 1);

			if (m0[i-1] == m0[i+1] && m0[i-1])
			{
				m0[i] = 0xFFFF;	// data
			}
			else
			{
				m0[i] = 0;	// opcode
			}
#ifdef LOG
			fprintf (fz, "it is most likely %s. (data %4.4x, opcode %4.4x)\n", m0[i] ? "data" : "an opcode", d0[i], o0[i]);
#endif
		}

		if (i == (((dLen / 2) / 3) * 1) || i == (((dLen / 2) / 3) * 2) || i == ((dLen / 2) - 1))
			printf (".");
	}

	printf ("\n\n");

/*
	printf ("Fixing mask (step 2)");

	// Opcode in the middle of data or data in the middle of opcodes --
	// This changes these so that they match the surrounding, but
	// there's no real way to tell if these are correct or not :S
	// Razoola seems to have left these alone, so I will too.
	for (i = 1; i < (dLen / 2)-2; i++) {
		if (m0[i] == m0[i+2] && m0[i] != m0[i+1]) {
			m0[i+1] = m0[i];
#ifdef LOG
			fprintf (fz, "Fixed incorrect(?) match at %x. (%s) (data %4.4x, %4.4x, opcode %4.4x, %4.4x)\n", (i+1) << 1, m0[i] ? "data" : "opcode", d0[i+1], d1[i+1], o0[i+1], o1[i+1]);
#endif
		}

		if (i == (((dLen / 2) / 3) * 1) || i == (((dLen / 2) / 3) * 2) || i == ((dLen / 2) - 1))
			printf (".");
	}

	printf ("\n\n");
*/
	printf ("Applying mask");

#ifdef LOG
	fclose (fz);
#endif

#ifdef WRITE_MASK
	// The fixed mask, write it to compare against the original version
	fz = fopen("fixedmask.bin", "wt");
	fwrite (src + (nLen * 4), 1, dLen, fz);
	fclose (fz);
#endif

	// Apply mask to the data/opcodes
	for (i = 0; i < dLen / 2; i++)
	{
		d0[i] = (d0[i] & m0[i]) | (o0[i] & ~m0[i]);	// Apply to set 1
		d1[i] = (d1[i] & m0[i]) | (o1[i] & ~m0[i]);	// Apply to set 2

		if (i == (((dLen / 2) / 3) * 1) || i == (((dLen / 2) / 3) * 2) || i == ((dLen / 2) - 1))
			printf (".");
	}

	printf ("\n\n");
}
