/*
	Encode CPS-2 32x32 pixel data from raw 32x32 4bpp pixel data into CPS-2 rom format
	currently roms for batcir are hooked up as an example
	iq_132 - 6/10/20
*/

#include <stdio.h>

static void get_bitmap(unsigned char *tmp, int len)
{
	unsigned char *tmp2 = (unsigned char*)malloc(len);
	unsigned char bmp_data[0x36];
	unsigned char palette_data[16 * 4];
	
	FILE *fa = fopen("output.bmp", "rb");
	fread (bmp_data, 0x36, 1, fa);
	fread (palette_data, 16*4, 1, fa);
	fread (tmp, len/2, 1, fa);
	fclose (fa);

	int wide = 0x1000;
	int high = len / 0x1000;

	int i;
	// unpack data (2 pixels / byte) -> 1 pixel / byte
	for (i = 0; i < len / 2; i++)
	{
		tmp2[(len - 2) - (i * 2) + 0] = tmp[i] & 0xf;
		tmp2[(len - 2) - (i * 2) + 1] = tmp[i] >> 4;
	}

	{
		int x,y,xx,yy,c=0;
		for (y = 0; y < high; y+=32)
		{
			for (x = 0; x < wide; x+=32,c++)
			{
				int offs = (y/32)*(wide/32)+(x/32);
	
				unsigned char *src = tmp + offs * 32 * 32;
				unsigned char *dst = tmp2 + y * wide + x;

				for (yy = 0; yy < 32; yy++)
				{
					for (xx = 0; xx < 32; xx++)
					{
						src[xx] = dst[xx];		// or is it flipped?			
					}

					src += 32;
					dst += wide;
				}
			}
		}
	}
	
	printf ("W: %d, h: %d\n", wide, high);

	free (tmp2);
}

static void gfx_encode(unsigned char *rom, int gfxlen) // encode and shuffle
{
	int i,j,k;
	unsigned char *tmp = (unsigned char*)malloc(gfxlen);
	
	memcpy (tmp, rom, gfxlen);
	memset (rom, 0, gfxlen / 2);
	
	for (i = 0; i < gfxlen*8; i++)
	{
		k = ((i & 3) << 3) | (((i >> 3) & 7) ^ 7) | ((i & 0xffffffc0) >> 1); // step 1 encode

		j = (((k >> 3) << 1) & 0x1ffff0) | (((k >> 3) >> 17) & 8) | ((k >> 3) & 0xffe00007); // step 2 shuffle

		rom[j] |= ((tmp[i/8] >> (i & 7)) & 1) << (k & 7);	
	}
}

int main()
{
	unsigned char *rom = (unsigned char*)malloc(0x1000000*2);

	get_bitmap(rom, 0x2000000);

	gfx_encode(rom, 0x2000000);
	
//	FILE *fp = fopen("reassembled", "wb");
//	fwrite (rom, 0x1000000, 1, fp);
//	fclose (fp);

	// type 0 - ROM_LOAD64_WORD
	{
		int i,j;
		FILE *f[4];

		f[0] = fopen("sfx.13m_modified", "wb");
		f[1] = fopen("sfx.15m_modified", "wb");
		f[2] = fopen("sfx.17m_modified", "wb");
		f[3] = fopen("sfx.19m_modified", "wb");

		unsigned char *tmp = (unsigned char*)malloc(0x200000);
		
		for (i = 0; i < 4; i++)
		{
			for (j = 0; j < 0x200000; j++) { // load 2 bytes, skip 6 bytes, repeat.
				tmp[j] = rom[(j & 1) + ((j & ~1) << 2) + (i * 2)];
			}

			fwrite (tmp, 0x200000, 1, f[i]);
			fclose (f[i]);
		}

		f[0] = fopen("sfx.14m_modified", "wb");
		f[1] = fopen("sfx.16m_modified", "wb");
		f[2] = fopen("sfx.18m_modified", "wb");
		f[3] = fopen("sfx.20m_modified", "wb");

		for (i = 0; i < 4; i++)
		{
			for (j = 0; j < 0x100000; j++) { // load 2 bytes, skip 6 bytes, repeat.
				tmp[j] = rom[0x800000 + (j & 1) + ((j & ~1) << 2) + (i * 2)];
			}

			fwrite (tmp, 0x100000, 1, f[i]);
			fclose (f[i]);
		}

		f[0] = fopen("sfx.21m_modified", "wb");
		f[1] = fopen("sfx.23m_modified", "wb");
		f[2] = fopen("sfx.25m_modified", "wb");
		f[3] = fopen("sfx.27m_modified", "wb");
		
		for (i = 0; i < 4; i++)
		{
			for (j = 0; j < 0x100000; j++) { // load 2 bytes, skip 6 bytes, repeat.
				tmp[j] = rom[0xc00000 + (j & 1) + ((j & ~1) << 2) + (i * 2)];
			}

			fwrite (tmp, 0x100000, 1, f[i]);
			fclose (f[i]);
		}
		free (tmp);
	}

	free (rom);
	
	return 0;
}
