#include <stdio.h>

void usage()
{
	printf("USAGE:\n");
	printf("\tsplit.exe in_file size\n");
}

int main(int argc, char **argv)
{
	FILE *file_in, *file_out;
	char name[0];
	int i;
	int ROMSize = 0;
	int outsize = 0;

	if (argc != 3)
	{
		usage();
		return(1);
	}

	// Scan arguments for file name
	sscanf(argv[1],"%s",&name);
	sscanf(argv[2],"%d",&outsize);

	printf("Checking input\n");
	// Check input files
	if ((file_in=fopen(name,"rb"))==NULL)
	{
		fprintf(stderr,"Error: cannot read %s.",name);
		return(1);
	}
	fseek (file_in , 0 , SEEK_END);
	ROMSize += ftell (file_in);
	rewind (file_in);

	// Scan arguments for file name
	sscanf(argv[1],"%7s",&name);
	sprintf(name,"%7s.001",name);

	printf("Checking output\n");
	// Check output files
	if ((file_out=fopen(name,"wb"))==NULL)
	{
		fclose(file_out);
		fprintf(stderr,"Error: cannot write to %s.", name);
		return(1);
	}

	printf("Allocate RAM\n");
	// Create buffer
	unsigned char *src = (unsigned char*)malloc(ROMSize);

	printf("Read and close input file\n");

	fread (src,1,ROMSize,file_in);
	fclose(file_in);

	printf("Write output\n");
	// Write the output
	fwrite (src,1,outsize*1024,file_out);
	fclose(file_out);

	printf("Free Allocated RAM\n");
	// Free buffer
	free(src);

	printf("Finished\n");
}
