#include "shared.h"

int nLen;
int setn = 0;			// set number 
int rmnm = 0;			// rom number
char setname[2][32];		// set names
char romname[2][16][32];	// rom names
unsigned int crcstore[2][16];	// CRCs for each rom
unsigned int romsize[2][16];	// Sizes for each rom
unsigned int keystore[2][2];	// keys for each set
unsigned int uppr = 0;		// upper limit for each set, should be the same

// standard CRC32 checking (modified)
unsigned int crc_tab(unsigned char a)
{
	unsigned int b = 0;

	if (a & 0x01) b ^= 0x77073096;
	if (a & 0x02) b ^= 0xEE0E612C;
	if (a & 0x04) b ^= 0x076DC419;
	if (a & 0x08) b ^= 0x0EDB8832;
	if (a & 0x10) b ^= 0x1DB71064;
	if (a & 0x20) b ^= 0x3B6E20C8;
	if (a & 0x40) b ^= 0x76DC4190;
	if (a & 0x80) b ^= 0xEDB88320;

	return b;
}

unsigned int crc32(unsigned char *src, unsigned int nLen)
{
	int i;
	unsigned int crc = ~0;

	for (i = 0; i < nLen; i++)
	{
		crc = crc_tab(crc ^ src[i]) ^ (crc >> 8);
	}

	return ~crc;
}

// put everything in lower case
int lowerall(char *src)
{
	int i;
	for (i = 0; i < strlen(src); i++)
		if (src[i] > 0x40 && src[i] < 0x5B) src[i] |= 0x20;
}

// custom sscanf-type function that actually does what I want it to
unsigned int sscanf_uint(char *inp)
{
	unsigned int i, k;

	for (i = 0, k = 0; i < 8; i++)
	{
		if ((inp[i] & 0xf0) == 0x30)
			k |= ((inp[i] & 0x0f) + 0) << (28 - (4 * i));

		if ((inp[i] & 0xd0) == 0x40 && (inp[i] & 0x0f) < 7)
			k |= ((inp[i] & 0x0f) + 9) << (28 - (4 * i));
	}

	k >>= (8-strlen(inp)) << 2;

	return k;
}

// parse the cps2.dat file for various information
void parse_dat()
{
	FILE *fz;
	char tmp[64];
	char szLine[256];
	int gFound;
	int c0, c1, i;

	printf ("Please type the name of the %s set you wish to work with\n", setn & 1 ? "second" : "first");
	gets (setname[setn]);

	fz = fopen("data//cps2.dat", "rt");
	if (fz == NULL) {
		error = 1;
		return;
	}

	strcpy (tmp, "begin ");
	strcat (tmp, setname[setn]); // begin setname
	lowerall(tmp);

	rmnm = 0;
	gFound = 0;

	while (1)
	{
		if (fgets(szLine, 256, fz) == NULL)
			break;

		int szLen = strlen(szLine)-1;
		if (szLen < 3) continue;

		szLine[szLen] = '\0';

		// get decrypt info
		if (strncmp (szLine, "decrypt", 7) == 0 && gFound)
		{
			fgets (szLine, 256, fz);

			memcpy (tmp, szLine + 0x00, 8);		// key 0
			tmp[8] = '\0';
			keystore[setn][0] = sscanf_uint(tmp);

			memcpy (tmp, szLine + 0x09, 8);		// key 1
			tmp[8] = '\0';
			keystore[setn][1] = sscanf_uint(tmp);

			memcpy (tmp, szLine + 0x12, 6);		// upper limit
			tmp[6] = '\0';
			uppr = sscanf_uint(tmp);

			fgets (szLine, 256, fz);
		}

		if (strncmp (szLine, "end", 3) == 0 & gFound)
			break;

		lowerall(szLine);

		// Check for "Begin x" (x => game name, eg. 'sfa')
		if (gFound == 0) {
			if (strncmp (szLine, tmp, strlen(tmp)) == 0 && strlen(tmp) == szLen) {
				gFound = 1;
			}

			continue;
		}

		for (i = 0, c0 = 0, c1 = 0; i < szLen; i++)
		{
			if (szLine[i] == ',' && c0 == 2) {		// CRC
				memcpy (tmp, szLine + c1, i-1);
				tmp[i-1] = '\0';
				sscanf (tmp, "%x", &crcstore[setn][rmnm]);
				break;
			}

			if (szLine[i] == ',' && c0 == 1) {		// size
				memcpy (tmp, szLine + c1, i-1);
				tmp[i-1] = '\0';
				sscanf(tmp, "%x", &romsize[setn][rmnm]);
				c0++;
				c1 = i+1;
			}

			if (szLine[i] == ',' && c0 == 0) {		// name
				memcpy (romname[setn][rmnm], szLine, i);
				romname[setn][rmnm][i] = '\0';
				c0++;
				c1 = i+1;
			}
		}

		rmnm++;
		if (rmnm > 16) break;
	}

	if (rmnm == 0) {			// did not find any roms for this setname
		error = 1;
		printf ("%s not found\n", setname[setn]);
		return;
	}

	fclose (fz);

	// Print rom information
//	for (i = 0; i < rmnm; i++)
//	{
//		printf ("%s, %x, %x\n", romname[setn][i], romsize[setn][i], crcstore[setn][i]);
//	}

	printf ("\n");

	// Get length of encrypted rom
	if (setn == 1) {
		for (i = 0; i < rmnm; i++)
		{
			if (crcstore[0][i] != crcstore[1][i])
				nLen += romsize[setn][i];
			else
				break;
		}
	}

	setn++;
}


// read files to opcode
void do_read(unsigned char *dst)
{
	FILE *fz;

	int tLen = 0;
	unsigned char *dstload = dst;

	int i, j;
	for (i = 0; i < 2; i++)
	{
		printf ("Reading roms for %s:\n", setname[i]);

		for (j = 0; j < rmnm; j++)
		{
			if (crcstore[0][j] == crcstore[1][j])
				break;

			fz = fopen(romname[i][j], "rb"); // open file
			if (fz == NULL)
			{
				error = 1;
				printf ("%s not found!\n", romname[i][j]);
				return;
			}
			fseek (fz, 0, SEEK_END);
			tLen = ftell (fz);
			rewind (fz);
			if (tLen != romsize[i][j])	// compare sizes
			{
				error = 1;
				printf ("%s's size does not match! (%x found, %x needed)\n", romname[i][j], romsize[i][j], tLen);
				fclose (fz);
				return;
			}

			fread (dstload, 1, tLen, fz);	// read file

			int crc = crc32(dstload, tLen);	// compare CRCs
			if (crc != crcstore[i][j])
			{
				error = 1;
				printf ("%s's CRC does not match! (%8.8x found, %8.8x needed)", romname[i][j], crcstore[i][j], crc);
				fclose (fz);
				return;
			}
			dstload += tLen;
			fclose (fz);

			printf ("%s, size %5.5x, crc %8.8x read\n", romname[i][j], tLen, crc);
		}

		memcpy (dst + (nLen * (2 + i)), dst + (nLen * i), nLen);
		dstload = dst + (nLen * (i + 1));

		printf ("\n");
	}
}


// write files from data
void do_write (unsigned char *dst)
{
	int i, j;
	FILE *fz;
	char tmp[64];
	unsigned char *dstwrite = dst;
	for (i = 0; i < 2; i++)
	{
		printf ("Writing roms for %s:\n", setname[i]);

		int len = 0;
		for (j = 0; j < rmnm; j++)
		{
			if (len >= dLen) break;

			memcpy (tmp, romname[i][j], strlen(romname[i][j]));	// Append _decrypted to the file names
			strcpy (tmp + strlen(romname[i][j]), "_decrypted");

			fz = fopen (tmp, "wb");
			fwrite (dstwrite, 1, romsize[i][j], fz);
			fclose (fz);

			printf ("%s written\n", tmp);

			len += romsize[i][j];
			dstwrite += romsize[i][j];
		}

		dstwrite = dst + (nLen * (i+1));

		printf ("\n");
	}
}
