#include <stdio.h>

/* Code by IQ_132.  You may use this in any way you wish, just leave this line intact. */

int main()
{
	FILE *p1_rom_out, *p1a_rom_in, *p2a_rom_in;

	if ((p1a_rom_in=fopen("269-p1a.bin","rb"))==NULL)
	{
		fclose(p1a_rom_in); fprintf(stderr,"Error: cannot read 269-p1a.bin"); return(1);
	}
	if ((p2a_rom_in=fopen("269-p2a.bin","rb"))==NULL)
	{
		fclose(p2a_rom_in); fprintf(stderr,"Error: cannot read 269-p2a.bin"); return(1);
	}

	if ((p1_rom_out=fopen("269-p1.bin","wb"))==NULL)
	{
		fprintf(stderr,"Error: cannot write to 269-p1.bin"); return(1);
	}

	unsigned char *src = (unsigned char*)malloc(0x1000000);

	fread (src+0x000000, 1, 0x400000, p1a_rom_in);
	fread (src+0x400000, 1, 0x400000, p2a_rom_in);

	int i;
	for (i = 0; i < 0x400000; i+=2)
	{
		fwrite (src+i+0x000000, 1, 2, p1_rom_out);
		fwrite (src+i+0x400000, 1, 2, p1_rom_out);

		*((unsigned short*)(src + i + 0x800000)) = 0xFFFF;
		*((unsigned short*)(src + i + 0xC00000)) = 0xFFFF;
	}

	fwrite (src+0x800000, 1, 0x800000, p1_rom_out);

	fclose(p1a_rom_in);
	fclose(p2a_rom_in);
	fclose(p1_rom_out);

	free (src);

	printf("Finished");
}
