/*  By Kenshiro (http://neosource.1emu.net)
      Driver Generator for Final Burn Alpha (15/02/2009)    */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_DRV_NUM 250
#define MAX_ROM_NUM 100

#define GET_INFO(str, c)  \
    while (line_to_scan[i] != c) {  \
		str[j] = line_to_scan[i]; \
		i++, j++; \
	} \
	str[j] = '\0'; \
	j = 0;


struct burn_rom_info
{
    char rom_type[32];
    char rom_name[32];
	char flags[128];
	unsigned int len;
	unsigned int crc;
};

struct rom_set
{
    char romset_name[9];
	char parent_set[9];
	int year;
	char game_title[256];
	char manufacturer[128];
	char system[64];
	int game_status;
	char input[32];

	struct burn_rom_info rom_info_list[MAX_ROM_NUM];
};

struct rom_set mame_drv_list[MAX_DRV_NUM];

int inside_drv;
int cur_drv;
int cur_rom;
int total_drv_num;
int drv_end_file;

char cur_rom_type[32];

FILE *mame_drv_file;
FILE *fba_drv_file;


// clean up the struct!
void init_mame_drv_list()
{
    int i, j;

	for (i = 0; i < MAX_DRV_NUM; i++) {

        memset(mame_drv_list[i].romset_name, 0, 9);
		memset(mame_drv_list[i].parent_set, 0, 9);
        mame_drv_list[i].year = 0;
	    memset(mame_drv_list[i].game_title, 0, 256);
		memset(mame_drv_list[i].manufacturer, 0, 128);
		memset(mame_drv_list[i].system, 0, 64);
		// assuming most games works!
		mame_drv_list[i].game_status = 1;
		memset(mame_drv_list[i].input, 0, 32);

		for (j = 0; j < MAX_ROM_NUM; j++) {

            memset(mame_drv_list[i].rom_info_list[j].rom_type, 0, 32);
		    memset(mame_drv_list[i].rom_info_list[j].rom_name, 0, 32);
			memset(mame_drv_list[i].rom_info_list[j].flags, 0, 128);

			mame_drv_list[i].rom_info_list[j].len = 0;
			mame_drv_list[i].rom_info_list[j].crc = 0;
		}
	}

	inside_drv = cur_drv = cur_rom = total_drv_num = drv_end_file = 0;    
}

// split str according to delimitors "star" and "end"
char *split_str(const char *src, char *dst, const char *start, const char *end, int keep_separators)
{
	int i = 0, j = 0;

    while (strncmp(src + i, start, strlen(start)) != 0) i++;

	// copy first separator
    if (keep_separators) {
        memcpy(dst + 0, start, strlen(start));
		j = strlen(start);
    }

	while (strncmp(src + i + strlen(start), end, strlen(end)) != 0) {
	    dst[j] = src[i + strlen(start)];
		i++; j++;
	}
    dst[j] = '\0';
    // copy second separator
	if (keep_separators)
		strcat(dst, end);
}


// by iq_132!
unsigned int sscanf0(char *ptr)
{
	unsigned int r = 0;

	int i, s = strlen(ptr);
	for (i = 0; i < s; i++)
	{
		r <<= 4;

		int t = ptr[i];

		if ((t & 0xd0) == 0x40 && (t & 0x0f) < 7 && (t & 0x0f))
			r |= (t & 0x0f) + 9;

		if ((t & 0xf0) == 0x30 && (t & 0x0f) < 0x0a)
			r |= (t & 0x0f);
	}

	return r;
}


void get_rom_line(const char *line_to_scan)
{
    int comma_count = 0, i = 0, j = 0, k = 0;

    char tmp_crc[32]; memset(tmp_crc, 0, 32);
	char tmp_len[16]; memset(tmp_len, 0, 16);

    //  get romname
    split_str(line_to_scan, mame_drv_list[cur_drv].rom_info_list[cur_rom].rom_name, "\"", "\"", 1);

    //  get rom size, she's stored between second and third comma!
	while (1) {

	    if (line_to_scan[i] == ',') comma_count++;

	    if (comma_count == 2) {
		    split_str(line_to_scan + i, tmp_len, "0x", ",", 0);
            break;
        }
		i++;
	}

    // convert rom size to an unsigned int!
    mame_drv_list[cur_drv].rom_info_list[cur_rom].len = sscanf0(tmp_len);

	// get crc 32 from file
	split_str(line_to_scan, tmp_crc, "CRC(", ")", 0);
	// and convert it to an unsigned int!
	mame_drv_list[cur_drv].rom_info_list[cur_rom].crc = sscanf0(tmp_crc);

    // get rom type (GFX, sound etc...)
	strcpy(mame_drv_list[cur_drv].rom_info_list[cur_rom].rom_type, cur_rom_type);

	// get the rom flag!
	if ((strncmp(cur_rom_type + 0, "main", strlen("main")) == 0) || (strncmp(cur_rom_type + 0, "audio", strlen("audio")) == 0))
		strcpy(mame_drv_list[cur_drv].rom_info_list[cur_rom].flags, "BRF_ESS | BRF_PRG");

    if ((strncmp(cur_rom_type + 0, "gfx", strlen("gfx")) == 0) || (strncmp(cur_rom_type + 0, "sprites", strlen("sprites")) == 0))
		strcpy(mame_drv_list[cur_drv].rom_info_list[cur_rom].flags, "BRF_GRA");

	// done!
	cur_rom++;    
}


void get_game_info_line()
{
    int comma_count = 0, i = 0, j = 0;

	char line_to_scan[1024];
    char tmp_romset_name[9];

	while(fgets(line_to_scan, 1024, mame_drv_file) != NULL) {

        if (strncmp(line_to_scan + 0, "GAME", strlen("GAME")) == 0) {

		    // make sure to work on the right driver, driver name is between first and second comma!
			memset(tmp_romset_name, 0, 9);
			split_str(line_to_scan + 0, tmp_romset_name, ", ", ",", 0);

		    for (cur_drv = 0; cur_drv < total_drv_num; cur_drv++) {
				if (strcmp(mame_drv_list[cur_drv].romset_name, tmp_romset_name) == 0) break;
			}

            //now get all infos! first year
			char tmp_year[5]; memset(tmp_year, 0, 5);
			// extract from file
			split_str(line_to_scan + 0, tmp_year, "GAME( ", ",", 0);
            // and convert it to an int
			mame_drv_list[cur_drv].year = atoi(tmp_year);

            // game status
			char *status = strstr(line_to_scan, "GAME_NOT_WORKING");
			if (status) mame_drv_list[cur_drv].game_status = 0;

            comma_count = i = j = 0;

            // to know where a setting is, have to count comma!
            while (comma_count != 9) {

				if (line_to_scan[i] == ',') {

					comma_count++, i++;
                    while (line_to_scan[i] == ' ') i++;

				    switch (comma_count) {
					    // useless infos!
				        case 1:
						case 3:
					    case 5:
					    case 6:
                            break;
                        // parent set
						case 2:
                            GET_INFO(mame_drv_list[cur_drv].parent_set, ',');
							comma_count++; break;
                        // game input
						case 4:
						    GET_INFO(mame_drv_list[cur_drv].input, ',');
							comma_count++; break;
                        // manufacturer
                        case 7:
							i++;
                            GET_INFO(mame_drv_list[cur_drv].manufacturer, '"');
                            break;
                        // game title
                        case 8:
							i++;
						    GET_INFO(mame_drv_list[cur_drv].game_title, '"');
                            break;
					}
				}
				i++;
			}
		}
	}    
}

// Print BurnDriver struct
void dump_burn_driver(int drv)
{
    // print start of struct!
    fprintf(fba_drv_file, "struct BurnDriver BurnDrv%s = {\n", mame_drv_list[drv].romset_name);

	// romset name
	fprintf(fba_drv_file, "\t\"%c%s\", ", tolower(mame_drv_list[drv].romset_name[0]), mame_drv_list[drv].romset_name + 1);

	// parent name
	if (strcmp(mame_drv_list[drv].parent_set, "0") == 0)
	    fprintf(fba_drv_file, "NULL, ");

	else fprintf(fba_drv_file, "\"%s\", ", mame_drv_list[drv].parent_set);

	// year
	fprintf(fba_drv_file, "NULL, \"%d\",\n", mame_drv_list[drv].year);

	// game title
	strcat(mame_drv_list[drv].game_title, "\\0");
	fprintf(fba_drv_file, "\t\"%s\", NULL, ", mame_drv_list[drv].game_title);

	// manufacturer
	fprintf(fba_drv_file, "\"%s\", ", mame_drv_list[drv].manufacturer);
	// system
	fprintf(fba_drv_file, "\"%s\",\n", mame_drv_list[drv].system);

    // useless stuff!
	fprintf(fba_drv_file, "\tNULL, NULL, NULL, NULL,\n");

	// process game flags, start with game status!
    if (mame_drv_list[drv].game_status != 0)
	    fprintf(fba_drv_file, "\tBDF_GAME_WORKING");

	else fprintf(fba_drv_file, "\t0");

	// then check if it's a clone set
	if (strcmp(mame_drv_list[drv].parent_set, "0") != 0)
	    fprintf(fba_drv_file, " | BDF_CLONE");

	// finally check if it's a bootleg
    if (strcmp(mame_drv_list[drv].manufacturer, "bootleg") == 0)
	    fprintf(fba_drv_file, " | BDF_BOOTLEG");

	 // number of player
	fprintf(fba_drv_file, ", 0,");

    // hardware flag
	if (mame_drv_list[drv].year >= 1990)
	    fprintf(fba_drv_file, " HARDWARE_MISC_POST90S,");

	else fprintf(fba_drv_file, " HARDWARE_MISC_PRE90S,");

    // genre, family

    fprintf(fba_drv_file, " 0, 0,\n");
	// rom info
	fprintf(fba_drv_file, "\tNULL, %sRomInfo, ", mame_drv_list[drv].romset_name);
	// rom name
	fprintf(fba_drv_file, "%sRomName, ", mame_drv_list[drv].romset_name);
	// game inputs
	fprintf(fba_drv_file, "%sInputInfo, ", mame_drv_list[drv].input);
	// dip switches
	fprintf(fba_drv_file, "%sDIPInfo,\n", mame_drv_list[drv].romset_name);

	fprintf(fba_drv_file, "\tDrvInit, DrvExit, DrvFrame, DrvDraw, DrvScan,\n");

	fprintf(fba_drv_file, "\t0, NULL, NULL, NULL, &DrvRecalc, 256, 256, 4, 3\n");

    fprintf(fba_drv_file, "};\n\n\n");

}


// Dump drivers one by one into the file
void dump_mame_drv_list()
{
    int i, j;

	for (i = 0; i < total_drv_num; i++) {


        fprintf(fba_drv_file, "//  %s\n\n", mame_drv_list[i].game_title);
		// Need to print the first letter in caps
		mame_drv_list[i].romset_name[0] = toupper(mame_drv_list[i].romset_name[0]);
		// Print struct beginning
        fprintf(fba_drv_file, "static struct BurnRomInfo %sRomDesc[] = {\n", mame_drv_list[i].romset_name);
		j = 0;

		// then print roms one by one!
        while (mame_drv_list[i].rom_info_list[j].crc) {

            if (strcmp(mame_drv_list[i].rom_info_list[j].rom_type, mame_drv_list[i].rom_info_list[j - 1].rom_type) != 0)
                fprintf(fba_drv_file, "\n");

			// rom name
		    fprintf(fba_drv_file, "\t{ %s, ", mame_drv_list[i].rom_info_list[j].rom_name);
			// rom size
			fprintf(fba_drv_file, "%#x, ", mame_drv_list[i].rom_info_list[j].len);
			// crc 32
			fprintf(fba_drv_file, "%#8.8x, ", mame_drv_list[i].rom_info_list[j].crc);
			// rom flags
			fprintf(fba_drv_file, "%s }, ", mame_drv_list[i].rom_info_list[j].flags);

			// new rom type, print it only one time
			if (strcmp(mame_drv_list[i].rom_info_list[j].rom_type, mame_drv_list[i].rom_info_list[j - 1].rom_type) != 0)
			    fprintf(fba_drv_file, "// %d %s\n", j, mame_drv_list[i].rom_info_list[j].rom_type);

            else fprintf(fba_drv_file, "// %d\n", j);

			j++;
		}

		fprintf(fba_drv_file, "};\n\n");

		fprintf(fba_drv_file, "STD_ROM_PICK(%s)\n", mame_drv_list[i].romset_name);
		fprintf(fba_drv_file, "STD_ROM_FN(%s)\n\n", mame_drv_list[i].romset_name);

        if (!drv_end_file)
            dump_burn_driver(i);
	}

	if (drv_end_file) {

	    for (i = 0; i < total_drv_num; i++) {
	        dump_burn_driver(i);
	    }
	}
}


// process file line by line!
void get_driver()
{
    char file_line[1024];

    while (fgets(file_line, 1024, mame_drv_file) != NULL) {

        if (inside_drv) {

			if (strncmp(file_line + 0, "\tROM_REGION", strlen("\tROM_REGION")) == 0) {
				memset(cur_rom_type, 0, 32);
				split_str(file_line, cur_rom_type, "\"", "\"", 0);
				continue;
			}
			// if CRC is present in line, get it!
            char *crc32 = strstr(file_line, "CRC");
			if (crc32) get_rom_line(file_line);
		}

        if (strncmp(file_line + 0, "ROM_START", strlen("ROM_START")) == 0) {
	        split_str(file_line, mame_drv_list[cur_drv].romset_name, "ROM_START( ", " )", 0);
		    inside_drv = 1; continue;
        }

        if (strncmp(file_line + 0, "ROM_END", strlen("ROM_END")) == 0) {
			inside_drv = cur_rom = 0;
		    cur_drv++, total_drv_num++;
		}
	}    
}


int main(int argc, char **argv)
{

    mame_drv_file = fba_drv_file = NULL;

	// first open the MAME driver
	char *path = argv[1];
    mame_drv_file = fopen(argv[1], "rt");

	if (mame_drv_file == NULL) {
	    printf("File not found, please try again!\n");
		return 1;
	}

	fba_drv_file = fopen("drv.c", "wt");

	// clean up all driver list content!
    init_mame_drv_list();

	// check if we gonna store all BurnDriver struct at the end of the file
	if (argc > 2) {
	    if (strcmp(argv[2], "-e") == 0) drv_end_file = 1;
	}

	// get all drivers info and store them in driver list!
    get_driver();

	rewind(mame_drv_file);
	get_game_info_line();

	// dump drivers into the file!
	dump_mame_drv_list();

    fclose(mame_drv_file);
	fclose(fba_drv_file);

    // done!
	printf("%d drivers generated!\n", total_drv_num);
    return 0;
}
