#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "bitswap.h"

static void process_s1(unsigned char *NeoTextROM, int nTextROMSize, int nNeoTextROMFixType)
{
		/* Original code from mame - converted by FerchogtX */
		switch (nNeoTextROMFixType) {
			unsigned char *srom;
			unsigned char *dst;
			int i, j;

			case 1:
				/* Thanks also to HappyASR for the info */
				srom = NeoTextROM;
				dst  = (unsigned char *)malloc(nTextROMSize);
				if (dst) {
					memcpy(dst, srom, nTextROMSize);
					// descrambling the S1 by dorriGa
					for (j = 0; j < nTextROMSize ; j += 0x000010) {
						memcpy(srom + j, dst + j + 0x000008, 8);
						memcpy(srom + j + 0x000008, dst + j, 8);
					}
				}
				free(dst);
				break;

			case 2:
				/* Thanks to Badzou for the info */
				/* Descrambling S1 by dorriga */
				srom = NeoTextROM;
				dst  = (unsigned char*)malloc(nTextROMSize);
				int split = (nTextROMSize/4);
				memcpy(dst + split*0, srom + split*3, split);
				memcpy(dst + split*1, srom + split*2, split);
				memcpy(dst + split*2, srom + split*1, split);
				memcpy(dst + split*3, srom + split*0, split);
				memcpy(srom, dst, split);
				free(dst);
				break;

			case 3:
				/* Descrambling S1 by FerchogtX, based on DorriGa's code */
				srom = NeoTextROM;
				dst = (unsigned char*)malloc(nTextROMSize);
				memcpy( dst+0x00000, srom+(nTextROMSize/2), (nTextROMSize/2) );
				memcpy( dst+0x10000, srom+(nTextROMSize*0), (nTextROMSize/2) );
				memcpy( srom, dst, nTextROMSize );
				free(dst);
				break;

			case 4:
				/* Original code for MAME by fataku	*/
				/* This is for kf2k1pla			*/
			        srom = NeoTextROM;
			        for (i=0;i<nTextROMSize;i++) 
			        srom[i]=BITSWAP08(srom[i],3,2,4,5,1,6,0,7); 
				break;

			case 5:
				/* Original code taken from MAME	*/
				/* This is for CTHD2003			*/
				srom = NeoTextROM;
				dst = (unsigned char*)malloc(nTextROMSize/2);
				memcpy(dst+(nTextROMSize*0),srom+(nTextROMSize/2),(nTextROMSize/4));
				memcpy(dst+(nTextROMSize/4),srom+(nTextROMSize/4),(nTextROMSize/4));
				memcpy(srom+(nTextROMSize/4),dst+(nTextROMSize*0),(nTextROMSize/2)); 
				free(dst);
				break;
			case 6: 
				// Converted by Jimmy_Page
				srom = NeoTextROM; 
			        for (i=0;i<nTextROMSize;i++) 
			        srom[i]=BITSWAP08(srom[i],7,6,0,4,3,2,1,5);
				break;
			case 7:
				srom = NeoTextROM;  
			        for (i=0;i<nTextROMSize;i++) 
				srom[i]=BITSWAP08(srom[i]^0xd2,4,0,7,2,5,1,6,3 ); 
				break;
			case 8:
				srom = NeoTextROM;
				dst = (unsigned char*)malloc((nTextROMSize/4));
				memcpy(dst, srom, (nTextROMSize/4));
				for(i = 0; i < (nTextROMSize/4); i++){
					int ofst = BITSWAP24( (i & 0x1ffff),23,22,21,20,19,18,17,3,0,1,4,2,13,14,15,16,5,6,11,10,9,8,7,12);
					ofst += (i >> 17) << 17;
					dst[i] = srom[ofst];
				}
				free(dst);
				break;
		}
}

int main(int argc, char **argv)
  {
	FILE *s1_rom_in, *s1_rom_out;
	int nTextROMSize = 0;
	char name[0];
	int nNeoTextROMFixType;

	if (argc < 2) {
//		usage();
		return(1);
	}

	sscanf(argv[1],"%s",&name);
	sscanf(argv[2],"%d",&nNeoTextROMFixType);

	// Check input files
	if ((s1_rom_in=fopen(name,"rb"))==NULL)
	{
		fprintf(stderr,"Error: cannot read %s.",name);
		return(1);
	}
	fseek (s1_rom_in , 0 , SEEK_END);
	nTextROMSize += ftell (s1_rom_in);
	rewind (s1_rom_in);

	sscanf(argv[1],"%3s",&name);

	// Check output files
	sprintf(name,"%s-s1d.bin",name);
	if ((s1_rom_out=fopen(name,"wb"))==NULL)
	{
		fclose(s1_rom_out);
		fprintf(stderr,"Error: cannot write to.");
		return(1);
	}

	// Create buffer
	unsigned char *src = (unsigned char*)malloc(nTextROMSize);

	fread (src,1,nTextROMSize,s1_rom_in);
	fclose(s1_rom_in);

	process_s1(src, nTextROMSize, nNeoTextROMFixType);

	fwrite (src,1,nTextROMSize,s1_rom_out);
	fclose(s1_rom_out);

	printf("Finished");
	// Free buffer
	free(src); 
  }
