#include <stdio.h>
#include <string.h>

#define BITSWAP16(n, 														\
				  bit15, bit14, bit13, bit12, bit11, bit10, bit09, bit08,	\
				  bit07, bit06, bit05, bit04, bit03, bit02, bit01, bit00)	\
		(((((n) >> (bit15)) & 1) << 15) | 									\
		 ((((n) >> (bit14)) & 1) << 14) | 									\
		 ((((n) >> (bit13)) & 1) << 13) | 									\
		 ((((n) >> (bit12)) & 1) << 12) | 									\
		 ((((n) >> (bit11)) & 1) << 11) | 									\
		 ((((n) >> (bit10)) & 1) << 10) | 									\
		 ((((n) >> (bit09)) & 1) <<  9) | 									\
		 ((((n) >> (bit08)) & 1) <<  8) | 									\
		 ((((n) >> (bit07)) & 1) <<  7) | 									\
		 ((((n) >> (bit06)) & 1) <<  6) | 									\
		 ((((n) >> (bit05)) & 1) <<  5) | 									\
		 ((((n) >> (bit04)) & 1) <<  4) | 									\
		 ((((n) >> (bit03)) & 1) <<  3) | 									\
		 ((((n) >> (bit02)) & 1) <<  2) | 									\
		 ((((n) >> (bit01)) & 1) <<  1) | 									\
		 ((((n) >> (bit00)) & 1) <<  0))

static const unsigned char m1_address_8_15_xor[256] =
{
	0xf5, 0x8d, 0x48, 0x50, 0x98, 0x21, 0xe2, 0x4e, 0x87, 0x3b, 0xb0, 0x4a, 0xb4, 0xe7, 0x89, 0x22,
	0xee, 0x1d, 0xc9, 0x5e, 0x7d, 0xfc, 0x67, 0x5f, 0xef, 0xa0, 0xc0, 0x29, 0xe0, 0x6f, 0x95, 0xf4,
	0x8f, 0x1f, 0x9b, 0x34, 0x60, 0xc7, 0x74, 0xac, 0xfb, 0x35, 0x07, 0x2f, 0xf8, 0x97, 0xa9, 0xcd,
	0x51, 0xe3, 0xd1, 0xb7, 0x9c, 0x6d, 0x65, 0x63, 0xbb, 0x7a, 0xbe, 0xbf, 0xf6, 0x3f, 0x37, 0x40,
	0x15, 0x44, 0x08, 0xd2, 0x66, 0xde, 0x09, 0x45, 0xea, 0x31, 0x54, 0x4f, 0xd5, 0x9f, 0x43, 0x0e,
	0x0f, 0x61, 0x2a, 0x68, 0x27, 0xb1, 0xeb, 0x62, 0xbd, 0xb2, 0xd3, 0xa3, 0xd4, 0x59, 0x1e, 0x58,
	0x10, 0xda, 0xcc, 0x85, 0x14, 0x18, 0xe4, 0x92, 0xb3, 0xad, 0xd9, 0x9d, 0x49, 0xca, 0x41, 0x7f,
	0xfe, 0x42, 0x02, 0xc8, 0x06, 0xb8, 0xaa, 0x8e, 0x4b, 0x0d, 0x00, 0xd8, 0x05, 0xdc, 0x36, 0x7c,
	0xe8, 0xc6, 0xec, 0xf2, 0x38, 0x79, 0xe9, 0x13, 0xb6, 0x90, 0x01, 0xcb, 0xfa, 0x70, 0xff, 0x19,
	0x5b, 0x25, 0x84, 0x3e, 0x0c, 0x0b, 0x26, 0x8a, 0xd7, 0x99, 0x78, 0x57, 0xba, 0x93, 0xdf, 0x16,
	0x88, 0x6c, 0x81, 0xc3, 0xe1, 0x8b, 0x0a, 0x73, 0xc1, 0x6b, 0x2b, 0x3d, 0xa5, 0xf9, 0xf1, 0x17,
	0xc2, 0x56, 0x4d, 0x1c, 0x1b, 0xdd, 0x30, 0xdb, 0x71, 0x94, 0x75, 0x72, 0x7b, 0xb5, 0x2d, 0x6e,
	0x77, 0x86, 0xa8, 0x5a, 0xf0, 0x32, 0x46, 0x53, 0xc4, 0x55, 0x4c, 0x2e, 0x11, 0xce, 0x7e, 0x83,
	0x28, 0x76, 0x2c, 0x69, 0xbc, 0x3a, 0x39, 0x3c, 0x96, 0x80, 0xb9, 0x20, 0xcf, 0xa4, 0x91, 0x1a,
	0xf7, 0x6a, 0x64, 0x04, 0x47, 0xa7, 0xf3, 0x9e, 0xaf, 0xa2, 0xc5, 0x5d, 0xd6, 0xed, 0x03, 0xae,
	0x82, 0xe5, 0xfd, 0x9a, 0xab, 0xa1, 0xe6, 0x33, 0x23, 0x24, 0x8c, 0x12, 0x52, 0xa6, 0xd0, 0x5c,
};

static const unsigned char m1_address_0_7_xor[256] =
{
	0x29, 0x2e, 0x10, 0x95, 0x34, 0xb1, 0xf4, 0x1e, 0x35, 0x55, 0xb0, 0xe5, 0x7d, 0xa3, 0x15, 0x89,
	0x5a, 0x14, 0x37, 0x4a, 0xe1, 0x4f, 0x4c, 0xfb, 0x36, 0xbc, 0x9f, 0x45, 0x98, 0x0c, 0x79, 0x3d,
	0xf0, 0x81, 0x76, 0x2a, 0x31, 0x60, 0x52, 0x06, 0x1b, 0x8e, 0xec, 0x70, 0x19, 0x01, 0xed, 0x88,
	0x3e, 0x5c, 0xe8, 0xf5, 0x9b, 0x49, 0xa8, 0xb3, 0xf3, 0x3f, 0x09, 0xd1, 0x4b, 0xf1, 0x7c, 0xa1,
	0x66, 0x1c, 0xbd, 0x07, 0x24, 0xce, 0x03, 0x68, 0xd8, 0xe2, 0x18, 0x38, 0x33, 0xae, 0xd2, 0x05,
	0x2d, 0xdf, 0x92, 0x87, 0x91, 0x1f, 0xd0, 0x8a, 0x71, 0xeb, 0x73, 0xb6, 0x12, 0x25, 0x82, 0x61,
	0xc3, 0x00, 0xa7, 0xba, 0x78, 0x21, 0x4d, 0xd5, 0x96, 0x46, 0x22, 0xc1, 0x97, 0xd9, 0xf9, 0x2f,
	0xca, 0x47, 0x40, 0xd4, 0x44, 0x6c, 0x58, 0x94, 0x9a, 0xe6, 0xdc, 0xf7, 0x2b, 0x04, 0x28, 0x1a,
	0x53, 0xc6, 0x7a, 0x51, 0xcd, 0xa0, 0x63, 0x32, 0x57, 0x83, 0x6a, 0x90, 0x77, 0xef, 0x8d, 0x54,
	0x0f, 0x2c, 0xad, 0x69, 0x75, 0xbe, 0xa2, 0x56, 0xbf, 0x59, 0x80, 0xfa, 0xa5, 0x84, 0x3b, 0xa4,
	0xcc, 0x3c, 0x93, 0x02, 0x85, 0xfc, 0xea, 0xa6, 0x39, 0x11, 0xb7, 0xda, 0xf2, 0x7b, 0xab, 0xee,
	0x5b, 0xdd, 0xe0, 0x7f, 0xc0, 0x62, 0xb8, 0xdb, 0xe7, 0xa9, 0x0d, 0xaa, 0xb2, 0xc7, 0x4e, 0xd6,
	0x65, 0x64, 0x6d, 0xcf, 0x6e, 0xb5, 0x5e, 0xf6, 0xc9, 0x6b, 0xe4, 0xe3, 0xfe, 0x7e, 0xde, 0x48,
	0x0a, 0xc8, 0x0e, 0x8b, 0xe9, 0x1d, 0x20, 0x23, 0x67, 0xb4, 0x5f, 0x16, 0x74, 0x27, 0x41, 0x99,
	0x8f, 0xf8, 0xb9, 0xc5, 0x72, 0x3a, 0xc4, 0xbb, 0x50, 0x6f, 0xd7, 0x9c, 0x5d, 0x30, 0xcb, 0xff,
	0x9e, 0x86, 0x8c, 0xac, 0x42, 0x13, 0x9d, 0xaf, 0x26, 0x17, 0xc2, 0xd3, 0x08, 0xfd, 0x43, 0x0b,
};

// inverse function, used to encrypt instead
int m1_address_scramble_inv(int address, unsigned short key)
{
	int block;
	int aux;

	const int p1[8][16] = {
		{8,4,5,6,15,14,12,3,7,13,2,10,9,11,1,0},
		{13,1,6,7,10,8,14,0,2,5,12,3,15,9,11,4},
		{9,7,10,3,8,11,1,5,0,15,4,13,14,12,2,6},
		{10,12,0,4,5,15,9,7,1,3,11,6,13,8,14,2},
		{14,0,13,5,9,12,2,10,6,8,7,15,11,1,4,3},
		{5,11,7,2,3,13,8,4,12,6,14,0,10,15,9,1},
		{11,6,15,10,14,1,4,13,3,9,0,8,12,2,7,5},
		{3,14,4,1,6,10,15,2,11,0,9,7,5,13,8,12},
	};

	block = (address>>16)&7;
	aux = address&0xffff;

	aux = BITSWAP16(aux, 14,13,10,9,7,5,3,1,15,12,11,8,6,4,2,0);
	aux ^= m1_address_8_15_xor[aux&0xff]<<8;
	aux ^= m1_address_0_7_xor[(aux>>8)&0xff];
	aux = BITSWAP16(aux,
		p1[block][15],p1[block][14],p1[block][13],p1[block][12],
		p1[block][11],p1[block][10],p1[block][9],p1[block][8],
		p1[block][7],p1[block][6],p1[block][5],p1[block][4],
		p1[block][3],p1[block][2],p1[block][1],p1[block][0]);
	aux ^= key;

	return (block<<16)|aux;
}

int m1_address_scramble(int address, unsigned short key)
{
	int block;
	int aux;

	const int p1[8][16] = {
		{15,14,10,7,1,2,3,8,0,12,11,13,6,9,5,4},
		{7,1,8,11,15,9,2,3,5,13,4,14,10,0,6,12},
		{8,6,14,3,10,7,15,1,4,0,2,5,13,11,12,9},
		{2,8,15,9,3,4,11,7,13,6,0,10,1,12,14,5},
		{1,13,6,15,14,3,8,10,9,4,7,12,5,2,0,11},
		{11,15,3,4,7,0,9,2,6,14,12,1,8,5,10,13},
		{10,5,13,8,6,15,1,14,11,9,3,0,12,7,4,2},
		{9,3,7,0,2,12,4,11,14,10,5,8,15,13,1,6},
	};

	block = (address>>16)&7;
	aux = address&0xffff;

	aux ^= key;
	aux = BITSWAP16(aux,
		p1[block][15],p1[block][14],p1[block][13],p1[block][12],
		p1[block][11],p1[block][10],p1[block][9],p1[block][8],
		p1[block][7],p1[block][6],p1[block][5],p1[block][4],
		p1[block][3],p1[block][2],p1[block][1],p1[block][0]);
	aux ^= m1_address_0_7_xor[(aux>>8)&0xff];
	aux ^= m1_address_8_15_xor[aux&0xff]<<8;
	aux = BITSWAP16(aux, 7,15,14,6,5,13,12,4,11,3,10,2,9,1,8,0);

	return (block<<16)|aux;
}


void neogeo_cmc50_m1_crypt(unsigned char *src, int size, /*unsigned short key,*/ int encrypt)
{
	int i;
	unsigned char * buf = (unsigned char*)malloc(size);

	unsigned short key = 0;

	for (i = 0; i < 0x10000; i++) {
		key += src[i];
	}

	key = BITSWAP16(key ^ 0xffff,12,0,2,4,8,15,7,13,10,1,3,6,11,9,14,5);

	printf ("Using key: %4.4x\n", key);

	if (encrypt) {
		for (i = 0; i < size; i++)
		{
			buf[i] = src[m1_address_scramble_inv(i,key)];
		}
	} else {
		for (i = 0; i < size; i++)
		{
			buf[i] = src[m1_address_scramble(i,key)];
		}
	}

	memcpy (src, buf, size);

	free (buf);
}

unsigned int sscanf0(char *ptr)
{
	unsigned int r = 0;

	int i, s = strlen(ptr);
	for (i = 0; i < s; i++)
	{
		r <<= 4;

		int t = ptr[i];

		if ((t & 0xd0) == 0x40 && (t & 0x0f) < 7 && (t & 0x0f))
			r |= (t & 0x0f) + 9;

		if ((t & 0xf0) == 0x30 && (t & 0x0f) < 0x0a)
			r |= (t & 0x0f);
	}

	return r;
}

int main()
{
	char filename[128];
//	char keyf[64];
//	unsigned short key = 0;
	char tmp[128];
	int encrypt = 0;

	printf ("Please type the name of the file you wish to work with:\n");
	gets (filename);

	FILE *fz = fopen(filename, "rb");
	if (fz == NULL) {
		printf ("%s not found.\n", filename);
		return 1;
	}

//	printf ("\nPlease type the key:\n");
//	gets (keyf);
//	key = sscanf0(keyf);

	printf ("\nEncrypt or decrypt this file: (e/d)\n");
	gets (tmp);
	if (tmp[0] == 'e' || tmp[0] == 'E') {
		encrypt = 1;
	}

	system ("cls");
	printf ("\n%scrypting %s\n", encrypt ? "En" : "De", filename);

	fseek (fz, 0, SEEK_END);
	int len = ftell(fz);
	rewind (fz);

	unsigned char *src = (unsigned char*)malloc(len);

	fread (src, len, 1, fz);
	fclose (fz);

	strcat (filename, encrypt ? ".encrypted" : ".decrypted");

	neogeo_cmc50_m1_crypt(src, len, /*key, */encrypt);

	fz = fopen(filename, "wb");
	fwrite (src, len, 1, fz);
	fclose (fz);

	free (src);

	printf ("\nFinished -- %s was written.\n", filename);

	return 0;
}
