#include <stdio.h>
#include <stdlib.h>
#include <string.h>

unsigned int sscanf0(char *p)
{
	unsigned int k = 0;

	while (p[0] != '\0') {
		if (p[0] == '\0') break;
		k <<= 4;
		if ((p[0] & 0xf0) == 0x30) k |= p[0] & 0x0f;
		if ((p[0] & 0xb0) == 0x40) k |= (p[0] & 0x0f) + 9;
		p++;
	}

	return k;
}

int main(int argc, char *argv[])
{
	char datname[128];
	char outname[128];
	char szLine[1024];

	outname[0] = -1;

	if (argc > 1) {
		strcpy (datname, argv[1]);
		printf ("%s\n");
	} else {
		printf ("Please type the dat name\n");
		gets (datname);
	}

	FILE *fk = fopen(datname, "rb");

	unsigned char *tmp = (unsigned char*)malloc(0x2000000); // 32mb
	memset (tmp, 0, 0x2000000);

	int max = 0;

	while (1)
	{
		if (fgets (szLine, 1024, fk) == NULL) break;

		int i = 0;
		char *ptr = szLine;

		if (szLine[0] == '#')
		{
			i = 0;
			ptr++;
			while (ptr[0] != '#') {
				outname[i] = ptr[0];
				i++, ptr++;
			}
			outname[i] = '\0';

			printf ("%s|", outname);
			continue;
		}

		i = 0;
		char fname[128];
		while (ptr[0] != ',')
		{
			fname[i] = ptr[0];
			i++, ptr++;
		}
		fname[i] = '\0';

		if (ptr[0] == ',') ptr++;

		char ttmp[128];

		i = 0;
		while (ptr[0] != ',') {
			ttmp[i] = ptr[0];
			i++, ptr++;
		}
		ttmp[i] = '\0';

		if (ptr[0] == ',') ptr++;

		int inmem_offset = sscanf0(ttmp);
			inmem_offset /= 2;

		i = 0;
		while (ptr[0] != ',') {
			ttmp[i] = ptr[0];
			i++, ptr++;
		}
		ttmp[i] = '\0';

		if (ptr[0] == ',') ptr++;

		int infile_offset = sscanf0(ttmp);

		i = 0;
		while (ptr[0] != ',') {
			ttmp[i] = ptr[0];
			i++, ptr++;
		}
		ttmp[i] = '\0';

		if (ptr[0] == ',') ptr++;

		int file_block_size = sscanf0(ttmp);

		printf ("%s %5.5x, %5.5x, %5.5x\n", fname, inmem_offset, infile_offset, file_block_size);

		FILE *fz = fopen(fname, "rb");

		fseek (fz, infile_offset, SEEK_SET);

		fread (tmp + inmem_offset, file_block_size, 1, fz);
		fclose (fz);

		if ((inmem_offset + file_block_size) > max) {
			max = inmem_offset + file_block_size;
		}
	}


	FILE *fz;

	if (outname[0] == -1) {
		fz = fopen("output.bin", "wb");
	} else {
		fz = fopen(outname, "wb");
	}	

	fwrite (tmp, max, 1, fz);
	fclose (fz);

	free (tmp);

	fclose (fk);
}
