// IQ_132's CRC32 Hacking Tool
// This will modify the last 4 bytes of a file in order to match a target CRC32
// This source and program are licensed under the WTFPL with one additional 
// stipulation -- Binaries and sources cannot be used for commercial purposes.
// http://sam.zoy.org/wtfpl/COPYING

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static unsigned char *src;
static int len;
static unsigned int *crc_table;

#define crc_tab(x) crc_table[(unsigned char)(x)]

static unsigned int fill_crc_table(unsigned char a)
{
	unsigned int b = 0;

	if (a & 0x01) b ^= 0x77073096;
	if (a & 0x02) b ^= 0xEE0E612C;
	if (a & 0x04) b ^= 0x076DC419;
	if (a & 0x08) b ^= 0x0EDB8832;
	if (a & 0x10) b ^= 0x1DB71064;
	if (a & 0x20) b ^= 0x3B6E20C8;
	if (a & 0x40) b ^= 0x76DC4190;
	if (a & 0x80) b ^= 0xEDB88320;

	return b;
}

static unsigned int start_crc32()
{
	int i;
	unsigned int crc = ~0;

	crc_table = (unsigned int*)malloc(256 * sizeof(int));

	// fill the crc hash table -- speedup
	for (i = 0; i < 256; i++) {
		crc_table[i] = fill_crc_table(i);
	}

	// get the crc32 of data up until the last 4 bytes
	for (i = 0; i < len - 4; i++) {
		crc = crc_tab(crc ^ src[i]) ^ (crc >> 8);
	}

	return crc;
}

static int crc32_hack(unsigned int good)
{
	unsigned int crc_start = start_crc32();// Get starting CRC32
	unsigned char *psrc = src + (len - 4); // Point to last 4 bytes
	unsigned int *p = (unsigned int*)psrc; // Long pointer

	p[0] = 0;

	while (1)
	{
		// Calculate CRC32 of all data + last 4 bytes
		unsigned int crc2 = crc_tab(crc_start ^ psrc[0]) ^ (crc_start >> 8);
		crc2 = crc_tab(crc2 ^ psrc[1]) ^ (crc2 >> 8);
		crc2 = crc_tab(crc2 ^ psrc[2]) ^ (crc2 >> 8);
		crc2 = crc_tab(crc2 ^ psrc[3]) ^ (crc2 >> 8);

		if (crc2 == good) {
			printf ("\nSuccess!\nAddress = %8.8x, data = %8.8x\n", (len - 4), p[0]);
			return 1;
		}

		// Status updates
		if ((p[0] & 0xfffffff) == 0xfffffff) {
			printf ("Check of range %8.8x - %8.8x complete.\n", (p[0] >> 28) << 28, p[0]);
		}

		if (p[0] == 0xffffffff) return 0; // failure

		p[0]++;
	}

	return 0; // Should never reach here (epic failure)
}

// Convert string to integer (target hash)
static unsigned int get_hash_from_string(char *string)
{
	int i;
	unsigned int ret = 0;

	for (i = 0; i < 8; i++)
	{
		if (string[i] == 0) break; // termination

		ret <<= 4;
		if ((string[i] & 0xf0) == 0x30 && (string[i] & 0x0f) < 10)                       ret |= string[i] & 0x0f;      //0-9
		if ((string[i] & 0xd0) == 0x40 && (string[i] & 0x0f) <  7 && (string[i] & 0x0f)) ret |=(string[i] & 0x07) + 9; //a-f
	}

	return ret;
}

int main()
{
	FILE *fa;
	char name[128];
	char hash[32];

	printf ("File name:\n");
	gets (name);

	printf ("\nTarget CRC32:\n");
	gets (hash);

	fa = fopen(name, "rb");

	if (fa == NULL) {
		printf ("%s not found.\n", name);
		return 0;
	}

	fseek (fa, 0, SEEK_END);
	len = ftell (fa);
	rewind (fa);

	src = (unsigned char*)malloc(len);

	fread (src, len, 1, fa);
	fclose (fa);

	if (crc32_hack(get_hash_from_string(hash) ^ 0xffffffff))
	{
		strcat (name, "_hack");

		fa = fopen(name, "wb");
		fwrite (src, len, 1, fa);
		fclose (fa);
	}
	else
	{
		printf ("Failure. :(\n");
	}

	free (src);
	free (crc_table);

	src = NULL;
	crc_table = NULL;

	return 1;
}
