#include <stdio.h>

/* Code by IQ_132.  You may use this in any way you wish, just leave this line intact. */

int main()
{
	FILE *p1_rom_in, *p1_rom_out, *p2_rom_out;

	if ((p1_rom_in=fopen("269-p1.bin","rb"))==NULL)
	{
		fprintf(stderr,"Error: cannot read 269-p1.bin"); return(1);
	}
	if ((p1_rom_out=fopen("269-p1a.bin","wb"))==NULL)
	{
		fclose(p1_rom_out); fprintf(stderr,"Error: cannot write to 269-p1a.bin"); return(1);
	}
	if ((p2_rom_out=fopen("269-p2a.bin","wb"))==NULL)
	{
		fclose(p2_rom_out); fprintf(stderr,"Error: cannot write to 269-p2a.bin"); return(1);
	}

	unsigned char *src = (unsigned char*)malloc(0x800000);
	unsigned char* dst = (unsigned char*)malloc(0x800000);

	printf("Reading File\n");
	fread (src+0x000000,1,0x800000, p1_rom_in);	fclose(p1_rom_in);

	printf("Processing\n");
	int i,j=0;
	for (i=0;i<0x400000;i=i+2){
		memcpy(dst+i, src+j+0, 2);
		memcpy(dst+i+0x400000, src+j+2, 2);
		j=j+4;
	}
	free(src);

	printf("Writing Files\n");
	fwrite (dst+0x000000,1,0x400000,p1_rom_out);	fclose(p1_rom_out);
	fwrite (dst+0x400000,1,0x400000,p2_rom_out);	fclose(p2_rom_out);

	free(dst);
	printf("Finished");
}
