// By IQ_132
// http://neosource.1emu.net
//


// 14-06-08 revision 0
// 	everything!

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

// Maximum number of drivers allowed in the list
#define MAX_DRIVER		4096

// Comment this line to show debug drivers
//#define HIDE_DEBUG_DRIVERS

// Comment this line to have drivers properly alphabetized (skipping "The")
#define SKIP_THE

#define PC_BUILD
//#define XBOX


int main()
{
	int i, j, k;
	int maxDriverLength = 0;

	FILE *fz, *fp, *fo;

	char vLine[1024];
	char szLine[1024];
	char fAddress[1024];

	int driverloc = 0;

	char *titlelist[MAX_DRIVER];
	char *driverlist[MAX_DRIVER];

	unsigned char *drivers = (unsigned char*)malloc(MAX_DRIVER * 0x100);
	unsigned char *titles  = (unsigned char*)malloc(MAX_DRIVER * 0x200);
	unsigned int *drivertype = (unsigned int*)malloc(MAX_DRIVER * sizeof (int));		// 0 = reg, 1 = d, 2 = x

	memset (drivers,    0, MAX_DRIVER * 0x100);
	memset (titles,     0, MAX_DRIVER * 0x200);
	memset (drivertype, 0, MAX_DRIVER * sizeof(int));

	for (i = 0; i < MAX_DRIVER; i++) {
		driverlist[i] = (char*)drivers + (i * 0x100);
		titlelist[i] = (char*)titles + (i * 0x200);
	}


#ifdef PC_BUILD

	  // by kenshiro, 18/07/2008

     int x, y;
     int counter = 0;
	 char fileAdress[256] = "";


      fz = fopen("makefile.mingw", "rt");
	  //fz = fopen("makefile.vc", "rt");

	  //  first take the line which contains all drivers directories

	  char *begin;
      char directory[2048];

	  while (1)
      {
	       fgets(directory, 2048, fz);
		   begin = strstr(directory, "alldir");
           if (begin) break;
      }

	  int lineSize = strlen(directory);
	  int numberOfDir = 0;

	  // go over the line to get the number of directory (to take less ram)


	  for (x = 0; x < lineSize; x++)
      {
          if (strncmp(directory + x, "burn/", 5) == 0)
		  {
		      numberOfDir++;
		  }
      }

	  // store directories in RAM

	  unsigned char *driversDir = (unsigned char*)malloc(numberOfDir * 0x200);

	  int tempCount = 0;

	  for (x = 0; x < lineSize; x++)
      {

          if (strncmp(directory + x, "burn/", 5) == 0)
		  {
		      char tempName[128] = "";
			  y = 0;

			  while (strncmp(directory + x, " ", 1) != 0)
			  {
			        if (directory[x] == '/')
                    {
                        strcat(tempName, "\\");
                    }

			        else
					{
					     tempName[y] = directory[x];
				    }

                    x++;
					y++;
			  }

			  memcpy(driversDir + (tempCount * 0x100), tempName, 0x100);
              tempCount++;
		  }
      }

     // now take all the drivers files

	 char line[1024];
	 char fileName[128];

	 char *driver;
	 char *end;

	 int numberOfDriver = 0;
     int tempCount2 = 0;

	 // first get the number of drivers to reduce the amount of RAM

	  while (1)
	 {

		 fgets(line, 1024, fz);

		 end = strstr(line, "depobj");    // end of drivers
		 if (end) break;

		 lineSize = strlen(line);
		 driver = strstr(line, "d_");

		 if (driver)
		 {
               // go over the line and get drivers one by one

		       for (x = 0; x < lineSize; x++)
			   {
			      if (strncmp(line + x, "d_", 2) == 0)
				  {
				     tempCount2++;
				  }
			   }
		 }
     }

     rewind(fz);

	 // now store drivers names in RAM

	 unsigned char *driverObjList = (unsigned char*) malloc(tempCount2 * 0x100);

	 while (1)
	 {

		 fgets(line, 1024, fz);

		 end = strstr(line, "depobj");    // end of drivers
		 if (end) break;

		 lineSize = strlen(line);
		 driver = strstr(line, "d_");

		 if (driver)
		 {
               // go over the line and get drivers one by one

		       for (x = 0; x < lineSize; x++)
			   {
			      if (strncmp(line + x, "d_", 2) == 0)
				  {
				     char tempName[256] = "";
				     y = 0;

				     while (strncmp(line + x, ".o", 2) != 0)
					 {
					       tempName[y] = line[x];
                           x++;
                           y++;
					 }

					 sprintf(fileName, "%s.cpp", tempName);

					 memcpy(driverObjList + (numberOfDriver * 0x100), fileName, 0x100);
					 numberOfDriver++;
				  }
			   }
		 }
     }

	 // now get complete paths list!

     FILE *mouk = NULL;
	 char fullPath[512] = "";

	 unsigned char *pathList = (unsigned char*)malloc(numberOfDriver * 0x200);

     for (x = 0; x < numberOfDriver; x++)
     {
	     // first select the driver's name

         char tempName[256] = "";
		 sprintf(tempName, "%s", driverObjList + (x * 0x100));

		 // then find in which folder he is

		 for (y = 0; y < numberOfDir; y++)
		 {
		     char tempName2[256] = "";
			 sprintf(tempName2, "%s", driversDir + (y * 0x100));

			 sprintf(fullPath, "src\\%s\\%s", tempName2, tempName);

			 mouk = fopen(fullPath, "rt");

			 if (mouk != NULL)
			 {
			    memcpy(pathList + (x * 0x200), fullPath, 0x200);
				fclose(mouk);
				break;
			 }
		 }
     }

     // done!

	 free(driversDir);
	 free(driverObjList);

#endif


#ifdef XBOX
	fz = fopen("FBA.vcproj", "rt");
#endif



	while (1)
	{

#ifdef XBOX

        if (fgets(vLine, 1024, fz) == NULL)
			break;

		int nLen = (int)strlen(vLine);

		// find driver file (must start with d_...)

		int cont = 0;
		for (i = 0; i < nLen - 3; i++)
		{
			if (strncmp (vLine + i, "\\d_", 3) == 0) {
				cont = 1;
			}
		}
		if (!cont) continue;
		cont = 0;

		// now get file address
		char *relpath = "RelativePath=\".\\";
		int relpathlen = strlen (relpath);
		for (i = 0; i < nLen; i++)
		{
			if (strncmp (vLine + i, relpath, relpathlen) == 0) {
				char *addr = vLine + i + relpathlen;
				char *dest = fAddress;
				j = i;
				while (j < nLen) {
					dest[0] = addr[0];
					dest++;
					addr++;
					j++;
					if (addr[0] == '\"') {
						dest[0] = '\0';
						break;
					}
				}
				break;
			}
		}

		fp = fopen(fAddress, "rt");
		if (fp == NULL) {
			continue;
		}
#endif

#ifdef PC_BUILD

        // get file adress!

        if (counter == numberOfDriver) break;

		sprintf(fileAdress, "%s", pathList + ( counter * 0x200));
		fp = fopen(fileAdress, "rt");
        counter++;

		if (fp == NULL) {
			continue;
		}

#endif


		int incomment = 0;
		while (1)
		{
			if (fgets (szLine, 1024, fp) == NULL)
				break;

			int rLen = strlen(szLine);

			// check every line for comment code - slow!
			for (i = 0; i < rLen-2; i++) {
				if (strncmp (szLine + i, "/*", 2) == 0) {
					i+=2;
					incomment = 1;
				}
				if (incomment) {
					if (strncmp (szLine + i, "*/", 2) == 0) {
						i+=2;
						incomment = 0;
					}
				}
			}

			if (incomment) continue;
			if (rLen < 17) continue; // speedup!

			char *burndrv = "struct BurnDriver ";
			int burndrvlen = strlen(burndrv);

			char *burndrvd = "struct BurnDriverD ";
			int burndrvdlen = strlen(burndrvd);

			char *burndrvx = "struct BurnDriverX ";
			int burndrvxlen = strlen(burndrvx);

			int zLen = 0;
			for (i = 0; i < rLen; i++) {
				if (strncmp (szLine + i, burndrv , burndrvlen ) == 0)
					zLen = burndrvlen;

				if (strncmp (szLine + i, burndrvd, burndrvdlen) == 0
				 || strncmp (szLine + i, burndrvx, burndrvxlen) == 0)
					zLen = burndrvdlen;

				if (!zLen) continue;

				char *dest = driverlist[driverloc];
				char *src  = szLine + i + zLen;
				while (1){
					dest[0] = src[0];
					dest++;
					src++;

					if (src[0] == ' ' || src[0] == '=' || src[0] == '\t' || src[0] == '\n') {
						dest[0] = '\0';

						drivertype[driverloc] = (szLine[i + 17] >> 2) & 3;

						// for after, to align game titles in file

                        if (strlen(driverlist[driverloc]) > maxDriverLength )
						{
						   maxDriverLength = strlen(driverlist[driverloc]);
						}
						break;
					}
				}

				break;
			}

			if (strlen(driverlist[driverloc]) < 7) continue;

			// make sure this isn't in the driverlist already!
			int pastbrk = 0;
			for (i = 0; i < driverloc; i++) {
				if (strcmp (driverlist[i], driverlist[driverloc]) == 0) {
					memset (driverlist[driverloc], 0, 512);
					pastbrk = 1;
					break;
				}
			}
			if (pastbrk) continue;

			// either line with { or with set name/parent/year info
			if (fgets (szLine, 1024, fp) == NULL)
				break;

			rLen = strlen(szLine);

			// the above line was {, so get the name/parent/year info
			if (rLen < 5) {
				if (fgets (szLine, 1024, fp) == NULL)
					break;
			}

			// great! now get the title
			if (fgets (szLine, 1024, fp) == NULL)
				break;

			char *src = szLine;
			char *dst = titlelist[driverloc];

			while (1) {
				if (src[0] == '\"') break;
				src++;
			}

			src++; // past quote

			while (src[0] != '\\') {
				dst[0] = src[0];
				src++;
				dst++;
			}
			dst[0] = '\0';

			driverloc++;

			if (driverloc == MAX_DRIVER) break;
		}

		fclose (fp);

		if (driverloc == MAX_DRIVER) break;
	}

	fclose (fz);

#ifdef PC_BUILD
	free (pathList);
#endif

///////////
// change "The..." to "..., The"

#ifdef SKIP_THE
	{
		char tmp[512];

		for (i = 0; i < driverloc; i++)
		{
			if (strncmp ("The ", titlelist[i], 4) != 0)
				continue;

			strncpy (tmp, titlelist[i] + 4, strlen(titlelist[i])-3);
			strcat (tmp, ", The");

			strcpy (titlelist[i], tmp);
		}
	}
#endif

///////////
// alphabetize the list

	{
		char *titlelist2[MAX_DRIVER];
		char *driverlist2[MAX_DRIVER];

		unsigned char *drivers2 = (unsigned char*)malloc(MAX_DRIVER * 0x100);
		unsigned char *titles2  = (unsigned char*)malloc(MAX_DRIVER * 0x200);
		unsigned int *drivertype2 = (unsigned int*)malloc(MAX_DRIVER * sizeof(int));		// 0 = reg, 1 = d, 2 = x

		for (i = 0; i < MAX_DRIVER; i++) {
			driverlist2[i] = (char*)drivers2 + (i * 0x100);
			titlelist2[i] = (char*)titles2 + (i * 0x200);
		}

		memcpy (drivers2,    drivers,    MAX_DRIVER * 0x100);
		memcpy (titles2,     titles,     MAX_DRIVER * 0x200);
		memcpy (drivertype2, drivertype, MAX_DRIVER * sizeof(int));

		memset (drivers,    0, MAX_DRIVER * 0x100);
		memset (titles,     0, MAX_DRIVER * 0x200);
		memset (drivertype, 0, MAX_DRIVER * sizeof (int));

		int pos = 0;
		i = 0;
		j = 1;

		// This actually turned out to be much more simple & fast than I anticipated

		while (1)
		{
			if (pos == driverloc) break;

			if (strcmp (titlelist2[i], titlelist2[j]) <= 0) {
				j++;
				j %= driverloc;
			} else {
				i++;
				i %= driverloc;
				j = i + 1;
				j %= driverloc;
			}

			if (j == i) {
				strcpy (titlelist[pos],   titlelist2[i]);
				strcpy (driverlist[pos],  driverlist2[i]);
				drivertype[pos] = drivertype2[i];

				memset (titlelist2[i], 0xff, 128);

				pos++;
			}
		}

		free (drivers2);
		free (titles2);
		free (drivertype2);
	}

/////////////
// dump the driverlist

	fo = fopen("src\\generated\\driverlist.h", "wt");

	time_t rawtime;
	struct tm * timeinfo;

	time ( &rawtime );
	timeinfo = localtime ( &rawtime );

	fprintf (fo, "// This file was generated %s\n\n", asctime (timeinfo));
	fprintf (fo, "// Declaration of all drivers\n");
	fprintf (fo, "#define DRV extern struct BurnDriver\n");

	int prevtype = 0;

	for (i = 0; i < driverloc; i++)
	{
		int type = drivertype[i];

#ifdef HIDE_DEBUG_DRIVERS
		if (type == 1) continue;
#endif

		if (type == 1 && (prevtype != 1 || i == 0)) {
			fprintf (fo, "#if defined FBA_DEBUG\n");
		}

		if (prevtype == 1 && type != 1) {
			fprintf (fo, "#endif\n");
		}

		prevtype = type;

		if (type != 2) fprintf (fo, "DRV	%s;\n", driverlist[i]);
	}

	if (prevtype == 1) fprintf (fo, "#endif\n");

	fprintf (fo, "#undef DRV\n\n");


	fprintf (fo, "// Structure containing addresses of all drivers\n");
	fprintf (fo, "// Needs to be kept sorted (using the full game name as the key) to prevent problems with the gamelist in Kaillera\n");
	fprintf (fo, "static struct BurnDriver* pDriver[] = {\n");

	prevtype = 0;
	for (i = 0; i < driverloc; i++)
	{
		int type = drivertype[i];

#ifdef HIDE_DEBUG_DRIVERS
		if (type == 1) continue;
#endif

		if ((type == 1 && prevtype != 1) || (type == 1 && i == 0)) {
			fprintf (fo, "#if defined FBA_DEBUG\n");
		}

		if (prevtype == 1 && type != 1) {
			fprintf (fo, "#endif\n");
		}

		prevtype = type;

        char space[5] = "";
		int driverSize = strlen(driverlist[i]);

		if (driverSize < maxDriverLength)
        {
		   for (int i = maxDriverLength; i > driverSize; i--)
		   {
		       strcat(space, " ");
	       }
        }

		if (type != 2) fprintf (fo, "	&%s,   %s// %s\n", driverlist[i], space,  titlelist[i]);
	}

	if (prevtype == 1) fprintf (fo, "#endif\n");

	fprintf (fo, "};\n\n");


	fprintf (fo, "static struct BurnDriver* pAllDrivers[] = {\n");

	int totallisted = 0;

	prevtype = 0;
	for (i = 0; i < driverloc; i++)
	{
		int type = drivertype[i];

#ifdef HIDE_DEBUG_DRIVERS
		if (type == 1) continue;
#endif

		if ((type == 1 && prevtype != 1) || (type == 1 && i == 0)) {
			fprintf (fo, "#if defined FBA_DEBUG\n");
		}

		if (prevtype == 1 && type != 1) {
			fprintf (fo, "#endif\n");
		}

		prevtype = type;

		char space[5] = "";
		int driverSize = strlen(driverlist[i]);

		if (driverSize < maxDriverLength)
        {
		   for (int i = maxDriverLength; i > driverSize; i--)
		   {
		       strcat(space, " ");
	       }
        }

		if (type != 2) {
			fprintf (fo, "	&%s,   %s// %s\n", driverlist[i], space,  titlelist[i]);
			totallisted++;
		}
	}

	if (prevtype == 1) fprintf (fo, "#endif\n");

	fprintf (fo, "};\n\n");

	fclose (fo);

	free (drivers);
	free (drivertype);
	free (titles);

	printf ("%d of %d available drivers listed\n", totallisted, driverloc);

}

