#include <stdio.h>

void usage()
{
	printf("USAGE:\n");
	printf("\tgfxcnv.exe c1_file c2_file\n");
}

int main(int argc, char **argv)
{
	FILE *c1_rom_in, *c2_rom_in, *c1_rom_out;

	int i;
	int ROMSize = 0;
	int ROMSizeb = 0;

	if (argc != 3)
	{
		usage();
		return(1);
	}

	printf("Checking input\n");
	// Check input files
	if ((c1_rom_in=fopen(argv[1],"rb"))==NULL)
	{
		fprintf(stderr,"Error: cannot read %s.",argv[1]);
		return(1);
	}
	fseek (c1_rom_in , 0 , SEEK_END);
	ROMSize += ftell (c1_rom_in);
	rewind (c1_rom_in);

	// Check input files
	if ((c2_rom_in=fopen(argv[2],"rb"))==NULL)
	{
		fprintf(stderr,"Error: cannot read %s.",argv[2]);
		return(1);
	}
	fseek (c2_rom_in , 0 , SEEK_END);
	ROMSizeb += ftell (c2_rom_in);
	rewind (c2_rom_in);

	if (ROMSize != ROMSizeb)
	{
		printf("Input sizes must match!");
		return(1);
	}

	printf("Checking output\n");
	// Check output files
	if ((c1_rom_out=fopen("spr.spr","wb"))==NULL)
	{
		fclose(c1_rom_out);
		fprintf(stderr,"Error: cannot write to spr.spr.");
		return(1);
	}

	printf("Allocate RAM\n");
	// Create buffer
	unsigned char *src = (unsigned char*)malloc(ROMSize*2);

	printf("Read, process, and close input file\n");
	for (i = 0; i < ROMSize*2; i+=4)
	{
		fread (src+i+1,1,1,c1_rom_in);
		fread (src+i+0,1,1,c1_rom_in);
		fread (src+i+3,1,1,c2_rom_in);
		fread (src+i+2,1,1,c2_rom_in);
	}
	fclose(c1_rom_in);
	fclose(c2_rom_in);

	printf("Write output\n");
	// Write the output
	fwrite (src,1,ROMSize*2,c1_rom_out);
	fclose(c1_rom_out);

	printf("Free Allocated RAM\n");
	// Free buffer
	free(src);

	printf("Finished\n");
}
