#include <stdio.h>

/* Code by IQ_132.  You may use this in any way you wish, just leave this line intact. */

int main()
{
	int i, j;
	FILE *p1_rom_in, *p2_rom_in, *p3_rom_in;
	FILE *s1_rom_in;

	printf ("\n    Checking files\n");
	if ((p1_rom_in=fopen("5008-p1.bin","rb"))==NULL)
	{
		fprintf(stderr,"Error: cannot read 5008-p1.bin");
		return(1);
	}

	if ((p2_rom_in=fopen("5008-p2.bin","rb"))==NULL)
	{
		fprintf(stderr,"Error: cannot read 5008-p2.bin");
		return(1);
	}

	if ((p3_rom_in=fopen("5008-p3.bin","rb"))==NULL)
	{
		fprintf(stderr,"Error: cannot read 5008-p3.bin");
		return(1);
	}

	if ((s1_rom_in=fopen("5008-s1.bin","rb"))==NULL)
	{
		fprintf(stderr,"Error: cannot read 5008-s1.bin");
		return(1);
	}

	FILE *p1_rom_out;

	if ((p1_rom_out=fopen("5008-p1d.bin","wb"))==NULL)
	{
		fprintf(stderr,"Error: cannot write to 5008-p1d.bin");
		return(1);
	}

	FILE *s1_rom_out;

	if ((s1_rom_out=fopen("5008-s1d.bin","wb"))==NULL)
	{
		fprintf(stderr,"Error: cannot write to 5008-s1d.bin");
		return(1);
	}

	unsigned char *src = (unsigned char*)malloc(0x200000);
	unsigned char *dst = (unsigned char*)malloc(0x800000);
	unsigned char *srom = (unsigned char*)malloc(0x20000);

	printf ("    Reading input files\n");
	fread (src, 1, 0x200000, p1_rom_in); fclose(p1_rom_in);
	// read these directly to the dst
	fread (dst + 0x100000, 1, 0x400000, p2_rom_in); fclose(p2_rom_in);
	fread (dst + 0x500000, 1, 0x200000, p3_rom_in); fclose(p3_rom_in);

	fread (srom, 1, 0x20000, s1_rom_in); fclose(s1_rom_in);

	printf ("    Re-ordering p1 rom\n");
	unsigned int sec[8] = { 0x3, 0x8, 0x7, 0xC, 0x1, 0xA, 0x6, 0xD };

	for (i = 0; i < 8; i++)
	{
		memcpy (dst + i * 0x20000, src + sec[i] * 0x20000, 0x20000);
	}

	printf ("    Patching p data\n");
	memcpy (dst + 0x0002e0, src + 0x0402e0, 0x00006a);
	memcpy (dst + 0x0f92bc, src + 0x0492bc, 0x000b9e);

	for (i = 0xf92bc; i < 0xf9e58; i++)
	{
		if ((dst[i]&0xbf) == 0xb9 && !dst[i+3])
		{
			dst[i+2] = 0x0f;
		}
	}

	dst[0x00342] = 0x0f;

	// change last meg to FF's
	for (i = 0x700000; i < 0x800000; i++)
	{
		dst[i] = 0xFF;
	}

	printf ("    Writing 5008-p1d.bin\n");
	fwrite (dst, 1, 0x800000, p1_rom_out);	fclose (p1_rom_out);

	printf ("    Writing 5008-s1d.bin\n");
	for (i = 0; i < 0x20000; i+=16)
	{
		fwrite (srom + i + 8, 1, 8, s1_rom_out);
		fwrite (srom + i + 0, 1, 8, s1_rom_out);
	}

	fclose (s1_rom_out);

	free (dst); free (src); free (srom);

	printf ("    Finished\n");
}

