#include <stdio.h>

#define BITSWAP08(n, 						\
	bit07, bit06, bit05, bit04, bit03, bit02, bit01, bit00)	\
		(((((n) >> (bit07)) & 1) <<  7) | 		\
		 ((((n) >> (bit06)) & 1) <<  6) | 		\
		 ((((n) >> (bit05)) & 1) <<  5) | 		\
		 ((((n) >> (bit04)) & 1) <<  4) | 		\
		 ((((n) >> (bit03)) & 1) <<  3) | 		\
		 ((((n) >> (bit02)) & 1) <<  2) | 		\
		 ((((n) >> (bit01)) & 1) <<  1) | 		\
		 ((((n) >> (bit00)) & 1) <<  0))

void usage()
{
	printf("Converts between encrypted and decrypted (Bootleg) C (graphics) roms\n\n");
	printf("Usage: bitswap8 [source] [output] [b] [b] [b] [b] [b] [b] [b] [b]\n\n");
	printf("[source]:       Name of the file that is to be bitswapped\n");
	printf("[output]:	Name of the file that will be produced\n");
	printf("\n");
	printf("[b]:            These are the bitswap values you wish to use.\n");
	printf("		  Example: 0 1 2 3 4 5 6 7\n");
	printf("		  You must use EXACTLY EIGHT (8) of these numbers\n");
}

int main(int argc, char **argv)
{
	int type = 0;
	int ed = 0;

	if (argc < 11)
	{
		usage();
		return (1);
	}

	int t[8] = {7, 6, 5, 4, 3, 2, 1, 0}; // 13 18 22 25 27 28

	sscanf(argv[3],"%d",&t[0]);
	sscanf(argv[4],"%d",&t[1]);
	sscanf(argv[5],"%d",&t[2]);
	sscanf(argv[6],"%d",&t[3]);
	sscanf(argv[7],"%d",&t[4]);
	sscanf(argv[8],"%d",&t[5]);
	sscanf(argv[9],"%d",&t[6]);
	sscanf(argv[10],"%d",&t[7]);

	if ((t[0]+t[1]+t[2]+t[3]+t[4]+t[5]+t[6]+t[7]) != 28)
	{
		printf ("The values you are using cannot be correct.  They must be\n");
		printf ("between 0 and 7: Valid values are: 0 1 2 3 4 5 6 7\n");
		return (1);
	}

	int i;
	int size = 0;
	FILE *rom_out, *rom_in;

	if ((rom_in=fopen(argv[1],"rb"))==NULL)
	{
		fprintf(stderr,"Error: cannot read %s.", argv[1]); return(1);
	}
	fseek (rom_in , 0 , SEEK_END);	size += ftell (rom_in);	rewind (rom_in);

	if ((rom_out=fopen(argv[2],"wb"))==NULL)
	{
		fprintf(stderr,"Error: cannot write to %s.", argv[2]); return(1);
	}

	unsigned char *src = (unsigned char*)malloc(size);

	fread (src, 1, size, rom_in);
	fclose(rom_in);

	for (i = 0; i < size; i++)
		src[i] = BITSWAP08(src[i], t[0], t[1], t[2], t[3], t[4], t[5], t[6], t[7]);

	fwrite (src, 1, size, rom_out);
	fclose(rom_out);

	free (src);
}
