
//-- Include Files -----------------------------------------------------------
#include <allegro.h>
#include <stdio.h>
#include <string.h>
#include <io.h>

//-- Cut off Allegro size... -------------------------------------------------
BEGIN_DIGI_DRIVER_LIST
END_DIGI_DRIVER_LIST

BEGIN_MIDI_DRIVER_LIST
END_MIDI_DRIVER_LIST

BEGIN_GFX_DRIVER_LIST
	GFX_DRIVER_VESA3
	GFX_DRIVER_VESA2L
	GFX_DRIVER_VESA2B
	GFX_DRIVER_VESA1
END_GFX_DRIVER_LIST

//-- Defines -----------------------------------------------------------------
#define DEFAULT_X	320
#define DEFAULT_Y	240

//-- Globals -----------------------------------------------------------------
static BITMAP			*bitmap = NULL;
static FILE				*fixfile = NULL;
static FILE				*palfile = NULL;
static int				res_x = 640;
static int	 			res_y = 480;
static int				display_mode = 0;
static char				*buffer = NULL;
static int				start_char = 0;
static int				max_char = 0;
static char				path[80];
static char				path2[80];
static char				path3[80];
static unsigned short	palette[16];
static int				max_palette = 0;
static int				current_palette = 0;
static int				offset_palette = 0;
static int				clicked_char = -1;
static int				clicked_char_offset = -1;
static char				embed_offs_string[8];
static char				embed_size_string[8];

//-- Function Prototypes -----------------------------------------------------
inline void				limit(int *value, int maxval, int minval);
int						set_video_mode(int, int);
void					update_menu_state(void);
void					fix_conv(unsigned char *Src, unsigned char *Ptr,
	int Taille);
void					read_bank(void);
void					update_bitmap(void);
void					fix_load(char *fname);
void					change_palette(void);

static int				open_fix(void);
static int				save_to_bmp(void);
static int				quitter(void);

static int				set_res_320240(void);
static int				set_res_640400(void);
static int				set_res_640480(void);
static int				set_res_800600(void);
static int				set_res_1024768(void);

static int				prev_bank(void);
static int				next_bank(void);

static int				open_pal(void);
static int				open_epal(void);
static int				prev_pal(void);
static int				next_pal(void);
static int				first_pal(void);
static int				last_pal(void);

static int				d_custom_proc(int msg, DIALOG *d, int c);

void					display_infos(void);

//-- Allegro Ressources ------------------------------------------------------
static MENU file_menu[32] =
{
   { "&Open .FIX file",             open_fix,         NULL,       0, NULL  },
   { "",                            NULL,             NULL,       0, NULL  },
   { "&Save screen to .BMP",        save_to_bmp,      NULL,       0, NULL  },
   { "",                            NULL,             NULL,       0, NULL  },
   { "&Quit",                       quitter,          NULL,       0, NULL  },
   { NULL,                          NULL,             NULL,       0, NULL  }
};

static MENU resolution_menu[] =
{
   { "320x240",                     set_res_320240,   NULL,       0, NULL  },
   { "640x400",                     set_res_640400,   NULL,       0, NULL  },
   { "640x480",                     set_res_640480,   NULL,       0, NULL  },
   { "800x600",                     set_res_800600,   NULL,       0, NULL  },
   { "1024x768",                    set_res_1024768,  NULL,       0, NULL  },
   { NULL,                          NULL,             NULL,       0, NULL  }
};

static MENU controls_menu[] =
{
   { "Previous Bank (&-)",          prev_bank,        NULL,       0, NULL  },
   { "Next Bank     (&+)",          next_bank,        NULL,       0, NULL  },
   { NULL,                          NULL,             NULL,       0, NULL  }
};

static MENU palette_menu[] =
{
   { "Open &Palette file",          open_pal,         NULL,       0, NULL  },
   { "Open &Embedded palette file", open_epal,        NULL,       0, NULL  },
   { "",                            NULL,             NULL,       0, NULL  },
   { "Previous Palette (&0)",       prev_pal,         NULL,       0, NULL  },
   { "Next Palette     (&.)",       next_pal,         NULL,       0, NULL  },
   { "&First Palette",              first_pal,        NULL,       0, NULL  },
   { "&Last Palette",               last_pal,         NULL,       0, NULL  },
   { NULL,                          NULL,             NULL,       0, NULL  }
};

static MENU menu[32] =
{
   { "&File",                       NULL,             file_menu,        0, NULL  },
   { "&Resolution",                 NULL,             resolution_menu,  0, NULL  },
   { "&Palette",                    NULL,             palette_menu,     0, NULL  },
   { "&Controls",                   NULL,             controls_menu,    0, NULL  },
   { NULL,                          NULL,             NULL,             0, NULL  }
};

static DIALOG main_dlg[] =
{
   /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key)    (flags)     (d1)           (d2)       (dp)          (dp2) (dp3) */
   { d_custom_proc,     0,    32,  128,  128,     0,    0,     0,         0,       0,             0,               NULL, NULL, NULL  },
   { d_menu_proc,       0,     0,    0,    0,     0,    0,     0,         0,       0,             0,               menu, NULL, NULL  },
   { d_keyboard_proc,   0,     0,    0,    0,     0,    0,   'o',         0,       0,             0,           open_fix, NULL, NULL  },
   { d_keyboard_proc,   0,     0,    0,    0,     0,    0,   's',         0,       0,             0,        save_to_bmp, NULL, NULL  },
   { d_keyboard_proc,   0,     0,    0,    0,     0,    0,   'q',         0,       0,             0,            quitter, NULL, NULL  },
   { d_keyboard_proc,   0,     0,    0,    0,     0,    0,   '-',         0,       0,             0,          prev_bank, NULL, NULL  },
   { d_keyboard_proc,   0,     0,    0,    0,     0,    0,   '+',         0,       0,             0,          next_bank, NULL, NULL  },
   { d_keyboard_proc,   0,     0,    0,    0,     0,    0,   'p',         0,       0,             0,           open_pal, NULL, NULL  },
   { d_keyboard_proc,   0,     0,    0,    0,     0,    0,   'e',         0,       0,             0,          open_epal, NULL, NULL  },
   { d_keyboard_proc,   0,     0,    0,    0,     0,    0,   '0',         0,       0,             0,           prev_pal, NULL, NULL  },
   { d_keyboard_proc,   0,     0,    0,    0,     0,    0,   '.',         0,       0,             0,           next_pal, NULL, NULL  },
   { d_keyboard_proc,   0,     0,    0,    0,     0,    0,   'f',         0,       0,             0,          first_pal, NULL, NULL  },
   { d_keyboard_proc,   0,     0,    0,    0,     0,    0,   'l',         0,       0,             0,           last_pal, NULL, NULL  },
   { NULL,              0,     0,    0,    0,     0,    0,     0,         0,       0,             0,               NULL, NULL, NULL  }
};

static DIALOG embed_dlg[] =
{
   /* (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)  (key)    (flags)     (d1)           (d2)     (dp) */
   { d_shadow_box_proc, 0,    0,    208,  112,  0,    0,    0,       0,          0,             0,       NULL },
   { d_ctext_proc,      104,  8,    0,    0,    0,    0,    0,       0,          0,             0,       "Embedded palette settings" },
   { d_text_proc,       16,   32,   0,    0,    0,    0,    0,       0,          0,             0,       "Offset :" },
   { d_edit_proc,       88,   32,   80,   8,    0,    0,    0,       0,          8,             0,       embed_offs_string },
   { d_text_proc,       16,   48,   0,    0,    0,    0,    0,       0,          0,             0,       "Size   :" },
   { d_edit_proc,       88,   48,   80,   8,    0,    0,    0,       0,          8,             0,       embed_size_string },
   { d_text_proc,       16,   56,   0,    0,    0,    0,    0,       0,          0,             0,       "(0 if unknown)" },
   { d_button_proc,     16,   80,   80,   16,   0,    0,    13,      D_EXIT,     0,             0,       "OK" }, 
   { d_button_proc,     112,  80,   80,   16,   0,    0,    27,      D_EXIT,     0,             0,       "Cancel" }, 
   { NULL }
};

//----------------------------------------------------------------------------
void update_menu_state(void)
{
	resolution_menu[0].flags &= ~D_SELECTED;
	resolution_menu[1].flags &= ~D_SELECTED;
	resolution_menu[2].flags &= ~D_SELECTED;
	resolution_menu[3].flags &= ~D_SELECTED;
	resolution_menu[4].flags &= ~D_SELECTED;

	if ((res_x == 320)&&(res_y==240))
			resolution_menu[0].flags |= D_SELECTED;
	else if ((res_x == 640)&&(res_y==400))
			resolution_menu[1].flags |= D_SELECTED;
	else if ((res_x == 640)&&(res_y==480))
			resolution_menu[2].flags |= D_SELECTED;
	else if ((res_x == 800)&&(res_y==600))
			resolution_menu[3].flags |= D_SELECTED;
	else if ((res_x == 1024)&&(res_y==768))
			resolution_menu[4].flags |= D_SELECTED;
}
//----------------------------------------------------------------------------
int	main(int argc, char *argv[])
{
	path[0] = 0;
	path2[0] = 0;
	path3[0] = 0;

	strcpy(embed_offs_string, "0");
	strcpy(embed_size_string, "0");

	install_allegro(SYSTEM_AUTODETECT, &errno, atexit);

	install_keyboard();
	install_mouse();
	install_timer();

	set_color_depth(8);
	
	buffer = calloc(1, 8192);

	bitmap = create_bitmap(128, 128);
	main_dlg[0].dp = bitmap;

	set_video_mode(DEFAULT_X, DEFAULT_Y);
	update_menu_state();

	if (argc == 2)
		fix_load(argv[1]);

	do_dialog(main_dlg, 1);

	free(buffer);

	if (fixfile != NULL)
		fclose(fixfile);

	if (palfile != NULL)
		fclose(palfile);

	set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
	return 0;
}
//----------------------------------------------------------------------------
int set_video_mode(int new_x, int new_y)
{
	if (set_gfx_mode(GFX_AUTODETECT, new_x, new_y, new_x, new_y)<0)
	{
		if (set_gfx_mode(GFX_AUTODETECT, res_x, res_y, res_x, res_y)<0)
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			puts("Fatal Error: Could not change video mode.");
			exit(-1);
		}
		else
		{
			show_mouse(screen);
			return 0;
		}
	}

	show_mouse(screen);

	res_x = new_x;
	res_y = new_y;

	read_bank();
	update_bitmap();

	change_palette();

	return 1;
}
//----------------------------------------------------------------------------
static int open_fix(void)
{
	if (file_select("Open a .FIX file", path, "FIX"))
		fix_load(path);

	scare_mouse();
	clear(screen);
	unscare_mouse();
	return D_REDRAW;
}
//----------------------------------------------------------------------------
static int save_to_bmp(void)
{
	PALETTE pal;
	
	get_palette(pal);

	if (file_select("Save to a .BMP file", path2, "BMP"))
		save_bmp(path2, bitmap, pal);

	scare_mouse();
	clear(screen);
	unscare_mouse();
	return D_REDRAW;
}
//----------------------------------------------------------------------------
static int quitter()
{
   if (alert("Really want to quit?", NULL, NULL, "&Yes", "&Cancel", 'y', 'c') == 1)
	  return D_CLOSE;
   else
	  return D_O_K;
}
//----------------------------------------------------------------------------
static int set_res_320240(void)
{
	if (!set_video_mode(320, 240))
		alert("set_video_mode failed !", "Previous video mode restored.",  NULL, "&OK", NULL, 'o', 0);

	update_menu_state();
	update_bitmap();
	
	return D_REDRAW;
}
//----------------------------------------------------------------------------
static int set_res_640400(void)
{
	if (!set_video_mode(640, 400))
		alert("set_video_mode failed !", "Previous video mode restored.",  NULL, "&OK", NULL, 'o', 0);

	update_menu_state();
	update_bitmap();

	return D_REDRAW;
}
//----------------------------------------------------------------------------
static int set_res_640480(void)
{
	if (!set_video_mode(640, 480))
		alert("set_video_mode failed !", "Previous video mode restored.",  NULL, "&OK", NULL, 'o', 0);

	update_menu_state();
	update_bitmap();

	return D_REDRAW;
}
//----------------------------------------------------------------------------
static int set_res_800600(void)
{
	if (!set_video_mode(800, 600))
		alert("set_video_mode failed !", "Previous video mode restored.",  NULL, "&OK", NULL, 'o', 0);

	update_menu_state();
	update_bitmap();

	return D_REDRAW;
}
//----------------------------------------------------------------------------
static int set_res_1024768(void)
{
	if (!set_video_mode(1024, 768))
		alert("set_video_mode failed !", "Previous video mode restored.",  NULL, "&OK", NULL, 'o', 0);

	update_menu_state();
	update_bitmap();

	return D_REDRAW;
}
//----------------------------------------------------------------------------
static int prev_bank(void)
{
	start_char -= 256;

	read_bank();
	update_bitmap();

	return D_REDRAW;
}
//----------------------------------------------------------------------------
static int next_bank(void)
{
	start_char += 256;
	
	read_bank();
	update_bitmap();

	return D_REDRAW;
}
//----------------------------------------------------------------------------
static int open_pal(void)
{
	if (file_select("Load a palette file", path3, "PRG;PAL"))
	{
		if (palfile != NULL)
			fclose(palfile);

		current_palette = 0;
		offset_palette = 0;
	
		palfile = fopen(path3, "rb");
		if (palfile==NULL)
		{
			max_palette = 0;
			alert(path3, "File not found !",  NULL, "&OK", NULL, 'o', 0);
		}
		else
		{
			max_palette = (filelength(fileno(palfile))>>5);
			change_palette();
		}
	}
	
	scare_mouse();
	clear(screen);
	unscare_mouse();

	return D_REDRAW;
}
//----------------------------------------------------------------------------
static int open_epal(void)
{	
	if (file_select("Load a palette file", path3, "PRG;PAL"))
	{
		if (palfile != NULL)
			fclose(palfile);

		max_palette = 0;
		current_palette = 0;
		offset_palette = 0;
	
		palfile = fopen(path3, "rb");
		if (palfile==NULL)
			alert(path3, "File not found !",  NULL, "&OK", NULL, 'o', 0);
		else
		{
			centre_dialog(embed_dlg);
			set_dialog_color(embed_dlg, gui_fg_color, gui_bg_color);

		    	if (do_dialog(embed_dlg, 3) == 7)
			{
				sscanf(embed_offs_string, "%08x", &offset_palette);
				sscanf(embed_size_string, "%08x", &max_palette);

				if (max_palette == 0)
					max_palette = ((filelength(fileno(palfile)) - offset_palette)>>5);
				else
					max_palette >>= 5;
			}
			else
			{
				fclose(palfile);
				palfile= NULL;
			}
			
			change_palette();
		}
	}

	scare_mouse();
	clear(screen);
	unscare_mouse();

	return D_REDRAW;
}
//----------------------------------------------------------------------------
static int prev_pal(void)
{
	current_palette--;
	change_palette();

	return D_O_K;
}
//----------------------------------------------------------------------------
static int next_pal(void)
{
	current_palette++;
	change_palette();

	return D_O_K;
}
//----------------------------------------------------------------------------
static int first_pal(void)
{
	current_palette = 0;
	change_palette();

	return D_O_K;
}
//----------------------------------------------------------------------------
static int last_pal(void)
{
	current_palette = max_palette;
	change_palette();

	return D_O_K;
}
//----------------------------------------------------------------------------
inline void limit(int *value, int maxval, int minval)
{
	if ((*value)>maxval)
		(*value) = maxval;
	else if ((*value)<minval)
		(*value) = minval;
}
//----------------------------------------------------------------------------
void change_palette(void)
{
	int	i, r, g, b;
	PALETTE	pal;

	if (palfile != NULL)
	{
		limit(&current_palette, max_palette-1, 0);

		fseek(palfile, (current_palette<<5) + offset_palette, SEEK_SET);
		fread(palette, 1, 32, palfile);
		swab(palette, palette, 32);

		for(i=0;i<16;i++)
		{
			r =  (palette[i] & 0x4000)>>14;
			r |= (palette[i] & 0x0F00)>>6;

			g =  (palette[i] & 0x2000)>>13;
			g |= (palette[i] & 0x00F0)>>2;

			b =  (palette[i] & 0x1000)>>12;
			b |= (palette[i] & 0x000F)<<2;
		
			if(i==0)
			{
				pal[i].r = 0;
				pal[i].g = 0;
				pal[i].b = 0;
			}
			else
			{
				pal[i].r = r;
				pal[i].g = g;
				pal[i].b = b;
			}
		}

		set_palette_range(pal, 0, 15, 0);

		display_infos();
	}
}
//----------------------------------------------------------------------------
void	fix_conv(unsigned char *Src, unsigned char *Ptr, int Taille)
{
	int		i;
	
	for(i=Taille;i>0;i-=32) {
		*Ptr++ = *(Src+16);
		*Ptr++ = *(Src+24);
		*Ptr++ = *(Src);
		*Ptr++ = *(Src+8);
		Src++;
		*Ptr++ = *(Src+16);
		*Ptr++ = *(Src+24);
		*Ptr++ = *(Src);
		*Ptr++ = *(Src+8);
		Src++;
		*Ptr++ = *(Src+16);
		*Ptr++ = *(Src+24);
		*Ptr++ = *(Src);
		*Ptr++ = *(Src+8);
		Src++;
		*Ptr++ = *(Src+16);
		*Ptr++ = *(Src+24);
		*Ptr++ = *(Src);
		*Ptr++ = *(Src+8);
		Src++;
		*Ptr++ = *(Src+16);
		*Ptr++ = *(Src+24);
		*Ptr++ = *(Src);
		*Ptr++ = *(Src+8);
		Src++;
		*Ptr++ = *(Src+16);
		*Ptr++ = *(Src+24);
		*Ptr++ = *(Src);
		*Ptr++ = *(Src+8);
		Src++;
		*Ptr++ = *(Src+16);
		*Ptr++ = *(Src+24);
		*Ptr++ = *(Src);
		*Ptr++ = *(Src+8);
		Src++;
		*Ptr++ = *(Src+16);
		*Ptr++ = *(Src+24);
		*Ptr++ = *(Src);
		*Ptr++ = *(Src+8);
		Src+=25;
	}	
}
//----------------------------------------------------------------------------
void update_bitmap(void)
{
	int				x, y, y2;
	unsigned int	*cur_data, pixels;
	char			*cur_line;

	clear(bitmap);
	
	if (buffer == NULL)
		return;

	cur_data = (unsigned int *)buffer;
	
	for(y=0;y<16;y++)
	{
		for(x=0;x<16;x++)
		{
			for(y2=0;y2<8;y2++)
			{
				cur_line = bitmap->line[(y<<3) + y2] + (x<<3);
				
				pixels = *cur_data++;
				
				*cur_line++ = pixels&0x0F;
				pixels >>= 4;
				*cur_line++ = pixels&0x0F;
				pixels >>= 4;
				*cur_line++ = pixels&0x0F;
				pixels >>= 4;
				*cur_line++ = pixels&0x0F;
				pixels >>= 4;
				*cur_line++ = pixels&0x0F;
				pixels >>= 4;
				*cur_line++ = pixels&0x0F;
				pixels >>= 4;
				*cur_line++ = pixels&0x0F;
				pixels >>= 4;
				*cur_line = pixels&0x0F;
			}
		}
	}
}
//----------------------------------------------------------------------------
void fix_load(char *fname)
{
	if (fixfile != NULL)
		fclose(fixfile);

	start_char = 0;
	
	fixfile = fopen(fname, "rb");
	if (fixfile==NULL)
	{
		max_char = 0;
		alert(fname, "File not found !",  NULL, "&OK", NULL, 'o', 0);
	}
	else
		max_char = (filelength(fileno(fixfile))>>5);

	read_bank();
	update_bitmap();
}
//----------------------------------------------------------------------------
int d_custom_proc(int msg, DIALOG *d, int c)
{
	int		x, y;
	
	BITMAP *b = (BITMAP *)d->dp;

	switch(msg)
	{
	case MSG_DRAW:
		blit(b, screen, 0, 0, d->x, d->y, d->w, d->h);
		display_infos();
		break;
      
    case MSG_WANTFOCUS:
		return D_WANTFOCUS;

	case MSG_CLICK:
		x = gui_mouse_x();
		y = gui_mouse_y();
		
		x >>= 3;
		y = (y>>3);
		
		if ((y > 0)&&(y < 20)&&(x < 16))
		{
			clicked_char = start_char + ((y-4)<<4) + x;
			clicked_char_offset = clicked_char<<5;

			if (clicked_char >= max_char)
				clicked_char = -1;
		}
		else
				clicked_char = -1;

		display_infos();
	}	   

   return D_O_K;
}
//----------------------------------------------------------------------------
void read_bank(void)
{
	int	maxval;
	char	temp[8192];
	
	maxval = max_char - 256;
	if (maxval < 0)
		maxval = 0;
	
	limit(&start_char, maxval, 0);
	
	if (fixfile != NULL)
	{
		memset(temp, 0, 8192);
		fseek(fixfile, start_char<<5, SEEK_SET);
		fread(temp, 8192, 1, fixfile);
		fix_conv(temp, buffer, 8192);
	}
}
//----------------------------------------------------------------------------
void display_infos(void)
{
	text_mode(16);	

	if ((clicked_char < 0)||(clicked_char_offset < 0))
		textprintf(screen, font, 0, 16, 255,
			"Char:--- Off.:-------- Palette:%08x", current_palette);	
	else
		textprintf(screen, font, 0, 16, 255,
			"Char:%03x Off.:%08x Palette:%08x", clicked_char,
			clicked_char_offset, current_palette);	
}
