#include <stdio.h>

/*----------------------------------------------------------------------*/
/*  Most of this source is by IQ_132					*/
/*  Thank you to Aquasync, Fataku, Halrin, The MAME Team, and The FBA   */
/*  Team for other code that is included.				*/
/*----------------------------------------------------------------------*/


unsigned char *src;
int v_size = 0;
int ed = 1;

// Thanks to Aquasync, Halrin, and Fataku
void neo_pcm2_swap(int value) // 0=kof2002, 1=matrim, 2=mslug5, 3=samsho5, 4=svcchaos, 5=kof2003, 6=samsh5sp
{
	//offset, xor address
	unsigned int addrs[7][2]={
		{0x000000,0xA5000}, //kof2002
		{0xFFCE20,0x01000}, //matrimelee
		{0xFE2CF6,0x4E001}, //mslug5
		{0xFEB2C0,0x0A000}, //samsho5
		{0xFFAC28,0xC2000}, //svcchaos
		{0xFF14EA,0xA7001}, //kof2003
		{0xFFB440,0x02000}, //samsh5sp
	};
	unsigned int xordata[7][8]={
		{0xF9,0xE0,0x5D,0xF3,0xEA,0x92,0xBE,0xEF}, //kof2002
		{0xC4,0x83,0xA8,0x5F,0x21,0x27,0x64,0xAF}, //matrimelee
		{0xC3,0xFD,0x81,0xAC,0x6D,0xE7,0xBF,0x9E}, //mslug5
		{0xCB,0x29,0x7D,0x43,0xD2,0x3A,0xC2,0xB4}, //samsho5
		{0xC3,0xFD,0x81,0xAC,0x6D,0xE7,0xBF,0x9E}, //svcchaos
		{0x4B,0xA4,0x63,0x46,0xF0,0x91,0xEA,0x62}, //kof2003
		{0x4B,0xA4,0x63,0x46,0xF0,0x91,0xEA,0x62}, //samsh5sp
	};

	int i, j, d;
	unsigned char *buf = (unsigned char*)malloc(v_size);

	if (ed == 0)	// encrypt type 1 (Aquasync's code, minus bitswap)
	{
		// http://www.1emulation.com/forums/index.php?showtopic=10405&st=20
		for (i = 0; i < 0x1000000; i++)
		{
			buf[i] = src[i] ^ xordata[value][i & 7];
		}
		for (i = 0; i < 0x1000000; i++)
		{
			j=(i & 0xfefffe)|((i & 0x010000) >> 16)|((i & 0x000001) << 16); // swap bits 1 and 16 (Halrin)
			src[(i + addrs[value][0]) % 0x1000000] = buf[j ^ addrs[value][1]];

		}

	} else {	// decrypt type 1 (Fataku's code, minus bitswap)
		memcpy(buf,src,0x1000000);
		for (i=0;i<0x1000000;i++)
		{
            		j=(i & 0xfefffe)|((i & 0x010000) >> 16)|((i & 0x000001) << 16); // swap bits 1 and 16 (Halrin)
            		j=j^addrs[value][1];
            		int d=((i+addrs[value][0])&0xffffff);
            		src[j]=buf[d]^xordata[value][j&0x7];
		}
	}
	free(buf);
}

// Ripped from MAME
// Neo-Pcm2 Drivers for Encrypted V Roms
static void neo_pcm2_snk_1999(int value) // 4=pnyaa, 8=mslug4, 16=rotd 
{
	int i, j;
	unsigned short *rom = (unsigned short*)src;

	// thanks to Elsemi for the NEO-PCM2 info
	if( src != NULL )
	{	// swap address lines on the whole ROMs
		unsigned short *buffer = (unsigned short*)malloc((value / 2) * sizeof(unsigned short));
		if (!buffer)
			return;

		for( i = 0; i < v_size / 2; i += ( value / 2 ) )
		{
			memcpy( buffer, &rom[ i ], value );
			for( j = 0; j < (value / 2); j++ )
			{
				rom[ i + j ] = buffer[ j ^ (value/4) ];
			}
		}
		free(buffer);
	}
}

void PCM2_SNK_1999_USAGE()
{
	printf ("PCM2, 1999, SNK Encryption (Table 0) is used by the following games:\n\n");
	printf ("\tROM NAME\tNGID#\tKEY\n");
	printf ("\tPNYAA\t\t267\t4\n");
	printf ("\tMSLUG4\t\t263\t8\n");
	printf ("\tROTD\t\t264\t16\n");
}

void PCM2_PLAYMORE_2002_USAGE()
{
	printf ("PCM2, 2002, Playmore Encryption (Table 1) is used by the following games:\n\n");
	printf ("\tROM NAME\tNGID#\tKEY\n");
	printf ("\tKOF2002\t\t265\t0\n");
	printf ("\tMATRIM\t\t266\t1\n");
	printf ("\tMSLUG5\t\t268\t2\n");
	printf ("\tSAMSHO5\t\t270\t3\n");
	printf ("\tSVCCHAOS\t269\t4\n");
	printf ("\tkof2003\t\t271\t5\n");
	printf ("\tSAMSH5SP\t272\t6\n");
}

void usage()
{
	char string [256];

	// This block is almost entirely ripped right from convert2
	// I simply liked the layout of that "help screen" and 
	// Didn't think the author (whoever that is ^^) would mind :)

	printf("Converts between encrypted and decrypted V (sample) roms\n\n");
	printf("Usage: neoconv [tables] [command] [extra-xor] [rom-name] [rom-number] < [separator] [extension] < [endchar] > >\n\n");
	printf("[tables]:       0 for pcm2 (1999) | 1 for pcm2 (2002)\n");
	printf("[command]:      e (for encryption) | d (for decryption)\n");
	printf("[extra-xor]:    one or two digit value\n");
	printf("                ( e.g. 0 for kof2002 )\n");
	printf("[rom-name]:     the first part of the rom name\n");
	printf("                ( e.g. for 265-vX.bin you type '265' )\n");
	printf("[rom-number]:   number of roms, it can be 1, 2, or 4\n");
	printf("                ( e.g. 2 for kof2002 )\n");
	printf("[separator]:    the separating char between the rom-name and vX\n");
	printf("                (e.g. for 265-vX.bin you type '-' )\n");
	printf("[extension]:    the extension of the roms\n");
	printf("                (e.g. for 265-vX.bin you type 'bin' )\n");
	printf("[endchar]:      the char after vX in the name of the roms (if it exists)\n");
	printf("                (e.g. for 265-vXd.bin you type d)\n");

	printf ("\nPress i and ENTER for extra info or ENTER alone to continue\n");
	gets (string);

	// If they want extra instructions, display this stuff
	if ((!strcmp(string, "i"))||(!strcmp(string, "I")))
	{
		printf("\n");
		PCM2_SNK_1999_USAGE();
		printf("\n");
		PCM2_PLAYMORE_2002_USAGE();
	}
}

int main(int argc, char **argv)
{
	// Define input
	FILE *V1_rom_in, *V2_rom_in, *V3_rom_in, *V4_rom_in;
	// Define output
	FILE *V1_rom_out, *V2_rom_out;//, *V3_rom_out, *V4_rom_out;

	int key = 0;
	int crypt = 0;
	int rom_no = 2; // default rom number is 2
	char *name[0];
	char *sepr[0];
	char *extn[0];
	char string [256];
	char *addn[0];

	if (argc < 8) {
		usage();return(1);
	}

	sscanf(argv[1],"%d",&crypt);

	if ((strcmp(argv[2],"d"))&&(strcmp(argv[2],"D"))&&(strcmp(argv[2],"e"))&&(strcmp(argv[2],"E")))
	{
		usage();return(1);
	}

	if ((strcmp(argv[2],"d"))&&(strcmp(argv[2],"D")))
	{
		ed = 0;
	}
	if ((strcmp(argv[2],"e"))&&(strcmp(argv[2],"E")))
	{
		ed = 1;
	}

	sscanf(argv[3],"%2d",&key);
	if ((crypt == 0) && (key != 4) && (key != 8) && (key != 16))
	{
		PCM2_SNK_1999_USAGE();
		return(1);
	}

	if ((crypt == 1) && (key > 6))
	{
		PCM2_PLAYMORE_2002_USAGE();
		return(1);
	}
	sscanf(argv[4],"%5s",&name);
	sscanf(argv[5],"%1d",&rom_no);
	if ((rom_no != 1) && (rom_no != 2) && (rom_no != 4)) {
		usage();return(1);
	}

	sscanf(argv[6],"%1s",&sepr);
	sscanf(argv[7],"%3s",&extn);
	if (argc > 8)
	{
		sscanf(argv[8],"%3s",&addn);
	}

	// Check input files
	sprintf(string,"%s%sv1.%s",name,sepr,extn);
	if (argc > 8)sprintf(string,"%s%sv1%s.%s",name,sepr,addn,extn);
	printf ("Checking %s\n", string);
	if ((V1_rom_in=fopen(string,"rb"))==NULL)
	{
		fprintf(stderr,"Error: cannot read %s", string); return(1);
	}
	fseek (V1_rom_in , 0 , SEEK_END);v_size += ftell (V1_rom_in);rewind (V1_rom_in);

	if (rom_no > 1)
	{
		sprintf(string,"%s%sv2.%s",name,sepr,extn);
		if (argc > 8)sprintf(string,"%s%sv2%s.%s",name,sepr,addn,extn);
		printf ("Checking %s\n", string);
		if ((V2_rom_in=fopen(string,"rb"))==NULL)
		{
			fprintf(stderr,"Error: cannot read %s", string); return(1);
		}
		fseek (V2_rom_in , 0 , SEEK_END);v_size += ftell (V2_rom_in);rewind (V2_rom_in);

		if (rom_no == 4)
		{
			sprintf(string,"%s%sv3.%s",name,sepr,extn);
			if (argc > 8)sprintf(string,"%s%sv3%s.%s",name,sepr,addn,extn);
			printf ("Checking %s\n", string);
			if ((V3_rom_in=fopen(string,"rb"))==NULL)
			{
				fprintf(stderr,"Error: cannot read %s", string); return(1);
			}
			fseek (V3_rom_in , 0 , SEEK_END);v_size += ftell (V3_rom_in);rewind (V3_rom_in);

			sprintf(string,"%s%sv4.%s",name,sepr,extn);
			if (argc > 8)sprintf(string,"%s%sv4%s.%s",name,sepr,addn,extn);
			printf ("Checking %s\n", string);
			if ((V4_rom_in=fopen(string,"rb"))==NULL)
			{
				fprintf(stderr,"Error: cannot read %s", string); return(1);
			}
			fseek (V4_rom_in , 0 , SEEK_END);v_size += ftell (V4_rom_in);rewind (V4_rom_in);
		}

	}

	// Check output files
	sprintf(string,"%s%sv1%s.%s",name,sepr,argv[2],extn);
	if ((V1_rom_out=fopen(string,"wb"))==NULL)
	{
		fclose(V1_rom_out); fprintf(stderr,"Error: cannot write to %s", string);
		return(1);
	}

	if (rom_no > 1)
	{
		sprintf(string,"%s%sv2%s.%s",name,sepr,argv[2],extn);
		if ((V2_rom_out=fopen(string,"wb"))==NULL)
		{
			fclose(V2_rom_out); fprintf(stderr,"Error: cannot write to %s", string);
			return(1);
		}

/*		if (rom_no == 4)
		{
			sprintf(string,"%s%sv3%s.%s",name,sepr,argv[2],extn);
			if ((V2_rom_out=fopen(string,"wb"))==NULL)
			{
				fclose(V3_rom_out); fprintf(stderr,"Error: cannot write to %s", string);
				return(1);
			}
		
			sprintf(string,"%s%sv4%s.%s",name,sepr,argv[2],extn);
			if ((V4_rom_out=fopen(string,"wb"))==NULL)
			{
				fclose(V4_rom_out); fprintf(stderr,"Error: cannot write to %s", string);
				return(1);
			}
		}
*/
	}

	// Create buffer
	src = (unsigned char*)malloc(v_size);


	printf("Reading Input Files\n");
	fread (src+0x000000,1,(v_size/rom_no),V1_rom_in);	fclose(V1_rom_in);
	if (rom_no > 1)
	{
		fread (src+(v_size/rom_no),1,(v_size/rom_no),V2_rom_in);	fclose(V2_rom_in);

		if (rom_no == 4)
		{
			fread (src+(v_size/rom_no)*2,1,(v_size/rom_no),V3_rom_in);	fclose(V3_rom_in);
			fread (src+(v_size/rom_no)*3,1,(v_size/rom_no),V4_rom_in);	fclose(V4_rom_in);
		}
	}

	printf("Processing Files\n");
	// Process V1 and V2
	if (crypt == 1)
	{
		neo_pcm2_swap(key);
	}

	if (crypt == 0)
	{
		neo_pcm2_snk_1999(key);
	}

	if (rom_no == 1)
	{
		fwrite (src,1,v_size, V1_rom_out);fclose(V1_rom_out);
	} else {
		fwrite (src,1,(v_size/2),V1_rom_out);	fclose(V1_rom_out);
		fwrite (src+(v_size/2),1,(v_size/2),V2_rom_out);	fclose(V2_rom_out);
	}

	printf("Finished");
	// Free buffer
	free(src); 
  }
