#include <stdio.h>

/* Code by IQ_132.  You may use this in any way you wish, just leave this line intact. */

// Bitswap code taken from final burn alpha source
#define BITSWAP16(n, 														\
		bit15, bit14, bit13, bit12, bit11, bit10, bit09, bit08,	\
		bit07, bit06, bit05, bit04, bit03, bit02, bit01, bit00)	\
		(((((n) >> (bit15)) & 1) << 15) | 									\
		 ((((n) >> (bit14)) & 1) << 14) | 									\
		 ((((n) >> (bit13)) & 1) << 13) | 									\
		 ((((n) >> (bit12)) & 1) << 12) | 									\
		 ((((n) >> (bit11)) & 1) << 11) | 									\
		 ((((n) >> (bit10)) & 1) << 10) | 									\
		 ((((n) >> (bit09)) & 1) <<  9) | 									\
		 ((((n) >> (bit08)) & 1) <<  8) | 									\
		 ((((n) >> (bit07)) & 1) <<  7) | 									\
		 ((((n) >> (bit06)) & 1) <<  6) | 									\
		 ((((n) >> (bit05)) & 1) <<  5) | 									\
		 ((((n) >> (bit04)) & 1) <<  4) | 									\
		 ((((n) >> (bit03)) & 1) <<  3) | 									\
		 ((((n) >> (bit02)) & 1) <<  2) | 									\
		 ((((n) >> (bit01)) & 1) <<  1) | 									\
		 ((((n) >> (bit00)) & 1) <<  0))

#define BITSWAP08(n, 														\
		bit07, bit06, bit05, bit04, bit03, bit02, bit01, bit00)	\
		(((((n) >> (bit07)) & 1) <<  7) | 									\
		 ((((n) >> (bit06)) & 1) <<  6) | 									\
		 ((((n) >> (bit05)) & 1) <<  5) | 									\
		 ((((n) >> (bit04)) & 1) <<  4) | 									\
		 ((((n) >> (bit03)) & 1) <<  3) | 									\
		 ((((n) >> (bit02)) & 1) <<  2) | 									\
		 ((((n) >> (bit01)) & 1) <<  1) | 									\
		 ((((n) >> (bit00)) & 1) <<  0))

static void interleave(unsigned char *src) 
{
	int j=0,i;
	unsigned char* dst = (unsigned char*)malloc(0x800000);
	for (i=0;i<0x800000;i=i+4){
		dst[i+0]=src[j];
		dst[i+1]=src[j+1];
		dst[i+2]=src[j+0x400000];
		dst[i+3]=src[j+0x400001];
		j=j+2;
	}
	memcpy(src,dst,0x800000);
	free(dst);
}

static void process_svc(unsigned char *src)
{
	const unsigned char xor1[ 0x20 ] = {
		0x3b, 0x6a, 0xf7, 0xb7, 0xe8, 0xa9, 0x20, 0x99, 0x9f, 0x39, 0x34, 0x0c, 0xc3, 0x9a, 0xa5, 0xc8,
		0xb8, 0x18, 0xce, 0x56, 0x94, 0x44, 0xe3, 0x7a, 0xf7, 0xdd, 0x42, 0xf0, 0x18, 0x60, 0x92, 0x9f,
	};

	const unsigned char xor2[ 0x20 ] = {
		0x69, 0x0b, 0x60, 0xd6, 0x4f, 0x01, 0x40, 0x1a, 0x9f, 0x0b, 0xf0, 0x75, 0x58, 0x0e, 0x60, 0xb4,
		0x14, 0x04, 0x20, 0xe4, 0xb9, 0x0d, 0x10, 0x89, 0xeb, 0x07, 0x30, 0x90, 0x50, 0x0e, 0x20, 0x26,
	};

	int i;
	int ofst;
	unsigned char *dst;

	for( i = 0; i < 0x100000; i++ ){
		src[ i ] ^= xor1[ (i % 0x20) ];
	}

	for( i = 0x100000; i < 0x800000; i++ ){
		src[ i ] ^= xor2[ (i % 0x20) ];
	}

	for( i = 0x100000; i < 0x800000; i += 4 ){
		unsigned short *src16 = (unsigned short*)&src[ i + 1 ];
		*src16 = BITSWAP16( *src16, 15, 14, 13, 12, 10, 11, 8, 9, 6, 7, 4, 5, 3, 2, 1, 0 );
	}

	dst = (unsigned char*)malloc( 0x800000 );
	memcpy( dst, src, 0x800000 );

	for( i = 0; i < 0x0100000 / 0x10000; i++ ){
		ofst = (i & 0xf0) + BITSWAP08( (i & 0x0f), 7, 6, 5, 4, 2, 3, 0, 1 );
		memcpy( &src[ i * 0x10000 ], &dst[ ofst * 0x10000 ], 0x10000 );
	}

	for( i = 0x100000; i < 0x800000; i += 0x100 ){
		ofst = (i & 0xf000ff) + 
			   ((i & 0x000f00) ^ 0x00a00) +
			   (BITSWAP08( ((i & 0x0ff000) >> 12), 4, 5, 6, 7, 1, 0, 3, 2 ) << 12);

		memcpy( &src[ i ], &dst[ ofst ], 0x100 );
	}

	free( dst );

	dst = (unsigned char*)malloc( 0x800000 );
	memcpy( dst, src, 0x800000 );
	memcpy( &src[ 0x100000 ], &dst[ 0x700000 ], 0x100000 );
	memcpy( &src[ 0x200000 ], &dst[ 0x100000 ], 0x600000 );

	free( dst );
}

static void process_2k3(unsigned char *src)
{
	interleave(src);

	const unsigned char xor2[ 0x20 ] = {
		0xb4, 0x0f, 0x40, 0x6c, 0x38, 0x07, 0xd0, 0x3f, 0x53, 0x08, 0x80, 0xaa, 0xbe, 0x07, 0xc0, 0xfa,
		0xd0, 0x08, 0x10, 0xd2, 0xf1, 0x03, 0x70, 0x7e, 0x87, 0x0B, 0x40, 0xf6, 0x2a, 0x0a, 0xe0, 0xf9
	};

	int i, ofst;
	unsigned char *dst;

	for( i = 0x100000; i < 0x800000; i++ ){
		src[ i ] ^= xor2[ (i % 0x20) ];
	}

	for( i = 0x100000; i < 0x800000; i += 4 ){
		unsigned short *src16 = (unsigned short*)&src[ i + 1 ];
		*src16 = BITSWAP16( *src16, 15, 14, 13, 12, 4, 5, 6, 7, 8, 9, 10, 11, 3, 2, 1, 0 );
	}

	dst = (unsigned char*)malloc( 0x800000 );
	memcpy( dst, src, 0x800000 );

	for( i = 0; i < 0x0100000 / 0x10000; i++ ){
		ofst = (i & 0xf0) + BITSWAP08( (i & 0x0f), 7, 6, 5, 4, 1, 0, 3, 2 );
		memcpy( &src[ i * 0x10000 ], &dst[ ofst * 0x10000 ], 0x10000 );
	}

	for( i = 0x100000; i < 0x800000; i += 0x100 ){
		ofst = (i & 0xf000ff) + 
			   ((i & 0x000f00) ^ 0x00300) +
			   (BITSWAP08( ((i & 0x0ff000) >> 12), 4, 5, 6, 7, 1, 0, 3, 2 ) << 12);

		memcpy( &src[ i ], &dst[ ofst ], 0x100 );
	}

	free( dst );

	dst = (unsigned char*)malloc(0x900000);
	memcpy( dst, src, 0x900000 );

	memcpy( &src[0x100000], &dst[0x800000], 0x100000 );
	memcpy( &src[0x200000], &dst[0x100000], 0x700000 );

	free(dst);
}

static void process_ms5(unsigned char *src)
{
	interleave(src);

	const unsigned char xor1[ 0x20 ] = {
		0xc2, 0x4b, 0x74, 0xfd, 0x0b, 0x34, 0xeb, 0xd7, 0x10, 0x6d, 0xf9, 0xce, 0x5d, 0xd5, 0x61, 0x29,
		0xf5, 0xbe, 0x0d, 0x82, 0x72, 0x45, 0x0f, 0x24, 0xb3, 0x34, 0x1b, 0x99, 0xea, 0x09, 0xf3, 0x03,
	};

	const unsigned char xor2[ 0x20 ] = {
		0x36, 0x09, 0xb0, 0x64, 0x95, 0x0f, 0x90, 0x42, 0x6e, 0x0f, 0x30, 0xf6, 0xe5, 0x08, 0x30, 0x64,
		0x08, 0x04, 0x00, 0x2f, 0x72, 0x09, 0xa0, 0x13, 0xc9, 0x0b, 0xa0, 0x3e, 0xc2, 0x00, 0x40, 0x2b,
	};

	int i;
	unsigned char *dst;
	int ofst;

	for( i = 0; i < 0x100000; i++ ){
		src[ i ] ^= xor1[ (i % 0x20) ];
	}

	for( i = 0x100000; i < 0x800000; i++ ){
		src[ i ] ^= xor2[ (i % 0x20) ];
	}

	for( i = 0x100000; i < 0x0800000; i += 4 ){
		unsigned short *src16 = (unsigned short*)&src[ i + 1 ];
		*src16 = BITSWAP16( *src16, 15, 14, 13, 12, 10, 11, 8, 9, 6, 7, 4, 5, 3, 2, 1, 0 );
	}

	dst = (unsigned char*)malloc( 0x800000 );
	memcpy( dst, src, 0x800000 );

	for( i = 0; i < 0x0100000 / 0x10000; i++ ){
		ofst = (i & 0xf0) + BITSWAP08( (i & 0x0f), 7, 6, 5, 4, 1, 0, 3, 2 );
		memcpy( &src[ i * 0x10000 ], &dst[ ofst * 0x10000 ], 0x10000 );
	}

	for( i = 0x100000; i < 0x800000; i += 0x100 ){
		ofst = (i & 0xf000ff) + 
			   ((i & 0x000f00) ^ 0x00700) +
			   (BITSWAP08( ((i & 0x0ff000) >> 12), 5, 4, 7, 6, 1, 0, 3, 2 ) << 12);

		memcpy( &src[ i ], &dst[ ofst ], 0x100 );
	}
//	free( dst );

	memcpy( dst, src, 0x800000 );

	memcpy( &src[ 0x100000 ], &dst[ 0x700000 ], 0x100000 );
	memcpy( &src[ 0x200000 ], &dst[ 0x100000 ], 0x600000 );

	free( dst );
}

void usage()
{
	   printf(" Usage: p_dec n\n");
	   printf(" If n = 1, process SVCCHAOS (269-p1.bin)\n");
	   printf(" If n = 2, process KOF2003  (271-p1.bin, 271-p2.bin, & 271-p3d.bin\n");
	   printf(" If n = 3, process MSLUG5   (268-p1.bin, 268-p2.bin)\n");
	   printf(" \n");
}

int main(int argc, char **argv)
{
	if (argc != 2) {
		usage(); return(1);
	}

	int CHOOSER;
	sscanf(argv[1],"%d",&CHOOSER);

	FILE *p1_rom_in, *p2_rom_in, *p3_rom_in, *p1_rom_out;
	unsigned char *src = (unsigned char*)malloc(0x800000);

	if (CHOOSER == 1) {
		printf("Attempting to open SVCCHAOS P1\n");
		src = (unsigned char*)malloc(0x2000000);
		if ((p1_rom_in=fopen("269-p1.bin","rb"))==NULL)
		{
			fprintf(stderr,"Error: cannot read 269-p1.bin"); return(1);
		}
		fread (src,1,0x2000000, p1_rom_in);	fclose(p1_rom_in);
		if ((p1_rom_out=fopen("269-p1d.bin","wb"))==NULL)
		{
			fclose(p1_rom_out); fprintf(stderr,"Error: cannot write to 269-p1d.bin"); return(1);
		}
		printf("Processing\n");
		process_svc(src);
		printf("Writing decrypted P file\n");
		fwrite (src,1,0x2000000,p1_rom_out);
	}
	if (CHOOSER == 2) {
		printf("Attempting to open KOF2003 P1, P2, & P3...\n");
		src = (unsigned char*)malloc(0x900000);
		if ((p1_rom_in=fopen("271-p1.bin","rb"))==NULL)
		{
			fprintf(stderr,"Error: cannot read 271-p1.bin"); return(1);
		}
		fread (src,1,0x400000, p1_rom_in);	fclose(p1_rom_in);
		if ((p2_rom_in=fopen("271-p2.bin","rb"))==NULL)
		{
			fprintf(stderr,"Error: cannot read 271-p2.bin"); return(1);
		}
		fread (src+0x400000,1,0x400000, p2_rom_in);	fclose(p2_rom_in);
		if ((p3_rom_in=fopen("271-p3d.bin","rb"))==NULL)
		{
			fprintf(stderr,"Error: cannot read 271-p3d.bin"); return(1);
		}
		fread (src+0x800000,1,0x100000, p3_rom_in);	fclose(p3_rom_in);
		if ((p1_rom_out=fopen("271-p1d.bin","wb"))==NULL)
		{
			fclose(p1_rom_out); fprintf(stderr,"Error: cannot write to 271-p1d.bin"); return(1);
		}
		printf("Processing\n");
		process_2k3(src);
		printf("Writing decrypted P file\n");
		fwrite (src,1,0x900000,p1_rom_out);
	}
	if (CHOOSER == 3) {
		printf("Attempting to open MSLUG5 P1 & P2...\n");
		if ((p1_rom_in=fopen("268-p1.bin","rb"))==NULL)
		{
			fprintf(stderr,"Error: cannot read 268-p1.bin"); return(1);
		}
		fread (src,1,0x400000, p1_rom_in);	fclose(p1_rom_in);
		if ((p2_rom_in=fopen("268-p2.bin","rb"))==NULL)
		{
			fprintf(stderr,"Error: cannot read 268-p2.bin"); return(1);
		}
		fread (src+0x400000,1,0x400000, p2_rom_in);	fclose(p2_rom_in);
		if ((p1_rom_out=fopen("268-p1d.bin","wb"))==NULL)
		{
			fclose(p1_rom_out); fprintf(stderr,"Error: cannot write to 271-p1d.bin"); return(1);
		}
		printf("Processing\n");
		process_ms5(src);
		printf("Writing decrypted P file\n");
		fwrite (src,1,0x800000,p1_rom_out);
	}


	fclose(p1_rom_out);
	free(src);
	printf("Finished");
}
