
/*------------------------------------------------------------------------------*/
/*	Source almost entirely by IQ_132 -- http://neosource.1emulation.com	*/
/*	You may use this code in any way you wish, but you must include this	*/
/*	header with any files you distribute that contain any of this code	*/
/*------------------------------------------------------------------------------*/

#include <stdio.h>
#define ENABLE_WRITE_CX

int main(int argc, char **argv)
{
	int i, j, size = 0;

#ifdef ENABLE_WRITE_CX
	if (argc < 4)
	{
		printf("Usage:\n\tcxencs1 xxx-s1d.bin xxx-c7d.bin xxx-c8d.bin\n");
#else
	if (argc < 2)
	{
		printf("Usage:\n\tcxencs1 xxx-s1d.bin\n");
#endif
		return(1);
	}

	FILE *SINP;
	if ((SINP=fopen(argv[1],"rb"))==NULL)
	{
		printf("Error: cannot read %s.\n", argv[1]);
		return(1);
	}
	fseek (SINP, 0, SEEK_END); size = ftell (SINP); rewind (SINP);

#ifdef ENABLE_WRITE_CX
	int c_size = 0;
	FILE *C1R, *C2R;
	if ((C1R=fopen(argv[2],"rb"))==NULL)
	{
		printf("Error: cannot read %s.\n", argv[2]);
		return(1);
	}
	fseek (C1R, 0, SEEK_END); c_size = ftell (C1R); rewind (C1R);

	if ((C2R=fopen(argv[3],"rb"))==NULL)
	{
		printf("Error: cannot read %s.\n", argv[3]);
		return(1);
	}
	fseek (C2R, 0, SEEK_END);
	if ((ftell (C2R)) != c_size)
	{
		printf ("File sizes must match for %s and %s!!\n", argv[2], argv[3]);
		return(1);
	}
	 rewind (C2R);
#endif
	unsigned char *src = (unsigned char*)malloc(size);
	unsigned char *dst = (unsigned char*)malloc(size);

	fread (src, 1, size, SINP);
		fclose(SINP);

	for (i = 0; i < size; i++)
		dst[(i & ~0x1F) + ((i & 7) << 2) + ((~i & 8) >> 2) + ((i & 0x10) >> 4)] = src[i]; // MAME Team

#ifdef ENABLE_WRITE_CX
	unsigned char *rom = (unsigned char*)malloc(c_size);
	fread (rom, 1, c_size, C1R);
	for (i = 0; i < size; i+=2)
		memcpy (rom+(c_size-size/2)+i/2, dst+i+0, 1);
	freopen (argv[2],"wb",C1R);
		fwrite(rom, 1, c_size, C1R);
	fclose(C1R);

	fread (rom, 1, c_size, C2R);
	for (i = 0; i < size; i+=2)
		memcpy (rom+(c_size-size/2)+i/2, dst+i+1, 1);
	freopen (argv[3],"wb",C2R);
		fwrite(rom, 1, c_size, C2R);
	fclose(C2R);
	free(rom);
#else
	FILE *CEND1=fopen("Addto_c7.bin","wb");
	FILE *CEND2=fopen("Addto_c8.bin","wb");
	for (i = 0; i < size; i+=2)
	{
		fwrite (dst + i + 0, 1, 1, CEND1);
		fwrite (dst + i + 1, 1, 1, CEND2);
	}
	fclose(CEND1);
	fclose(CEND2);
#endif


	free (dst);
	free (src);
}
