/*------------------------------------------------------------------------------*/
/*	This source is entirely by IQ_132 -- http://www.freepgs.com/iq_132/	*/
/*	You may use this code in any way you wish, but you must include this	*/
/*	header with any files you distribute that contain any of this code	*/
/*------------------------------------------------------------------------------*/

#include <stdio.h>

void usage()
{
	printf ("Usage:\n");
	printf ("\tptcrt type base_file changed_file offset\n\n");
	printf ("\t- The type can be M (MAME) or F (FBA).\n");
	printf ("\t- The base file is the old file.\n");
	printf ("\t- The changed file is the file the patches will come from.\n");
	printf ("\t- The offset is optional\n\n");
}

int main(int argc, char **argv)
{
	FILE *testa, *testb, *pFile;
	int i,j;

	int size_1 = 0;
	int size_2 = 0;
	int size = 0;

	int type = 0;

	int offset = 0;

	if (argc < 4) {
		usage();
		return(1);
	}

	if ((strcmp(argv[1],"m"))&&(strcmp(argv[1],"M"))&&(strcmp(argv[1],"f"))&&(strcmp(argv[1],"F"))) {
		usage();
		return(1);
	}

	if (!(strcmp(argv[1],"m"))||!(strcmp(argv[1], "M")))
	{
		type = 1;
	}

	if (argc == 5)
	{
		sscanf(argv[4],"%d",&offset);
	}

	if ((testa=fopen(argv[2],"rb"))==NULL)
	{
		fprintf(stderr,"Error: cannot read input file #1.");
		return(1);
	}
	fseek (testa , 0 , SEEK_END);size_1 += ftell (testa);rewind (testa);

	if ((testb=fopen(argv[3],"rb"))==NULL)
	{
		fprintf(stderr,"Error: cannot read input file #2.");
		return(1);
	}
	fseek (testb , 0 , SEEK_END);size_2 += ftell (testb);rewind (testb);

	unsigned char *sra = (unsigned char*)malloc(size_1);
	unsigned char *srb = (unsigned char*)malloc(size_2);

	fread (sra, 1, size_1, testa);
		fclose(testa);
	fread (srb, 1, size_2, testb);
		fclose(testb);

	size = size_1;

	if (size_1 != size_2)
	{
		printf ("File sizes do not match; using the smaller of the two...\n");

		if (size_2 < size_1) size = size_2;
	}

	pFile = fopen ("values.txt","wa");

	for (i = 0+offset; i < size; i+=2)
	{
		if (i == 0+offset) printf ("Starting\n");
		if (i == ((size/100)*10)+offset) printf("10 Percent complete\n");
		if (i == ((size/100)*20)+offset) printf("20 Percent complete\n");
		if (i == ((size/100)*30)+offset) printf("30 Percent complete\n");
		if (i == ((size/100)*40)+offset) printf("40 Percent complete\n");
		if (i == ((size/100)*50)+offset) printf("50 Percent complete\n");
		if (i == ((size/100)*60)+offset) printf("60 Percent complete\n");
		if (i == ((size/100)*70)+offset) printf("70 Percent complete\n");
		if (i == ((size/100)*80)+offset) printf("80 Percent complete\n");
		if (i == ((size/100)*90)+offset) printf("90 Percent complete\n");
		if (i == ((size/100)*100)) printf("Finished\n");

		if ((i == 0+offset)&&(type==1))
		{
			fprintf (pFile, "\tdata16_t *mem16 = (data16_t *)memory_region(REGION_CPU1);\n");
		}

		if ((sra[i+0] != srb[i+0])||(sra[i+1] != srb[i+1]))
		{
			if (type == 1)	// MAME
			{
				fprintf (pFile, "\tmem16[%#X/2] = ", i);
			} else {	// FBA
				fprintf (pFile, "\t*((unsigned short*)(Neo68KROM + %#X)) = ", i);
			}
	
			if (srb[i+1] == 0x00)		// Fix how 00 is output
			{
				fprintf (pFile, "0x00");
			} else {			// Normal output
				fprintf (pFile, "%#2.2X", srb[i+1]);
			}

			if (srb[i+0] == 0x00)		// Fix how 00 is output
			{
				fprintf (pFile, "00\n");	
			} else {			// Normal output
				fprintf (pFile, "%2.2X\n", srb[i+0]);
			}
		}
	}

	free(sra);free(srb);
	fclose (pFile);
}
