// MaLaExternal.cpp : Definiert den Einstiegspunkt fr die DLL-Anwendung.
//

#include "stdafx.h"
#include <iostream>
#include "MaLaEventLogger.h"


#ifdef _MANAGED
#pragma managed(push, off)
#endif

#define DLL __declspec(dllexport)

BOOL APIENTRY DllMain( HMODULE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved
					 )
{
    return TRUE;
}

/******************************************************************************
*
******************************************************************************/
void WriteToFile(const char* text)
{
	FILE *f;
	f = fopen("events.log","a");
	fprintf(f, text);
	fclose(f);
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL void MaLaGameSelected(EventGame* g)
{
	char buf[500];
	sprintf_s(buf, "%s\nEVENT: Game selected\nName: %s\nManufacturer: %s\nGenre: %s\nYear: %d\n\n", eventbegin, g->Description, g->Manufacturer, g->Genre, g->Year);
    WriteToFile(buf);
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL void MaLaEmulatorSelected(EventEmulator* e)
{
	char buf[500];
	sprintf_s(buf, "%s\nEVENT: Emulator selected\nName: %s\nExecutable: %s\nCommand line: %s\n\n", eventbegin, e->Name, e->Filename, e->Commandline);
	WriteToFile(buf);
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL void MaLaListSelected(EventGamelist* l)
{
	char buf[500];
	sprintf_s(buf, "%s\nEVENT: Gamelist selected\nName: %s\nGame count: %d\nFilter count: %d\n\n", eventbegin, l->Name, l->GameCount, l->FilterCount);
	WriteToFile(buf);
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL void MaLaGameStart()
{
	char buf[500];
	sprintf_s(buf, "%s\nEVENT: Game start\n\n", eventbegin);
	WriteToFile(buf);
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL void MaLaGameQuit()
{
	char buf[500];
	sprintf_s(buf, "%s\nEVENT: Game quit\n\n", eventbegin);
	WriteToFile(buf);
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL void MaLaScreensaverStart()
{
	char buf[500];
	sprintf_s(buf, "%s\nEVENT: Screensaver start\n\n", eventbegin);
	WriteToFile(buf);
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL void MaLaScreensaverSwitch(const char* filename)
{
	char buf[500];
	sprintf_s(buf, "%s\nEVENT: MaLa screensaver switch\nFile: %s\n", eventbegin, filename);
	WriteToFile(buf);
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL void MaLaScreensaverStop()
{
	char buf[500];
	sprintf_s(buf, "%s\nEVENT: Screensaver stop\n\n", eventbegin);
	WriteToFile(buf);
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL void MaLaAttractModeStart()
{
	char buf[500];
	sprintf_s(buf, "%s\nEVENT: AttractMode start\n\n", eventbegin);
	WriteToFile(buf);
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL void MaLaAttractModeStop()
{
	char buf[500];
	sprintf_s(buf, "%s\nEVENT: AttractMode stop\n\n", eventbegin);
	WriteToFile(buf);
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL void MaLaTreeUp(EventTree* t)
{
	char buf[500];
	sprintf_s(buf, "%s\nEVENT: MaLa tree up\nName: %s\nNode count: %d\Is menu: %d\n\n", eventbegin, t->Name, t->NodeCount, t->Menu );
	WriteToFile(buf);
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL void MaLaTreeDown(EventTree* t)
{
	char buf[500];
	sprintf_s(buf, "%s\nEVENT: MaLa tree Down\nName: %s\nNode count: %d\Is menu: %d\n\n", eventbegin, t->Name, t->NodeCount, t->Menu );
	WriteToFile(buf);
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL void MaLaStart()
{
	char buf[500];
	sprintf_s(buf, "%s\nEVENT: MaLa start\n\n", eventbegin);
	WriteToFile(buf);
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL void PluginConfigure()
{
	Beep(523,500);
// ** Insert Plugin Configure Window code here
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL void MaLaQuit()
{
	char buf[500];
	sprintf_s(buf, "%s\nEVENT: MaLa quit\n\n", eventbegin);
	WriteToFile(buf);
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL void MaLaOrientationSwitch(int* orientation)
{
	char buf[500];
	sprintf_s(buf, "%s\nEVENT: MaLa orientation switch\nOrientation: %d\n", eventbegin, orientation);
	WriteToFile(buf);
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL const char* PluginName()
{
	return "MaLa Event Logger";
}

/******************************************************************************
*
******************************************************************************/
extern "C" DLL const char* PluginCopyright()
{
	return "2006 by S.Windus";
}

#ifdef _MANAGED
#pragma managed(pop)
#endif

