unit Configure;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, IniFiles, Buttons ;

type
  TConfigureF = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Label1: TLabel;
    Edit1: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ConfigureF: TConfigureF;
  IniFileName: string = 'MaLaPlugIn.ini';

implementation

{$R *.dfm}

{ *** This is a simple example of how a plugin configuration window
can be called from MaLa.
At that point you could choose to save the config to a .ini file and possibly apply that to the plugin straight away.
Obviously in this example the config does not change the operation
of MaLaEventLogger.. I will leave that to you }

procedure TConfigureF.BitBtn1Click(Sender: TObject);
var
IniFile  : TIniFile;
begin
    ShowMessage('Saving Plugin configuration settings to: '+ #13 + #10
     +extractfilepath(application.exename) +IniFileName);
      // Save Data to ini file
   IniFile := TIniFile.Create(extractfilepath(application.exename) +IniFileName);
   IniFile.Writebool('Settings', 'Checkbox1',checkbox1.Checked);
   IniFile.Writebool('Settings', 'Checkbox2',checkbox2.Checked);
   IniFile.WriteString('Settings','Text',Edit1.Text);

end;

procedure TConfigureF.FormCreate(Sender: TObject);
var
   IniFile : TIniFile;
begin
    // Load Data from ini File .
   IniFile := TIniFile.Create(extractfilepath(application.exename)
   +IniFileName);
   Checkbox1.Checked :=  IniFile.readbool('Settings', 'Checkbox1', FALSE);
   Checkbox2.Checked :=  IniFile.readbool('Settings', 'Checkbox2', FALSE);
   Edit1.Text := IniFile.ReadString('Settings','Text','bla bla bla');
end;


end.
