library MaLaEventLogger;

uses
  SysUtils,
  Classes,
  eventdata in 'eventdata.pas',
  Configure in 'Configure.pas' {ConfigureF},
  dialogs,
  forms,
  windows;

const
   nl = #13 + #10;


procedure WriteToFile(Text: string);
var
  myFile: TextFile;
begin
     AssignFile(myFile, 'events.log');
     if FileExists('events.log') then Append(myFile)
     else Rewrite(myFile);
     Write(myFile, Text);
     WriteLn(myFile);
     CloseFile(myFile);
end;

{*******************************************************************************
*
*******************************************************************************}
procedure MaLaGameSelected(g: TPEventGame); cdecl;
begin
     WriteToFile('*************************************************************' + nl +
                 'EVENT: Game selected' + nl +
                 'Name: ' + String(g.Description) + nl +
                 'Manufacturer: ' + String(g.Manufacturer) + nl +
                 'Genre: ' + String(g.Genre) + nl +
                 'Year: ' + IntToStr(g.Year) + nl +
                 'Clone of: ' + String(g.CloneOf) + nl +
                 '-------------------- INPUTS ---------------------------------' + nl +
                 'Coins: ' + IntToStr(g.InputCoins) + nl +
                 'Buttons: ' + IntToStr(g.InputButtons) + nl +
                 'Players: ' + String(g.InputPlayers) + nl +
                 'Control: ' + String(g.InputControl) + nl +
                 '-------------------- VIDEO ----------------------------------' + nl +
                 'Screen: ' + String(g.VideoScreen) + nl +
                 'Orientation: ' + String(g.VideoOrientation) + nl +
                 'Video size: ' + IntToStr(g.VideoWidth) + 'x' + IntToStr(g.VideoHeight) + nl +
                 '-------------------- DRIVER ---------------------------------' + nl +
                 'Status: ' + String(g.DriverStatus) + nl +
                 '-------------------- CONTROLS.INI ---------------------------' + nl +
                 'Control: ' + String(g.Controls) + nl +
                 'JoyUp: ' + String(g.JoyUp) + nl +
                 'JoyDown: ' + String(g.JoyDown) + nl +
                 'JoyLeft: ' + String(g.JoyLeft) + nl +
                 'JoyRight: ' + String(g.JoyRight) + nl +
                 'Button1: ' + String(g.Button1) + nl +
                 'Button2: ' + String(g.Button2) + nl +
                 'Button3: ' + String(g.Button3) + nl +
                 'Button4: ' + String(g.Button4) + nl +
                 'Button5: ' + String(g.Button5) + nl +
                 'Button6: ' + String(g.Button6) + nl +
                 'Button7: ' + String(g.Button7) + nl +
                 'Button8: ' + String(g.Button8) + nl +
                 '-------------------- ROMFILE --------------------------------' + nl +
                 'Rom name: ' + String(g.Rom) + nl +
                 'Rom path: ' + String(g.RomPath) + nl +
                 'Rom extension: ' + String(g.Extension) + nl +
                 '-------------------- STATS ----------------------------------' + nl +
                 'Game played: ' + IntToStr(g.Played) + nl
                 );
end;

{*******************************************************************************
*
*******************************************************************************}
procedure MaLaEmulatorSelected(e: TPEventEmulator); cdecl;
begin
     WriteToFile('*************************************************************' + nl +
                 'EVENT: Emulator selected' + nl +
                 'Name: ' + String(e.Name) + nl +
                 'Executable: ' + String(e.Filename) + nl +
                 'Command line: ' + String(e.Commandline) + nl +
                 '-------------------- ROMFILES -------------------------------' + nl +
                 'Rom path: ' + String(e.RomPath) + nl +
                 'Rom extensions: ' + String(e.Extensions) + nl +
                 '-------------------- IMAGES ---------------------------------' + nl +
                 'Snap path: ' + String(e.SnapPath) + nl +
                 'Marquee path: ' + String(e.MarqueePath) + nl +
                 'CPanel path: ' + String(e.CPanelPath) + nl +
                 'Video path: ' + String(e.VideoPath) + nl +
                 '-------------------- ENCODER PROGRAMMING --------------------' + nl +
                 'Encoder default config file: ' + String(e.EncoderConfigFile) + nl +
                 'Encoder game based: ' + IntToSTr(e.EncoderGameBased) + nl +
                 'Encoder config file path: ' + String(e.EncoderConfigFilesPath) + nl +
                 'Encoder config file extension: ' + String(e.EncoderConfigFileExtension) + nl
                 );
end;

{*******************************************************************************
*
*******************************************************************************}
procedure MaLaListSelected(gl: TPEventGamelist); cdecl;
begin
     WriteToFile('*************************************************************' + nl +
                 'EVENT: Gamelist selected' + nl +
                 'Name: ' + String(gl.Name) + nl +
                 'Game count: ' + IntToStr(gl.GameCount) + nl +
                 'Filter count: ' + IntToStr(gl.FilterCOunt) + nl
                 );
end;

{*******************************************************************************
*
*******************************************************************************}
procedure MaLaGameStart(); cdecl;
begin
     WriteToFile('*************************************************************' + nl +
                 'EVENT: Game start' + nl
                 );
end;

{*******************************************************************************
*
*******************************************************************************}
procedure MaLaOrientationSwitch(orientation: Integer); cdecl;
begin
     WriteToFile('*************************************************************' + nl +
                 'EVENT: Orientation switch' + nl +
                 'Orientation: ' + IntToStr(orientation) + nl
                 );
end;

{*******************************************************************************
*
*******************************************************************************}
procedure MaLaGameQuit(); cdecl;
begin
     WriteToFile('*************************************************************' + nl +
                 'EVENT: Game quit' + nl
                 );
end;

{*******************************************************************************
*
*******************************************************************************}
procedure MaLaScreensaverStart(); cdecl;
begin
     WriteToFile('*************************************************************' + nl +
                 'EVENT: Screensaver start' + nl
                 );
end;

{*******************************************************************************
*
*******************************************************************************}
procedure MaLaScreensaverSwitch(filename: string); cdecl;
begin
     WriteToFile('*************************************************************' + nl +
                 'EVENT: Screensaver switch' + nl +
                 'Filename: ' + filename + nl
                 );
end;

{*******************************************************************************
*
*******************************************************************************}
procedure MaLaScreensaverStop(); cdecl;
begin
     WriteToFile('*************************************************************' + nl +
                 'EVENT: Screensaver stop' + nl
                 );
end;

{*******************************************************************************
*
*******************************************************************************}
procedure MaLaAttractModeStart(); cdecl;
begin
     WriteToFile('*************************************************************' + nl +
                 'EVENT: AttractMode start' + nl
                 );
end;

{*******************************************************************************
*
*******************************************************************************}
procedure MaLaAttractModeStop(); cdecl;
begin
     WriteToFile('*************************************************************' + nl +
                 'EVENT: AttractMode stop' + nl
                 );
end;


{*******************************************************************************
*
*******************************************************************************}
procedure MaLaTreeUp(t: TPEventTree); cdecl;
begin
     WriteToFile('*************************************************************' + nl +
                 'EVENT: MaLa tree up' + nl +
                 'Name : ' + t.Name + nl +
                 'Node count: ' + IntToStr(t.NodeCount) + nl +
                 'Is menu: ' + IntToStr(t.Menu) + nl
                 );
end;

{*******************************************************************************
*
*******************************************************************************}
procedure MaLaTreeDown(t: TPEventTree); cdecl;
begin
     WriteToFile('*************************************************************' + nl +
                 'EVENT: MaLa tree down' + nl +
                 'Name : ' + t.Name + nl +
                 'Node count: ' + IntToStr(t.NodeCount) + nl +
                 'Is menu: ' + IntToStr(t.Menu) + nl
                 );
end;

{*******************************************************************************
*
*******************************************************************************}
procedure MaLaConfigureStart(); cdecl;
begin
     WriteToFile('*************************************************************' + nl +
                 'EVENT: Configure start' + nl
                 );
end;

{*******************************************************************************
*
*******************************************************************************}
procedure MaLaConfigureStop(ch: integer); cdecl;
begin

     if ch=1 then begin
              WriteToFile('*************************************************************' + nl +
                 'EVENT: Configure stop.  Possible Changes' + nl
                 )
     end
     else
     begin
              WriteToFile('*************************************************************' + nl +
                 'EVENT: Configure stop. No Changes' + nl
                 );
                 end;
end;

{*******************************************************************************
*
*******************************************************************************}
function PluginName(): PChar; cdecl;
begin
     result := PChar('MaLa Event Logger');
end;

{*******************************************************************************
*
*******************************************************************************}
function PluginCopyright(): PChar; cdecl;
begin
     result := PChar('2009 by S.Windus');
end;

{*******************************************************************************
*
*******************************************************************************}
procedure MaLaStart(); cdecl;
var
parent: hwnd;
begin
     WriteToFile('*************************************************************' + nl +
                 'EVENT: MaLa start' + nl);
     // Plugin Configuration:
     ConfigureF := TConfigureF.Create(nil); // Only required if configure window desired
     // Note: This is where you would add code to load the configuration file.
end;

{*******************************************************************************
*
*******************************************************************************}
procedure MaLaQuit(); cdecl;
begin
     WriteToFile('*************************************************************' + nl +
                 'EVENT: MaLa quit' + nl );
     // Plugin Configuration:
     ConfigureF.Destroy;  // ** Only required if plugin configure is used
end;

{*******************************************************************************
*
*******************************************************************************}
Procedure PluginConfigure(); cdecl;
begin
    WriteToFile('*************************************************************' + nl +
                 'EVENT: PluginConfigure' + nl );
    ConfigureF.ShowModal;
end;

{*******************************************************************************
*
*******************************************************************************}

exports
  MaLaGameSelected,
  MaLaEmulatorSelected,
  MaLaListSelected,
  MaLaOrientationSwitch,
  MaLaGameStart,
  MaLaGameQuit,
  MaLaScreensaverStart,
  MaLaScreensaverSwitch,
  MaLaScreensaverStop,
  MaLaAttractModeStart,
  MaLaAttractModeStop,
  MaLaStart,
  MaLaQuit,
  MaLaTreeUp,
  MaLaTreeDown,
  MaLaConfigureStart,
  MaLaConfigureStop,
  PluginName,
  PluginCopyright,
  PluginConfigure;

{$R *.RES}

begin

end.
