<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- xml2info.xsl version 0.7 for transforming MAME XML to listinfo format -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text"/>

	<xsl:template match="/">

		<xsl:variable name="extascii">&#180;&#176;&#179;&#233;&#130;&#138;&#147;&#190;&#204;&#150;&#240;&#129;&#145;&#228;</xsl:variable>
		<xsl:variable name="ascii">''3e??????????</xsl:variable>

		<xsl:for-each select="mame/game">

			<xsl:choose>
				<xsl:when test="@runnable='yes'">game</xsl:when>
				<xsl:otherwise>resource</xsl:otherwise>
			</xsl:choose>

			<xsl:value-of select="concat(' (','&#x0A;','&#x09;name ',@name,'&#x0A;')" />
			<xsl:if test="@sourcefile"><xsl:value-of select="concat('&#x09;sourcefile ',@sourcefile,'&#x0A;')" /></xsl:if>
			<xsl:if test="@cloneof"><xsl:value-of select="concat('&#x09;cloneof ',@cloneof,'&#x0A;')" /></xsl:if>
			<xsl:if test="@romof"><xsl:value-of select="concat('&#x09;romof ',@romof,'&#x0A;')" /></xsl:if>
			<xsl:if test="@sampleof"><xsl:value-of select="concat('&#x09;sampleof ',@sampleof,'&#x0A;')" /></xsl:if>
			<xsl:value-of select="concat('&#x09;description &quot;',translate(description,$extascii,$ascii),'&quot;&#x0A;')" />
			<xsl:if test="year"><xsl:value-of select="concat('&#x09;year ',year,'&#x0A;')" /></xsl:if>
			<xsl:value-of select="concat('&#x09;manufacturer &quot;',translate(manufacturer,$extascii,$ascii),'&quot;&#x0A;')" />

			<xsl:for-each select="biosset">
				<xsl:value-of select="concat('&#x09;biosset ( name ',@name,' description &quot;',@description,'&quot;')" />
				<xsl:if test="@default='yes'"><xsl:value-of select="concat(' default ',@default)" /></xsl:if>
				<xsl:value-of select="concat(' )&#x0A;','')" />
			</xsl:for-each>

			<xsl:for-each select="rom">
				<xsl:value-of select="concat('&#x09;rom ( name ',translate(@name, ' ', '_'))" />
				<xsl:if test="@merge"><xsl:value-of select="concat(' merge ',@merge)" /></xsl:if>
				<xsl:if test="@bios"><xsl:value-of select="concat(' bios ',@bios)" /></xsl:if>
				<xsl:value-of select="concat(' size ',@size)" />
				<xsl:if test="@crc"><xsl:value-of select="concat(' crc ',@crc)" /></xsl:if>
				<xsl:if test="@sha1"><xsl:value-of select="concat(' sha1 ',@sha1)" /></xsl:if>
				<xsl:value-of select="concat(' region ',@region)" />
				<xsl:if test="@status='baddump'"><xsl:value-of select="concat(' flags ','baddump')" /></xsl:if>
				<xsl:if test="@status='nodump'"><xsl:value-of select="concat(' flags ','nodump')" /></xsl:if>
				<xsl:if test="@dispose='yes'"><xsl:value-of select="concat(' flags ','dispose')" /></xsl:if>
				<xsl:if test="@soundonly='yes'"><xsl:value-of select="concat(' flags ','soundonly')" /></xsl:if>
				<xsl:value-of select="concat(' offs ',@offset,' )&#x0A;')" />
			</xsl:for-each>

			<xsl:for-each select="disk">
				<xsl:value-of select="concat('&#x09;disk ( name ',translate(@name, ' ', '_'))" />
				<xsl:if test="@merge"><xsl:value-of select="concat(' merge ',@merge)" /></xsl:if>
				<xsl:if test="@sha1"><xsl:value-of select="concat(' sha1 ',@sha1)" /></xsl:if>
				<xsl:if test="@md5"><xsl:value-of select="concat(' md5 ',@md5)" /></xsl:if>
				<xsl:value-of select="concat(' region ',@region)" />
				<xsl:if test="@status='baddump'"><xsl:value-of select="concat(' flags ','baddump')" /></xsl:if>
				<xsl:if test="@status='nodump'"><xsl:value-of select="concat(' flags ','nodump')" /></xsl:if>
				<xsl:value-of select="concat(' index ',@index,' )&#x0A;')" />
			</xsl:for-each>

			<xsl:for-each select="sample">
				<xsl:value-of select="concat('&#x09;sample ',@name,'&#x0A;')" />
			</xsl:for-each>

			<xsl:for-each select="chip">
				<xsl:value-of select="concat('&#x09;chip ( type ',@type)" />
				<xsl:if test="@soundonly='yes'"><xsl:value-of select="concat(' flags ','audio')" /></xsl:if>
				<xsl:value-of select="concat(' name &quot;',@name,'&quot;')" />
				<xsl:if test="@clock"><xsl:value-of select="concat(' clock ',@clock)" /></xsl:if>
				<xsl:value-of select="concat(' )&#x0A;','')" />
			</xsl:for-each>

			<xsl:for-each select="display[1]">
				<xsl:value-of select="concat('&#x09;video (',' screen ',@type,' orientation ')" />
				<xsl:variable name="vertical" select="number(@rotate) div 10 mod 2" />
				<xsl:choose>
					<xsl:when test="$vertical">vertical</xsl:when>
					<xsl:otherwise>horizontal</xsl:otherwise>
				</xsl:choose>
				<xsl:if test="@type!='vector'">
					<xsl:choose>
						<xsl:when test="$vertical"><xsl:value-of select="concat(' x ',@height,' y ',@width)" /></xsl:when>
						<xsl:otherwise><xsl:value-of select="concat(' x ',@width,' y ',@height)" /></xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="$vertical"><xsl:value-of select="concat(' aspectx 3',' aspecty 4')" /></xsl:when>
					<xsl:otherwise><xsl:value-of select="concat(' aspectx',' 4 aspecty 3')" /></xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="concat(' freq ',@refresh,' )&#x0A;')" />
			</xsl:for-each>

			<xsl:for-each select="video">
				<xsl:value-of select="concat('&#x09;video (',' screen ',@screen,' orientation ',@orientation)" />
				<xsl:if test="@screen!='vector'"><xsl:value-of select="concat(' x ',@width,' y ',@height)" /></xsl:if>
				<xsl:value-of select="concat(' aspectx ',@aspectx,' aspecty ',@aspecty,' freq ',@refresh,' )&#x0A;')" />
			</xsl:for-each>

			<xsl:for-each select="sound">
				<xsl:value-of select="concat('&#x09;sound (',' channels ',@channels,' )&#x0A;')" />
			</xsl:for-each>

			<xsl:for-each select="input">
				<xsl:value-of select="concat('&#x09;input (',' players ',@players)" />
				<xsl:choose>
					<xsl:when test="@control"><xsl:value-of select="concat(' control ',@control)" /></xsl:when>
					<xsl:when test="control[1]"><xsl:value-of select="concat(' control ',control[1]/@type)" /></xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
				<xsl:if test="@buttons"><xsl:value-of select="concat(' buttons ',@buttons)" /></xsl:if>
				<xsl:if test="@coins"><xsl:value-of select="concat(' coins ',@coins)" /></xsl:if>
				<xsl:if test="@service='yes'"><xsl:value-of select="concat(' service ',@service)" /></xsl:if>
				<xsl:if test="@tilt='yes'"><xsl:value-of select="concat(' tilt ',@tilt)" /></xsl:if>
				<xsl:value-of select="concat(' )&#x0A;','')" />
			</xsl:for-each>

			<xsl:for-each select="dipswitch">
				<xsl:value-of select="concat('&#x09;dipswitch (',' name &quot;')" />
				<xsl:call-template name="cleanQuote">
					<xsl:with-param name="string" select="translate(@name,$extascii,$ascii)" />
				</xsl:call-template>
				<xsl:value-of select="concat('&quot;','')" />
				<xsl:for-each select="dipvalue">
					<xsl:value-of select="concat(' entry &quot;',translate(@name,$extascii,$ascii),'&quot;')" />
					<xsl:if test="@default='yes'"><xsl:value-of select="concat(' default &quot;',translate(@name,$extascii,$ascii),'&quot;')" /></xsl:if>
				</xsl:for-each>
				<xsl:value-of select="concat(' )&#x0A;','')" />
			</xsl:for-each>

			<xsl:for-each select="driver">
				<xsl:value-of select="concat('&#x09;driver ( status ',@status)" />
				<xsl:if test="@emulation"><xsl:value-of select="concat(' emulation ',@emulation)" /></xsl:if>
				<xsl:value-of select="concat(' color ',@color,' sound ',@sound)" />
				<xsl:if test="@graphic"><xsl:value-of select="concat(' graphic ',@graphic)" /></xsl:if>
				<xsl:if test="@cocktail"><xsl:value-of select="concat(' cocktail ',@cocktail)" /></xsl:if>
				<xsl:if test="@protection"><xsl:value-of select="concat(' protection ',@protection)" /></xsl:if>
				<xsl:if test="@savestate"><xsl:value-of select="concat(' savestate ',@savestate)" /></xsl:if>
				<xsl:value-of select="concat(' palettesize ',@palettesize,' )&#x0A;')" />
			</xsl:for-each>
			<xsl:value-of select="concat(')&#x0A;&#x0A;','')" />

		</xsl:for-each>

	</xsl:template>

	<!-- the template below is for replacing ["] with [\"] in strings -->
	<xsl:template name="cleanQuote">
		<xsl:param name="string" />
		<xsl:if test="contains($string, '&#x22;')">
			<xsl:value-of select="substring-before($string, '&#x22;')" />
			<xsl:text>\"</xsl:text>
			<xsl:call-template name="cleanQuote">
				<xsl:with-param name="string" select="substring-after($string, '&#x22;')" />
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="not(contains($string, '&#x22;'))">
			<xsl:value-of select="$string" />
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
