/*
 * Decompiled with CFR 0.152.
 */
package emu98;

import emu98.Emulator;
import io.HP9800Mainframe;
import io.HP9810A.HP9810Mainframe;
import io.HP9810A.HP9810Mainframe2;
import io.HP9820A.HP9820Mainframe;
import io.HP9821A.HP9821Mainframe;
import io.HP9830A.HP9830Mainframe;
import io.SoundMedia;

public class HP9800E {
    public static void usage() {
        System.out.println("Usage: HP9800E.jar < Machine-Configuration >");
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            HP9800E.usage();
            System.exit(1);
        }
        System.out.println("HP9800 Emulator Release 1.41, Copyright (C) 2006-2009 Achim Buerger\n");
        System.out.println("HP9800E comes with ABSOLUTELY NO WARRANTY.");
        System.out.println("This is free software, and you are welcome to");
        System.out.println("redistribute it under certain conditions.\n");
        String machine = args[0];
        HP9800Mainframe mainframe = null;
        SoundMedia.enable(true);
        Emulator emu = new Emulator(machine);
        if (emu.model.equals("HP9830A")) {
            mainframe = new HP9830Mainframe(emu);
        } else if (emu.model.equals("HP9821A")) {
            mainframe = new HP9821Mainframe(emu);
        } else if (emu.model.equals("HP9820A")) {
            mainframe = new HP9820Mainframe(emu);
        } else if (emu.model.equals("HP9810A")) {
            mainframe = Integer.parseInt(emu.version) == 1 ? new HP9810Mainframe(emu) : new HP9810Mainframe2(emu);
        } else {
            System.err.println(String.valueOf(machine) + " not implemented.");
            System.exit(1);
        }
        emu.start();
    }
}

