/*
 * Decompiled with CFR 0.152.
 */
package io;

import emu98.Console;
import emu98.Emulator;
import emu98.InstructionsWindow;
import emu98.ROMselector;
import io.HP9865A;
import io.IOregister;
import io.SoundMedia;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

public class HP9800Mainframe
extends Frame
implements KeyListener,
LineListener {
    private static final long serialVersionUID = 1L;
    public static int keyWidth = 42;
    public static int keyOffsetY = 525;
    public static int[] keyOffsetX;
    public static int[][] keyCodes;
    public static int KEYB_W;
    public static int KEYB_H;
    public static int DISPLAY_X;
    public static int DISPLAY_Y;
    public static int DISPLAY_W;
    public static int DISPLAY_H;
    public static int LED_X;
    public static int LED_Y;
    public static int LED_DOT_SIZE;
    public static int PAPER_HEIGHT;
    public static int PAPER_WIDTH;
    public static int PAPER_LEFT;
    public static int PAPER_EDGE;
    public static int BLOCK1_X;
    public static int BLOCK1_Y;
    public static int BLOCK2_X;
    public static int BLOCK2_Y;
    public static int BLOCK3_X;
    public static int BLOCK3_Y;
    public static int BLOCK_W;
    public static int BLOCK_H;
    public static int STOP_KEYCODE;
    public Emulator emu;
    public IOregister ioReg;
    public Console console;
    public ROMselector romSelector;
    public InstructionsWindow instructionsWindow;
    public Image keyboardImage;
    public Image displayImage;
    public Color ledRed;
    public Color ledBack;
    public Color paperWhite;
    public Color paperGray;
    SoundMedia fanSound;
    SoundMedia printSound;
    SoundMedia paperSound;
    Vector printBuffer;
    byte[] lineBuffer;
    public int numLines;
    public int page;
    int dotLine = 0;
    public boolean backgroundImage = false;
    boolean printing = false;
    public boolean advancing = false;
    boolean showKeycode = false;

    static {
        KEYB_W = 1000;
        KEYB_H = 578;
        DISPLAY_X = 100;
        DISPLAY_Y = 105;
        DISPLAY_W = 320;
        DISPLAY_H = 118;
        LED_X = 100;
        LED_Y = 25;
        LED_DOT_SIZE = 3;
        PAPER_HEIGHT = 168;
        PAPER_WIDTH = 124;
        PAPER_LEFT = 548;
        PAPER_EDGE = 126;
        BLOCK1_X = 23;
        BLOCK1_Y = 3;
        BLOCK2_X = 174;
        BLOCK2_Y = 3;
        BLOCK3_X = 324;
        BLOCK3_Y = 3;
        BLOCK_W = 152;
        BLOCK_H = 54;
        STOP_KEYCODE = 33;
    }

    public HP9800Mainframe(Emulator emu, String machine) {
        super(machine);
        this.emu = emu;
        this.ioReg = emu.ioRegister;
        this.console = new Console((Frame)this, emu);
        emu.setConsole(this.console);
        emu.ioRegister.setDisassemblerOutput(this.console);
        this.addKeyListener(this);
        this.addWindowListener(new windowListener());
        this.fanSound = new SoundMedia("media/HP9800/HP9800_FAN.wav");
        this.fanSound.loop();
        this.romSelector = new ROMselector((Frame)this, emu);
        this.instructionsWindow = new InstructionsWindow((Frame)this, emu);
        this.instructionsWindow.setSize(860, 800);
        this.ledRed = new Color(255, 64, 32);
        this.ledBack = new Color(31, 10, 9);
        this.setBackground(Color.BLACK);
        this.setLocation(0, 100);
        if (!machine.startsWith("HP9830")) {
            this.printSound = new SoundMedia("media/HP9810A/HP9810A_PRINT_LINE.wav");
            this.paperSound = new SoundMedia("media/HP9810A/HP9810A_PAPER.wav");
            this.paperWhite = new Color(230, 230, 230);
            this.paperGray = new Color(100, 100, 85);
            this.initializeBuffer();
            System.out.println("HP9800 Printer at select code 4:0 loaded.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize() {
        this.setResizable(false);
        this.setVisible(true);
        Image image = this.keyboardImage;
        synchronized (image) {
            try {
                this.keyboardImage.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setSize(this.keyboardImage.getWidth(this) + this.getInsets().left + this.getInsets().right, this.keyboardImage.getHeight(this) + this.getInsets().top + this.getInsets().bottom);
    }

    public void setTapeDevice(HP9865A tapeDevice) {
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
    }

    public void displayLEDs(int keyLEDs) {
    }

    public void display(int reg, int i) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(KeyEvent event) {
        int numPages = this.numLines / PAPER_HEIGHT;
        char keyChar = event.getKeyChar();
        int keyCode = event.getKeyCode();
        String strCode = "";
        String modifier = "";
        switch (keyCode) {
            case 0: {
                if (keyChar != '\uffff') {
                    strCode = Integer.toString(keyChar);
                    break;
                }
                return;
            }
            case 16: 
            case 17: 
            case 18: 
            case 144: {
                return;
            }
            default: {
                if (event.isControlDown()) {
                    switch (keyCode) {
                        case 68: {
                            this.console.setVisible(!this.console.isVisible());
                            break;
                        }
                        case 70: {
                            this.fanSound.toggle();
                            break;
                        }
                        case 75: {
                            this.showKeycode = !this.showKeycode;
                            this.repaint();
                            break;
                        }
                        case 82: {
                            if (!event.isAltDown()) break;
                            IOregister iOregister = this.ioReg;
                            synchronized (iOregister) {
                                this.ioReg.reset = true;
                                break;
                            }
                        }
                        case 83: {
                            if (SoundMedia.isEnabled()) {
                                this.fanSound.stop();
                                SoundMedia.enable(false);
                                break;
                            }
                            SoundMedia.enable(true);
                            this.fanSound.loop();
                            break;
                        }
                        case 84: {
                            if (this.emu.measure) {
                                this.emu.stopMeasure();
                                this.console.append("NumOps=" + this.emu.numOps);
                                this.console.append(" Min=" + this.emu.minExecTime);
                                this.console.append(" Max=" + this.emu.maxExecTime);
                                this.console.append(" Mean=" + this.emu.sumExecTime / this.emu.numOps + "[ns]\n");
                                if (this.console.isVisible()) break;
                                this.console.setVisible(true);
                                break;
                            }
                            this.emu.startMeasure();
                            break;
                        }
                        case 33: {
                            if (--this.page < 0) {
                                this.page = 0;
                            }
                            this.displayPrintOutput();
                            break;
                        }
                        case 34: {
                            ++this.page;
                            if (this.page >= numPages) {
                                this.page = numPages;
                                this.repaint();
                                break;
                            }
                            this.displayPrintOutput();
                            break;
                        }
                        case 127: {
                            this.initializeBuffer();
                            this.page = 0;
                            this.repaint();
                            break;
                        }
                        case 36: {
                            this.print(3);
                            keyCode = -1;
                        }
                    }
                    return;
                }
                strCode = Integer.toString(keyCode);
            }
        }
        if (event.isAltDown()) {
            modifier = "A";
        }
        if (event.isControlDown()) {
            modifier = String.valueOf(modifier) + "C";
        }
        if (event.isShiftDown()) {
            modifier = String.valueOf(modifier) + "S";
        }
        if (this.emu.keyLogMode) {
            this.emu.console.append(strCode);
            if (modifier != "") {
                this.emu.console.append(" " + modifier);
            }
            this.emu.console.append(" ; " + (char)keyChar);
            return;
        }
        if ((strCode = (String)this.emu.keyCodes.get(String.valueOf(strCode) + modifier)) != null) {
            keyCode = Integer.parseInt(strCode, 8);
        } else if (keyChar >= ' ' && keyChar <= 'z') {
            keyCode = Character.isLowerCase((int)keyChar) ? Character.toUpperCase((int)keyChar) : (Character.isUpperCase((int)keyChar) ? keyChar + 128 : (int)keyChar);
        } else {
            return;
        }
        if (keyCode == STOP_KEYCODE) {
            this.ioReg.STP = true;
        }
        event.consume();
        this.ioReg.bus.keyboard.setKeyCode(keyCode);
        this.ioReg.bus.keyboard.requestInterrupt();
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public void initializeBuffer() {
        this.numLines = 0;
        this.lineBuffer = new byte[16];
        this.printBuffer = new Vector();
    }

    public void print(int dotGroup) {
        int i = (dotGroup & 3) * 4;
        if (this.dotLine == 0 && !this.printing) {
            this.printSound.start();
            this.printing = true;
        }
        this.lineBuffer[i++] = (byte)(dotGroup >> 16 & 0x1F);
        this.lineBuffer[i++] = (byte)(dotGroup >> 21 & 0x1F);
        this.lineBuffer[i++] = (byte)(dotGroup >> 6 & 0x1F);
        this.lineBuffer[i++] = (byte)(dotGroup >> 11 & 0x1F);
        if (i == 16) {
            ++this.numLines;
            this.printBuffer.addElement(this.lineBuffer);
            this.lineBuffer = new byte[16];
            this.displayPrintOutput();
            if (++this.dotLine == 10) {
                this.dotLine = 0;
                this.printing = false;
            }
            try {
                Thread.sleep(SoundMedia.isEnabled() ? this.ioReg.time_32ms : 0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void update(LineEvent event) {
        if (this.advancing && event.getType() == LineEvent.Type.STOP) {
            this.paper(true);
        }
    }

    public void paper(boolean advance) {
        if (!advance) {
            this.advancing = false;
            this.paperSound.getClip().removeLineListener(this);
            return;
        }
        this.advancing = true;
        this.paperSound.getClip().addLineListener(this);
        this.paperSound.start();
        int i = 1;
        while (i <= 10) {
            ++this.numLines;
            this.printBuffer.addElement(this.lineBuffer);
            try {
                Thread.sleep(SoundMedia.isEnabled() ? this.ioReg.time_32ms : 0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.lineBuffer = new byte[16];
            this.displayPrintOutput();
            ++i;
        }
    }

    public void displayPrintOutput() {
        int minLine;
        if (this.numLines == 0) {
            return;
        }
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        int x = this.getInsets().left;
        int y = this.getInsets().top;
        int maxLine = this.numLines - this.page * PAPER_HEIGHT;
        if (maxLine < 0) {
            maxLine = 0;
        }
        if ((minLine = maxLine - PAPER_HEIGHT - 1) < 0) {
            minLine = 0;
        }
        g.setColor(this.paperWhite);
        g.fillRect(x += PAPER_LEFT, y + PAPER_HEIGHT - maxLine, PAPER_WIDTH, maxLine);
        x += 8;
        y += PAPER_HEIGHT - 1;
        g.setColor(Color.BLUE);
        int i = maxLine - 1;
        while (i >= minLine) {
            byte[] lineBuffer = (byte[])this.printBuffer.elementAt(i);
            int j = 0;
            while (j < 16) {
                int dotRow = lineBuffer[j];
                int n = 4;
                while (n >= 0) {
                    if ((dotRow & 1) != 0) {
                        int xd = x + 7 * j + n;
                        g.drawLine(xd, y, xd, y);
                    }
                    dotRow >>= 1;
                    --n;
                }
                ++j;
            }
            --y;
            --i;
        }
        x = this.getInsets().left + PAPER_LEFT;
        y = this.getInsets().top + PAPER_EDGE;
        g.setColor(this.paperGray);
        g.fillRect(x, y, PAPER_WIDTH, 6);
    }

    public void displayKeyMatrix() {
        if (!this.showKeycode) {
            return;
        }
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        g.setColor(new Color(0, 120, 250));
        Font font = new Font("Sans", 1, 12);
        g.setFont(font);
        int row = 0;
        while (row < keyOffsetX.length) {
            int y = keyOffsetY - this.getInsets().top - row * keyWidth;
            int col = 0;
            while (col < keyCodes[row].length) {
                int keyCode = keyCodes[row][col];
                if (keyCode != -1) {
                    int x = this.emu.model.equals("HP9830A") && col > 11 ? keyOffsetX[7] : keyOffsetX[row];
                    g.drawRect(x += col * keyWidth + this.getInsets().left, y, keyWidth, keyWidth);
                    if (keyCode < 448) {
                        String strKey = Integer.toString(keyCode);
                        if ((strKey = (String)this.emu.keyStrings.get(strKey)) == null) {
                            strKey = String.valueOf((char)keyCode);
                        }
                        g.drawString(strKey, x + 5, y + keyWidth - 5);
                    }
                }
                ++col;
            }
            ++row;
        }
    }

    class windowListener
    extends WindowAdapter {
        windowListener() {
        }

        public void windowClosing(WindowEvent event) {
            HP9800Mainframe.this.setVisible(false);
            HP9800Mainframe.this.dispose();
            System.out.println("HP9800 Emulator terminated.");
            System.exit(0);
        }
    }

    public class mouseListener
    extends MouseAdapter {
    }
}

