/*
 * Decompiled with CFR 0.152.
 */
package io.HP9821A;

import emu98.Emulator;
import emu98.Memory;
import emu98.MemoryBlock;
import io.HP9820A.HP9820Mainframe;
import io.HP9830A.HP9830Beeper;
import io.HP9865A;
import io.ImageMedia;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class HP9821Mainframe
extends HP9820Mainframe {
    private static final long serialVersionUID = 1L;
    static final int[] HP9821keyOffsetX = new int[]{110, 110, 110, 110, 110, 110, 110, 110, 110};
    static final int[][] HP9821keyCodes = new int[][]{{63, 32, -1, 72, 77, -1, 82, 87, -1, 48, 48, 46, 93, 93, -1, 91, 91, 33, 2, 2}, {39, 15, -1, 71, 76, -1, 81, 86, -1, 43, 49, 50, 51, 59, -1, 95, 58, 35, 31, 64}, {38, 14, -1, 70, 75, -1, 80, 85, -1, 45, 52, 53, 54, 44, -1, 67, 90, 61, 30, 27}, {37, 9, -1, 69, 74, -1, 79, 84, -1, 42, 55, 56, 57, 34, -1, 66, 89, 60, 28, 29}, {36, 8, -1, 68, 73, -1, 78, 83, -1, 47, 92, 94, 40, 41, -1, 65, 88, 62, 25, 26}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {16, 17, -1, 97, 98, 96, -1, 100, 99, -1, 3, -1, 20, 21, 23, 22, -1, 4, 5, 24}, {101, -1, -1, -1, -1, -1, -1, 18, 19, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 510}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 511, -1, -1, -1, -1, -1, -1}};
    HP9865A tapeDevice;
    boolean tapeLoaded = false;

    public HP9821Mainframe(Emulator emu) {
        super(emu, "HP9821A");
        keyWidth = 42;
        keyOffsetY = 615;
        keyOffsetX = HP9821keyOffsetX;
        keyCodes = HP9821keyCodes;
        DISPLAY_X = 74;
        DISPLAY_Y = 133;
        DISPLAY_W = 75;
        DISPLAY_H = 12;
        LED_X = 45;
        LED_Y = 8;
        PAPER_HEIGHT = 208;
        PAPER_LEFT = 557;
        PAPER_EDGE = 123;
        BLOCK1_X = 33;
        BLOCK2_X = 185;
        BLOCK3_X = 336;
        TEMPLATE1_X = 87;
        TEMPLATE1_Y = 391;
        TEMPLATE2_X = 214;
        TEMPLATE2_Y = 391;
        TEMPLATE3_X = 342;
        TEMPLATE3_Y = 391;
        TEMPLATE_W = 118;
        TEMPLATE_H = 223;
        this.addMouseListener(new mouseListener());
        int MAW = 13312;
        while (MAW > 9216) {
            if (emu.memory[MAW - 1].isRW) break;
            MAW -= 2048;
        }
        emu.memory[767] = new Memory(false, 767, MAW);
        this.ioReg.bus.cardReader = new HP9830Beeper(this, this.ioReg);
        this.tapeDevice = new HP9865A(emu.ioRegister, 5);
        this.tapeDevice.setStatusFrame(this, 880, 177);
        this.romSelector.addRomButton("media/HP9821A/HP11XXXX_Block.jpg", "HP11XXXX");
        this.romSelector.addRomButton("media/HP9821A/HP11220A_Block.jpg", "HP11220A");
        this.romSelector.addRomButton("media/HP9821A/HP11221A_Block.jpg", "HP11221A");
        this.romSelector.addRomButton("media/HP9821A/HP11222A_Block.jpg", "HP11222A");
        this.keyboardImage = new ImageMedia("media/HP9821A/HP9821A_Keyboard.jpg").getImage();
        this.setSize();
        System.out.println("HP9821 Mainframe loaded.");
    }

    class mouseListener
    extends MouseAdapter {
        mouseListener() {
        }

        public void mousePressed(MouseEvent event) {
            int x = event.getX() - HP9821Mainframe.this.getInsets().left;
            int y = event.getY() - HP9821Mainframe.this.getInsets().top;
            if (y > 10 && y < 50) {
                if (x >= 25 && x <= 475) {
                    int block = (x - 25) / 150 + 1;
                    if (event.getButton() == 1) {
                        HP9821Mainframe.this.romSelector.setRomSlot("Slot" + Integer.toString(block));
                        HP9821Mainframe.this.romSelector.setTitle("HP9821A ROM Blocks Slot " + Integer.toString(block));
                        HP9821Mainframe.this.romSelector.setVisible(true);
                    } else {
                        MemoryBlock romBlock = (MemoryBlock)HP9821Mainframe.this.emu.memoryBlocks.get("Slot" + Integer.toString(block));
                        if (romBlock != null) {
                            HP9821Mainframe.this.instructionsWindow.setROMblock(romBlock);
                            HP9821Mainframe.this.instructionsWindow.showInstructions();
                        }
                    }
                }
                return;
            }
            int row = keyOffsetY - y;
            if (row < 0) {
                return;
            }
            if ((row /= keyWidth) > 8) {
                return;
            }
            int col = x - keyOffsetX[row];
            if (col < 0) {
                return;
            }
            if ((col /= keyWidth) > 19) {
                return;
            }
            int keyCode = keyCodes[row][col];
            if (keyCode == 510) {
                HP9821Mainframe.this.keyboardImage = new ImageMedia("media/HP9821A/HP9821A_Keyboard+Tape.jpg").getImage();
                HP9821Mainframe.this.repaint();
                HP9821Mainframe.this.tapeLoaded = HP9821Mainframe.this.tapeDevice.openTapeFile();
                if (!HP9821Mainframe.this.tapeLoaded) {
                    HP9821Mainframe.this.keyboardImage = new ImageMedia("media/HP9821A/HP9821A_Keyboard.jpg").getImage();
                    HP9821Mainframe.this.repaint();
                    return;
                }
                HP9821Mainframe.this.keyboardImage = new ImageMedia("media/HP9821A/HP9821A_Keyboard+Cassette.jpg").getImage();
                HP9821Mainframe.this.repaint();
                return;
            }
            if (keyCode == 511) {
                HP9821Mainframe.this.paper(true);
                return;
            }
            if (keyCode != -1) {
                if (HP9821Mainframe.this.emu.keyLogMode) {
                    HP9821Mainframe.this.emu.console.append("\n" + Integer.toOctalString(keyCode) + " ");
                    return;
                }
                HP9821Mainframe.this.ioReg.bus.keyboard.setKeyCode(keyCode);
                HP9821Mainframe.this.ioReg.bus.keyboard.requestInterrupt();
            }
        }

        public void mouseReleased(MouseEvent event) {
            if (HP9821Mainframe.this.advancing) {
                HP9821Mainframe.this.paper(false);
            }
        }
    }
}

