/*
 * Decompiled with CFR 0.152.
 */
package io.HP9830A;

import io.DisplayInterface;
import io.HP9800Mainframe;
import io.IOinterface;
import io.IOregister;

public class HP9830DisplayInterface
extends IOinterface
implements DisplayInterface {
    HP9800Mainframe mainframe;
    int[][] displayBuffer;
    boolean equal;

    public HP9830DisplayInterface(HP9800Mainframe mainframe, IOregister ioReg) {
        super(0, ioReg);
        this.mainframe = mainframe;
        this.displayBuffer = new int[1][32];
        int i = 0;
        while (i < 32) {
            this.displayBuffer[0][i] = 0;
            ++i;
        }
        this.equal = false;
        System.out.println("HP9830 Display at select code 8:0 loaded.");
    }

    public int[][] getDisplayBuffer() {
        return this.displayBuffer;
    }

    public int getKeyLEDs() {
        return 0;
    }

    public void blank() {
        int j = 0;
        while (j < 32) {
            this.displayBuffer[0][j] = 32;
            ++j;
        }
        int l = this.mainframe.getInsets().left;
        int t = this.mainframe.getInsets().top;
        this.mainframe.repaint(l + HP9800Mainframe.DISPLAY_X, t + HP9800Mainframe.DISPLAY_Y, HP9800Mainframe.DISPLAY_W, HP9800Mainframe.DISPLAY_H);
    }

    public boolean output(int printValue) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean output() {
        IOregister iOregister = this.ioReg;
        synchronized (iOregister) {
            block11: {
                if (!this.ioReg.KLS) break block11;
                return false;
            }
            if (this.ioReg.DEN) {
                int pos = this.ioReg.getValue() & 0xF;
                int c1 = (this.ioReg.getValue() & 0xFC00) >> 10;
                int c2 = (this.ioReg.getValue() & 0x3F0) >> 4;
                this.equal = this.displayBuffer[0][pos] == c1;
                this.equal &= this.displayBuffer[0][pos + 16] == c2;
                if (!this.equal) {
                    this.displayBuffer[0][pos] = c1;
                    this.displayBuffer[0][pos + 16] = c2;
                    this.mainframe.display(0, pos);
                    this.mainframe.display(0, pos + 16);
                }
                if (pos == 0) {
                    this.ioReg.dispSRQ = false;
                }
                try {
                    if (pos == 15 && !this.ioReg.dispSRQ) {
                        this.ioReg.wait(this.ioReg.time_16ms);
                    } else {
                        Thread.yield();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

