/*
 * Decompiled with CFR 0.152.
 */
package io.HP9830A;

import emu98.Emulator;
import emu98.MemoryBlock;
import io.HP9800Mainframe;
import io.HP9830A.HP9830Beeper;
import io.HP9830A.HP9830DisplayInterface;
import io.HP9830A.HP9830KeyboardInterface;
import io.HP9830A.HP9830ROMslots;
import io.HP9865A;
import io.ImageMedia;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class HP9830Mainframe
extends HP9800Mainframe {
    private static final long serialVersionUID = 1L;
    static int[][] ledMatrixValues;
    static int[] HP9830keyOffsetX;
    static int[][] HP9830keyCodes;
    HP9830ROMslots romSlots;
    HP9865A tapeDevice;
    Image[] ledMatrix;
    boolean tapeLoaded = false;

    static {
        int[][] nArrayArray = new int[64][];
        nArrayArray[0] = new int[]{62, 65, 93, 85, 60};
        nArrayArray[1] = new int[]{63, 72, 72, 72, 63};
        nArrayArray[2] = new int[]{127, 73, 73, 73, 54};
        nArrayArray[3] = new int[]{62, 65, 65, 65, 34};
        nArrayArray[4] = new int[]{65, 127, 65, 65, 62};
        nArrayArray[5] = new int[]{127, 73, 73, 73, 65};
        nArrayArray[6] = new int[]{127, 72, 72, 72, 64};
        nArrayArray[7] = new int[]{62, 65, 65, 69, 71};
        nArrayArray[8] = new int[]{127, 8, 8, 8, 127};
        int[] nArray = new int[5];
        nArray[1] = 65;
        nArray[2] = 127;
        nArray[3] = 65;
        nArrayArray[9] = nArray;
        nArrayArray[10] = new int[]{2, 1, 1, 1, 126};
        nArrayArray[11] = new int[]{127, 8, 20, 34, 65};
        nArrayArray[12] = new int[]{127, 1, 1, 1, 1};
        nArrayArray[13] = new int[]{127, 32, 24, 32, 127};
        nArrayArray[14] = new int[]{127, 16, 8, 4, 127};
        nArrayArray[15] = new int[]{62, 65, 65, 65, 62};
        nArrayArray[16] = new int[]{127, 72, 72, 72, 48};
        nArrayArray[17] = new int[]{62, 65, 69, 66, 61};
        nArrayArray[18] = new int[]{127, 72, 76, 74, 49};
        nArrayArray[19] = new int[]{50, 73, 73, 73, 38};
        nArrayArray[20] = new int[]{64, 64, 127, 64, 64};
        nArrayArray[21] = new int[]{126, 1, 1, 1, 126};
        nArrayArray[22] = new int[]{112, 12, 3, 12, 112};
        nArrayArray[23] = new int[]{127, 2, 12, 2, 127};
        nArrayArray[24] = new int[]{99, 20, 8, 20, 99};
        nArrayArray[25] = new int[]{96, 16, 15, 16, 96};
        nArrayArray[26] = new int[]{67, 69, 73, 81, 97};
        int[] nArray2 = new int[5];
        nArray2[1] = 127;
        nArray2[2] = 65;
        nArray2[3] = 65;
        nArrayArray[27] = nArray2;
        nArrayArray[28] = new int[]{127, 127, 127, 127, 127};
        int[] nArray3 = new int[5];
        nArray3[1] = 65;
        nArray3[2] = 65;
        nArray3[3] = 127;
        nArrayArray[29] = nArray3;
        nArrayArray[30] = new int[]{16, 32, 127, 32, 16};
        nArrayArray[31] = new int[]{127, 8, 8, 8, 8};
        nArrayArray[32] = new int[5];
        int[] nArray4 = new int[5];
        nArray4[2] = 125;
        nArrayArray[33] = nArray4;
        int[] nArray5 = new int[5];
        nArray5[1] = 96;
        nArray5[3] = 96;
        nArrayArray[34] = nArray5;
        nArrayArray[35] = new int[]{20, 127, 20, 127, 20};
        nArrayArray[36] = new int[]{18, 42, 127, 42, 36};
        nArrayArray[37] = new int[]{98, 100, 8, 19, 35};
        nArrayArray[38] = new int[]{54, 73, 53, 2, 5};
        int[] nArray6 = new int[5];
        nArray6[1] = 104;
        nArray6[2] = 112;
        nArrayArray[39] = nArray6;
        int[] nArray7 = new int[5];
        nArray7[1] = 28;
        nArray7[2] = 34;
        nArray7[3] = 65;
        nArrayArray[40] = nArray7;
        int[] nArray8 = new int[5];
        nArray8[1] = 65;
        nArray8[2] = 34;
        nArray8[3] = 28;
        nArrayArray[41] = nArray8;
        nArrayArray[42] = new int[]{8, 42, 28, 42, 8};
        nArrayArray[43] = new int[]{8, 8, 62, 8, 8};
        int[] nArray9 = new int[5];
        nArray9[1] = 13;
        nArray9[2] = 14;
        nArrayArray[44] = nArray9;
        nArrayArray[45] = new int[]{8, 8, 8, 8, 8};
        int[] nArray10 = new int[5];
        nArray10[1] = 3;
        nArray10[2] = 3;
        nArrayArray[46] = nArray10;
        nArrayArray[47] = new int[]{2, 4, 8, 16, 32};
        nArrayArray[48] = new int[]{62, 69, 73, 81, 62};
        int[] nArray11 = new int[5];
        nArray11[1] = 33;
        nArray11[2] = 127;
        nArray11[3] = 1;
        nArrayArray[49] = nArray11;
        nArrayArray[50] = new int[]{35, 69, 73, 73, 49};
        nArrayArray[51] = new int[]{34, 65, 73, 73, 54};
        nArrayArray[52] = new int[]{12, 20, 36, 127, 4};
        nArrayArray[53] = new int[]{114, 81, 81, 81, 78};
        nArrayArray[54] = new int[]{30, 41, 73, 73, 70};
        nArrayArray[55] = new int[]{64, 71, 72, 80, 96};
        nArrayArray[56] = new int[]{54, 73, 73, 73, 54};
        nArrayArray[57] = new int[]{48, 73, 73, 74, 60};
        int[] nArray12 = new int[5];
        nArray12[1] = 54;
        nArray12[2] = 54;
        nArrayArray[58] = nArray12;
        int[] nArray13 = new int[5];
        nArray13[1] = 109;
        nArray13[2] = 110;
        nArrayArray[59] = nArray13;
        int[] nArray14 = new int[5];
        nArray14[1] = 8;
        nArray14[2] = 20;
        nArray14[3] = 34;
        nArray14[4] = 65;
        nArrayArray[60] = nArray14;
        nArrayArray[61] = new int[]{20, 20, 20, 20, 20};
        int[] nArray15 = new int[5];
        nArray15[0] = 65;
        nArray15[1] = 34;
        nArray15[2] = 20;
        nArray15[3] = 8;
        nArrayArray[62] = nArray15;
        nArrayArray[63] = new int[]{48, 64, 69, 72, 48};
        ledMatrixValues = nArrayArray;
        HP9830keyOffsetX = new int[]{90, 90, 70, 60, 80, 80, 80, 80};
        int[][] nArrayArray2 = new int[8][];
        nArrayArray2[0] = new int[]{-1, -1, 32, 32, 32, 32, 32, 32, 32, 32, -1, -1, -1, 11, -1, 48, 46, 44, -1, 43, -1};
        nArrayArray2[1] = new int[]{-1, 90, 88, 67, 86, 66, 78, 77, 44, 46, 47, -1, -1, 11, -1, 49, 50, 51, -1, 45, -1};
        nArrayArray2[2] = new int[]{28, 65, 83, 68, 70, 71, 72, 74, 75, 76, 59, 58, -1, 107, -1, 52, 53, 54, -1, 42, -1};
        nArrayArray2[3] = new int[]{115, 81, 87, 69, 82, 84, 89, 85, 73, 79, 80, 114, -1, 61, -1, 55, 56, 57, -1, 47, -1};
        nArrayArray2[4] = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 15, 127, -1, 106, -1, 40, 41, 111, -1, 94, -1};
        nArrayArray2[5] = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        nArrayArray2[6] = new int[]{5, 6, 7, 8, 9, -1, 18, 19, 31, 16, 17, -1, 22, 23, -1, 116, 117, 29, 118, 26, -1};
        int[] nArray16 = new int[21];
        nArray16[1] = 1;
        nArray16[2] = 2;
        nArray16[3] = 3;
        nArray16[4] = 4;
        nArray16[5] = -1;
        nArray16[6] = 30;
        nArray16[7] = 14;
        nArray16[8] = 112;
        nArray16[9] = 12;
        nArray16[10] = 13;
        nArray16[11] = -1;
        nArray16[12] = 20;
        nArray16[13] = 21;
        nArray16[14] = -1;
        nArray16[15] = 119;
        nArray16[16] = 10;
        nArray16[17] = 24;
        nArray16[18] = 25;
        nArray16[19] = 510;
        nArray16[20] = 511;
        nArrayArray2[7] = nArray16;
        HP9830keyCodes = nArrayArray2;
    }

    public HP9830Mainframe(Emulator emu) {
        super(emu, "HP9830A");
        keyWidth = 42;
        keyOffsetY = 504;
        keyOffsetX = HP9830keyOffsetX;
        keyCodes = HP9830keyCodes;
        DISPLAY_X = 40;
        DISPLAY_Y = 25;
        DISPLAY_W = 635;
        DISPLAY_H = 30;
        STOP_KEYCODE = 127;
        this.addWindowListener(new windowListener());
        this.addMouseListener(new mouseListener());
        this.ioReg.line10_20 = true;
        this.ioReg.bus.cardReader = new HP9830Beeper(this, this.ioReg);
        this.ioReg.bus.display = new HP9830DisplayInterface(this, this.ioReg);
        this.ioReg.bus.keyboard = new HP9830KeyboardInterface(12, this.ioReg);
        this.ioReg.bus.devices.add(this.ioReg.bus.keyboard);
        this.tapeDevice = new HP9865A(emu.ioRegister, 10);
        this.tapeDevice.setStatusFrame(this, 820, 70);
        this.keyboardImage = new ImageMedia("media/HP9830A/HP9830A_Keyboard.jpg").getImage();
        this.romSlots = new HP9830ROMslots(this);
        this.setSize();
        System.out.println("HP9830 Mainframe loaded.");
    }

    public void paint(Graphics g) {
        int[][] displayBuffer = this.ioReg.bus.display.getDisplayBuffer();
        int x = this.getInsets().left;
        int y = this.getInsets().top;
        this.backgroundImage = g.drawImage(this.keyboardImage, x, y, this.keyboardImage.getWidth(this), this.keyboardImage.getHeight(this), this);
        if (this.backgroundImage) {
            if (this.ioReg.dispCounter.running()) {
                int i = 0;
                while (i < 32) {
                    int charCode = displayBuffer[0][i];
                    g.drawImage(this.ledMatrix[charCode], x + DISPLAY_X + i * (6 * LED_DOT_SIZE + 2), y + DISPLAY_Y, 5 * LED_DOT_SIZE, 7 * LED_DOT_SIZE, this);
                    ++i;
                }
            }
            this.displayKeyMatrix();
        }
    }

    public void display(int line, int i) {
        Graphics g = this.getGraphics();
        if (this.ioReg.DEN && this.backgroundImage && g != null) {
            int[][] displayBuffer = this.ioReg.bus.display.getDisplayBuffer();
            int x = this.getInsets().left;
            int y = this.getInsets().top;
            int charCode = displayBuffer[0][i];
            g.drawImage(this.ledMatrix[charCode], x + DISPLAY_X + i * (6 * LED_DOT_SIZE + 2), y + DISPLAY_Y, 5 * LED_DOT_SIZE, 7 * LED_DOT_SIZE, this);
        }
    }

    public void print(int dotGroup) {
    }

    class windowListener
    extends WindowAdapter {
        windowListener() {
        }

        public void windowOpened(WindowEvent event) {
            HP9830Mainframe.this.ledMatrix = new Image[64];
            int i = 0;
            while (i < 64) {
                HP9830Mainframe.this.ledMatrix[i] = HP9830Mainframe.this.createImage(5 * LED_DOT_SIZE, 7 * LED_DOT_SIZE);
                Graphics ledGraphics = HP9830Mainframe.this.ledMatrix[i].getGraphics();
                ledGraphics.setColor(HP9830Mainframe.this.ledBack);
                ledGraphics.fillRect(0, 0, 5 * LED_DOT_SIZE, 7 * LED_DOT_SIZE);
                ledGraphics.setColor(HP9830Mainframe.this.ledRed);
                int x = 0;
                while (x < 5) {
                    int ledColumn = ledMatrixValues[i][x];
                    int y = 6;
                    while (y >= 0) {
                        if ((ledColumn & 1) != 0) {
                            ledGraphics.fillRect(x * LED_DOT_SIZE, y * LED_DOT_SIZE, LED_DOT_SIZE - 1, LED_DOT_SIZE - 1);
                        }
                        ledColumn >>= 1;
                        --y;
                    }
                    ++x;
                }
                ++i;
            }
        }

        public void windowClosing(WindowEvent event) {
            HP9830Mainframe.this.setVisible(false);
            HP9830Mainframe.this.dispose();
            System.out.println("HP9800 Emulator terminated.");
            System.exit(0);
        }
    }

    class mouseListener
    extends MouseAdapter {
        mouseListener() {
        }

        public void mousePressed(MouseEvent event) {
            int x = event.getX() - HP9830Mainframe.this.getInsets().left;
            int y = event.getY() - HP9830Mainframe.this.getInsets().top;
            if (y < 80 && x <= 250) {
                if (event.getButton() == 1) {
                    HP9830Mainframe.this.romSlots.setVisible(true);
                } else {
                    MemoryBlock romBlock = (MemoryBlock)HP9830Mainframe.this.emu.memoryBlocks.get("Block0");
                    if (romBlock != null) {
                        HP9830Mainframe.this.instructionsWindow.setROMblock(romBlock);
                        HP9830Mainframe.this.instructionsWindow.showInstructions();
                    }
                }
                return;
            }
            int row = keyOffsetY - y;
            if (row < 0) {
                return;
            }
            if ((row /= keyWidth) > 7) {
                return;
            }
            int col = x - keyOffsetX[row];
            if (col < 0) {
                return;
            }
            if ((col /= keyWidth) > 11) {
                col = (x - keyOffsetX[7]) / keyWidth;
            }
            if (col > 20) {
                return;
            }
            int keyCode = keyCodes[row][col];
            if (keyCode == 510) {
                if (HP9830Mainframe.this.tapeDevice != null) {
                    HP9830Mainframe.this.tapeDevice.output(768);
                }
                return;
            }
            if (keyCode == 511) {
                HP9830Mainframe.this.keyboardImage = new ImageMedia("media/HP9830A/HP9830A_Keyboard+Tape.jpg").getImage();
                HP9830Mainframe.this.repaint();
                HP9830Mainframe.this.tapeLoaded = HP9830Mainframe.this.tapeDevice.openTapeFile();
                if (!HP9830Mainframe.this.tapeLoaded) {
                    HP9830Mainframe.this.keyboardImage = new ImageMedia("media/HP9830A/HP9830A_Keyboard.jpg").getImage();
                    HP9830Mainframe.this.repaint();
                    return;
                }
                HP9830Mainframe.this.keyboardImage = new ImageMedia("media/HP9830A/HP9830A_Keyboard+Cassette.jpg").getImage();
                HP9830Mainframe.this.repaint();
                return;
            }
            if (keyCode != -1) {
                if (event.isShiftDown()) {
                    keyCode |= 0x80;
                }
                if (HP9830Mainframe.this.emu.keyLogMode) {
                    HP9830Mainframe.this.emu.console.append("\n" + Integer.toOctalString(keyCode) + " ");
                    return;
                }
                if (keyCode == 127) {
                    HP9830Mainframe.this.ioReg.STP = true;
                }
                HP9830Mainframe.this.ioReg.bus.keyboard.setKeyCode(keyCode);
                HP9830Mainframe.this.ioReg.bus.keyboard.requestInterrupt();
            }
        }

        public void mouseReleased(MouseEvent event) {
        }
    }
}

