/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.HP11200Interface;
import io.IOregister;
import io.ImageMedia;
import io.SoundMedia;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class HP9860A
extends Frame
implements KeyListener {
    private static final long serialVersionUID = 1L;
    HP11200Interface hp11200;
    IOregister ioReg;
    Image hp9860aImage;
    SoundMedia cardReaderSound;
    DataInputStream inFile;
    String cardType;
    static int WAIT_CHAR = 30;
    static final int WAIT_CARD = 300;
    static final int WAIT_IDLE = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HP9860A(IOregister ioRegister) {
        super("HP9860A");
        this.addKeyListener(this);
        this.addWindowListener(new windowListener());
        this.addMouseListener(new mouseListener());
        this.cardReaderSound = new SoundMedia("media/HP9860A/HP9860_CARD.wav");
        this.ioReg = ioRegister;
        this.hp11200 = new HP11200Interface(12, this.ioReg);
        this.hp11200.setFrame(this);
        this.ioReg.bus.devices.add(this.hp11200);
        WAIT_CHAR = this.ioReg.time_30ms;
        this.hp9860aImage = new ImageMedia("media/HP9860A/HP9860A.jpg").getImage();
        this.setResizable(false);
        this.setLocation(740, 0);
        this.setBackground(Color.BLACK);
        this.setVisible(true);
        Image image = this.hp9860aImage;
        synchronized (image) {
            try {
                this.hp9860aImage.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setSize(this.hp9860aImage.getWidth(this) + this.getInsets().left + this.getInsets().right, this.hp9860aImage.getHeight(this) + this.getInsets().top + this.getInsets().bottom);
        System.out.println("HP9860A Marked Card Reader loaded.");
    }

    boolean openInputFile() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Load Card");
        fileDialog.setBackground(Color.WHITE);
        fileDialog.setVisible(true);
        String fileName = fileDialog.getFile();
        String dirName = fileDialog.getDirectory();
        if (fileName != null) {
            fileName = String.valueOf(dirName) + fileName;
            try {
                this.inFile = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
            }
            catch (FileNotFoundException e) {
                System.err.println(e.toString());
                return false;
            }
            try {
                this.cardType = this.inFile.readLine();
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
            this.cardReaderSound.loop();
            this.hp9860aImage = new ImageMedia("media/HP9860A/HP9860A+Card.jpg").getImage();
            this.repaint();
            this.hp11200.timerValue = 300;
            this.hp11200.devThread.interrupt();
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean readInputFile() {
        int inByte = -1;
        try {
            if (this.cardType.equals("OCT")) {
                inByte = Integer.parseInt(this.inFile.readLine(), 8);
            }
            this.hp11200.timerValue = WAIT_CHAR;
            if (this.cardType.equals("BAS")) {
                inByte = this.inFile.readUnsignedByte();
                if (inByte >= 97 && inByte <= 122) {
                    inByte &= 0xDF;
                }
                switch (inByte) {
                    case 10: {
                        this.hp11200.timerValue = 300;
                        inByte = 114;
                        break;
                    }
                    case 13: {
                        inByte = -1;
                        break;
                    }
                }
            }
            if (inByte > 127) {
                if (inByte == 255) {
                    this.closeInputFile();
                    return false;
                }
                inByte = -1;
                this.hp11200.timerValue = 300;
            }
            this.hp11200.keyCode = inByte;
            return true;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (EOFException eOFException) {
        }
        catch (IOException e) {
            System.err.println(e.toString());
        }
        this.closeInputFile();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean closeInputFile() {
        if (this.hp11200.reading) {
            this.hp11200.reading = false;
            IOregister iOregister = this.ioReg;
            synchronized (iOregister) {
                this.ioReg.SSI &= 0xFFFFF7FF;
                this.ioReg.SSF = false;
                this.ioReg.SIH = false;
            }
            try {
                this.inFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.hp9860aImage = new ImageMedia("media/HP9860A/HP9860A.jpg").getImage();
        this.repaint();
        this.cardReaderSound.loop(0);
        this.hp11200.timerValue = 5000;
        return false;
    }

    public void keyPressed(KeyEvent event) {
        int keyCode = event.getKeyCode();
        switch (keyCode) {
            case 10: {
                this.hp11200.reading = this.openInputFile();
                break;
            }
            case 19: {
                this.closeInputFile();
            }
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public void paint(Graphics g) {
        int x = this.getInsets().left;
        int y = this.getInsets().top;
        g.drawImage(this.hp9860aImage, x, y, this.hp9860aImage.getWidth(this), this.hp9860aImage.getHeight(this), this);
    }

    class windowListener
    extends WindowAdapter {
        windowListener() {
        }

        public void windowClosing(WindowEvent event) {
            HP9860A.this.setVisible(false);
            HP9860A.this.dispose();
            HP9860A.this.ioReg.bus.devices.remove(HP9860A.this.hp11200);
            System.out.println("HP9860A unloaded.");
        }
    }

    class mouseListener
    extends MouseAdapter {
        mouseListener() {
        }

        public void mousePressed(MouseEvent event) {
            int x = event.getX() - HP9860A.this.getInsets().left;
            int y = event.getY() - HP9860A.this.getInsets().top;
            if (x >= 55 && x <= 210) {
                if (y >= 500) {
                    HP9860A.this.hp11200.reading = HP9860A.this.openInputFile();
                }
                if (y <= 330) {
                    HP9860A.this.closeInputFile();
                }
            }
        }

        public void mouseReleased(MouseEvent event) {
        }
    }
}

