/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.HP9865A;
import io.IOinterface;
import io.IOregister;

public class HP9865Interface
extends IOinterface {
    HP9865A driveFrame;
    int timerValue = 500;
    int tapeValue = 0;
    int status = 2816;

    public HP9865Interface(int selectCode, IOregister ioReg) {
        super(selectCode, ioReg, "HP9865A");
    }

    public void setFrame(HP9865A wind) {
        this.driveFrame = wind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.timerValue);
            }
            catch (InterruptedException e) {
                continue;
            }
            this.status = this.driveFrame.executeCommand();
            IOregister iOregister = this.ioReg;
            synchronized (iOregister) {
                if (this.ioReg.getSelectCode() == this.selectCode && this.ioReg.CEO) {
                    if (this.driveFrame.inByteReady) {
                        this.ioReg.setData(this.tapeValue);
                        this.driveFrame.inByteReady = false;
                        this.ioReg.CEO = false;
                    } else {
                        this.tapeValue = this.ioReg.getData();
                        this.driveFrame.outByteReady = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean input() {
        IOregister iOregister = this.ioReg;
        synchronized (iOregister) {
            if (this.serviceRequested) {
                this.ioReg.bus.value = this.tapeValue | this.status;
                this.driveFrame.inByteReady = false;
                this.ioReg.SSI &= ~this.srqBits;
                this.ioReg.SSF = false;
                this.serviceRequested = false;
            } else if (this.ioReg.CEO) {
                this.ioReg.bus.value = this.status;
                if (this.driveFrame.inByteReady) {
                    this.ioReg.bus.value |= this.tapeValue;
                    this.driveFrame.inByteReady = false;
                }
            } else {
                this.ioReg.bus.value = this.status;
            }
            return this.ioReg.CEO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean output() {
        IOregister iOregister = this.ioReg;
        synchronized (iOregister) {
            if (this.ioReg.CEO) {
                this.driveFrame.output(this.ioReg.getStatus());
            }
            return this.ioReg.CEO;
        }
    }
}

