/*
 * Decompiled with CFR 0.152.
 */
package io;

import emu98.Memory;
import io.ImageMedia;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class HP9867A
extends Frame
implements KeyListener {
    private static final long serialVersionUID = 1L;
    public static int LOADSW_X = 700;
    public static int LOADSW_Y = 236;
    public static int DRIVE_POWER_X = 596;
    public static int DRIVE_POWER_Y = 216;
    public static int DRIVE_POWER_W = 38;
    public static int DRIVE_POWER_H = 40;
    public static int DOOR_UNLOCKED_X = 494;
    public static int DOOR_UNLOCKED_Y = 216;
    public static int DOOR_UNLOCKED_W = 37;
    public static int DOOR_UNLOCKED_H = 40;
    public static int SWITCH_LOAD_X = 693;
    public static int SWITCH_LOAD_Y = 225;
    public static int SWITCH_LOAD_W = 15;
    public static int SWITCH_LOAD_H = 19;
    public static int DRIVE_READY_X = 546;
    public static int DRIVE_READY_Y = 217;
    public static int DRIVE_READY_W = 37;
    public static int DRIVE_READY_H = 40;
    public static int PROTECT_LD_X = 443;
    public static int PROTECT_LD_Y = 238;
    public static int PROTECT_LD_W = 38;
    public static int PROTECT_LD_H = 19;
    public static int PROTECT_UD_X = 443;
    public static int PROTECT_UD_Y = 217;
    public static int PROTECT_UD_W = 38;
    public static int PROTECT_UD_H = 20;
    public static int STATUS_X = 300;
    public static int STATUS_Y = 250;
    Memory[] memory;
    Image hp9867Image;
    Image drivePowerImage;
    Image doorUnlockedImage;
    Image driveReadyImage;
    Image protectLdImage;
    Image protectUdImage;
    Image loadSwitchImage;
    RandomAccessFile diskFile;
    HP9867A statusFrame;
    String statusString = "";
    String prevStatus = "";
    private String windowTitle;
    int accessMode = -1;
    int unit;
    int numDiscs;
    boolean powerOn = true;
    boolean doorUnlocked = false;
    boolean driveReady = true;
    boolean driveProtectL = false;
    boolean driveProtectU = false;
    private boolean highSpeed;
    static int time_10ms = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HP9867A(int unit, Memory[] memory, int numDiscs, HP9867A dispFrame) {
        super("HP9867A Unit " + unit);
        this.windowTitle = "HP9867A Unit " + unit;
        this.unit = unit;
        this.numDiscs = numDiscs;
        this.memory = memory;
        if (dispFrame == null) {
            this.statusFrame = this;
            this.addKeyListener(this);
            this.addWindowListener(new windowListener());
            this.addMouseListener(new mouseListener());
            this.hp9867Image = new ImageMedia("media/HP9880A/HP9867B.jpg").getImage();
            this.drivePowerImage = new ImageMedia("media/HP9880A/HP9867B_DRIVE_POWER.jpg").getImage();
            this.doorUnlockedImage = new ImageMedia("media/HP9880A/HP9867B_DOOR_UNLOCKED.jpg").getImage();
            this.driveReadyImage = new ImageMedia("media/HP9880A/HP9867B_DRIVE_READY.jpg").getImage();
            this.protectLdImage = new ImageMedia("media/HP9880A/HP9867B_PROTECT_LD.jpg").getImage();
            this.protectUdImage = new ImageMedia("media/HP9880A/HP9867B_PROTECT_UD.jpg").getImage();
            this.loadSwitchImage = new ImageMedia("media/HP9880A/HP9867B_LOAD_SWITCH.jpg").getImage();
            this.setBackground(Color.BLACK);
            this.setLocation(220 + unit * 20, unit * 20);
            this.setResizable(false);
            this.setVisible(true);
            Image image = this.hp9867Image;
            synchronized (image) {
                try {
                    this.hp9867Image.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.setSize(this.hp9867Image.getWidth(this) + this.getInsets().left + this.getInsets().right, this.hp9867Image.getHeight(this) + this.getInsets().top + this.getInsets().bottom);
        } else {
            this.statusFrame = dispFrame;
            this.statusFrame.windowTitle = "HP9867B Unit " + (unit - 1) + "+" + unit;
            this.statusFrame.setTitle(this.statusFrame.windowTitle);
        }
        try {
            this.diskFile = new RandomAccessFile("applications/HP9830/HP9880-UNIT" + unit + ".disc", "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        System.out.println("HP9867" + (numDiscs == 1 ? "A" : "B") + " Mass Memory Storage Unit " + unit + " loaded.");
    }

    public boolean openDiskFile() {
        int l = this.getInsets().left;
        int t = this.getInsets().top;
        this.closeDiskFile();
        FileDialog fileDialog = new FileDialog((Frame)this, "Load Cartridge for Disk Unit " + this.unit);
        fileDialog.setBackground(Color.WHITE);
        fileDialog.setVisible(true);
        String fileName = fileDialog.getFile();
        String dirName = fileDialog.getDirectory();
        if (fileName != null) {
            fileName = String.valueOf(dirName) + fileName;
            try {
                this.diskFile = new RandomAccessFile(fileName, "rw");
            }
            catch (FileNotFoundException e) {
                System.err.println(e.toString());
                return false;
            }
            this.statusFrame.driveReady = true;
            this.doorUnlocked = false;
            this.repaint(DOOR_UNLOCKED_X + l, DOOR_UNLOCKED_Y + t, DOOR_UNLOCKED_W + DRIVE_READY_W + 20, DOOR_UNLOCKED_H);
            this.repaint(SWITCH_LOAD_X + l, SWITCH_LOAD_Y + t, SWITCH_LOAD_W, SWITCH_LOAD_H);
            return true;
        }
        this.closeDiskFile();
        return false;
    }

    public boolean closeDiskFile() {
        if (this.diskFile != null) {
            try {
                this.diskFile.close();
                this.diskFile = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public void keyPressed(KeyEvent event) {
        int keyCode = event.getKeyCode();
        switch (keyCode) {
            case 83: {
                this.statusFrame.highSpeed = !this.statusFrame.highSpeed;
                this.setTitle(String.valueOf(this.statusFrame.windowTitle) + (this.statusFrame.highSpeed ? " High Speed" : ""));
                break;
            }
            default: {
                return;
            }
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public void paint(Graphics g) {
        int x = this.getInsets().left;
        int y = this.getInsets().top;
        boolean backgroundImage = g.drawImage(this.hp9867Image, x, y, this.hp9867Image.getWidth(this), this.hp9867Image.getHeight(this), this);
        if (backgroundImage) {
            if (this.powerOn) {
                g.drawImage(this.drivePowerImage, x + DRIVE_POWER_X, y + DRIVE_POWER_Y, DRIVE_POWER_W, DRIVE_POWER_H, this);
            }
            if (this.statusFrame.driveReady) {
                g.drawImage(this.driveReadyImage, x + DRIVE_READY_X, y + DRIVE_READY_Y, DRIVE_READY_W, DRIVE_READY_H, this);
            }
            if (this.doorUnlocked) {
                g.drawImage(this.doorUnlockedImage, x + DOOR_UNLOCKED_X, y + DOOR_UNLOCKED_Y, DOOR_UNLOCKED_W, DOOR_UNLOCKED_H, this);
            } else {
                g.drawImage(this.loadSwitchImage, x + SWITCH_LOAD_X, y + SWITCH_LOAD_Y, SWITCH_LOAD_W, SWITCH_LOAD_H, this);
            }
            if (this.driveProtectL) {
                g.drawImage(this.protectLdImage, x + PROTECT_LD_X, y + PROTECT_LD_Y, PROTECT_LD_W, PROTECT_LD_H, this);
            }
            if (this.driveProtectU) {
                g.drawImage(this.protectUdImage, x + PROTECT_UD_X, y + PROTECT_UD_Y, PROTECT_UD_W, PROTECT_UD_H, this);
            }
        }
    }

    void drawStatus() {
        int x = this.statusFrame.getInsets().left;
        int y = this.statusFrame.getInsets().top;
        Graphics g = this.statusFrame.getGraphics();
        Font font = new Font("Monospaced", 1, 20);
        g.setFont(font);
        g.setColor(new Color(180, 170, 170));
        g.drawString(this.statusFrame.prevStatus, x + STATUS_X, y + STATUS_Y);
        switch (this.accessMode) {
            case 0: {
                g.setColor(Color.RED);
                break;
            }
            case 1: {
                g.setColor(Color.GREEN);
                break;
            }
            case 2: 
            case 3: {
                g.setColor(Color.YELLOW);
            }
        }
        g.drawString(this.statusFrame.statusString, x + STATUS_X, y + STATUS_Y);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int output(int head, int cylinder, int sector, int mode) {
        if (this.diskFile == null) return 2304;
        if (this.doorUnlocked) return 2304;
        if (!this.statusFrame.driveReady) {
            return 2304;
        }
        if (head > 1) return 3072;
        if (cylinder > 202) return 3072;
        if (sector > 22) return 3072;
        if ((sector & 1) != 0) {
            return 3072;
        }
        int record = (head * 203 + cylinder) * 24 + sector;
        this.statusFrame.prevStatus = this.statusFrame.statusString;
        this.statusFrame.statusString = String.valueOf(this.numDiscs == 1 ? "" : ((this.unit & 1) == 0 ? "U" : "L")) + Integer.toString(record);
        this.accessMode = mode;
        this.drawStatus();
        try {
            this.diskFile.seek(256 * record);
            if (!this.statusFrame.highSpeed) {
                try {
                    Thread.sleep(time_10ms);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int address = 0;
            while (true) {
                if (address >= 256) {
                    return 2048;
                }
                if ((mode & 1) != 0) {
                    this.memory[32256 + address].setValue(this.diskFile.readShort());
                } else {
                    if ((this.unit & 1) == 0 || this.numDiscs == 1) {
                        if (this.driveProtectU) {
                            return 3072;
                        }
                    } else if (this.driveProtectL) {
                        return 2048;
                    }
                    this.diskFile.writeShort(this.memory[32256 + address].getValue());
                }
                ++address;
            }
        }
        catch (IOException e) {
            return 3072;
        }
    }

    class windowListener
    extends WindowAdapter {
        windowListener() {
        }

        public void windowClosing(WindowEvent event) {
            HP9867A.this.setVisible(false);
            HP9867A.this.dispose();
            System.out.println("HP9867 Unit " + HP9867A.this.unit + " unloaded.");
        }
    }

    class mouseListener
    extends MouseAdapter {
        mouseListener() {
        }

        public void mousePressed(MouseEvent event) {
            int l = HP9867A.this.getInsets().left;
            int t = HP9867A.this.getInsets().top;
            int x = event.getX() - l;
            int y = event.getY() - t;
            if (x > LOADSW_X - 10 && x < LOADSW_X + 10 && y > LOADSW_Y - 10 && y < LOADSW_Y + 10) {
                HP9867A.this.statusFrame.driveReady = false;
                HP9867A.this.doorUnlocked = true;
                HP9867A.this.repaint(DOOR_UNLOCKED_X + l, DOOR_UNLOCKED_Y + t, DOOR_UNLOCKED_W + DRIVE_READY_W + 20, DOOR_UNLOCKED_H);
                HP9867A.this.openDiskFile();
                return;
            }
            if (x > PROTECT_UD_X && x < PROTECT_UD_X + PROTECT_UD_W && y > PROTECT_UD_Y - 10 && y < PROTECT_UD_Y + PROTECT_UD_H) {
                HP9867A.this.driveProtectU = !HP9867A.this.driveProtectU;
                HP9867A.this.repaint(PROTECT_UD_X + l, PROTECT_UD_Y + t, PROTECT_UD_W, PROTECT_UD_H);
                return;
            }
            if (HP9867A.this.numDiscs > 1 && x > PROTECT_LD_X && x < PROTECT_LD_X + PROTECT_LD_W && y > PROTECT_LD_Y - 10 && y < PROTECT_LD_Y + PROTECT_LD_H) {
                HP9867A.this.driveProtectL = !HP9867A.this.driveProtectL;
                HP9867A.this.repaint(PROTECT_LD_X + l, PROTECT_LD_Y + t, PROTECT_LD_W, PROTECT_LD_H);
                return;
            }
        }

        public void mouseReleased(MouseEvent event) {
        }
    }
}

