/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.IOinterface;
import io.IOregister;

public class IOinstruction {
    IOregister ioReg;

    public IOinstruction(IOregister ioRegister) {
        this.ioReg = ioRegister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlag(int selectCode) {
        IOregister iOregister = this.ioReg;
        synchronized (iOregister) {
            switch (selectCode) {
                case 1: {
                    this.ioReg.SIH = true;
                    this.ioReg.CEO = false;
                    this.ioReg.input();
                    break;
                }
                case 2: {
                    this.ioReg.MCR = true;
                    this.ioReg.bus.cardReader.output();
                    this.ioReg.MCR = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFlag(int selectCode) {
        IOregister iOregister = this.ioReg;
        synchronized (iOregister) {
            switch (selectCode) {
                case 1: {
                    this.ioReg.SIH = false;
                    this.ioReg.CEO = false;
                    this.ioReg.setSelectCode(0);
                    break;
                }
                case 2: {
                    this.ioReg.MFL = false;
                    break;
                }
                case 4: {
                    this.ioReg.PEN = false;
                    break;
                }
                case 8: {
                    this.ioReg.DEN = false;
                    break;
                }
                case 16: {
                    this.ioReg.KLS = true;
                    this.ioReg.bus.display.output();
                    this.ioReg.KLS = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFlag(int selectCode) {
        IOregister iOregister = this.ioReg;
        synchronized (iOregister) {
            try {
                Thread.sleep(this.ioReg.time_1ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            switch (selectCode) {
                case 0: {
                    return this.ioReg.STP;
                }
                case 1: {
                    return !this.ioReg.CEO;
                }
                case 2: {
                    this.ioReg.bus.cardReader.input();
                    return this.ioReg.MFL;
                }
                case 4: {
                    return this.ioReg.PEN;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setControl(int selectCode) {
        IOregister iOregister = this.ioReg;
        synchronized (iOregister) {
            switch (selectCode) {
                case 1: {
                    this.ioReg.bus.setCEO();
                    break;
                }
                case 2: {
                    this.ioReg.MLS = true;
                    this.ioReg.bus.cardReader.output();
                    this.ioReg.MLS = false;
                }
            }
        }
    }

    public void clearControl(int selectCode) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int output(int selectCode, int regValue) {
        IOregister iOregister = this.ioReg;
        synchronized (iOregister) {
            switch (selectCode) {
                case 0: {
                    this.ioReg.setData(regValue);
                    this.ioReg.bus.setCEO();
                    return (regValue & 0xFF) << 8 | regValue >> 8;
                }
                case 1: {
                    this.ioReg.setValue(regValue);
                    int sc = this.ioReg.getSelectCode();
                    if (sc == 0) break;
                    IOinterface device = this.ioReg.bus.selectDevice();
                    if (device != null) {
                        device.input();
                        break;
                    }
                    if (!this.ioReg.line10_20) break;
                    this.ioReg.bus.value |= 0xF00;
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    int printValue = (this.ioReg.getValue() & 0xFFC0) << 10;
                    this.ioReg.setValue(regValue);
                    this.ioReg.PEN = true;
                    this.ioReg.bus.display.output(printValue);
                    break;
                }
                case 8: {
                    this.ioReg.setValue(regValue);
                    this.ioReg.DEN = true;
                    this.ioReg.dispCounter.restart();
                    this.ioReg.bus.display.output();
                    break;
                }
                case 16: {
                    this.ioReg.setValue(regValue);
                    IOinterface device = this.ioReg.bus.selectDevice();
                    while (device != null) {
                        device.input();
                        device = this.ioReg.bus.nextDevice();
                    }
                    this.ioReg.KLS = true;
                    this.ioReg.bus.keyboard.enableInterrupt(false);
                    this.ioReg.bus.display.output();
                    this.ioReg.KLS = false;
                    this.ioReg.bus.keyboard.enableInterrupt(true);
                }
            }
            return regValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int input(int selectCode, int regValue) {
        IOregister iOregister = this.ioReg;
        synchronized (iOregister) {
            switch (selectCode) {
                case 0: {
                    int dio = this.ioReg.getData();
                    this.ioReg.CEO = true;
                    return dio << 8 | regValue >> 8;
                }
                case 1: {
                    return this.ioReg.getValue();
                }
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int merge(int selectCode, int regValue) {
        IOregister iOregister = this.ioReg;
        synchronized (iOregister) {
            switch (selectCode) {
                case 0: {
                    int dio = (regValue | this.ioReg.getData()) % 255;
                    this.ioReg.CEO = true;
                    return dio << 8 | regValue >> 8;
                }
                case 1: {
                    return regValue | this.ioReg.getValue();
                }
            }
            return 0;
        }
    }
}

