/*
 * Decompiled with CFR 0.152.
 */
package io;

import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundMedia {
    private AudioInputStream ais;
    private Clip soundClip;
    private static boolean enabled;
    private static final Mixer smMixer;
    private static final boolean DIRECT = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Mixer mixer;
        block8: {
            enabled = true;
            mixer = null;
            try {
                int maxlines;
                mixer = AudioSystem.getMixer(null);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("javax.sound.sampled.SourceDataLine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((maxlines = mixer.getMaxLines(new Line.Info(clazz))) == -1 || maxlines >= 16) break block8;
                Mixer.Info[] mixers = AudioSystem.getMixerInfo();
                int mixeri = 0;
                while (mixeri < mixers.length) {
                    if (mixers[mixeri].getName().equals("Java Sound Audio Engine")) {
                        mixer = AudioSystem.getMixer(mixers[mixeri]);
                        break;
                    }
                    ++mixeri;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        smMixer = mixer;
    }

    public SoundMedia(String soundFile) {
        try {
            this.ais = AudioSystem.getAudioInputStream(this.getClass().getResourceAsStream("/" + soundFile));
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("javax.sound.sampled.Clip");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            DataLine.Info info = new DataLine.Info(clazz, this.ais.getFormat());
            if (smMixer == null) {
                this.soundClip = null;
                return;
            }
            this.soundClip = (Clip)smMixer.getLine(info);
            this.soundClip.open(this.ais);
        }
        catch (IOException e) {
            System.err.println(String.valueOf(soundFile) + ": " + e);
        }
        catch (UnsupportedAudioFileException e) {
            System.err.println(String.valueOf(soundFile) + ": " + e);
        }
        catch (LineUnavailableException e) {
            System.err.println(String.valueOf(soundFile) + ": " + e);
        }
        catch (IllegalArgumentException e) {
            System.err.println(String.valueOf(soundFile) + ": " + e);
        }
        catch (NullPointerException e) {
            System.err.println(String.valueOf(soundFile) + ": " + e);
        }
    }

    public static void enable(boolean value) {
        enabled = value;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public void loop() {
        if (enabled && this.soundClip != null) {
            this.soundClip.setFramePosition(0);
            this.soundClip.loop(-1);
        }
    }

    public void loop(int count) {
        if (enabled && this.soundClip != null) {
            this.soundClip.setFramePosition(0);
            this.soundClip.loop(count);
        }
    }

    public void start() {
        if (enabled && this.soundClip != null) {
            if (this.soundClip.isRunning()) {
                this.soundClip.stop();
            }
            this.soundClip.setFramePosition(0);
            this.soundClip.loop(0);
        }
    }

    public void finish() {
        if (enabled && this.soundClip != null && this.soundClip.isRunning()) {
            this.soundClip.loop(0);
        }
    }

    public void stop() {
        if (enabled && this.soundClip != null) {
            this.soundClip.stop();
        }
    }

    public void toggle() {
        if (enabled && this.soundClip != null) {
            if (this.soundClip.isRunning()) {
                this.soundClip.stop();
            } else {
                this.soundClip.setFramePosition(0);
                this.soundClip.loop(-1);
            }
        }
    }

    public Clip getClip() {
        return this.soundClip;
    }
}

