/*
 * Decompiled with CFR 0.152.
 */
package emu98;

import emu98.Emulator;
import emu98.MemoryBlock;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class InstructionsWindow
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane instructionsScrollPane = null;
    private JButton instructionsButton = null;
    private Emulator emu;
    private MemoryBlock romBlock;

    public InstructionsWindow(Frame owner, Emulator emu) {
        super(owner);
        this.initialize();
        this.emu = emu;
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getInstructionsScrollPane(), "Center");
        }
        return this.jContentPane;
    }

    private JScrollPane getInstructionsScrollPane() {
        if (this.instructionsScrollPane == null) {
            this.instructionsButton = new JButton();
            this.instructionsButton.setText("");
            this.instructionsButton.setBackground(Color.white);
            this.instructionsButton.setForeground(Color.white);
            this.instructionsButton.setActionCommand("next");
            this.instructionsButton.addActionListener(this);
            this.instructionsScrollPane = new JScrollPane();
            this.instructionsScrollPane.setViewportView(this.instructionsButton);
        }
        return this.instructionsScrollPane;
    }

    public void showInstructions() {
        Image instructionsImage = this.romBlock.getInstructions();
        if (instructionsImage != null) {
            this.instructionsButton.setIcon(new ImageIcon(instructionsImage));
            this.setTitle(String.valueOf(this.romBlock.getName()) + " User Instructions");
            this.setVisible(true);
        }
    }

    public void setROMblock(MemoryBlock romBlock) {
        this.romBlock = romBlock;
    }

    public void actionPerformed(ActionEvent event) {
        Image instructionsImage;
        String cmd = event.getActionCommand();
        if (cmd.equals("next") && (instructionsImage = this.romBlock.nextInstructions()) != null) {
            this.instructionsButton.setIcon(new ImageIcon(instructionsImage));
        }
    }
}

