/*
 * Decompiled with CFR 0.152.
 */
package io;

import emu98.Memory;
import io.HP11273Interface;
import io.HP9867A;
import io.IOregister;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Image;

public class HP11305A
extends Frame {
    private static final long serialVersionUID = 1L;
    static final int FIRST = 1024;
    static final int PLATTER = 768;
    static final int INITIALIZE = 128;
    static final int HEAD = 64;
    static final int READ = 32;
    static final int SECTOR = 31;
    static final int CYLINDER = 255;
    static final int POWER_ON = 2048;
    static final int ADDRESS_ERROR = 1024;
    static final int CKWORD_ERROR = 512;
    static final int DRIVE_UNSAFE_ERROR = 256;
    static final int IDLE_TIMER = 500;
    static int BUSY_TIMER = 10;
    HP11273Interface hp11273Interface;
    HP9867A[] hp9867a;
    IOregister ioReg;
    Memory[] memory;
    Image hp11305aImage;
    int platter = 0;
    int head = 0;
    int cylinder = 0;
    int sector = 0;
    int accessMode = 0;
    int initialize = 0;
    boolean debug = false;

    public HP11305A(IOregister ioRegister, Memory[] memory, int numUnits, int numDiscs) {
        super("HP11305A");
        this.memory = memory;
        this.ioReg = ioRegister;
        this.hp11273Interface = new HP11273Interface(11, this.ioReg);
        this.hp11273Interface.setFrame(this);
        this.ioReg.bus.devices.add(this.hp11273Interface);
        BUSY_TIMER = this.ioReg.time_10ms;
        this.setBackground(Color.BLACK);
        this.setForeground(Color.WHITE);
        System.out.println("HP11305A Mass Memory Controller at select code 1:11 loaded.");
        this.hp9867a = new HP9867A[4];
        numUnits *= numDiscs;
        HP9867A.time_10ms = BUSY_TIMER;
        int unit = 0;
        while (unit < numUnits && unit < 4) {
            this.hp9867a[unit] = new HP9867A(unit, memory, numDiscs, null);
            if (numDiscs != 1) {
                this.hp9867a[++unit] = new HP9867A(unit, memory, numDiscs, this.hp9867a[unit - 1]);
            }
            ++unit;
        }
        if (numDiscs == 1) {
            System.out.println("HP9880A Mass Memory System loaded.");
        } else {
            System.out.println("HP9880B Mass Memory System loaded.");
        }
    }

    public int output(int status) {
        if ((status & 0x400) != 0) {
            this.platter = (status & 0x300) >> 8;
            this.initialize = (status & 0x80) >> 7;
            this.head = (status & 0x40) >> 6;
            this.accessMode = (status & 0x20) >> 5;
            this.sector = status & 0x1F;
            status = 2048;
        } else {
            this.cylinder = status & 0xFF;
            if (this.debug) {
                this.ioReg.console.append("HP9880A Commmand: init=" + this.initialize + " read=" + this.accessMode + " unit=" + this.platter + " head=" + this.head + " cylinder=" + this.cylinder + " sector=" + this.sector + "\n");
            }
            this.accessMode += this.initialize << 1;
            status = this.hp9867a[this.platter].output(this.head, this.cylinder, this.sector, this.accessMode);
        }
        return status;
    }
}

