/*
 * Decompiled with CFR 0.152.
 */
package io.HP9810A;

import emu98.Emulator;
import emu98.MemoryBlock;
import io.HP9800Mainframe;
import io.HP9810A.HP9810DisplayInterface;
import io.HP9810A.HP9810KeyboardInterface;
import io.ImageMedia;
import io.MagneticCardReaderInterface;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class HP9810Mainframe
extends HP9800Mainframe {
    private static final long serialVersionUID = 1L;
    static final int[] HP9810keyOffsetX = new int[]{120, 120, 120, 120, 120, 120, 120, 120};
    static final int[][] HP9810keyCodes;
    static int TEMPLATE_X;
    static int TEMPLATE_Y;
    static int TEMPLATE_W;
    static int TEMPLATE_H;
    static int LED1_X;
    static int LED2_X;
    static int LED3_X;
    static int LED_SMALL_Y;
    static int LED_SMALL_WH;
    static int STATUS_X;
    static int FLOAT_X;
    static int FIX_X;
    static int RUN_X;
    static int PRGM_X;
    static int KEYLOG_X;
    static int CARD_X;
    static int LED_LARGE_Y;
    static int LED_LARGE_WH;
    static int LED_SEGMENT_SIZE;
    Image ledLargeOn;
    Image ledLargeOff;
    Image ledSmallOn;
    Image ledSmallOff;

    static {
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[19];
        nArray[0] = 48;
        nArray[1] = 61;
        nArray[2] = 57;
        nArray[3] = -1;
        nArray[4] = 19;
        nArray[5] = 55;
        nArray[6] = 23;
        nArray[7] = -1;
        nArray[8] = 27;
        nArray[11] = 17;
        nArray[12] = -1;
        nArray[13] = 39;
        nArray[14] = -1;
        nArray[15] = 63;
        nArray[16] = 36;
        nArray[17] = 64;
        nArray[18] = -1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{51, 53, 59, -1, 32, 20, 24, -1, 28, 1, 2, 3, -1, 39, -1, 37, 43, 65, -1};
        nArrayArray[2] = new int[]{49, 60, 56, -1, 11, 25, 21, -1, 30, 4, 5, 6, -1, -1, -1, 34, 40, 33, -1};
        nArrayArray[3] = new int[]{54, 13, 58, -1, 12, 52, 18, -1, 29, 7, 8, 9, -1, -1, -1, 41, 42, 47, -1};
        nArrayArray[4] = new int[]{50, 14, 45, -1, 46, 15, 10, -1, 62, 26, 22, 31, -1, 16, -1, 44, 35, 38, -1};
        nArrayArray[5] = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        nArrayArray[6] = new int[]{-1, -1, -1, -1, -1, -1, -1, 73, 72, -1, 71, 70, -1, 69, 68, -1, 67, -1, 66};
        nArrayArray[7] = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 511, -1, -1, -1, -1};
        HP9810keyCodes = nArrayArray;
        TEMPLATE_X = 100;
        TEMPLATE_Y = 269;
        TEMPLATE_W = 162;
        TEMPLATE_H = 260;
        LED1_X = 136;
        LED2_X = 178;
        LED3_X = 219;
        LED_SMALL_Y = 279;
        LED_SMALL_WH = 11;
        STATUS_X = 342;
        FLOAT_X = 424;
        FIX_X = 467;
        RUN_X = 552;
        PRGM_X = 595;
        KEYLOG_X = 679;
        CARD_X = 847;
        LED_LARGE_Y = 274;
        LED_LARGE_WH = 18;
        LED_SEGMENT_SIZE = 4;
    }

    public HP9810Mainframe(Emulator emu) {
        super(emu, "HP9810A");
        this.addMouseListener(new mouseListener());
        keyOffsetX = HP9810keyOffsetX;
        keyCodes = HP9810keyCodes;
        this.ioReg.bus.cardReader = new MagneticCardReaderInterface(this, this.ioReg);
        this.ioReg.bus.display = new HP9810DisplayInterface(this, this.ioReg);
        this.ioReg.bus.keyboard = new HP9810KeyboardInterface(16, this.ioReg);
        this.ioReg.bus.devices.add(this.ioReg.bus.keyboard);
        this.romSelector.addRomButton("media/HP9810A/HP11XXXX_Block.jpg", "HP11XXXX");
        this.romSelector.addRomButton("media/HP9810A/HP11210A_Block.jpg", "HP11210A");
        this.romSelector.addRomButton("media/HP9810A/HP11211A_Block.jpg", "HP11211A");
        this.romSelector.addRomButton("media/HP9810A/HP11213A_Block.jpg", "HP11213A");
        this.romSelector.addRomButton("media/HP9810A/HP11214A_Block.jpg", "HP11214A");
        this.romSelector.addRomButton("media/HP9810A/HP11215A_Block.jpg", "HP11215A");
        this.romSelector.addRomButton("media/HP9810A/HP11252A_Block.jpg", "HP11252A");
        this.romSelector.addRomButton("media/HP9810A/HP11261A_Block.jpg", "HP11261A");
        this.romSelector.addRomButton("media/HP9810A/HP11262A_Block.jpg", "HP11262A");
        this.romSelector.addRomButton("media/HP9810A/HP11266A_Block.jpg", "HP11266A");
        this.romSelector.addRomButton("media/HP9810A/HP11267A_Block.jpg", "HP11267A");
        this.keyboardImage = new ImageMedia("media/HP9810A/HP9810A_Keyboard.jpg").getImage();
        this.displayImage = new ImageMedia("media/HP9810A/HP9810A_Display.jpg").getImage();
        this.ledLargeOn = new ImageMedia("media/HP9810A/HP9810A_LED_Large_On.jpg").getImage();
        this.ledLargeOff = new ImageMedia("media/HP9810A/HP9810A_LED_Large_Off.jpg").getImage();
        this.ledSmallOn = new ImageMedia("media/HP9810A/HP9810A_LED_Small_On.jpg").getImage();
        this.ledSmallOff = new ImageMedia("media/HP9810A/HP9810A_LED_Small_Off.jpg").getImage();
        this.setSize();
        System.out.println("HP9810 Mainframe loaded.");
    }

    public void paint(Graphics g) {
        int x = this.getInsets().left;
        int y = this.getInsets().top;
        this.backgroundImage = g.drawImage(this.keyboardImage, x, y, this.keyboardImage.getWidth(this), this.keyboardImage.getHeight(this), this);
        if (this.backgroundImage) {
            MemoryBlock block = (MemoryBlock)this.emu.memoryBlocks.get("Slot1");
            if (block != null) {
                g.drawImage(block.getModule(), x + BLOCK1_X, y + BLOCK1_Y, BLOCK_W, BLOCK_H, this);
                g.drawImage(block.getTemplate(), x + TEMPLATE_X, y + TEMPLATE_Y, TEMPLATE_W, TEMPLATE_H, this);
            }
            if ((block = (MemoryBlock)this.emu.memoryBlocks.get("Slot2")) != null) {
                g.drawImage(block.getModule(), x + BLOCK2_X, y + BLOCK1_Y, BLOCK_W, BLOCK_H, this);
            }
            if ((block = (MemoryBlock)this.emu.memoryBlocks.get("Slot3")) != null) {
                g.drawImage(block.getModule(), x + BLOCK3_X, y + BLOCK3_Y, BLOCK_W, BLOCK_H, this);
            }
            g.drawImage(this.displayImage, x + DISPLAY_X, y + DISPLAY_Y, DISPLAY_W, DISPLAY_H, this);
            this.displayLEDs(this.ioReg.bus.display.getKeyLEDs());
            if (this.ioReg.dispCounter.running()) {
                int j = 0;
                while (j < 3) {
                    int i = 0;
                    while (i < 15) {
                        this.display(j, i);
                        ++i;
                    }
                    ++j;
                }
            }
            this.displayPrintOutput();
            this.displayKeyMatrix();
        }
    }

    public void displayLEDs(int keyLEDs) {
        int x = this.getInsets().left;
        int y = this.getInsets().top;
        Graphics g = this.getGraphics();
        if ((keyLEDs & 0x10) != 0) {
            g.drawImage(this.ledLargeOn, x + STATUS_X, y + LED_LARGE_Y, LED_LARGE_WH, LED_LARGE_WH, this);
        } else {
            g.drawImage(this.ledLargeOff, x + STATUS_X, y + LED_LARGE_Y, LED_LARGE_WH, LED_LARGE_WH, this);
        }
        if ((keyLEDs & 0x80) != 0) {
            g.drawImage(this.ledLargeOn, x + FLOAT_X, y + LED_LARGE_Y, LED_LARGE_WH, LED_LARGE_WH, this);
            g.drawImage(this.ledLargeOff, x + FIX_X, y + LED_LARGE_Y, LED_LARGE_WH, LED_LARGE_WH, this);
        } else {
            g.drawImage(this.ledLargeOff, x + FLOAT_X, y + LED_LARGE_Y, LED_LARGE_WH, LED_LARGE_WH, this);
            g.drawImage(this.ledLargeOn, x + FIX_X, y + LED_LARGE_Y, LED_LARGE_WH, LED_LARGE_WH, this);
        }
        if ((keyLEDs & 2) != 0) {
            g.drawImage(this.ledLargeOn, x + RUN_X, y + LED_LARGE_Y, LED_LARGE_WH, LED_LARGE_WH, this);
            g.drawImage(this.ledLargeOff, x + PRGM_X, y + LED_LARGE_Y, LED_LARGE_WH, LED_LARGE_WH, this);
        } else {
            g.drawImage(this.ledLargeOff, x + RUN_X, y + LED_LARGE_Y, LED_LARGE_WH, LED_LARGE_WH, this);
            g.drawImage(this.ledLargeOn, x + PRGM_X, y + LED_LARGE_Y, LED_LARGE_WH, LED_LARGE_WH, this);
        }
        if ((keyLEDs & 4) != 0) {
            g.drawImage(this.ledLargeOn, x + KEYLOG_X, y + LED_LARGE_Y, LED_LARGE_WH, LED_LARGE_WH, this);
        } else {
            g.drawImage(this.ledLargeOff, x + KEYLOG_X, y + LED_LARGE_Y, LED_LARGE_WH, LED_LARGE_WH, this);
        }
        if ((keyLEDs & 1) != 0) {
            g.drawImage(this.ledLargeOn, x + CARD_X, y + LED_LARGE_Y, LED_LARGE_WH, LED_LARGE_WH, this);
        } else {
            g.drawImage(this.ledLargeOff, x + CARD_X, y + LED_LARGE_Y, LED_LARGE_WH, LED_LARGE_WH, this);
        }
        if (((MemoryBlock)this.emu.memoryBlocks.get("Slot1")).getTemplate() == null) {
            if ((keyLEDs & 0x20) != 0) {
                g.drawImage(this.ledLargeOn, x + LED1_X - 3, y + LED_LARGE_Y + 2, LED_LARGE_WH, LED_LARGE_WH, this);
            }
            if ((keyLEDs & 0x40) != 0) {
                g.drawImage(this.ledLargeOn, x + LED2_X - 3, y + LED_LARGE_Y + 2, LED_LARGE_WH, LED_LARGE_WH, this);
            }
            if ((keyLEDs & 8) != 0) {
                g.drawImage(this.ledLargeOn, x + LED3_X - 3, y + LED_LARGE_Y + 2, LED_LARGE_WH, LED_LARGE_WH, this);
            }
        } else {
            g.drawImage((keyLEDs & 0x20) != 0 ? this.ledSmallOn : this.ledSmallOff, x + LED1_X, y + LED_SMALL_Y, LED_SMALL_WH, LED_SMALL_WH, this);
            g.drawImage((keyLEDs & 0x40) != 0 ? this.ledSmallOn : this.ledSmallOff, x + LED2_X, y + LED_SMALL_Y, LED_SMALL_WH, LED_SMALL_WH, this);
            g.drawImage((keyLEDs & 8) != 0 ? this.ledSmallOn : this.ledSmallOff, x + LED3_X, y + LED_SMALL_Y, LED_SMALL_WH, LED_SMALL_WH, this);
        }
    }

    public void display(int reg, int i) {
        int[][] displayBuffer = this.ioReg.bus.display.getDisplayBuffer();
        int x = this.getInsets().left;
        int y = this.getInsets().top;
        Graphics g = this.getGraphics();
        if (this.backgroundImage && g != null) {
            int segments = displayBuffer[reg][i];
            int x1 = (x += DISPLAY_X + LED_X + i * (LED_SEGMENT_SIZE + 10)) + LED_SEGMENT_SIZE + 2;
            int y1 = (y += DISPLAY_Y + LED_Y + reg * (2 * LED_SEGMENT_SIZE + 30)) + LED_SEGMENT_SIZE;
            int y2 = y1 + LED_SEGMENT_SIZE;
            g.setColor(this.ledBack);
            g.fillRect(x, y, LED_SEGMENT_SIZE + 5, 2 * LED_SEGMENT_SIZE + 1);
            g.setColor(this.ledRed);
            if (segments == 0) {
                return;
            }
            if ((segments & 0x40) != 0) {
                g.drawLine(x + 3, y, x1 + 1, y);
            }
            if ((segments & 0x20) != 0) {
                g.drawLine(x1 + 2, y, x1 + 1, y1);
            }
            if ((segments & 2) != 0) {
                g.drawLine(x1 + 1, y1, x1, y2);
            }
            if ((segments & 4) != 0) {
                g.drawLine(x + 1, y2, x1 - 1, y2);
            }
            if ((segments & 8) != 0) {
                g.drawLine(x + 1, y1, x, y2);
            }
            if ((segments & 0x80) != 0) {
                g.drawLine(x + 2, y, x + 1, y1);
            }
            if ((segments & 0x10) != 0) {
                g.drawLine(x + 2, y1, x1, y1);
            }
            if ((segments & 1) != 0) {
                g.drawLine(x1 + 2, y2, x1 + 2, y2);
            }
        }
    }

    public class mouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent event) {
            int x = event.getX() - HP9810Mainframe.this.getInsets().left;
            int y = event.getY() - HP9810Mainframe.this.getInsets().top;
            if (y > 10 && y < 50 && x >= 25 && x <= 475) {
                int block = (x - 25) / 150 + 1;
                if (event.getButton() == 1) {
                    HP9810Mainframe.this.romSelector.setRomSlot("Slot" + Integer.toString(block));
                    HP9810Mainframe.this.romSelector.setTitle("HP9810A ROM Blocks Slot " + Integer.toString(block));
                    HP9810Mainframe.this.romSelector.setVisible(true);
                } else {
                    MemoryBlock romBlock = (MemoryBlock)HP9810Mainframe.this.emu.memoryBlocks.get("Slot" + Integer.toString(block));
                    if (romBlock != null) {
                        HP9810Mainframe.this.instructionsWindow.setROMblock(romBlock);
                        HP9810Mainframe.this.instructionsWindow.showInstructions();
                    }
                }
                return;
            }
            if (y >= 40 && y <= 70 && x >= 760 && x <= 990) {
                MemoryBlock romBlock;
                if (event.getButton() != 1 && (romBlock = (MemoryBlock)HP9810Mainframe.this.emu.memoryBlocks.get("Block0")) != null) {
                    HP9810Mainframe.this.instructionsWindow.setROMblock(romBlock);
                    HP9810Mainframe.this.instructionsWindow.showInstructions();
                }
                return;
            }
            int row = keyOffsetY - y;
            if (row < 0) {
                return;
            }
            if ((row /= keyWidth) > 7) {
                return;
            }
            int col = x - keyOffsetX[row];
            if (col < 0) {
                return;
            }
            if ((col /= keyWidth) > 18) {
                return;
            }
            int keyCode = keyCodes[row][col];
            if (keyCode == 511) {
                HP9810Mainframe.this.paper(true);
                return;
            }
            if (keyCode != -1) {
                if (HP9810Mainframe.this.emu.keyLogMode) {
                    HP9810Mainframe.this.emu.console.append("\n" + Integer.toOctalString(keyCode) + " ");
                    return;
                }
                if (keyCode == 33) {
                    HP9810Mainframe.this.ioReg.STP = true;
                }
                HP9810Mainframe.this.ioReg.bus.keyboard.setKeyCode(keyCode);
                HP9810Mainframe.this.ioReg.bus.keyboard.requestInterrupt();
            }
        }

        public void mouseReleased(MouseEvent event) {
            if (HP9810Mainframe.this.advancing) {
                HP9810Mainframe.this.paper(false);
            }
        }
    }
}

