/*
 * Decompiled with CFR 0.152.
 */
package io.HP9820A;

import emu98.Emulator;
import emu98.Memory;
import emu98.MemoryBlock;
import io.HP9800Mainframe;
import io.HP9820A.HP9820DisplayInterface;
import io.HP9820A.HP9820KeyboardInterface;
import io.ImageMedia;
import io.MagneticCardReaderInterface;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class HP9820Mainframe
extends HP9800Mainframe {
    private static final long serialVersionUID = 1L;
    static final int[] HP9820keyOffsetX = new int[]{80, 80, 80, 80, 80, 80, 80, 80};
    static final int[][] HP9820keyCodes = new int[][]{{63, 32, -1, 72, 77, -1, 82, 87, -1, 48, 48, 46, 93, 93, -1, 91, 91, 33, 2, 2}, {39, 15, -1, 71, 76, -1, 81, 86, -1, 43, 49, 50, 51, 59, -1, 95, 58, 35, 31, 64}, {38, 14, -1, 70, 75, -1, 80, 85, -1, 45, 52, 53, 54, 44, -1, 67, 90, 61, 30, 27}, {37, 9, -1, 69, 74, -1, 79, 84, -1, 42, 55, 56, 57, 34, -1, 66, 89, 60, 28, 29}, {36, 8, -1, 68, 73, -1, 78, 83, -1, 47, 92, 94, 40, 41, -1, 65, 88, 62, 25, 26}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {16, 17, -1, 97, 98, 96, -1, 100, 99, -1, 3, -1, 20, 21, 23, 22, -1, 4, 5, 24}, {101, -1, -1, -1, -1, -1, -1, 18, 19, -1, -1, -1, -1, -1, -1, 511, -1, -1, -1, -1}};
    public static int TEMPLATE1_X = 58;
    public static int TEMPLATE1_Y = 301;
    public static int TEMPLATE2_X = 184;
    public static int TEMPLATE2_Y = 301;
    public static int TEMPLATE3_X = 313;
    public static int TEMPLATE3_Y = 301;
    public static int TEMPLATE_W = 118;
    public static int TEMPLATE_H = 223;

    public HP9820Mainframe(Emulator emu, String machine) {
        super(emu, machine);
        keyWidth = 42;
        keyOffsetY = 523;
        keyOffsetX = HP9820keyOffsetX;
        keyCodes = HP9820keyCodes;
        DISPLAY_X = 50;
        DISPLAY_Y = 109;
        DISPLAY_W = 85;
        DISPLAY_H = 6;
        LED_X = 45;
        LED_Y = 4;
        BLOCK1_Y = 2;
        BLOCK2_Y = 2;
        BLOCK3_Y = 2;
        this.ioReg.line10_20 = true;
        this.ioReg.bus.display = new HP9820DisplayInterface(this, this.ioReg);
        this.ioReg.bus.keyboard = new HP9820KeyboardInterface(12, this.ioReg);
        this.ioReg.bus.devices.add(this.ioReg.bus.keyboard);
    }

    public HP9820Mainframe(Emulator emu) {
        this(emu, "HP9820A");
        this.addMouseListener(new mouseListener());
        int MAW = 13312;
        while (MAW > 8192) {
            if (emu.memory[MAW - 1].isRW) break;
            MAW -= 1024;
        }
        emu.memory[767] = new Memory(false, 767, MAW);
        this.ioReg.bus.cardReader = new MagneticCardReaderInterface(this, this.ioReg);
        this.romSelector.addRomButton("media/HP9820A/HP11XXXX_Block.jpg", "HP11XXXX");
        this.romSelector.addRomButton("media/HP9820A/HP11220A_Block.jpg", "HP11220A");
        this.romSelector.addRomButton("media/HP9820A/HP11221A_Block.jpg", "HP11221A");
        this.romSelector.addRomButton("media/HP9820A/HP11222A_Block.jpg", "HP11222A");
        this.romSelector.addRomButton("media/HP9820A/HP11223A_Block.jpg", "HP11223A");
        this.keyboardImage = new ImageMedia("media/HP9820A/HP9820A_Keyboard.jpg").getImage();
        this.setSize();
        System.out.println("HP9820 Mainframe loaded.");
    }

    public void paint(Graphics g) {
        int x = this.getInsets().left;
        int y = this.getInsets().top;
        this.backgroundImage = g.drawImage(this.keyboardImage, x, y, this.keyboardImage.getWidth(this), this.keyboardImage.getHeight(this), this);
        if (this.backgroundImage) {
            MemoryBlock block = (MemoryBlock)this.emu.memoryBlocks.get("Slot1");
            if (block != null) {
                g.drawImage(block.getModule(), x + BLOCK1_X, y + BLOCK1_Y, BLOCK_W, BLOCK_H, this);
                g.drawImage(block.getTemplate(), x + TEMPLATE1_X, y + TEMPLATE1_Y, TEMPLATE_W, TEMPLATE_H, this);
            }
            if ((block = (MemoryBlock)this.emu.memoryBlocks.get("Slot2")) != null) {
                g.drawImage(block.getModule(), x + BLOCK2_X, y + BLOCK2_Y, BLOCK_W, BLOCK_H, this);
                g.drawImage(block.getTemplate(), x + TEMPLATE2_X, y + TEMPLATE2_Y, TEMPLATE_W, TEMPLATE_H, this);
            }
            if ((block = (MemoryBlock)this.emu.memoryBlocks.get("Slot3")) != null) {
                g.drawImage(block.getModule(), x + BLOCK3_X, y + BLOCK3_Y, BLOCK_W, BLOCK_H, this);
                g.drawImage(block.getTemplate(), x + TEMPLATE3_X, y + TEMPLATE3_Y, TEMPLATE_W, TEMPLATE_H, this);
            }
            g.setColor(this.ledBack);
            g.fillRect(x + DISPLAY_X, y + DISPLAY_Y, DISPLAY_W + 16 * (6 * LED_DOT_SIZE + 2), DISPLAY_H + 7 * LED_DOT_SIZE);
            if (this.ioReg.dispCounter.running()) {
                int i = 0;
                while (i < 5) {
                    int j = 0;
                    while (j < 16) {
                        this.display(i, j);
                        ++j;
                    }
                    ++i;
                }
            }
            this.displayPrintOutput();
            this.displayKeyMatrix();
        }
    }

    public void display(int col, int chr) {
        Graphics g = this.getGraphics();
        if (this.backgroundImage && g != null) {
            int[][] displayBuffer = this.ioReg.bus.display.getDisplayBuffer();
            int x = this.getInsets().left + DISPLAY_X + LED_X + chr * (6 * LED_DOT_SIZE + 2) + col * LED_DOT_SIZE;
            int y = this.getInsets().top + DISPLAY_Y + LED_Y;
            int ledColumn = displayBuffer[col][chr];
            int j = 6;
            while (j >= 0) {
                if ((ledColumn & 1) != 0) {
                    g.setColor(this.ledRed);
                } else {
                    g.setColor(this.ledBack);
                }
                g.fillRect(x, y + j * LED_DOT_SIZE, LED_DOT_SIZE - 1, LED_DOT_SIZE - 1);
                ledColumn >>= 1;
                --j;
            }
        }
    }

    class mouseListener
    extends MouseAdapter {
        mouseListener() {
        }

        public void mousePressed(MouseEvent event) {
            int x = event.getX() - HP9820Mainframe.this.getInsets().left;
            int y = event.getY() - HP9820Mainframe.this.getInsets().top;
            if (y > 10 && y < 50 && x >= 25 && x <= 475) {
                int block = (x - 25) / 150 + 1;
                if (event.getButton() == 1) {
                    HP9820Mainframe.this.romSelector.setRomSlot("Slot" + Integer.toString(block));
                    HP9820Mainframe.this.romSelector.setTitle("HP9820A ROM Blocks Slot " + Integer.toString(block));
                    HP9820Mainframe.this.romSelector.setVisible(true);
                } else {
                    MemoryBlock romBlock = (MemoryBlock)HP9820Mainframe.this.emu.memoryBlocks.get("Slot" + Integer.toString(block));
                    if (romBlock != null) {
                        HP9820Mainframe.this.instructionsWindow.setROMblock(romBlock);
                        HP9820Mainframe.this.instructionsWindow.showInstructions();
                    }
                }
                return;
            }
            if (y >= 40 && y <= 70 && x >= 760 && x <= 990) {
                MemoryBlock romBlock;
                if (event.getButton() != 1 && (romBlock = (MemoryBlock)HP9820Mainframe.this.emu.memoryBlocks.get("Block0")) != null) {
                    HP9820Mainframe.this.instructionsWindow.setROMblock(romBlock);
                    HP9820Mainframe.this.instructionsWindow.showInstructions();
                }
                return;
            }
            int row = keyOffsetY - y;
            if (row < 0) {
                return;
            }
            if ((row /= keyWidth) > 7) {
                return;
            }
            int col = x - keyOffsetX[row];
            if (col < 0) {
                return;
            }
            if ((col /= keyWidth) > 19) {
                return;
            }
            int keyCode = keyCodes[row][col];
            if (keyCode == 511) {
                HP9820Mainframe.this.paper(true);
                return;
            }
            if (keyCode != -1) {
                if (HP9820Mainframe.this.emu.keyLogMode) {
                    HP9820Mainframe.this.emu.console.append("\n" + Integer.toOctalString(keyCode) + " ");
                    return;
                }
                if (keyCode == STOP_KEYCODE) {
                    HP9820Mainframe.this.ioReg.STP = true;
                }
                HP9820Mainframe.this.ioReg.bus.keyboard.setKeyCode(keyCode);
                HP9820Mainframe.this.ioReg.bus.keyboard.requestInterrupt();
            }
        }

        public void mouseReleased(MouseEvent event) {
            if (HP9820Mainframe.this.advancing) {
                HP9820Mainframe.this.paper(false);
            }
        }
    }
}

