/*
 * Decompiled with CFR 0.152.
 */
package io.HP9830A;

import emu98.Emulator;
import emu98.MemoryBlock;
import emu98.ROMselector;
import io.HP9830A.HP9830Mainframe;
import io.ImageMedia;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class HP9830ROMslots
extends Frame {
    private static final long serialVersionUID = 1L;
    Image romSlotImage;
    HP9830Mainframe hp9830;
    Emulator emu;
    ROMselector romSelector;
    boolean backgroundImage = false;

    public HP9830ROMslots(HP9830Mainframe hp9830) {
        super("HP9830A ROMs");
        this.addWindowListener(new windowListener());
        this.addMouseListener(new mouseListener());
        this.hp9830 = hp9830;
        this.emu = hp9830.emu;
        this.setSize(264, 345);
        this.setLocation(20, 120);
        this.setBackground(Color.BLACK);
        this.romSlotImage = new ImageMedia("media/HP9830A/HP9830A_ROMslot.jpg").getImage();
        this.romSelector = new ROMselector((Frame)this, this.emu);
        this.romSelector.addRomButton("media/HP9830A/HP11XXXX_Block.jpg", "HP11XXXX");
        this.romSelector.addRomButton("media/HP9830A/HP11270B_Block.jpg", "HP11270B");
        this.romSelector.addRomButton("media/HP9830A/HP11271B_Block.jpg", "HP11271B");
        this.romSelector.addRomButton("media/HP9830A/HP11272B_Block.jpg", "HP11272B");
        this.romSelector.addRomButton("media/HP9830A/HP11273B_Block.jpg", "HP11273B");
        this.romSelector.addRomButton("media/HP9830A/HP11274B_Block.jpg", "HP11274B");
        this.romSelector.addRomButton("media/HP9830A/HP11277B_Block.jpg", "HP11277B");
        this.romSelector.addRomButton("media/HP9830A/HP11278B_Block.jpg", "HP11278B");
        this.romSelector.addRomButton("media/HP9830A/HP11279B_Block.jpg", "HP11279B");
        this.romSelector.addRomButton("media/HP9830A/HP11283B_Block.jpg", "HP11283B");
        this.romSelector.addRomButton("media/HP9830A/HP11289B_Block.jpg", "HP11289B");
        this.romSelector.addRomButton("media/HP9830A/INFOTEK_FB1_Block.jpg", "INFOTEK_FB1");
        this.romSelector.addRomButton("media/HP9830A/INFOTEK_FB3_Block.jpg", "INFOTEK_FB3");
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        int x = this.getInsets().left;
        int y = this.getInsets().top;
        this.backgroundImage = g.drawImage(this.romSlotImage, x, y, 256, 318, this);
        if (this.backgroundImage) {
            int i = 1;
            while (i <= 5) {
                Image blockImage;
                MemoryBlock block = (MemoryBlock)this.emu.memoryBlocks.get("Slot" + i);
                if (block != null && (blockImage = block.getUniModule()) != null) {
                    g.drawImage(blockImage, x + 32, y + 50 * i - 32, 200, blockImage.getHeight(this), this);
                }
                ++i;
            }
        }
    }

    class windowListener
    extends WindowAdapter {
        windowListener() {
        }

        public void windowOpened(WindowEvent event) {
        }

        public void windowClosing(WindowEvent event) {
            HP9830ROMslots.this.setVisible(false);
        }
    }

    class mouseListener
    extends MouseAdapter {
        mouseListener() {
        }

        public void mousePressed(MouseEvent event) {
            int x = event.getX() - HP9830ROMslots.this.getInsets().left;
            int y = event.getY() - HP9830ROMslots.this.getInsets().top;
            if (y > 20 && y < 250 && x > 35 && x < 235) {
                int block = (y - 5) / 50 + 1;
                if (event.getButton() == 1) {
                    HP9830ROMslots.this.romSelector.setRomSlot("Slot" + Integer.toString(block));
                    HP9830ROMslots.this.romSelector.setTitle("HP9830A ROM Blocks Slot " + Integer.toString(block));
                    HP9830ROMslots.this.romSelector.setVisible(true);
                } else {
                    MemoryBlock romBlock = (MemoryBlock)HP9830ROMslots.this.emu.memoryBlocks.get("Slot" + Integer.toString(block));
                    if (romBlock != null) {
                        HP9830ROMslots.this.hp9830.instructionsWindow.setROMblock(romBlock);
                        HP9830ROMslots.this.hp9830.instructionsWindow.showInstructions();
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent event) {
        }
    }
}

