/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.HP9866Interface;
import io.IOregister;
import io.SoundMedia;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class HP9866A
extends Frame
implements KeyListener {
    private static final long serialVersionUID = 1L;
    HP9866Interface hp9866Interface;
    IOregister ioReg;
    SoundMedia fanSound;
    SoundMedia printSound;
    Vector printBuffer;
    StringBuffer lineBuffer;
    int numLines;
    int page;

    public HP9866A(IOregister ioRegister, int selectCode) {
        super("HP9866A");
        this.addKeyListener(this);
        this.addWindowListener(new windowListener());
        this.addMouseListener(new mouseListener());
        this.fanSound = new SoundMedia("media/HP9800/HP9800_FAN.wav");
        this.printSound = new SoundMedia("media/HP9866A/HP9866_PRINT.wav");
        this.ioReg = ioRegister;
        this.hp9866Interface = new HP9866Interface(selectCode, this.ioReg);
        this.hp9866Interface.setFrame(this);
        this.ioReg.bus.devices.add(this.hp9866Interface);
        this.setSize(575, 250);
        this.setLocation(190, 0);
        this.page = 0;
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLUE);
        Font font = new Font("Monospaced", 0, 12);
        this.setFont(font);
        this.initializeBuffer();
        this.setVisible(true);
        System.out.println("HP9866A Printer at select code 1:15 loaded.");
    }

    public void keyPressed(KeyEvent event) {
        int keyCode = event.getKeyCode();
        int h = this.getHeight() - 6;
        int windowLines = (h - this.getInsets().top) / 12;
        int numPages = this.numLines / windowLines;
        switch (keyCode) {
            case 34: {
                ++this.page;
                if (this.page <= numPages) break;
                this.page = numPages;
                break;
            }
            case 33: {
                if (--this.page >= 0) break;
                this.page = 0;
                break;
            }
            case 35: {
                this.page = 0;
                break;
            }
            case 36: {
                this.page = numPages;
                break;
            }
            case 127: {
                this.initializeBuffer();
                this.page = 0;
                this.setSize(575, 250);
                break;
            }
            case 155: {
                int i = 0;
                while (i < this.numLines) {
                    System.out.print(this.printBuffer.elementAt(i));
                    ++i;
                }
                return;
            }
            case 83: {
                this.hp9866Interface.highSpeed = !this.hp9866Interface.highSpeed;
                this.setTitle("HP9866A" + (this.hp9866Interface.highSpeed ? " High Speed" : ""));
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public void paint(Graphics g) {
        int minLine;
        int x = this.getInsets().left + 4;
        int y = this.getHeight() - 6;
        int windowLines = (y - this.getInsets().top) / 12;
        int maxLine = this.numLines - this.page * windowLines;
        if (maxLine < 0) {
            maxLine = 0;
        }
        if ((minLine = maxLine - windowLines - 1) < 0) {
            minLine = 0;
        }
        int i = maxLine - 1;
        while (i >= minLine) {
            g.drawString(this.printBuffer.elementAt(i).toString(), x, y);
            y -= 12;
            --i;
        }
    }

    public void initializeBuffer() {
        this.numLines = 0;
        this.lineBuffer = new StringBuffer();
        this.printBuffer = new Vector();
    }

    public int output(int status, int value) {
        this.lineBuffer.append((char)value);
        if (value == 10) {
            if (!this.hp9866Interface.highSpeed) {
                this.printSound.start();
            }
            ++this.numLines;
            this.printBuffer.addElement(this.lineBuffer);
            this.lineBuffer = new StringBuffer();
            this.repaint();
            return 0;
        }
        return 256;
    }

    class windowListener
    extends WindowAdapter {
        windowListener() {
        }

        public void windowClosing(WindowEvent event) {
            HP9866A.this.setVisible(false);
            HP9866A.this.dispose();
            HP9866A.this.ioReg.bus.devices.remove(HP9866A.this.hp9866Interface);
            System.out.println("HP9866A unloaded.");
        }
    }

    class mouseListener
    extends MouseAdapter {
        mouseListener() {
        }

        public void mousePressed(MouseEvent event) {
            int x = event.getX() - HP9866A.this.getInsets().left;
            int y = event.getY() - HP9866A.this.getInsets().top;
        }

        public void mouseReleased(MouseEvent event) {
        }
    }
}

